(window).onload = function() {
    $(document).ready(function() {

        //No permitir que la pantalla del dispositivo FirefoxOS se apague
        if (typeof window.navigator.requestWakeLock === 'function'){
            window.navigator.requestWakeLock('screen');
        }


        //Ajustar el la panel de botones para pantallas grandes, solo funciona al cargar no al resize
        function setIndicaionesStyle() {
            if (window.innerHeight < 480) {
                $("#orden").addClass("horizontal");
                $("#orden").removeClass("vertical");
            } else {
                $("#orden").addClass("vertical");
                $("#orden").removeClass("horizontal");

            }

            if (screen.height > 550) {
                $("#wrapper, #actividad_nombre, #contador, .panel_wrapper, #pantalla, #pantalla img").addClass("pantalla_larga");
            } else {
                $("#wrapper, #actividad_nombre, #contador, .panel_wrapper, #pantalla, #pantalla img").removeClass("pantalla_larga");
            }

        }

        setIndicaionesStyle();


        function setMainViewContent() {
            if (getCurrent() >= 0) {
                actividad = rutina[getCurrent()];
                $("#actividad_nombre").html(actividad.nombreactividad);
                $("#pantalla img").attr("src", "images/gifs/" + actividad.image);
            }
        }

        function circular(next) {
            if (getCurrent() >= 0) {
                var in_current = getCurrent();
                if (next > 0) {
                    in_current++;
                    if (in_current >= rutina.length) {
                        in_current = 0;
                    }
                } else {
                    in_current--;
                    if (in_current < 0) {
                        in_current = rutina.length - 1;
                    }
                }
                return in_current;
            }
        }

        function getCurrent() {
            return document.getElementById("app_data").contentWindow.getCurrent();
        }
        function setCurrent(x) {
            document.getElementById("app_data").contentWindow.setCurrent(x);
        }

        /* Clase temporizador.
         * Descripcion: Cuenta del numero especificado hasta el cero y muestra la cantidad en el elemento especificado (p.ej. un div o span)
         * Recibe: 3 argumentos
         * - seconds: Segundos de la cuenta regresiva.
         * - UIcounter: ID del elemento que mostrará la cuenta.
         * - FunctionAfterComplete: Funcion a ejecutar despues de terminar la cuenta regresiva.
         *
         * Funcionalidades:
         * 
         *         start: Inicia un nuevo intervalo. Al llegar a la cuenta ejecuta la funcion especificada por FunctionAfterComplete. 
         *         stop: Detiene el contador y elimina cualquier ejecucion de Interval asociado al objeto en cuestion
         *         playpause: pone en pausa o marcha segun el estado actual.        
         * */

        function Temporizador(seconds, UIcounter, FunctionAfterComplete /* Opcional */, TicFunction /* Opcional */) {
            var timer = null;
            var inPauseTime = 0;
            var inPause = false;

            this.start = function() {

                if (timer === null)
                    timer = setInterval(function() {
                        seconds--;
                        document.getElementById(UIcounter).innerHTML = ((seconds < 10) ? "0" : "") + seconds;
                        if (seconds <= 0) {
                            clearInterval(timer);
                            if (typeof FunctionAfterComplete === 'function')
                                FunctionAfterComplete();
                        }

                        if (typeof TicFunction === 'function')
                            TicFunction();
                    }, 1000);
                return this;
            };

            this.stop = function() {
                if (this.start !== null)
                    clearInterval(timer);
            };

            this.playPause = function() {
                if (timer !== null) {
                    inPause = !inPause;
                    if (inPause) {
                        inPauseTime = seconds;
                        clearInterval(timer);
                    } else {
                        timer = null;
                        seconds = inPauseTime;
                        this.start();
                    }
                }

            };

            this.getTime = function() {
                return seconds;
            };
        }

        /* 
         * 
         */
        function SecuenciaRutina() {

            var tempo = null;
            var tiempoEfectivo = 0;

            function secuencia() {
                setMainViewContent();
                actividad = rutina[getCurrent()];
                $("#contador").css("background-image", "url(images/counter_red.png)");
                document.getElementById("orden").innerHTML = "DESCANZA observa el ejercicio";
                document.getElementById("contador").innerHTML = rutina[getCurrent()].recuperation;
                $("#orden").removeClass("green");
                if (SounActive && soundPlayNoChange)
                    $('#Stop')[0].play();
                tempo = new Temporizador(actividad.recuperation, "contador", function() { //Cuando termine el tiempo de preparacion
                    $("#contador").css("background-image", "url(images/counter_green.png)");
                    $("#orden").addClass("green");
                    soundPlayNoChange = true;
                    document.getElementById("contador").innerHTML = rutina[getCurrent()].time;
                    document.getElementById("orden").innerHTML = "&#9733; EJERCITATE &#9733;";
                    if (SounActive && soundPlayNoChange)
                        $('#Start')[0].play();
                    tempo = new Temporizador(actividad.time, "contador", function() { //Iniciar tiempo de actividad
                        setCurrent(circular(1)); //Cambiar a la sig actividad                        
                        secuencia(); //Iniciar actividad
                    }, setTiempoEfectivo).start();
                }, TicPreparacion).start();

            }

            //Iniciar la secuencia desde la posicion especificada
            this.start = function(current) {
                if (current === null)
                    current = 0;
                if (tempo !== null)
                    tempo.stop();
                setCurrent(current);

                secuencia();
                return this;
            };

            this.playPause = function() {
                tempo.playPause();
            };

            function TicPreparacion() {
                if (tempo.getTime() === 3) {
                    $("#contador").css("background-image", "url(images/counter_orange.png)");
                }
            }

            function setTiempoEfectivo() {
                tiempoEfectivo++;
                sec = tiempoEfectivo % 60;
                min = parseInt(tiempoEfectivo / 60);
                $("#tiempoEfectivo").html("0" + min + ":" + ((sec < 10) ? "0" : "") + sec);
            }

            this.getTiempoEfectivo = function() {
                return tiempoEfectivo;
            };

            this.reset = function() {
                tiempoEfectivo = 0;
                $("#tiempoEfectivo").html("00:00");
                this.start(0);
            };

        }



        rutina = document.getElementById("app_data").contentWindow.getData();
        var SounActive = (document.getElementById("app_data").contentWindow.getSound() === "true") ? true : false;
        $("#sound").attr("src", "images/" + (SounActive === true ? "bell6.png" : "mute6.png"));
        var soundPlayNoChange = false;
        /* */


        //Iniciar la seceuncia en la ultima vista secuencia = new SecuenciaRutina().start(getCurrent());
        secuencia = new SecuenciaRutina().start(0);

        $("#prev").click(function() {
            soundPlayNoChange = false;
            secuencia.start(circular(-1));

        });
        $("#button_restart").click(function() {
            soundPlayNoChange = false;
            secuencia.reset();

        });
        $("#next").click(function() {
            soundPlayNoChange = false;
            secuencia.start(circular(1));

        });
        $("#tiempo").click(function() {
            secuencia.playPause();
            //($('#tiempo').css('background-image')==="none")? $('#tiempo').css('background-image', 'url(images/play_white.png)') : $('#tiempo').css('background-image', 'none');
        });

        $("#sound").click(function() {
            datos = document.getElementById("app_data").contentWindow;
            datos.setSound((datos.getSound() === "true") ? "false" : "true");
            SounActive = (datos.getSound() === "true") ? true : false;
            $(this).attr("src", "images/" + (SounActive === true ? "bell6.png" : "mute6.png"));
        });

        $(window).resize(function() {
            setIndicaionesStyle();
        });

    });
};