/**
 * 去字符串兩端的空字符（空格、制表符、换行符等）
 *
 * @return
 */
String.prototype.trim = function () {
    return this.replace(/^\s+|\s+$/g, "");
};
/**
 * 去字符串左端的空字符（空格、制表符、换行符等）
 *
 * @return
 */
String.prototype.ltrim = function () {
    return this.replace(/^\s+/, "");
};
/**
 * 去字符串右端的空字符（空格、制表符、换行符等）
 *
 * @return
 */
String.prototype.rtrim = function () {
    return this.replace(/\s+$/, "");
};
/**
 * 判断字符串是否以指定的字符串开头
 */
String.prototype.startWithReg = function (str) {
    var reg = new RegExp("^" + str);
    return reg.test(this);
};
/**
 * 判断字符串是否以指定的字符串开头
 */
String.prototype.startWith = function (str) {
    if (this.length < str.length) {
        return false;
    }
    return this.indexOf(str) >= 0;
};
/**
 * 判断字符串是否以指定的字符串结尾
 */
String.prototype.endWith = function (str) {
    var reg = new RegExp(str + "$");
    return reg.test(this);
};
/**
 * 忽略大小写进行字符串比较
 */
String.prototype.equalsIgnoreCase = function (str) {
    return this.toLowerCase() == str.toLowerCase();
};
/**
 * 将字符串中的所有指定内容替换为指定字符串
 */
String.prototype.replaceAll = function (s1, s2) {
    return this.replace(new RegExp(s1, "gm"), s2);
};

/**
 * 判断数组中是否包含指定元素
 */
Array.prototype.inArray = function (e) {
    for (var i = 0; i < this.length && this[i] != e; i++) {
    }
    return !(i == this.length);
};
/**
 * 获取指定元素的下标，如果不存在该元素则返回-1
 */
Array.prototype.indexOf = function (e) {
    for (var i = 0; i < this.length && this[i] != e; i++) {
    }
    return (i == this.length) ? -1 : i;
};
/**
 * 删除指定元素
 */
Array.prototype.remove = function (dx) {
    if (isNaN(dx) || dx > this.length) {
        return false;
    }
    for (var i = 0, n = 0; i < this.length; i++) {
        if (this[i] != this[dx]) {
            this[n++] = this[i];
        }
    }
    if (this.length > 0) {
        this.length -= 1;
    }
};
/**
 * 希尔排序
 */
Array.prototype.shellSort = function (compare) {
    for (var step = this.length >> 1; step > 0; step >>= 1) {
        for (var i = 0; i < step; ++i) {
            for (var j = i + step; j < this.length; j += step) {
                var k = j, value = this[j];
                while (k >= step && (compare ? compare(this[k - step], value) : this[k - step] > value)) {
                    this[k] = this[k - step];
                    k -= step;
                }
                this[k] = value;
            }
        }
    }
};

/**
 * 获取Url中的参数
 */
var jQuery = jQuery || {};
(function ($) {
    $.getUrlParam = function (name) {
        var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
        var r = window.location.search.substr(1).match(reg);
        if (r != null) return decodeURI(r[2]);
        return null;
    }
})(jQuery);