/**
 * Created by Workspace on 14-3-4.
 */

(function () {
    /** @type {xx.MatrixLayer} **/
    var $miniMatrix = $("#miniMatrix")[0].matrix;
    /** @type {xx.MatrixLayer} **/
    var $mainMatrix = $("#mainMatrix")[0].matrix;

    /**
     * 总分
     **/
    var currentScore = 0;

    /**
     * 在MiniMatrix中，显示下一波颜色
     */
    $miniMatrix.refill = function () {
        // 获得行数、列数
        var row = $miniMatrix.matrixData.getRowNum();
        var col = $miniMatrix.matrixData.getColNum();
        // 随机生成相等数量的类型
        var classes = xx.MatrixLayer.generateRandomClass(row * col);
        // 设置显示的颜色
        for (var i = 0; i < row; i++) {
            for (var j = 0; j < col; j++) {
                $miniMatrix.matrixData.getItem(i, j).setItemClass(classes[i * j + j]);
            }
        }
    };

    /**
     * 在MiniMatrix中，显示下一波颜色
     */
    $mainMatrix.refill = function () {
        var emptyItems = $mainMatrix.find("tr td div.EMPTY").toArray();
        //
        var row = $miniMatrix.matrixData.getRowNum();
        var col = $miniMatrix.matrixData.getColNum();
        //
        var index = -1;
        //
        while ((++index) < (row * col)) {
            if (emptyItems.length == 0) {
                emptyItems = $mainMatrix.find("tr td div.EMPTY").toArray();
                //
                if (emptyItems.length == 0) {
                    GameOver();
                    return;
                }
            }
            var item = emptyItems.splice(Math.floor(Math.random() * emptyItems.length), 1)[0];
            item.$item.setItemClass($miniMatrix.matrixData.getItem(Math.floor(index / col), index % col).getItemClass());
            $mainMatrix.checkAndClear(item.$item);
        }
        //
        if ($mainMatrix.find("tr td div.EMPTY").length == 0) {
            GameOver();
        }
    };

    // 在Item完成移动后将被回调
    $mainMatrix.setMoveCallback(function (result) {
        // 在切换CLASS的动画完成后再执行
        setTimeout(function () {
            if (result.length == 0) {
                // 如果没有任何Item被消除，则重新填充MainMatrix
                $mainMatrix.refill();
                $miniMatrix.refill();
            } else {
                // 如果有Item被消除，计算得分，并更新UI上的值
                // 同时消除的直线越多分数越高，倍数为1、2、4 …
                var mul = Math.pow(2, result.length - 1);
                $(result).each(function () {
                    // TODO 计分算法有待研究
                    currentScore += mul * this;
                });
                $("#score").text(currentScore);
            }
        }, 144);
    });

    if ($.getUrlParam("restart") == "true") {
        // 重新开始新游戏
        restart();
    } else {
        // 加载上次的记录
        load();
    }

    /**
     * 离开页面时，保存
     */
    window.onunload = function () {
        save();
    }

    /**
     * 存档，便于下次游戏时继续
     */
    function save() {
        // 当前分数
        window.localStorage.currentScore = currentScore;
        // mini
        window.localStorage.miniMatrixDataClasses = $.toJSON($miniMatrix.getClassesMatrix());
        // main
        window.localStorage.mainMatrixDataClasses = $.toJSON($mainMatrix.getClassesMatrix());
    }

    window.onunload

    /**
     * 加载游戏记录
     */
    function load() {
        // score
        currentScore = parseInt(window.localStorage.currentScore);
        $("#score").text(currentScore);

        // mini
        var miniClasses = $.parseJSON(window.localStorage.miniMatrixDataClasses);
        for (var i = 0; i < miniClasses.length; i++) {
            for (var j = 0; j < miniClasses[i].length; j++) {
                $miniMatrix.matrixData.getItem(i, j).setItemClass(miniClasses[i][j]);
            }
        }

        // main
        var mainClasses = $.parseJSON(window.localStorage.mainMatrixDataClasses);
        for (var i = 0; i < mainClasses.length; i++) {
            for (var j = 0; j < mainClasses[i].length; j++) {
                $mainMatrix.matrixData.getItem(i, j).setItemClass(mainClasses[i][j]);
            }
        }

    }

    /**
     * 重新开始新的游戏
     */
    function restart() {
        // 首次生成MiniMatrix中的候选颜色
        $miniMatrix.refill();
        // 填充MainMatrix并重新生成MiniMatrix中的候选颜色
        $mainMatrix.getMoveCallback()([]);
    }

    /**
     * 游戏结束 GameOver
     */
    function GameOver() {
        var dialog = $("<form role='dialog' data-type='confirm'>" +
            "   <section style='overflow-y: hidden;'>" +
            "       <h1>Congratulations</h1>" +
            "       <p>Your score is " + currentScore + ".<br>Do you want to try again?</p>" +
            "   </section>" +
            "   <menu>" +
            "       <button  type='button' onclick=\"window.location.href='index.html'\">No</button>" +
            "       <button  type='button' class='recommend' onclick=\"window.location.href='game.html?restart=true'\">Yes</button></menu>" +
            "</form>");
        $mainMatrix.setTouchable(false);
        setTimeout(function () {
            // 如果是最高分，则记录
            localStorage.highestScore = Math.max(currentScore, localStorage.highestScore);
            // 清除缓存
            localStorage.currentScore = "";
            localStorage.miniMatrixDataClasses = "";
            localStorage.mainMatrixDataClasses = "";
            // 不再保存
            window.onunload = null;
            // 弹出窗口提示是否继续
            $("body").append(dialog);
        }, 800);
    }
})();