/**
 * 矩阵的数据模型
 *
 * @class
 * @extends xx.Class
 */
xx.MatrixData = xx.Class.extend({

    /**
     * 行数
     * @type {Number}
     */
    m_rowNum: 0,
    /**
     * 列数
     * @type {Number}
     */
    m_colNum: 0,


    /**
     * 二维数组
     * @type {Array}
     */
    m_matrix: null,

    /**
     * 初始化
     * @param {Number} row
     * @param {Number} col
     */
    init: function (row, col) {
        this.m_rowNum = row;
        this.m_colNum = col;
        this.m_matrix = [];
    },


    /**
     * 返回位于指定位置的元素
     *
     * @param row
     * @param col
     * @returns {xx.MatrixItem}
     */
    getItem: function (row, col) {
        return this.m_matrix[row][col];
    },

    /**
     * 获取经过指定点的所有连线，这些线的角度分别为 0°、45°、90°、135°
     *
     * @param {xx.MatrixItem} $item
     * @param {Number} minLen 最小长度
     * @return {Array}
     */
    getLines: function ($item, minLen) {
        if (!$item || !$item.isInLine) {
            return [];
        }
        var lines = [];
        var line = [];

        var i, j, tmp;

        // 0°水平
        for (i = $item._colIndex - 1; i >= 0; i--) {
            /** @type {xx.MatrixItem} */
            tmp = this.m_matrix[$item._rowIndex][i];
            if ($item.isInLine(tmp)) {
                line.push(tmp);
            } else {
                break;
            }
        }
        line = line.reverse();
        line.push($item);
        for (i = $item._colIndex + 1; i < this.m_colNum; i++) {
            /** @type {xx.MatrixItem} */
            tmp = this.m_matrix[$item._rowIndex][i];
            if ($item.isInLine(tmp)) {
                line.push(tmp);
            } else {
                break;
            }
        }
        if (line.length >= minLen) {
            lines.push(line);
        }

        line = [];
        // 45°
        for (i = $item._rowIndex - 1, j = $item._colIndex - 1; i >= 0 && j >= 0; i--, j--) {
            /** @type {xx.MatrixItem} */
            tmp = this.m_matrix[i][j];
            if ($item.isInLine(tmp)) {
                line.push(tmp);
            } else {
                break;
            }
        }
        line = line.reverse();
        line.push($item);
        for (i = $item._rowIndex + 1, j = $item._colIndex + 1; i < this.m_rowNum && j < this.m_colNum; i++, j++) {
            /** @type {xx.MatrixItem} */
            tmp = this.m_matrix[i][j];
            if ($item.isInLine(tmp)) {
                line.push(tmp);
            } else {
                break;
            }
        }
        if (line.length >= minLen) {
            lines.push(line);
        }

        line = [];
        // 90°垂直
        for (i = $item._rowIndex - 1; i >= 0; i--) {
            /** @type {xx.MatrixItem} */
            tmp = this.m_matrix[i][$item._colIndex];
            if ($item.isInLine(tmp)) {
                line.push(tmp);
            } else {
                break;
            }
        }
        line = line.reverse();
        line.push($item);
        for (i = $item._rowIndex + 1; i < this.m_rowNum; i++) {
            /** @type {xx.MatrixItem} */
            tmp = this.m_matrix[i][$item._colIndex];
            if ($item.isInLine(tmp)) {
                line.push(tmp);
            } else {
                break;
            }
        }
        if (line.length >= minLen) {
            lines.push(line);
        }

        line = [];
        // 135°
        for (i = $item._rowIndex - 1, j = $item._colIndex + 1; i >= 0 && j < this.m_colNum; i--, j++) {
            /** @type {xx.MatrixItem} */
            tmp = this.m_matrix[i][j];
            if ($item.isInLine(tmp)) {
                line.push(tmp);
            } else {
                break;
            }
        }
        line = line.reverse();
        line.push($item);
        for (i = $item._rowIndex + 1, j = $item._colIndex - 1; i < this.m_rowNum && j >= 0; i++, j--) {
            /** @type {xx.MatrixItem} */
            tmp = this.m_matrix[i][j];
            if ($item.isInLine(tmp)) {
                line.push(tmp);
            } else {
                break;
            }
        }
        if (line.length >= minLen) {
            lines.push(line);
        }
        //
        return lines;
    },

    /**
     * @returns {Number}
     */
    getRowNum: function () {
        return this.m_rowNum;
    },

    /**
     * @returns {Number}
     */
    getColNum: function () {
        return this.m_colNum;
    }
})
;


/**
 *
 * 创建MatrixData实例
 *
 * @param {Number} row
 *            行数
 * @param {Number} col
 *            列术
 *
 * @return {xx.MatrixData} 创建的MatrixData实例
 */
xx.MatrixData.createMatrixData = function (row, col) {
    var matrixData = new xx.MatrixData();
    // 初始化数据
    matrixData.init(row, col);
    return matrixData;
};


/**
 * 矩阵中的连线
 *
 * @param {xx.MatrixItem} start
 * @param {xx.MatrixItem} end
 * @constructor
 */
xx.LineInMatrix = function (start, end) {
    /**
     * 起点
     * @type {xx.MatrixItem}
     */
    this.start = start;
    /**
     * 终点
     * @type {xx.MatrixItem}
     */
    this.end = end;
};
