// Bubble Pop Configuration File


// Datatypes
// ------------------------------------------------------------------
//
// Boolean
// Booleans have two possible values true or false.
//     Example:
//         value: true
// Number
// Numbers can be represented as whole numbers or decimals.
//     Example:
//         x: -20
//         alpha: 0.4
//
// String
// String are described with quotes surrounding zero or more characters.
//     Example:
//         filename: "image1.png"
//
// Object 
// Objects are described with curly brackets surrounding 'name: value' pairs delimited by commas.
//     Example:
//         {
//             name1: value1,
//             name2: value2
//         }
//
// Array
// Arrays are described with square brackets surrounding values delimited by commas.
//     Example:
//         [
//             value1,
//             value2
//         ]

// Framework Properties
// ------------------------------------------------------------------
//
// View Properties
//     type (String)
//     filename (String): The url of image of the view is defined by the resourcePath and the filename.
//     x (Number): Location of view relative to the left of the viewport.
//     y (Number): Location of view relative to the top of the viewport.
//     offsetX (Number): Distance in pixels the image is shifted right.
//     offsetY (Number): Distance in pixels the image is shifted down.
//     numFrames (Number): Number of frames of animation. If this property is set and greater than one, the view will be a sprite.
//     frameRate (Number): Delay between frames of animation (in 1 / 60 second increments).
//         Example:
//              frameRate: 60 // The delay between frames is one second
//              frameRate: 10 // The delay between frames is on 10 / 60 or 0.6 seconds
//     loop (Boolean): If true the animation will continue to play indefinitely after started until stopped.
//     states (Array): Array of views that describe specific states of the view.
//         Example:
//             states: [
//					{
//						type: "ON",
//						filename: "light-switch-on.png"
//					},{
//						type: "OFF",
//						filename: "light-switch-off.png"
//					}
//				]
//
// Audio Properties
//     states (Array): Array of audio sprites.
//         State Properties:
//             name (String): Type of audio state. 
//             startTime (Number): Start time of the state in seconds.
//             duration (Number): The duration of the state in seconds.
//             loop (Boolean): If true the state will loop.
//         Example:
//             states: [
//                 {
//                     type: "intro", 
//                     startTime: 0,
//                     duration: 3.5
//                 },
//  
// Game Properties
//     element (HTML Element): The HTML element in which the game will be populated. Usually a div element.
//         Example:
//              element: window.document.getElementById("game"),
//     device (String): What device the game is launched in (e.g. "IPHONE", "IPAD").
//     resourcePath (String): The url where all resources are relative to. Note the "/" is required.
//         Example:
//             resourcePath: "resources/"
//.    deviceOffset (Object):
//         Example:
//             deviceOffset: {
//.                iPhone: {x: -32, y: -64}
//.            }
//     rounds (Array): An array of objects containing each round's properties.
//	   startImageFilename (String): The url of image title card show at the beginning of the game.
//     audioEnabled (Boolean): If false audio will not be loaded or played.
//     audioFilename (String): The url of the audio file.

// Bubble Pop Specific Properties
// ------------------------------------------------------------------
//
// Game Properties
//
//     hud
//         Properties:
//             sidebar: Displays the number of targets found for the current round.
//                 Available States:
//                     DEFAULT: Only currently supported state.
//     audio
//         Available States:
//             INTRO: Played at the beginning of each round.
//             PAYOFF: Played after the required number of bubbles for the round have been popped and eating by the catcher.
//             MUSIC: Loops in the background.
//			   CORRECT_HIT: Plays when a bubble with a target item is touched.
//         
// Round Properties
//
//     numBubbles: Maximum number of bubbles visible on the screen at once.
//     background
//         Properties:
//            filename: Filename of the background image.
//     bubbleHighlight: Displayed behind the bubble when it is highlighted.
//     bubblePopAnimation: Displayed when a bubble is touched.
//     emptyBubble
//         Properties:
//             filename: Filename of the emoty bubble image.
//     catcher: A character would catches items that fall out of bubbles which are popped.
//         Available States:
//             WAIT: Displayed when the catcher is not active.
//             WAVE: Displayed at the beginning of each round.
//             MOVE: Displayed when the catcher is moving.
//             JUMP: Displayed when a popped bubble has dropped in range of the catcher.
//     target: A random item is selected at the start of each round to be the correct item.
//         Properties:
//             unpopped
//                 Properties:
//                     filename: Filename of the image displayed if the bubble has not been touched.
//             popped
//                 Properties:
//                     filename: Filename of the image displayed after bubble has been touched.
//             label
//                 Available States:
//                     NOTFOUND: Initial state of the label.
//                     FOUND: Displayed after the item is found.
//     distractors (Array): Array of objects that will be displayed with target bubbles that just pop when touch
//         Properties:
//             filename: Filename of the distractor image.

WM.config = {
	resourcePath: "resources/",
	deviceOffset: { //chopping of the BG image to iPhone size specs. Image BG must be 1024x768
		iPhone: {
			x: -32,
			y: -64
		}
	},
	gameIcon: "mozilla_thumb_256x256_ABCHungry.png",
	audioEnabled: true,
	loadingImageWhiteFilename: "loading-white.png",
	loadingImageColorFilename: "loading-color.png",
	landscapeOnlyFilename: "landscape-only.png",
	exitButtonFilename: "exit-button.png",
	startImageFilename: "start-bubblePop-uppercase.jpg",
	audioFilename: "BP_letters.mp3", //all audio including intro, payoff, and music is in one file found here
	audio: {
		states: [
			{
				name: "music", 
				startTime: 262,
				duration: 19,
				loop: true
			}
		]
	},
	hud: {
		sidebar: {
			type: "SIDEBAR",
			states: [
				{
					type: "Default",
					filename: "sidebar.png",
					numFrames: 12,
					autoStart: false
				}
			]
		}
	},
	rounds: [
		{
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 0,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 4,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_A.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_A.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "A_purple.png"
						},{
							type: "Found",
							filename: "A_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "UpLetters_bubbles_letter_B.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_C.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_D.png"
				}, {
					filename: "UpLetters_bubbles_letter_E.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_F.png"
				}, {
					filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_J.png"
				}, {
					filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				}, {
					filename: "UpLetters_bubbles_letter_M.png"
				}, {
					filename: "UpLetters_bubbles_letter_N.png"
				}, {
					filename: "UpLetters_bubbles_letter_O.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				}, {
					filename: "UpLetters_bubbles_letter_R.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_S.png"
				}, {
					filename: "UpLetters_bubbles_letter_T.png"
				}, {
					filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 10,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 14,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_B.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_B.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "B_purple.png"
						},{
							type: "Found",
							filename: "B_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "UpLetters_bubbles_letter_A.png"
				}, {
					filename: "UpLetters_bubbles_letter_C.png"
				}, {
					filename: "UpLetters_bubbles_letter_D.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_E.png"
				}, {
					filename: "UpLetters_bubbles_letter_F.png"
				}, {
					filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				}, {
					filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_J.png"
				}, {
					filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				}, {
					filename: "UpLetters_bubbles_letter_M.png"
				}, {
					filename: "UpLetters_bubbles_letter_N.png"
				}, {
					filename: "UpLetters_bubbles_letter_O.png"
				}, {
					filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				}, {
					filename: "UpLetters_bubbles_letter_R.png"
				}, {
					filename: "UpLetters_bubbles_letter_S.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_T.png"
				}, {
					filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				}, {
					filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 20,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 24,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_C.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_C.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "C_purple.png"
						},{
							type: "Found",
							filename: "C_found.png"
						}
					]
				}
			},
			distractors: [
				{
				//	filename: "UpLetters_bubbles_letter_A.png"
				//}, {
					filename: "UpLetters_bubbles_letter_B.png"
				}, {
				//	filename: "UpLetters_bubbles_letter_D.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_E.png"
				//}, {
					filename: "UpLetters_bubbles_letter_F.png"
				}, {
					filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				}, {
					filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_J.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				}, {
					filename: "UpLetters_bubbles_letter_M.png"
				}, {
					filename: "UpLetters_bubbles_letter_N.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_O.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				}, {
					filename: "UpLetters_bubbles_letter_R.png"
				}, {
					filename: "UpLetters_bubbles_letter_S.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_T.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				}, {
					filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 31,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 35,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_D.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_D.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "D_purple.png"
						},{
							type: "Found",
							filename: "D_found.png"
						}
					]
				}
			},
			distractors: [
				{
				//	filename: "UpLetters_bubbles_letter_A.png"
				//}, {
					filename: "UpLetters_bubbles_letter_B.png"
				}, {
					filename: "UpLetters_bubbles_letter_C.png"
				}, {
					filename: "UpLetters_bubbles_letter_E.png"
				}, {
					filename: "UpLetters_bubbles_letter_F.png"
				}, {
					filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_J.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_M.png"
				}, {
					filename: "UpLetters_bubbles_letter_N.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_O.png"
				}, {
					filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_R.png"
				}, {
					filename: "UpLetters_bubbles_letter_S.png"
				}, {
					filename: "UpLetters_bubbles_letter_T.png"
				}, {
					filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				}, {
					filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 41,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 45,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_E.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_E.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "E_purple.png"
						},{
							type: "Found",
							filename: "E_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "UpLetters_bubbles_letter_A.png"
				}, {
					filename: "UpLetters_bubbles_letter_B.png"
				}, {
					filename: "UpLetters_bubbles_letter_C.png"
				}, {
					filename: "UpLetters_bubbles_letter_D.png"
				}, {
					filename: "UpLetters_bubbles_letter_F.png"
				}, {
					filename: "UpLetters_bubbles_letter_G.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_H.png"
				}, {
					filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_J.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				}, {
					filename: "UpLetters_bubbles_letter_M.png"
				}, {
					filename: "UpLetters_bubbles_letter_N.png"
				}, {
					filename: "UpLetters_bubbles_letter_O.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				}, {
					filename: "UpLetters_bubbles_letter_R.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_S.png"
				}, {
					filename: "UpLetters_bubbles_letter_T.png"
				}, {
					filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 51,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 55,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_F.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_F.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "F_purple.png"
						},{
							type: "Found",
							filename: "F_found.png"
						}
					]
				}
			},
			distractors: [
				{
				//	filename: "UpLetters_bubbles_letter_A.png"
				//}, {
					filename: "UpLetters_bubbles_letter_B.png"
				}, {
					filename: "UpLetters_bubbles_letter_C.png"
				}, {
					filename: "UpLetters_bubbles_letter_D.png"
				}, {
					filename: "UpLetters_bubbles_letter_E.png"
				}, {
					filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				}, {
					filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_J.png"
				}, {
					filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				}, {
					filename: "UpLetters_bubbles_letter_M.png"
				}, {
					filename: "UpLetters_bubbles_letter_N.png"
				}, {
					filename: "UpLetters_bubbles_letter_O.png"
				}, {
					filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				}, {
					filename: "UpLetters_bubbles_letter_R.png"
				}, {
					filename: "UpLetters_bubbles_letter_S.png"
				}, {
					filename: "UpLetters_bubbles_letter_T.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				}, {
					filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 61,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 65,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_G.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_G.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "G_purple.png"
						},{
							type: "Found",
							filename: "G_found.png"
						}
					]
				}
			},
			distractors: [
				{
				//	filename: "UpLetters_bubbles_letter_A.png"
				//}, {
					filename: "UpLetters_bubbles_letter_B.png"
				}, {
					filename: "UpLetters_bubbles_letter_C.png"
				}, {
					filename: "UpLetters_bubbles_letter_D.png"
				}, {
					filename: "UpLetters_bubbles_letter_E.png"
				}, {
					filename: "UpLetters_bubbles_letter_F.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				}, {
					filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_J.png"
				}, {
					filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				}, {
					filename: "UpLetters_bubbles_letter_M.png"
				}, {
					filename: "UpLetters_bubbles_letter_N.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_O.png"
				}, {
					filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				}, {
					filename: "UpLetters_bubbles_letter_R.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_S.png"
				}, {
					filename: "UpLetters_bubbles_letter_T.png"
				}, {
					filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				}, {
					filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 71,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 75,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_H.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_H.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "H_purple.png"
						},{
							type: "Found",
							filename: "H_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "UpLetters_bubbles_letter_A.png"
				}, {
					filename: "UpLetters_bubbles_letter_B.png"
				}, {
					filename: "UpLetters_bubbles_letter_C.png"
				}, {
					filename: "UpLetters_bubbles_letter_D.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_E.png"
				}, {
					filename: "UpLetters_bubbles_letter_F.png"
				}, {
					filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_J.png"
				}, {
					filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				}, {
					filename: "UpLetters_bubbles_letter_M.png"
				}, {
					filename: "UpLetters_bubbles_letter_N.png"
				}, {
					filename: "UpLetters_bubbles_letter_O.png"
				}, {
					filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				}, {
					filename: "UpLetters_bubbles_letter_R.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_S.png"
				}, {
					filename: "UpLetters_bubbles_letter_T.png"
				}, {
					filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				}, {
					filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 81,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 85,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_I.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_I.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "I_purple.png"
						},{
							type: "Found",
							filename: "I_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "UpLetters_bubbles_letter_A.png"
				}, {
					filename: "UpLetters_bubbles_letter_B.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_C.png"
				}, {
					filename: "UpLetters_bubbles_letter_D.png"
				}, {
					filename: "UpLetters_bubbles_letter_E.png"
				}, {
					filename: "UpLetters_bubbles_letter_F.png"
				}, {
					filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_J.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				}, {
					filename: "UpLetters_bubbles_letter_M.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_N.png"
				}, {
					filename: "UpLetters_bubbles_letter_O.png"
				}, {
					filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				}, {
					filename: "UpLetters_bubbles_letter_R.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_S.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_T.png"
				}, {
					filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				}, {
					filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 91,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 95,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_J.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_J.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "J_purple.png"
						},{
							type: "Found",
							filename: "J_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "UpLetters_bubbles_letter_A.png"
				}, {
					filename: "UpLetters_bubbles_letter_B.png"
				}, {
					filename: "UpLetters_bubbles_letter_C.png"
				}, {
					filename: "UpLetters_bubbles_letter_D.png"
				}, {
					filename: "UpLetters_bubbles_letter_E.png"
				}, {
					filename: "UpLetters_bubbles_letter_F.png"
				}, {
					filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				}, {
					filename: "UpLetters_bubbles_letter_M.png"
				}, {
					filename: "UpLetters_bubbles_letter_N.png"
				}, {
					filename: "UpLetters_bubbles_letter_O.png"
				}, {
					filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				}, {
					filename: "UpLetters_bubbles_letter_R.png"
				}, {
					filename: "UpLetters_bubbles_letter_S.png"
				}, {
					filename: "UpLetters_bubbles_letter_T.png"
				}, {
					filename: "UpLetters_bubbles_letter_U.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_V.png"
				}, {
					filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 102,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 106,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_K.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_K.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "K_purple.png"
						},{
							type: "Found",
							filename: "K_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "UpLetters_bubbles_letter_A.png"
				}, {
					filename: "UpLetters_bubbles_letter_B.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_C.png"
				}, {
					filename: "UpLetters_bubbles_letter_D.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_E.png"
				}, {
					filename: "UpLetters_bubbles_letter_F.png"
				}, {
					filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_J.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				}, {
					filename: "UpLetters_bubbles_letter_M.png"
				}, {
					filename: "UpLetters_bubbles_letter_N.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_O.png"
				}, {
					filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				}, {
					filename: "UpLetters_bubbles_letter_R.png"
				}, {
					filename: "UpLetters_bubbles_letter_S.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_T.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 112,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 116,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_L.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_L.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "L_purple.png"
						},{
							type: "Found",
							filename: "L_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "UpLetters_bubbles_letter_A.png"
				}, {
					filename: "UpLetters_bubbles_letter_B.png"
				}, {
					filename: "UpLetters_bubbles_letter_C.png"
				}, {
					filename: "UpLetters_bubbles_letter_D.png"
				}, {
					filename: "UpLetters_bubbles_letter_E.png"
				}, {
					filename: "UpLetters_bubbles_letter_F.png"
				}, {
					filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_J.png"
				}, {
					filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_M.png"
				}, {
					filename: "UpLetters_bubbles_letter_N.png"
				}, {
					filename: "UpLetters_bubbles_letter_O.png"
				}, {
					filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				}, {
					filename: "UpLetters_bubbles_letter_R.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_S.png"
				}, {
					filename: "UpLetters_bubbles_letter_T.png"
				}, {
					filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				}, {
					filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 122,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 126,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_M.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_M.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "M_purple.png"
						},{
							type: "Found",
							filename: "M_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "UpLetters_bubbles_letter_A.png"
				}, {
					filename: "UpLetters_bubbles_letter_B.png"
				}, {
					filename: "UpLetters_bubbles_letter_C.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_D.png"
				}, {
					filename: "UpLetters_bubbles_letter_E.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_F.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_J.png"
				}, {
					filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				}, {
					filename: "UpLetters_bubbles_letter_N.png"
				}, {
					filename: "UpLetters_bubbles_letter_O.png"
				}, {
					filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				}, {
					filename: "UpLetters_bubbles_letter_R.png"
				}, {
					filename: "UpLetters_bubbles_letter_S.png"
				}, {
					filename: "UpLetters_bubbles_letter_T.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				}, {
					filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 132,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 136,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_N.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_N.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "N_purple.png"
						},{
							type: "Found",
							filename: "N_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "UpLetters_bubbles_letter_A.png"
				}, {
					filename: "UpLetters_bubbles_letter_B.png"
				}, {
					filename: "UpLetters_bubbles_letter_C.png"
				}, {
					filename: "UpLetters_bubbles_letter_D.png"
				}, {
					filename: "UpLetters_bubbles_letter_E.png"
				}, {
					filename: "UpLetters_bubbles_letter_F.png"
				}, {
					filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_J.png"
				}, {
					filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				}, {
					filename: "UpLetters_bubbles_letter_M.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_O.png"
				}, {
					filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_R.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_S.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_T.png"
				}, {
					filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 142,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 146,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_O.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_O.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "O_purple.png"
						},{
							type: "Found",
							filename: "O_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "UpLetters_bubbles_letter_A.png"
				}, {
					filename: "UpLetters_bubbles_letter_B.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_C.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_D.png"
				}, {
					filename: "UpLetters_bubbles_letter_E.png"
				}, {
					filename: "UpLetters_bubbles_letter_F.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				}, {
					filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_J.png"
				}, {
					filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				}, {
					filename: "UpLetters_bubbles_letter_M.png"
				}, {
					filename: "UpLetters_bubbles_letter_N.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				}, {
					filename: "UpLetters_bubbles_letter_R.png"
				}, {
					filename: "UpLetters_bubbles_letter_S.png"
				}, {
					filename: "UpLetters_bubbles_letter_T.png"
				}, {
					filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 152,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 156,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_P.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_P.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "P_purple.png"
						},{
							type: "Found",
							filename: "P_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "UpLetters_bubbles_letter_A.png"
				}, {
					filename: "UpLetters_bubbles_letter_B.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_C.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_D.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_E.png"
				}, {
					filename: "UpLetters_bubbles_letter_F.png"
				}, {
					filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_J.png"
				}, {
					filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				}, {
					filename: "UpLetters_bubbles_letter_M.png"
				}, {
					filename: "UpLetters_bubbles_letter_N.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_O.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				}, {
					filename: "UpLetters_bubbles_letter_R.png"
				}, {
					filename: "UpLetters_bubbles_letter_S.png"
				}, {
					filename: "UpLetters_bubbles_letter_T.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				}, {
					filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 162,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 166,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_Q.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_Q.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "Q_purple.png"
						},{
							type: "Found",
							filename: "Q_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "UpLetters_bubbles_letter_A.png"
				}, {
					filename: "UpLetters_bubbles_letter_B.png"
				}, {
					filename: "UpLetters_bubbles_letter_C.png"
				}, {
					filename: "UpLetters_bubbles_letter_D.png"
				}, {
					filename: "UpLetters_bubbles_letter_E.png"
				}, {
					filename: "UpLetters_bubbles_letter_F.png"
				}, {
					filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				}, {
					filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_J.png"
				}, {
					filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				}, {
					filename: "UpLetters_bubbles_letter_M.png"
				}, {
					filename: "UpLetters_bubbles_letter_N.png"
				}, {
					filename: "UpLetters_bubbles_letter_O.png"
				}, {
					filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_R.png"
				}, {
					filename: "UpLetters_bubbles_letter_S.png"
				}, {
					filename: "UpLetters_bubbles_letter_T.png"
				}, {
					filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				}, {
					filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 172,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 176,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_R.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_R.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "R_purple.png"
						},{
							type: "Found",
							filename: "R_found.png"
						}
					]
				}
			},
			distractors: [
				{
				//	filename: "UpLetters_bubbles_letter_A.png"
				//}, {
					filename: "UpLetters_bubbles_letter_B.png"
				}, {
					filename: "UpLetters_bubbles_letter_C.png"
				}, {
					filename: "UpLetters_bubbles_letter_D.png"
				}, {
					filename: "UpLetters_bubbles_letter_E.png"
				}, {
					filename: "UpLetters_bubbles_letter_F.png"
				}, {
					filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				}, {
					filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_J.png"
				}, {
					filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				}, {
					filename: "UpLetters_bubbles_letter_M.png"
				}, {
					filename: "UpLetters_bubbles_letter_N.png"
				}, {
					filename: "UpLetters_bubbles_letter_O.png"
				}, {
					filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				}, {
					filename: "UpLetters_bubbles_letter_S.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_T.png"
				}, {
					filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				}, {
					filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 182,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 186,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_S.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_S.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "S_purple.png"
						},{
							type: "Found",
							filename: "S_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "UpLetters_bubbles_letter_A.png"
				}, {
					filename: "UpLetters_bubbles_letter_B.png"
				}, {
					filename: "UpLetters_bubbles_letter_C.png"
				}, {
					filename: "UpLetters_bubbles_letter_D.png"
				}, {
					filename: "UpLetters_bubbles_letter_E.png"
				}, {
					filename: "UpLetters_bubbles_letter_F.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_J.png"
				}, {
					filename: "UpLetters_bubbles_letter_K.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_L.png"
				}, {
					filename: "UpLetters_bubbles_letter_M.png"
				}, {
					filename: "UpLetters_bubbles_letter_N.png"
				}, {
					filename: "UpLetters_bubbles_letter_O.png"
				}, {
					filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_R.png"
				}, {
					filename: "UpLetters_bubbles_letter_T.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_W.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 192,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 196,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_T.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_T.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "T_purple.png"
						},{
							type: "Found",
							filename: "T_found.png"
						}
					]
				}
			},
			distractors: [
				{
				//	filename: "UpLetters_bubbles_letter_A.png"
				//}, {
					filename: "UpLetters_bubbles_letter_B.png"
				}, {
					filename: "UpLetters_bubbles_letter_C.png"
				}, {
					filename: "UpLetters_bubbles_letter_D.png"
				}, {
					filename: "UpLetters_bubbles_letter_E.png"
				}, {
					filename: "UpLetters_bubbles_letter_F.png"
				}, {
					filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_J.png"
				}, {
					filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				}, {
					filename: "UpLetters_bubbles_letter_M.png"
				}, {
					filename: "UpLetters_bubbles_letter_N.png"
				}, {
					filename: "UpLetters_bubbles_letter_O.png"
				}, {
					filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				}, {
					filename: "UpLetters_bubbles_letter_R.png"
				}, {
					filename: "UpLetters_bubbles_letter_S.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				}, {
					filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 202,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 206,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_U.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_U.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "U_purple.png"
						},{
							type: "Found",
							filename: "U_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "UpLetters_bubbles_letter_A.png"
				}, {
					filename: "UpLetters_bubbles_letter_B.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_C.png"
				}, {
					filename: "UpLetters_bubbles_letter_D.png"
				}, {
					filename: "UpLetters_bubbles_letter_E.png"
				}, {
					filename: "UpLetters_bubbles_letter_F.png"
				}, {
					filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				}, {
					filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_J.png"
				}, {
					filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_M.png"
				}, {
					filename: "UpLetters_bubbles_letter_N.png"
				}, {
					filename: "UpLetters_bubbles_letter_O.png"
				}, {
					filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				}, {
					filename: "UpLetters_bubbles_letter_R.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_S.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_T.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				}, {
					filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 212,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 216,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_V.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_V.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "V_purple.png"
						},{
							type: "Found",
							filename: "V_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "UpLetters_bubbles_letter_A.png"
				}, {
					filename: "UpLetters_bubbles_letter_B.png"
				}, {
					filename: "UpLetters_bubbles_letter_C.png"
				}, {
					filename: "UpLetters_bubbles_letter_D.png"
				}, {
					filename: "UpLetters_bubbles_letter_E.png"
				}, {
					filename: "UpLetters_bubbles_letter_F.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				}, {
					filename: "UpLetters_bubbles_letter_I.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_J.png"
				}, {
					filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				}, {
					filename: "UpLetters_bubbles_letter_M.png"
				}, {
					filename: "UpLetters_bubbles_letter_N.png"
				}, {
					filename: "UpLetters_bubbles_letter_O.png"
				}, {
					filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				}, {
					filename: "UpLetters_bubbles_letter_R.png"
				}, {
					filename: "UpLetters_bubbles_letter_S.png"
				}, {
					filename: "UpLetters_bubbles_letter_T.png"
				}, {
					filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 222,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 226,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_W.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_W.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "W_purple.png"
						},{
							type: "Found",
							filename: "W_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "UpLetters_bubbles_letter_A.png"
				}, {
					filename: "UpLetters_bubbles_letter_B.png"
				}, {
					filename: "UpLetters_bubbles_letter_C.png"
				}, {
					filename: "UpLetters_bubbles_letter_D.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_E.png"
				}, {
					filename: "UpLetters_bubbles_letter_F.png"
				}, {
					filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				}, {
					filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_J.png"
				}, {
					filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				}, {
					filename: "UpLetters_bubbles_letter_M.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_N.png"
				}, {
					filename: "UpLetters_bubbles_letter_O.png"
				}, {
					filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				}, {
					filename: "UpLetters_bubbles_letter_R.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_S.png"
				}, {
					filename: "UpLetters_bubbles_letter_T.png"
				}, {
					filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 232,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 236,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_X.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_X.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "X_purple.png"
						},{
							type: "Found",
							filename: "X_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "UpLetters_bubbles_letter_A.png"
				}, {
					filename: "UpLetters_bubbles_letter_B.png"
				}, {
					filename: "UpLetters_bubbles_letter_C.png"
				}, {
					filename: "UpLetters_bubbles_letter_D.png"
				}, {
					filename: "UpLetters_bubbles_letter_E.png"
				}, {
					filename: "UpLetters_bubbles_letter_F.png"
				}, {
					filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				}, {
					filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_J.png"
				}, {
					filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				}, {
					filename: "UpLetters_bubbles_letter_M.png"
				}, {
					filename: "UpLetters_bubbles_letter_N.png"
				}, {
					filename: "UpLetters_bubbles_letter_O.png"
				}, {
					filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				}, {
					filename: "UpLetters_bubbles_letter_R.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_S.png"
				}, {
					filename: "UpLetters_bubbles_letter_T.png"
				}, {
					filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				}, {
					filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 242,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 246,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_Y.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_Y.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "Y_purple.png"
						},{
							type: "Found",
							filename: "Y_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "UpLetters_bubbles_letter_A.png"
				}, {
					filename: "UpLetters_bubbles_letter_B.png"
				}, {
					filename: "UpLetters_bubbles_letter_C.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_D.png"
				}, {
					filename: "UpLetters_bubbles_letter_E.png"
				}, {
					filename: "UpLetters_bubbles_letter_F.png"
				}, {
					filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				}, {
					filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_J.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				}, {
					filename: "UpLetters_bubbles_letter_M.png"
				}, {
					filename: "UpLetters_bubbles_letter_N.png"
				}, {
					filename: "UpLetters_bubbles_letter_O.png"
				}, {
					filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				}, {
					filename: "UpLetters_bubbles_letter_R.png"
				}, {
					filename: "UpLetters_bubbles_letter_S.png"
				}, {
					filename: "UpLetters_bubbles_letter_T.png"
				}, {
					filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				}, {
					filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Z.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 252,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 256,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "UpLetters_bubbles_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "UpLetters_bubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "UpLetters_bubbles_letter_Z.png"
				},
				popped: {
					filename: "UpLetters_outof_bubbles_letter_Z.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "Z_purple.png"
						},{
							type: "Found",
							filename: "Z_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "UpLetters_bubbles_letter_A.png"
				}, {
					filename: "UpLetters_bubbles_letter_B.png"
				}, {
					filename: "UpLetters_bubbles_letter_C.png"
				}, {
					filename: "UpLetters_bubbles_letter_D.png"
				}, {
					filename: "UpLetters_bubbles_letter_E.png"
				}, {
					filename: "UpLetters_bubbles_letter_F.png"
				}, {
					filename: "UpLetters_bubbles_letter_G.png"
				}, {
					filename: "UpLetters_bubbles_letter_H.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_I.png"
				}, {
					filename: "UpLetters_bubbles_letter_J.png"
				}, {
					filename: "UpLetters_bubbles_letter_K.png"
				}, {
					filename: "UpLetters_bubbles_letter_L.png"
				}, {
					filename: "UpLetters_bubbles_letter_M.png"
				}, {
					filename: "UpLetters_bubbles_letter_N.png"
				}, {
					filename: "UpLetters_bubbles_letter_O.png"
				//}, {
				//	filename: "UpLetters_bubbles_letter_P.png"
				}, {
					filename: "UpLetters_bubbles_letter_Q.png"
				}, {
					filename: "UpLetters_bubbles_letter_R.png"
				}, {
					filename: "UpLetters_bubbles_letter_S.png"
				}, {
					filename: "UpLetters_bubbles_letter_T.png"
				}, {
					filename: "UpLetters_bubbles_letter_U.png"
				}, {
					filename: "UpLetters_bubbles_letter_V.png"
				}, {
					filename: "UpLetters_bubbles_letter_W.png"
				}, {
					filename: "UpLetters_bubbles_letter_X.png"
				}, {
					filename: "UpLetters_bubbles_letter_Y.png"
				}
			]
		}
	]
};