/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var startTime;
var elapsedTime = null;
var breatheCount = 0;

$('#step1_button').on('click', onStep1);
$('#step2_button').on('click', onStep2);
$('#exit_button').on('click', onExit);

// step1
function onStep1() {
    startTime = new Date();
    $.mobile.changePage("#step2", {transition: "flip"});
}

// step2
function onStep2() {
    if (elapsedTime == null) {
        var currentTime = new Date();
        elapsedTime = (currentTime - startTime);
    }
    setTimeout(onStep3, elapsedTime * 2);
    $.mobile.changePage("#step3", {transition: "flip"});
    $('#step3_sec').text(elapsedTime * 2 / 1000);
}

// step3
function onStep3() {
    breatheCount += 1;
    if (breatheCount >= 10) {
        onStepEnd();
        return;
    }
    setTimeout(onStep4, elapsedTime * 2);
    $.mobile.changePage("#step4", {transition: "flip"});
    $('#step4_sec').text(elapsedTime * 2 / 1000);
}

// step4
function onStep4() {
    setTimeout(onStep2, elapsedTime);
    $.mobile.changePage("#step5", {transition: "flip"});
    $('#step5_sec').text(elapsedTime / 1000);
}

// stepEnd
function onStepEnd() {
    $.mobile.changePage("#step-end", {transition: "flip"});
    setTimeout(onExit, 3000);
}

function onExit() {
    window.close();
}
