var app = {
    cordova: false,
    device: null,
    // Application Constructor
    initialize: function() {
        this.bindEvents();
    },
    // Bind Event Listeners
    //
    // Bind any events that are required on startup. Common events are:
    // 'load', 'deviceready', 'offline', and 'online'.
    bindEvents: function() {
        document.addEventListener('deviceready', this.onDeviceReady, false);
        window.addEventListener('load', this.onLoad, false);
    },
    // deviceready Event Handler
    //
    // The scope of 'this' is the event. In order to call the 'receivedEvent'
    // function, we must explicitly call 'app.receivedEvent(...);'
    onDeviceReady: function() {
        app.receivedEvent('deviceready');
        console.log("Cordova running on " + cordova.platformId.toLowerCase());
        setupApp();
    },
    onLoad: function() {
        app.receivedEvent('load');
        if (typeof cordova !== "undefined") {
          console.log("In Cordova " + cordova.platformId);
        } else {
          // We are not in cordova so we don't wit for the deviceready.
          setupApp();
        }
    },
    // Update DOM on a Received Event
    receivedEvent: function(id) {
        var parentElement = document.getElementById(id);
        console.log('Received Event: ' + id);
    }
};
