// Returns a random integer between min (included) and max (excluded)
// Using Math.round() will give you a non-uniform distribution!
function getRandomInt(min, max) {
  return Math.floor(Math.random() * (max - min)) + min;
}
function validResult(result) {
  return result >= 0 && result<=9999;
}
var lastGames = {
  save: function() {
    this.lastgames = this.lastgames.slice(-9);
    this.lastgames.push(game);
    profileWrite("lastgames",this.lastgames);
  },
  won: function() {
    return this.lastgames.filter(function(g) {
      return g.won == true;
    });
  },
  max: function() {
    console.log("won", this.won().map(function (g) {return g.level}))
    if (this.won().length <1) {
      return 0
    }
    return Math.max.apply(null,this.won().map(function(g) {
      return g.level;
    }));
  },
  winRatio: function() {
    if (this.lastgames.length == 0) {
      return 0;
    }
    return this.won().length/this.lastgames.length;
  },
  min: function() {
    if (this.won().length <1) {
      return 0
    }
    return Math.min.apply(null,this.won().map(function(g) {
      return g.level;
    }));
  },
  init: function() {
    this.lastgames = profileRead("lastgames");
    if (!Array.isArray(this.lastgames)) {
        this.lastgames=[];
        for (i=0; i<10; i++) {
          this.lastgames.push(this.new());
        }
      }
      this.lastgame = this.lastgames[this.lastgames.length-1];
  },
  defaultgame: {
    'maxlevel': 6,
    'operation': '+',
    'level': 0,
    'operands': [],
    'trail': [],
    'strike': 0,
    'won': false
  },
  new: function(level) {
    var game = JSON.parse(JSON.stringify(this.defaultgame));
    if (typeof level != "undefined") {
      game.level = level;
    }

    var params = {
      '+': {
        result: function(o) { return o[0] + o[1]; },
        getOperands: function(min, max, carry) {
          var o, o0l, o1l, s, carrying = false;
          if (typeof carry == "undefined") {
            carry = false;
          }
          o = [getRandomInt(min, max), getRandomInt(min, max)];
          s = [String(o[0]), String(o[1])];
          var shorter = s[0].length < s[1].length ? 0 : 1;
          for (var i = 1; i <= s[shorter].length; i++) {
            s0i = s[0].length - i;
            s1i = s[1].length - i;
            carrying = (Number(s[0][s0i]) + Number(s[1][s1i])) > 9;
            if (carrying) {
              break;
            }
          }
          if (carry == carrying && validResult(min+max)) {
            return o;
          }
          return getOperands(min, max, carry);

        },
        level: [
          "getOperands(1, 9, false)",
          "getOperands(5, 19, false)",
          "getOperands(11, 39, false)",
          "getOperands(30, 99, true)",
          "getOperands(100, 499, true)",
          "getOperands(500, 999, true)"
        ],
      },
      '-': {
        result: function(o) { return o[0] - o[1]; },
        getOperands: function(min, max, borrow) {
          var o, o0l, o1l, s, carrying = false;
          if (typeof borrow == "undefined") {
            borrow = false;
          }
          o = [getRandomInt(min, max), getRandomInt(min, max)];
          s = [String(o[0]), String(o[1])];
          var shorter = s[0].length < s[1].length ? 0 : 1;
          for (var i = 1; i <= s[shorter].length; i++) {
            s0i = s[0].length - i;
            s1i = s[1].length - i;
            borrowing = (Number(s[0][s0i]) < Number(s[1][s1i]));
            if (borrowing) {
              break;
            }
          }
          if (borrow == borrowing && validResult(o[0]-o[1])) {
            return o;
          }
          console.log("Recurring", "borrow == borrowing",borrow == borrowing, o, validResult(o[0]-o[1]));
          return arguments.callee(min, max, borrow);
        },
        level: [
          "getOperands(1, 9, false)",
          "getOperands(5, 19, true)",
          "getOperands(11, 39, false)",
          "getOperands(30, 99, true)",
          "getOperands(100, 499, true)",
          "getOperands(500, 999, true)"
        ],
      },
      '×': {
        result: function(o) { return o[0] * o[1]; },
        getTable: function(min,max) {
            return [getRandomInt(2,10),getRandomInt(min,max)];
        },
        getOperands: function(min, max, handicap) {
          if (handicap) {
              o = [getRandomInt(min, max), getRandomInt(10, 20)];
          } else {
              o = [getRandomInt(min, max), getRandomInt(2, 9)];
          }
          return o;
        },
        level: [
          "getTable(2,5)",
          "getTable(5,7)",
          "getTable(10,10)",
          "getTable(7,9)",
          "getOperands(11, 40, false)",
          "getOperands(21, 111, false)",
          "getOperands(11, 50, true)"
        ],
      },
      '÷': {
        result: function(o) { return o[0]/o[1]; },
        getOperands: function(dividend, divisor, handicap) {
          if (typeof handicap == "undefined") {
            handicap = false;
          }
          dividend = getRandomInt(dividend[0], dividend[1]);
          divisor  = getRandomInt(divisor[0],   divisor[1]);
          quotient = Math.floor(dividend / divisor);
          reminder = dividend % divisor;
          if (!handicap && reminder>0) {
              dividend = divisor * quotient;
          }
          return [dividend,divisor];
        },
        level: [
          "getOperands([2,21], [2,3], false)",
          "getOperands([20,80], [4,6], false)"
        ],
      },
    }
    /* another game level sanitization */
    game.maxlevel = params[game.operation].level.length-1;
    if (game.level < 0) { game.level = 0; }
    if (game.level > game.maxlevel) {
      game.level = game.maxlevel;
    }
    console.log(game.operation,"level:", game.level, params[game.operation], params[game.operation].level[game.level]);
    console.log(params[game.operation].level[game.level]);
    console.log('params["' + game.operation + '"].' + params[game.operation].level[game.level])
    game.operands = eval('params["' + game.operation + '"].' + params[game.operation].level[game.level]);
    game.result = eval(params[game.operation].result(game.operands));
    return game;
  },
  get: function() {
    this.init();
    this.levels = this.lastgames.map(function(g) {
      if (g.won) {
        return g.level
      }
      return g.level-1; // If not won, count 1 less;
    });
    if (this.levels.length > 0) {
      this.lsum = this.levels.reduce(function (a,b) {return a+b});
    } else {
      this.lsum = 0;
    }
    return this.max();
  },
  debug: function() {
    var maxcount = this.won().filter(function(g) {
      return g.level == lastGames.max();
    }).length;
    var ccount = this.won().filter(function(g) {
      return g.level == Math.ceil(lastGames.lsum/lastGames.lastgames.length);
    }).length;
    return {
      'levels': {
        'maxcount': maxcount,
        'sum': this.lsum,
        'array': this.levels,
        'max': Math.max.apply(null,this.levels),
        'floor': Math.floor(this.lsum/this.lastgames.length),
        'ceil': Math.ceil(this.lsum/this.lastgames.length),
        'min': Math.min.apply(null,this.levels),
      },
      'maxlevel': Math.max.apply(null,this.levels),
      'count': {
        'max': maxcount,
        'current': ccount
      },
      'total': this.lastgames.length,
      'ratios': {
        'won': this.won().length/this.lastgames.length,
        'max/won': maxcount/this.won().length,
        'max/last': maxcount/this.lastgames.length,

      }
    }
  },
  last: function(minwon) {
    if (typeof minwon == "undefined") {
      minwon = 3;
    }
    return this.lastgames.slice(-minwon).some(function (g) {return g.won})
  },
  playLevel: function() {
    /*
    FIXME: Counterintuitive.
    We should have a game object and lastgames, setup and next should be methods of that object.
    */
    /*
      Algorithm:
        In the last 10 games
          If the
    */
    this.get()
    if (this.lastgames.length <1) {
      return 0;
    }
    var maxcount = this.won().filter(function(g) {
      return g.level == lastGames.max();
    }).length;
    var candidate, levels;
    levels = [0,0,0,0,0];

    if (!this.last(2)) {
      console.log("out !this.last(2)");
      candidate = this.lastgame.level - 1;
    } else if (this.levels.length >4) { // More than 5 won games
      if (this.winRatio() > 0.4 && this.lastgame.won && this.lastgame.level < this.lastgame.maxlevel) {
        sounds['levelup'].play();
        candidate = this.lastgame.level + 1;
      } else {
        console.log("out !this.winRatio() > 0.4");
        candidate = this.lastgame.level;
      }
    }
    if (candidate < 0) { candidate = 0; }
    if (candidate > this.lastgame.maxlevel) { candidate = this.lastgame.maxlevel; }
    return candidate;

    var l = {
      'sum': this.lsum,
      'array': this.levels,
      'max': Math.max.apply(null,this.levels),
      'floor': Math.floor(this.lsum/this.lastgames.length),
      'ceil': Math.ceil(this.lsum/this.lastgames.length),
      'min': Math.min.apply(null,this.levels),
    };
    return Math.ceil(this.lsum/this.lastgames.length);
  }
}

function savetrail() {
    var now = new Date();
    var storekey = "games" + now.getUTCFullYear() + "" + (now.getUTCMonth() + 1);
    var storedgames = profileRead(storekey);
    if (storedgames === undefined) {
      storedgames = {}
    }
    var gamekey = now.getTime();
    storedgames[gamekey] = game;
    profileWrite(storekey, storedgames);
    lastGames.save();
}
  /*
   */
function profileWrite(k, v) {
  lwrite(profileKey(k), v);
}

function profileKey(k) {
    return getCurrentProfile() + "_" + k;
}

function lwrite(key, v) {
  console.log("k: " + key + " v: " + JSON.stringify(v));
  localStorage[key] = JSON.stringify(v);
}

function profileDelete(k) {
  delete(localStorage[profileKey(k)]);
}

function rgbToHex(r, g, b) {
    if (typeof r == "string" && r.substr(0,4) == "rgb(") {
      var rgb = r.substr(4,r.length-5).split(",");
      r = Number(rgb[0].trim());
      g = Number(rgb[1].trim());
      b = Number(rgb[2].trim());
    }
    return "#" + ((1 << 24) + (r << 16) + (g << 8) + b).toString(16).slice(1);
}

function getCurrentProfile() {
  var i = lread('currentProfile');
  if ([0,1,2,3].indexOf(i) == -1 || typeof i == "undefined" ) {
    lwrite('currentProfile', 0);
    i=0;
  }
  return i;
  var profiles = lread("profiles");
  if (typeof profiles == "undefined" || profiles == null) {
    profiles = [];
  }
  var profileColor = window.getComputedStyle(document.querySelector("#profile #player button:nth-child(" + ( i + 1) + ")")).backgroundColor;
  var profileStyle = window.getComputedStyle(document.querySelector("#profile #player button:nth-child(" + ( i + 1) + ")"));
  if (typeof profiles[i] == "undefined" || profiles[i] == null) {
    profiles[i] = guid();
    lwrite("profiles", profiles);
  }
  console.log("getCurrentProfile " + i + " " +profiles[i] + " color: " + profileColor);
  console.log(document.querySelector("#profile #player button:nth-child(" + ( i + 1) + ")").tagName);
  console.log(rgbToHex(profileColor));
  return profiles[i];
}

function lread(key) {
  if (localStorage[key] === undefined) {
    return undefined;
  }
  console.log("lread " + key + ": " + localStorage[key]);
  try {
    return JSON.parse(localStorage[key]);
  } catch(e) {
    return undefined;
  }

}

function profileRead(k) {
  return lread(profileKey(k));
}

function setLevel(level) {
  profileWrite('level', level);
}

function getLevel(truelevel) {
  if (truelevel) {
    return Math.floor(getWins() / 20);
  }
   var level = Number(profileRead("level"));
  if  (!isNaN(level)) {
    game.level = level;
  } else {
    // localStorage["level"] = game.level;
    game.level = Math.floor(getWins() / 20);
  }
  return game.level;
}

function clearDiv(div) {
  while (div.firstChild) {
    div.removeChild(div.firstChild);
  }
}

function setOperation(operation) {
  document.title = operation;
  document.querySelector("h1").textContent = operation;
  var operands = document.querySelectorAll(".operand"),
    lastop = operands[operands.length - 1];
  var opDiv = lastop.insertBefore(document.createElement("div"), lastop.firstChild);
  opDiv.classList.add("digit");
  opDiv.textContent = operation;
}

function getUnits(index) {
  var positions = ["units",
    "tens",
    "hundreds",
    "thousands"
  ];
  return positions[index];
}

function showKeypad(index, target) {
  var positions = ["units",
    "tens",
    "hundreds",
    "thousands"
  ];
  var digitsDiv = document.querySelector("#digits");
  for (var i = 0; i < digitsDiv.classList.length; i++) {
    var c = digitsDiv.classList[i];
    digitsDiv.classList.remove(c);
  }
  digitsDiv.style.display = "initial";
  digitsDiv.classList.add(getUnits(index));
  digitsDiv["xin-target"] = target;
  vpcenter(digitsDiv);
  //digitsDiv.style.top = (resultDiv.offsetTop + resultDiv.offsetHeight) * 1.;
  digitsDiv.style.top = '';
  digitsDiv.style.bottom = '.2em';
}

function newDigit(char, kind) {
  var r = document.createElement(kind);
  r.classList.add("digit");
  r.textContent = char;
  if (kind === "button") {
    r.addEventListener('click', buttonPress);
    r.add
    var w = document.createElement("div");
    w.classList.add("digit");
    w.appendChild(r);
    return w;
  }
  return r;
}

function writeDiv(div, string, kind) {
  clearDiv(div);
  for (var i = 0; i < string.length; i++) {
    div.appendChild(newDigit(string[i], kind), div);
  }
  console.log("writeDiv", div, string);

}

function getOperands(low, high, handicap) {
  /*
  TODO: refactor to multiple operations
    carry would become handicap
  */
  var o, o0l, o1l, s, carrying = false;
  if (typeof carry == "undefined") {
    carry = false;
  }
  o = [getRandomInt(low, high), getRandomInt(low, high)];
  s = [String(o[0]), String(o[1])];
  var shorter = s[0].length < s[1].length ? 0 : 1;
  for (var i = 1; i <= s[shorter].length; i++) {
    s0i = s[0].length - i;
    s1i = s[1].length - i;
    carrying = (Number(s[0][s0i]) + Number(s[1][s1i])) > 9;
    if (carrying) {
      console.log("carry!", s, getUnits(i - 1), Number(s[0][s0i]), Number(s[1][s1i]));
      break;
    }
  }
  console.log("Seguimos", o);
  if (carry != carrying) {
    return getOperands(low, high, carry);
  }
  return o;
}

function setupGame() {
  game = lastGames.new(lastGames.playLevel());
  document.querySelector("#profile").style.display = 'none';
  console.log("setupGame", game);


  opels = document.querySelectorAll(".operand");
  for (var i = 0; i < opels.length; i++) {
    writeDiv(opels[i], String(game.operands[i]), "div");

  };
  setOperation(game.operation);

  setupResult(String(game.result));
  replaceElements();
  playing = true;



}

function setupResult(string) {
  var zeros = "";
  for (var i = 0; i < string.length; i++) {
    zeros += "0";
  }
  writeDiv(resultDiv, zeros, "button")
}

function getWins() {
  var wins = profileRead("wins");
  if (typeof wins == "undefined") {
    wins = 0;
  }
  return wins;
}
function isEveryTrue(value, index, array) {
  return value
}
function check(element) {
  console.log("check " + JSON.stringify(checkResult()));
  var checkArray = checkResult();
  if (checkArray.every(isEveryTrue)) {
    // Win
    console.log("check ok");

    var wins = getWins();
    wins++;
    profileWrite("wins", wins);
    game.won = true;
    solve("ok");
  } else {
    console.log(["check ko", checkArray , game.result, readResult()]);
    if (game.trail.length >= String(game.result).length) {
      strike(element);
    }
  }
}

function buttonPress(e) {
  sounds['key'].play();

  var button = e.target,
    parent = e.target.parentNode.parentNode,
    digitsDiv = document.querySelector("#digits");
  console.log(parent.id, button.textContent);
  switch (parent.id) {
    case "result":
      var i = 0;
      var n = button.parentNode;
      while ((n = n.previousSibling) != null)
        i++;
      console.log("result", i, parent.children.length - i, button.parentNode);
      showKeypad(parent.children.length - i - 1, button);
      break;
    case "digits":
      game.trail.push({
        "value": button.textContent,
        "position": digitsDiv.classList.toString()
      });
      digitsDiv["xin-target"].textContent = button.textContent;
      digitsDiv.style.display = "none";
      check(digitsDiv["xin-target"]);
      break;
  }

}

function replaceElements() {

  var digitsDiv = document.querySelector("#digits");
  showKeypad(1);
  digitsDiv.style.display = "none";
  document.querySelector("#badge-ok span:first-of-type").textContent = Math.round(lastGames.winRatio()*100);
  document.querySelector("#badge-ko span:first-of-type").textContent = 3;

}

function endAnimation(e) {
  console.log("Finishing animation " + e.target.id);
  resultDiv.style = '';
  if (!playing) {
      setupGame();
  }
  e.target.classList.remove("ko");
  e.target.classList.remove("ok");

}

function readResult() {
  var digits = resultDiv.querySelectorAll("button");
  var lecture = "";
  for (var i = 0; i < digits.length; i++) {
    lecture += digits[i].textContent;
  }
  return Number(lecture);
}

function checkResult() {
  var digits = resultDiv.querySelectorAll("button");
  var check = [];
  var lecture = "";
  var result  = String(game.result);
  for (var i = 0; i < digits.length; i++) {
    check[i] = digits[i].textContent == result[i];
  }
  return check;
}


function strike() {
  game.strike++;
  var badge = document.querySelector("#badge-ko");

  document.querySelector("#badge-ko span:first-of-type").textContent = 3 - game.strike;
  flash(badge);

  console.log("game.strike", game.strike);
  if (game.strike == 3) {
    game.won = false;
    solve("ko");
    return;
  }

  sounds['strike'].play();
}

function solve(state) {
  console.log("Log before sound");
  sounds[state].play();
  playing = false;
  console.log("Snootchie-bootchies!");

  var badge = document.querySelector("#badge-" + state);

  flash(badge,true);
  savetrail();
  //
}

function setMode(mode) {}

var game;

var playing = false;

var resultDiv;


var unfilled;
var operationDiv = document.querySelector("#operation");


window.addEventListener('load', function() {
/*
  try {
    setupApp();
  } catch (e) {
    console.log(e);
    //throw(e);
  }
  */
  // setupApp();
});
var sounds = {
  'ok': null,
  'levelup': null,
  'ko': null,
  'strike': null,
  'key': null
};

function setupApp() {

  console.log("Can play " + (new Audio()).canPlayType("audio/mp3"));
  Object.keys(sounds).forEach(function(v, i, array) {
    var soundfile = 'res/sound/' + v + '.mp3';
    if (typeof cordova != 'undefined' && cordova.platformId.toLowerCase() == "android") {
      console.log("Loading Audio: Cordova Media");
      soundfile = '/android_asset/www/' + soundfile;
      sounds[v] = new Media(soundfile, function(e) {
        console.log(" + audio loaded " + soundfile);
        console.log(e);
      }, function(e) {
        console.log(" - audio error " + soundfile);
        console.log(e);
      });
//      sounds[v] = document.createElement("audio");
//      sounds[v].src = v + ".mp3";

    } else {
      console.log("Loading Audio: W3");
      sounds[v] = new Audio(soundfile);
    }
    //
  });

  document.querySelector('button#toggleProfile').addEventListener('click', toggleProfile);
  document.addEventListener('click', dismissViews);
  map(document.querySelectorAll('#player button'), function(e) {e.addEventListener('click', profileButtonClick);});

  operationDiv = document.querySelector("#operation");
  resultDiv = document.getElementById('result');

  writeDiv(document.querySelector("#digits"),"7894561230","button");
  if ([0,1,2,3].indexOf(lread("currentProfile")) == -1) {
    lwrite('currentProfile', 0);
  }
  if (!Array.isArray(lread("profiles"))) {
    lwrite("profiles",[]);
  }
  selectProfile(lread('currentProfile'));



  resultDiv.addEventListener("animationend", endAnimation, true);
  /*
    One big reason to prefer Firefox over the rest: they don't abuse the
    vendor prefix and adhere to the standards when possible.

    TODO: Implement animations for Opera and IE10
  */
  resultDiv.addEventListener("webkitAnimationEnd", endAnimation, true); // Webkit
  resultDiv.addEventListener("oanimationend", endAnimation, true); // Opera
  resultDiv.addEventListener("MSAnimationEnd", endAnimation, true); // IE10

}

function dismissViews(e) {
console.log(e.target.tagName);
  if (["HTML","DIV","H1"].indexOf(e.target.tagName) >= 0) {
    document.querySelector("#digits").style.display = document.querySelector("#profile").style.display="none";
    document.querySelector("#content").style.display = "block";
  }
}
function selectProfile(profileIndex) {
  lwrite('currentProfile', profileIndex);
  console.log("Select profile " + profileIndex + " " + getCurrentProfile());
  var profileColor = window.getComputedStyle(document.querySelector("#profile #player button:nth-child(" + (Number(lread('currentProfile')) + 1) + ")")).getPropertyValue("background-color");
  document.querySelector("#toggleProfile").style.backgroundColor = profileColor;
  document.querySelector("h1").style.backgroundColor = profileColor;
  map(document.querySelectorAll('#profile > div'), function(e) {
    e.style.backgroundColor = profileColor;
  });

//  document.querySelector("#profile #player").style.backgroundColor = profileColor;
  var selected = document.querySelector('#player button.selected');
  if (selected != null) {
    document.querySelector('#player button.selected').classList.remove("selected");
  }
  document.querySelector("#profile #player button:nth-child(" + (Number(lread('currentProfile')) +1 ) + ")")
    .classList.add("selected");
  setupGame();
}

function profileButtonClick(e) {
  sounds['key'].play();
  var newProfile = window.getComputedStyle(e.target);
  var profileIndex = toarr(e.target.parentNode.children).indexOf(e.target);
  selectProfile(profileIndex);
}

function toggleProfile() {
  sounds['key'].play();
  var profileDiv = document.querySelector("#profile");
//  var contentDiv = document.querySelector("#content");
  if (window.getComputedStyle(profileDiv)['display'] == "none") {
    profileDiv.style.display = 'block';
//    contentDiv.style.display = 'none';
  } else {
    profileDiv.style.display = 'none';
//    contentDiv.style.display = 'block';
  }

}
function hideOperation() {
  var element = document.querySelector("#operation");
  operationDiv.style.opacity = 0;
  element.style.left = -element.offsetWidth + "px";
}

function reflow() {
  document.body.offsetTop = document.body.offsetTop;
}

function flash(e,long) {
  // resultDiv.style.backgroundColor = document.defaultView.getComputedStyle(e,"").getPropertyValue("background-color");
  resultDiv.classList.remove("long");
  e.classList.remove("long");
  resultDiv.classList.remove("flash");
  e.classList.remove("flash");
  reflow();
  e.classList.add("flash");
  resultDiv.classList.add("flash");
  if (long === true) {
    e.classList.add("long");
    resultDiv.classList.add("long");
  }
}

function vpcenter(vpc) {
  console.log("centering", vpc);
  console.log("window:", window.innerWidth, "x", window.innerHeight);
  console.log("element:", vpc.offsetWidth, "x", vpc.offsetHeight);
  console.log(window.innerHeight / 2, vpc.offsetHeight / 2);
  vpc.style.left = ((window.innerWidth / 2) - (vpc.offsetWidth / 2)) + "px";
  vpc.style.top = ((window.innerHeight / 2) - (vpc.offsetHeight / 2)) + "px";
  vpc.style.position = "absolute";
}

function debug(wat) {
  document.getElementById('debug').textContent += new Date() + "> " + wat + "\n";
}

app.initialize();

// convenience
function map() {
    var args = [].slice.call(arguments, 0);
    var ctx = args.shift();
    return [].map.apply(ctx, args);
}

function toarr(arr) {
  return [].slice.call(arr);
}

// http://stackoverflow.com/a/105074/267777

var guid = (function() {
  function s4() {
    return Math.floor((1 + Math.random()) * 0x10000)
               .toString(16)
               .substring(1);
  }
  return function() {
    return s4() + s4() + '-' + s4() + '-' + s4() + '-' +
           s4() + '-' + s4() + s4() + s4();
  };
})();
