var DEBUG = false,
    selectedDay = -1;

// for release, make this device.ready
$(document).on('deviceready', function() {
    init();
});

// protocol is "http:"" when we're debugging, "file:" on device, so this is a good way of firing init during testing
$(function() {
    if(location.protocol.indexOf('http') > -1) {
        init();
    }
});

var init = function() {
    FastClick.attach(document.body);

    var $adventSquare = $('.advent-square'),
        adventSquareWidth = $adventSquare.width(),
        todaysDate = new Date().getDate(),
        thisMonth  = new Date().getMonth();

    if(todaysDate > 24 || thisMonth !== 11 || DEBUG) {
        todaysDate = 0;
        $('#background-image-old').css({'background':'url(img/1.jpg) no-repeat center center fixed', 'background-size':'cover'});
        setImageAttribution(1);
    } else if(todaysDate > 1) {
        $('#background-image-old').css({'background':'url(img/' + (todaysDate - 1) + '.jpg) no-repeat center center fixed', 'background-size':'cover'});
        setImageAttribution(todaysDate - 1);
    }

    $adventSquare.height(adventSquareWidth).css({'line-height':adventSquareWidth+'px'});

    $('.advent-box').css({'padding-top':(($(window).height() - $('.advent-box').height()) / 2) + 'px'});


    if(thisMonth !== 11 && !DEBUG) {
        console.log('Not December!');
        $('.not-christmas').show();
        $('.advent-box').addClass('disabled');
    } else {
        $adventSquare.filter("[data-day='" + todaysDate + "']").addClass('clickable today');
        for(var i=1; i<=todaysDate; i++) {
            $('.advent-square[data-day="' + i + '"]').addClass('clickable opened');
        }

        if(DEBUG) {
            $('.advent-square').addClass('clickable');
        }

        $adventSquare.on('click', function() {
            var $this = $(this);
            selectedDay = $this.data('day');

            if(!$this.hasClass('clickable') || $('.advent-box').hasClass('disabled')) {
                return false;
            }

            $this.addClass('animated open-door selected');
            $('.advent-box').addClass('disabled');

            setTimeout(function() {
                $adventSquare.fadeOut();
                revealNewDay($this.data('day'));
            }, 1000);

            // set the line height after the animation is complete so the height is correct
            setTimeout(function() {
                var $todaySquare = $this;
                $todaySquare.animate({'line-height':$todaySquare.height() + 'px'}, 100);
            }, 2000);
        });

        $(document).on('click', '.fake-link', function() {
            window.open($(this).data('link'), '_system');
        });

        $('#setWallpaper').on('click', function() {
            setWallpaper(selectedDay);
        });

        $(document).on('backbutton', function() {
            onBackButton();
        });

        $('.back-button').on('click', function() {
            onBackButton();
        });
    }

    $('.loading-overlay').fadeOut();
};

var onBackButton = function() {
    location.reload();
};

var getDaysUntilChristmas = function() {
    var now = new Date(),
        christmas = new Date(now.getFullYear(), 11, 25);

    return Math.ceil((christmas - now)/(1000*60*60*24), 10);
};

var revealNewDay = function(day) {
    var todaysDate = parseInt(day, 10);//= new Date().getDate();

    // $('.days-until').html('There are only ' + getDaysUntilChristmas() + ' days until Christmas!').show();

    $('#background-image-old').addClass('animated fadeOutDownBig');
    $('body').css({'background':'url(img/' + todaysDate + '.jpg) center center no-repeat fixed', 'background-size':'cover'});

    setTimeout(function() {
        setImageAttribution(todaysDate);
    });

    setTimeout(function() {
        $('.thing-' + todaysDate).show();
        $todaysThing = $('.todays-thing');
        if(deviceIsAndroid || DEBUG) {
            $todaysThing.addClass('with-button');
        }
        $todaysThing.show().css({'margin-top': $todaysThing.outerHeight() / -1.75 + 'px'}).addClass('animated bounceInUp');
        $('.back-button').fadeIn();
        $('.wallpaper-button').fadeIn();
    }, 500);
};

var setImageAttribution = function(day) {
    $('#image-attribution').html('Today\'s image was taken by <span class="fake-link" data-link="' + images[day-1].url + '">' + images[day-1].author + '</span>');
};

var setWallpaper = function(imageId) {
    if($('#setWallpaper').hasClass('disabled')) {
        return;
    }

    var imagePath = 'www/img/' + imageId + '.jpg',
        imageTitle = 'Day ' + imageId,
        exportPath = 'AdventCalendarImages';

    $('#setWallpaper').text('Setting wallpaper ...');

    wallpaper.setImage(imagePath, imageTitle, exportPath,
        function() {
            $('#setWallpaper').text('Wallpaper set!').addClass('disabled');
        },
        function() {
            alert('Could not set wallpaper, please try again');
            $('#setWallpaper').text('Set wallpaper').removeClass('disabled');
        });
};

images = [
    {
        'author':'Beatnik Photos',
        'url':'https://secure.flickr.com/photos/dharmabum1964/3108177283'
    },
    {
        'author':'RAYANDBEE',
        'url':'https://secure.flickr.com/photos/rayandbee/4040738002/'
    },
    {
        'author':'Luz Adriana Villa A.',
        'url':'https://secure.flickr.com/photos/luchilu/2122762150/'
    },
    {
        'author':'Sebastian Dooris',
        'url':'https://secure.flickr.com/photos/sebastiandooris/3047057158/'
    },
    {
        'author':'dominicotine',
        'url':'https://secure.flickr.com/photos/dominicotine/5944632130'
    },
    {
        'author':'seelensturm',
        'url':'https://secure.flickr.com/photos/seelensturm/5231715284/'
    },
    {
        'author':'Matthew Ring',
        'url':'https://secure.flickr.com/photos/mattring/8276441593/'
    },
    {
        'author':'AlicePopkorn',
        'url':'https://secure.flickr.com/photos/alicepopkorn/2063095876/'
    },
    {
        'author':'gia_s',
        'url':'https://secure.flickr.com/photos/giasadhwani/79796838/'
    },
    {
        'author':'CmdrGravy',
        'url':'https://secure.flickr.com/photos/cmdrgravy/108414421/'
    },
    {
        'author':'woodleywonderworks',
        'url':'https://secure.flickr.com/photos/wwworks/5339500307/'
    },
    {
        'author':'ercwttmn',
        'url':'https://secure.flickr.com/photos/ricoslounge/328791944/'
    },
    {
        'author':'sociotard',
        'url':'https://secure.flickr.com/photos/9918311@N02/3136725337/'
    },
    {
        'author':'Clearly Ambiguous',
        'url':'https://secure.flickr.com/photos/clearlyambiguous/99012567/'
    },
    {
        'author':'Michael Hammerton',
        'url':'https://secure.flickr.com/photos/mikehamm/6458492255/'
    },
    {
        'author':'rennes.i',
        'url':'https://secure.flickr.com/photos/mandarina94/8327299404/'
    },
    {
        'author':'allison.hare',
        'url':'https://secure.flickr.com/photos/allisonhare'
    },
    {
        'author':'mikejmartelli',
        'url':'https://secure.flickr.com/photos/mikemartelli/4142995884/'
    },
    {
        'author':'David Hepworth',
        'url':'https://secure.flickr.com/photos/medhead/2522666636/'
    },
    {
        'author':'Dano',
        'url':'https://secure.flickr.com/photos/mukluk/316665247/'
    },
    {
        'author':'ninacoco',
        'url':'https://secure.flickr.com/photos/geishabot/2133747333/'
    },
    {
        'author':'y entonces',
        'url':'https://secure.flickr.com/photos/estudiante/5322595200/'
    },
    {
        'author':'Chris_J',
        'url':'https://secure.flickr.com/photos/chrisjones/'
    },
    {
        'author':'Michael Hammerton',
        'url':'https://secure.flickr.com/photos/mikehamm/5254198817/'
    },
    {
        'author':'Ryan Holst',
        'url':'https://secure.flickr.com/photos/holstphoto/3306031188/'
    }
];
