sessionStorage.setItem("pagina_navegar","index");
sessionStorage.setItem("estado_conexion","si");
sessionStorage.setItem("id_noticia_actual","");
sessionStorage.setItem("id_galeria_actual","");
sessionStorage.setItem("detalle_noticia","");
sessionStorage.setItem("orientacion","vertical");

sessionStorage.setItem("tokenregistro","");
sessionStorage.setItem("firma_agricultor",localStorage.getItem("firma_agricultor"));
sessionStorage.setItem("recarga_albaranes","si");


//Otras variables
var scrollpanel;
var scrollcontenido;
var datos_en_memoria = "";
var datos_recarga;
var respuestaboton = 150;//tiempo de retardo en hacer los timeout de los tap de los botones
sessionStorage.setItem("galeria_abierta","no");
//const ruta_aplicacion = "http://agroejido.indalweb.net/app/";
const ruta_aplicacion = "https://www.agroejido.com/app/";

//Obtención de la hora local para saber si actualizar el contenido o no según haya pasado cierto tiempo
var ahora = new Date(); 
sessionStorage.setItem('hora_actual',ahora);

/**
 * mensaje_consola()
 * Función para sacar mensajes por pantalla si estamos en el modo depuración
 * @param mensaje
 */
function mensaje_consola(mensaje){
    if(sessionStorage.getItem("depuracion") == "true"){
        console.log(mensaje);
    }
}

/**
 * calcular_fecha(f_actual, f_guardada)
 * Función para calcular la direfencia de la fecha y hora actual con la que tenga almacenada
 * @param f_actual La fecha y hora actual
 * @param f_guardada La fecha y hora que se tenga guardada en localStorage
 * @retun true false dependiendo de si la fecha es mayor a 15 minutos o no
 */
function calcular_fecha(f_actual, f_guardada){
    f_act = Date.parse(f_actual);
    f_ant = Date.parse(f_guardada);
    diferencia = f_act - f_ant;
    //15 minutos de recarga
    if(diferencia > 900000){
        return true;
    }else{
        return false;
    }
}

/**
 * Fecha_Hoy()
 * Método para sacar la fecha de hoy con un formato determinado
 * @returns date Variable con la fecha
 */
function Fecha_Hoy(){
    var d = new Date();
    var day = d.getDate();
    var month = d.getMonth() + 1;
    var year = d.getFullYear();
    if (day < 10) {
        day = "0" + day;
    }
    if (month < 10) {
        month = "0" + month;
    }
    var date = year + "-" + month + "-" + day;
    return date;        
}

/**
 * Generar_Firma()
 * Método para generar la firma con un código junto con la fecha diaria
 * @returns aux Variable con el resultado del md5 de nuestro codigo y fecha.
 */
function Generar_Firma(cadena){
    var hoy =new Date();
    var clave = "OENC67hfdg34KJyHG5749U";
    var aux = Fecha_Hoy();
    aux = aux + cadena + clave;
    aux = $.md5(aux);
    return aux;
}

/**
 * actualizar_idgaleria(id)
 * Método para almacenar en el session storage el id de la galeria que queremos mostrar
 * @param id Variable con el id
 */
function actualizar_idgaleria(id){
	sessionStorage.setItem("id_galeria_actual",id);
}

/**
 * alerta_texto(texto)
 * Método para lanzar un alert de sistema
 * @param texto Variable con el texto a mostrar
 */
function alerta_texto(titulo,texto) {
    navigator.notification.alert(texto,null,titulo,'Aceptar');
}

/**
 * navegacion_inicio_portada()
 * función para cargar un index dependiendo de si es móvil o tablet
 */
function navegacion_inicio_portada() {
	if (sessionStorage.getItem("dispositivo") == "movil") {
		$.mobile.changePage( "index.html", {transition: "none",reverse: false,changeHash: true,reloadPage: false});
	}else{
		$.mobile.changePage( "index-tablet.html", {transition: "none",reverse: false,changeHash: true,reloadPage: false});
	}
}



/********** INICIAMOS LA APP **********/
var app = {
    initialize: function() {
        this.bindEvents();
    },
    bindEvents: function() {
        document.addEventListener('deviceready', this.onDeviceReady, false);
    },
    onDeviceReady: function() {
        app.receivedEvent('deviceready');

		sessionStorage.setItem("iddispositivo","FirefoxOS");
		sessionStorage.setItem("plataforma","FirefoxOS");

    },
    // Update DOM on a Received Event
    receivedEvent: function(id) {
        mensaje_consola('Received Event: ' + id);
    },
    // result contains any message sent from the plugin call
    successHandler: function(result) {
        mensaje_consola('Callback Success! Result = '+result);
    },
    errorHandler:function(error) {
        mensaje_consola(error);
    }
};


//inicializamos la app
app.initialize();
/********************************************************************/




/** ACCIONES DE ESTADO DE LA APP **/
/********************************************************************/

/**
 * compruebaInicio()
 * Método para comprobar que tipo de inicio tenemos, si es de móvil o de tablet
 */
function compruebaInicio(){
    var url;
    if(sessionStorage.getItem("dispositivo") == "tablet"){
        url = "index-tablet.html";
    }else{
        url = "index.html";
    }
    return url;
}

/**
 * botonVolver()
 * Método con las acciones a realizar cuando pulsamos el botón de Android volver según la página en la que nos encontramos
 */
function botonVolver() {
    var idPagina = $.mobile.activePage.attr( "id" );
    // si estamos en portada
    if ((idPagina == 'secportada')||(idPagina == 'secportadatablet')) {
        salir_app();
    } else {
        switch(idPagina)
        {
            case 'productos':
            case 'noticias':
            case 'precios':
            case 'rsociales':
            case 'contactar':
            case 'sobre_nosotros':
            case 'formulario_agricultores':
            case 'entrada_agricultores':
                mensaje_consola("volvemmos a la portada");
                navegacion_inicio_portada();
            break;
            //AREA AGRICULTORES
            case 'avisos':
            case 'noticias_agricultores':
            case 'albaranes':
            case 'mis_datos':
                $.mobile.changePage( "entrada_agricultores.html", {transition: "none",reverse: true,changeHash: true,reloadPage: false});
            break;
            case 'detalle_albaran':
                $.mobile.changePage( "albaranes.html", {transition: "none",reverse: true,changeHash: true,reloadPage: false});
            break;
            //PIZARRAS
            case 'pizarra':
                $.mobile.changePage( "precios.html", {transition: "none",reverse: true,changeHash: true,reloadPage: false});
            break;
            //PRODUCTOS
            case 'pimiento':
            case 'pepino':
            case 'calabacin':
            case 'judia':
            case 'berenjena':
            case 'tomate':
            case 'melon':
            case 'sandia':
            case 'guisante':
                $.mobile.changePage( "productos.html", {transition: "none",reverse: true,changeHash: true,reloadPage: false});
            break;
            //DETALLE NOTICIA
            case 'detalle_noticia':
                $.mobile.changePage( "noticias.html", {transition: "none",reverse: true,changeHash: true,reloadPage: false});
            break;
            case 'detalle_galeria_noticia':
                if(sessionStorage.getItem("galeria_abierta") == "no"){
                    mensaje_consola("codigo para volver atras");
                    history.back(1);
                }else{
                    mensaje_consola("codigo para cerrar la foto y volver atras");
                    window.Code.PhotoSwipe.activeInstances[0].instance.hide();
                }
            break;
        }
    }
}

/********************************************************************/






/** NAVEGACION **/
/********************************************************************/
/**
 * cambio_pagina()
 * Método para cargar una página pasada por parámetro
 * aux: variable con el nombre de la nueva página a cargar, según el id del botón del que extraemos la cadena del nombre final
 */
function cambio_pagina(){
    final = sessionStorage.getItem("pagina_navegar");
    final = final + ".html";
    $.mobile.changePage( final, {
    transition: "none",
    reverse: false,
    changeHash: true,
    reloadPage: false
    });
}
/**
 * cambio_noticias()
 * Método para ir al detalle noticia
 */
function cambio_noticias(){
    $.mobile.changePage( "detalle_noticias.html", {
    transition: "none",
    reverse: false,
    changeHash: true,
    reloadPage: false
    });
}
/********************************************************************/



/** SCROLLS DE LA APP **/
/********************************************************************/
/**
 * actualizar_scroll(contenedor)
 * @param contenedor variable con el contenedor a refrescar para el scroll
 */
function actualiza_scroll(contenedor){
    scrollcontenido = new IScroll(contenedor, {
        scrollX: false,
        scrollY: true,
        click:true, // open click event
        scrollbars: false,
        useTransform: true,
        useTransition: false,
        probeType:1});
}
/**
 * actualizar_scrollpanel(contenedor)
 * @param contenedor variable con el contenedor a refrescar para el scroll del panel
 */
function actualiza_scrollpanel(contenedor){
    scrollpanel = new IScroll(contenedor, {
        scrollX: false,
        scrollY: true,
        click:true, // open click event
        scrollbars: false,
        useTransform: true,
        useTransition: false,
        probeType:1});
}
/********************************************************************/


/** BOTONES DE LA CABECERA**/
/****************************/
/**
 * botones_cabecera()
 * Método con las acciones de los botones que vamos a tener en la cabecera de la app
 */
function botones_cabecera() {
    mensaje_consola("botones cabecera añadidos");
    $(document).on('vmousedown', ".boton_menu_cebecera", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
         mensaje_consola("boton menu");
        $(this).css("background-color","#004421");
    });
    $(document).on('vmouseup', ".boton_menu_cebecera", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background-color","inherit");
		$(".mypanel").panel( "open" );
    });
    $(document).on('vmousedown', ".boton_volver_cebecera", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
         mensaje_consola("boton volver");
        $(this).css("background-color","#004421");
    });
    $(document).on('vmouseup', ".boton_volver_cebecera", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background-color","inherit");
        botonVolver();
    });
}
/********************************************************************/




/** CREACIÓN Y EVENTOS DE LOS PANELES **/
/********************************************************************/
/**
 * pagina_actual(capa)
 * Método para crear la cadena de acceso a las capas de los botones del catálogo según la página que se encuentre cargada en el momento
 * @param capa Variable con el id de la capa cargadora dónde queremos inyectar html
 * @returns aux Devuelve la cadena de acceso
 */
function pagina_actual(capa){
	var aux = "#" + $.mobile.activePage.attr('id') + " " + capa;
	return aux;
}

/**
 * acciones_botones_panel()
 * Método para aplicar las acciones de pulsado al panel de la izquierda
 */
function acciones_botones_panel(){
    $(document).on('tap taphold', ".boton_panel", function (event) {
        event.preventDefault();event.stopImmediatePropagation();

        valor = $(this).attr("id");
        valor = valor.substring(2,valor.length);
        mensaje_consola("valor del panel -> " + valor);

        if(valor != ($.mobile.activePage.attr('id'))){
            $(this).css("background","#378B2F").css("color","#fff").css("border-top","1px solid #378B2F");
            if (valor == "salir") {
                window.setTimeout('salir_app()',respuestaboton);
            }else{
                if (valor == "cerrar_sesion") {
                    mensaje_consola("cerrar_sesion pulsado")
                    window.setTimeout('salida_agricultor("1")',respuestaboton);
                }
                else{
                    if((valor == "secportada")||(valor == "secportadatablet")){
                        window.setTimeout("navegacion_inicio_portada()",respuestaboton);
                    }else{
                        sessionStorage.setItem("pagina_navegar", valor);
                        window.setTimeout("cambio_pagina()",respuestaboton);
                    }
                }
            }
        }
    });
}
/**
 * panel_izquierda(panel)
 * Método para añadir el contenido y activar las acciones en el panel de la izquierda de la App
 * @param panel Variable con el id del contenedor de carga del panel, que varia según la sección apra evitar errores en la carga
 * @param tipo Variable con el tipo de panel a cargar, público o privado.
 * Añadimos acciones sobre el boton Inicio del pie de la App
 */
function panel_izquierda(panel,tipo) {
	$(".mypanel").panel( "close" );
	panel = pagina_actual(panel);
	$(panel).empty();
    switch(tipo)
    {
        case 'publico':
            $(panel).append('<li class="cabecera_panel">MENU</li>' +
            '<li class="boton_panel" id="p_secportada">INICIO</li>' +
            '<li class="boton_panel" id="p_precios">PRECIOS</li>' +
            '<li class="boton_panel" id="p_noticias">NOTICIAS</li>' +
            '<li class="boton_panel" id="p_productos"">PRODUCTOS</li>' +
            '<li class="boton_panel" id="p_sobre_nosotros">SOBRE NOSOTROS</li>' +
            '<li class="boton_panel" id="p_contactar">CONTACTAR</li>' +
            '<li class="boton_panel" id="p_rsociales">REDES SOCIALES</li>' +
            '<li class="boton_panel" id="p_formulario_agricultores">ÁREA AGRICULTORES</li>');
        break;
        case 'privado':
            $(panel).append('<li class="cabecera_panel">AGRICULTORES</li>' +
            '<li class="boton_panel" id="p_entrada_agricultores">MENU AGRICULTORES</li>' +
            '<li class="boton_panel" id="p_avisos">AVISOS</li>' +
            '<li class="boton_panel" id="p_noticias_agricultores">NOTICIAS</li>' +
            '<li class="boton_panel" id="p_albaranes">ALBARANES</li>' +
            '<li class="boton_panel" id="p_mis_datos">MIS DATOS</li>' +
            '<li class="boton_panel" id="p_cerrar_sesion">CERRAR SESIÓN</li>' +
            '<li class="cabecera_panel">MENU</li>' +
            '<li class="boton_panel" id="p_secportada">INICIO</li>' +
            '<li class="boton_panel" id="p_precios">PRECIOS</li>' +
            '<li class="boton_panel" id="p_noticias">NOTICIAS</li>' +
            '<li class="boton_panel" id="p_productos"">PRODUCTOS</li>' +
            '<li class="boton_panel" id="p_sobre_nosotros">SOBRE NOSOTROS</li>' +
            '<li class="boton_panel" id="p_contactar">CONTACTAR</li>' +
            '<li class="boton_panel" id="p_rsociales">REDES SOCIALES</li>');
        break;
        case 'productos':
            $(panel).append('<li class="cabecera_panel">MENU</li>' +
            '<li class="boton_panel" id="p_secportada">INICIO</li>' +
            '<li class="boton_panel" id="p_precios">PRECIOS</li>' +
            '<li class="boton_panel" id="p_noticias">NOTICIAS</li>' +
            '<li class="cabecera_panel">PRODUCTOS</li>' +
            '<li class="boton_panel" id="p_pimiento">PIMIENTO</li>' +
            '<li class="boton_panel" id="p_pepino">PEPINO</li>' +
            '<li class="boton_panel" id="p_calabacin">CALABACÍN</li>' +
            '<li class="boton_panel" id="p_judia">JUDIA</li>' +
            '<li class="boton_panel" id="p_berenjena">BERENJENA</li>' +
            '<li class="boton_panel" id="p_tomate">TOMATE</li>' +
            '<li class="boton_panel" id="p_melon">MELÓN</li>' +
            '<li class="boton_panel" id="p_sandia">SANDÍA</li>' +
            '<li class="boton_panel" id="p_guisante">GUISANTE / TIRABEQUE</li>' +
            '<li class="boton_panel" id="p_sobre_nosotros">SOBRE NOSOTROS</li>' +
            '<li class="boton_panel" id="p_contactar">CONTACTAR</li>' +
            '<li class="boton_panel" id="p_rsociales">REDES SOCIALES</li>');
        break;
    }

    var refresco = pagina_actual(".deslizante_panel");
    actualiza_scroll(refresco);
    acciones_botones_panel();

    //marcamos como activa la opción en el menú del panel
    var boton_panel = panel + " #p_" + ($.mobile.activePage.attr('id'));
    mensaje_consola("el boton es -> "+ boton_panel);
    $(boton_panel).css("background","#378B2F").css("color","#fff").css("border-top","1px solid #378B2F");
}
/********************************************************************/









/** PORTADA **/
/********************************************************************/
/**
 * botones_listadoproductos()
 * Métodos para las acciones de los botones de inicio
 */
function botones_portada() {
    $(document).on('tap taphold', '.botones_portada', function (event) {
        event.preventDefault();event.stopImmediatePropagation();

        valor = $(this).attr("id");
        valor = valor.substring(5,valor.length);

        switch(valor) {
            case 'precios':
                $(this).css("background","#F28304");
            break;
            case 'noticias':
                $(this).css("background","#1e2a1d");
            break;
            case 'formulario_agricultores':
                $("#boto_formulario_agricultores").css("background","#FF7D0C");
            break;
            case 'productos':
                $("#port_productos img").removeClass("boton_productos_portada_off").addClass("boton_productos_portada_on");
            break;
            case 'sobre_nosotros':
                $("#port_sobre_nosotros img").removeClass("boton_nosotros_portada_off").addClass("boton_nosotros_portada_on");
            break;
            case 'rsociales':
                $("#port_rsociales img").removeClass("boton_social_portada_off").addClass("boton_social_portada_on");
            break;
        }
        sessionStorage.setItem("pagina_navegar", valor);
        //Cargamos la pagina con un poco de retardo para simular el pulsado de botón
        window.setTimeout('cambio_pagina()',respuestaboton);
    });
}


/**
 * reestablecer_botones_inicio()
 * Método para resetear los botones del inicio al cambiar a una seccion interior
 */
function reestablecer_botones_inicio(){
    $("#port_precios").css("background","#FDAC00");
    $("#port_noticias").css("background","#394838");
    $("#boto_formulario_agricultores").css("background","url('./imagenes/fverde.png') top left no-repeat");
    $("#port_productos img").removeClass("boton_productos_portada_on").addClass("boton_productos_portada_off");
    $("#port_sobre_nosotros img").removeClass("boton_nosotros_portada_on").addClass("boton_nosotros_portada_off");
    $("#port_rsociales img").removeClass("boton_social_portada_on").addClass("boton_social_portada_off");
}
/********************************************************************/





/** PIZARRAS **/
/********************************************************************/

/**
 * botones_pizarras()
 * Método con las acciones a realizar al pulsar en una pizarra en concreto
 */
function botones_pizarras() {
    $(document).on('tap', ".datos_subasta", function (event) {
        event.preventDefault();event.stopImmediatePropagation();

        var subasta = "#" + ($(this).attr("id"));
        $(subasta).css("background","#69AC67").css("color","#fff");
        subasta = subasta + " span";
        $(subasta).css("color","#fff");

        var pizarra = $(this).attr("id");
        pizarra = pizarra.substring(2,pizarra.length);
        var fechapizarra = $(this).attr("rel");

        sessionStorage.setItem("tipo_pizarra",pizarra);
        sessionStorage.setItem("fecha_pizarra",fechapizarra);
        sessionStorage.setItem("pagina_navegar","pizarra");
        window.setTimeout("cambio_pagina()",respuestaboton);
    });
}



/**
 * listado_precios()
 * Método para cargar las fechas de las ultimas pizarras en la sección de precios
 */
function listado_precios(){
	var contenedorinfo = pagina_actual("#contenedor_detalle_pizarra");

    var url = ruta_aplicacion + 'pizarras.ashx' + "?firma=" + Generar_Firma("");
    $.ajax({
        url: url,
        dataType: 'jsonp',
        data: {},
        global: false,
        cache: false,
        crossDomain: true,
        success: function(data){
            //salvamos los datos en local
            localStorage.setItem('detalle_pizarra', JSON.stringify(data));
            datos_en_memoria = JSON.parse(localStorage.getItem('detalle_pizarra'));

            $(contenedorinfo).animate({"opacity": 0}, 0);

            $("#actualizacion_elejido").empty().append(datos_en_memoria.pizarras[0].El_Ejido[0].fecha_corta);
            $("#b_El_Ejido").attr("rel",datos_en_memoria.pizarras[0].El_Ejido[0].fecha_corta);

            $("#actualizacion_berja").empty().append(datos_en_memoria.pizarras[0].Berja[0].fecha_corta);
            $("#b_Berja").attr("rel",datos_en_memoria.pizarras[0].Berja[0].fecha_corta);

            $("#actualizacion_dalias").empty().append(datos_en_memoria.pizarras[0].Dalias[0].fecha_corta);
            $("#b_Dalias").attr("rel",datos_en_memoria.pizarras[0].Dalias[0].fecha_corta);

            mostrar_contenido(contenedorinfo);
            $("#listado_pizarras").css("display","inherit");

            actualiza_scroll("#deslizante_precios");
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
            alerta_texto('Agroejido','Fallo en la lectura de datos. Inténtelo más tarde.');
        }
    });

}



/**
 * SELECTOR_FECHA()
 * Método para las acciones de los botones del histórico de las pizarras y para la selección avanzada de fecha
 */
function selector_fecha(){
    //selección avanzada de fecha
    var picker = $( ".input_fecha", this );
    picker.mobipick();
    picker.on( "change", function() {
        var date = $( this ).val();
        var dateObject = $( this ).mobipick( "option", "date" );
    });
    $(".input_fecha").mobipick({
        locale: "es",
        dateFormat: "dd/MM/yyyy"
    });

    //enlaces en el selector de fecha que se abre para seleccionar
    $(document).on('vmousedown', '.mobipick-main a', function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background","#3A9137");
    });
    $(document).on('vmouseup', '.mobipick-main a', function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background","#69AC67");
    });
    $(document).on('tap taphold', '.mas_historico', function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background","#013E1F");
        //sacamos el tipo de pizarra(localización)
        var tipo_pizarra = $(this).attr('id');
        tipo_pizarra = tipo_pizarra.substring(13,tipo_pizarra.length);
        //montamos el contenedor para una subasta en concreto
        var contenedor_fecha = "#fecha_"+ tipo_pizarra;

        if($(contenedor_fecha).val() != ""){
            sessionStorage.setItem("pagina_navegar", "pizarra");
            sessionStorage.setItem("tipo_pizarra", tipo_pizarra);
			sessionStorage.setItem("fecha_pizarra",$(contenedor_fecha).val());

            mensaje_consola("la fecha es -> " + $(contenedor_fecha).val());

            window.setTimeout('cambio_pagina()',respuestaboton);
        }else{
            alerta_texto('Información Agroejido','Debe seleccionar una fecha específica.');
            $(this).css("background","#1F9A1D");
        }
    });
}


/**
 * errores_pizarra(contenedorlistado)
 * metodo para mostrar por pantalla el error de que no hay pizarra
 * @param contenedorlistado
 */
function errores_pizarra(contenedorlistado){
    mensaje_consola("errores nene");
    $('.capa_anima_carga').css("display","none");
    $('.contenedor_alerta').css("display","inherit");
    $(contenedorlistado).css("display","none");
    $('.contenedor_alerta').append("<div style='width:100%; text-align:center; margin-top: 150px;'><img src='./imagenes/trans.png' class='imagen_alerta_agroejido' /><br /><strong>No hay datos disponibles para la fecha seleccionada.</strong><br />Escoja otra fecha distinta</div>");
    //$('.contenedor_alerta').append("<div style='width:100%; text-align:center; margin-top:150px;'><img src='./imagenes/logoagroejido.png' /><br /><strong>No hay datos disponibles para la fecha seleccionada.</strong><br />Escoja otra fecha distinta</div>");
    $('.contenedor_alerta').animate({"opacity": 1}, 200);
}


/**
 * detalle_pizarra()
 * Método para cargar los precios de una pizarra en concreto
 */
function detalle_pizarra(){
    var contenedorinfo = pagina_actual("#contenedor_detalle_pizarra");
	var contenedoradjuntos = pagina_actual("#contenedor_adjuntos_pizarra");
    var contenedorlistado = pagina_actual("#contenedor_listado_pizarras");

    //Recuperamos los datos locales para tratarlos después
    tipo_pizarra = sessionStorage.getItem('tipo_pizarra');
    switch(tipo_pizarra)
    {
        case 'El_Ejido':
            $('.titulo_pagina h2').append('EL EJIDO');
        break;
        case 'Berja':
            $('.titulo_pagina h2').append('BERJA');
        break;
        case 'Dalias':
            $('.titulo_pagina h2').append('DALÍAS');
        break;
    }





    auxlugar = sessionStorage.getItem("tipo_pizarra");
    if (auxlugar == "El_Ejido"){auxlugar = "El%20Ejido";}
    auxfecha = sessionStorage.getItem("fecha_pizarra");
    var url = ruta_aplicacion+'pizarra.ashx?lugar=' + auxlugar +'&fecha='+ auxfecha + "&firma=" + Generar_Firma("");
    mensaje_consola("la url de detalle pizarra es -> " + url);

    $.ajax({
        url: url,
        dataType: 'jsonp',
        data: {},
        global: false,
        cache: false,
        crossDomain: true,
        success: function(data){
            //salvamos los datos en local
            localStorage.setItem('detalle_pizarra', JSON.stringify(data));
            datos_en_memoria = JSON.parse(localStorage.getItem('detalle_pizarra'));

            $(contenedorinfo).animate({"opacity": 0}, 0);

            if(datos_en_memoria.error == "no") {
                $("#fecha_definitiva").empty().append("Fecha: "+datos_en_memoria.pizarra[0].fecha_larga);
                $.each(datos_en_memoria.pizarra[0].productos, function (i, productos) {
                    //str = productos.familia;
                    //res = str.toLowerCase();
                    $(contenedorlistado).append('<div class="ficha_pizarra"><div class="producto_pizarra">' +
                        productos.producto + '</div><div class="precio_producto_pizarra"><div class="imagen_producto_pizarra"><img src="./imagenes/trans.png" class="' +
                        productos.imagenproducto + '"/></div><div class="maxmin_pizarra">Max: <strong>' +
                        productos.precios[0].maximo + '€</strong> - Min: <strong>' +
                        productos.precios[0].minimo + '€</strong></div><div class="precios_pizarra">' +
                        productos.precios[0].C1 + ' &nbsp; ' +
                        productos.precios[0].C2 + ' &nbsp; ' +
                        productos.precios[0].C3 + ' &nbsp; ' +
                        productos.precios[0].C4 + ' &nbsp; ' +
                        productos.precios[0].C5 + ' &nbsp; ' +
                        productos.precios[0].C6 + ' &nbsp; ' +
                        productos.precios[0].C7 + ' &nbsp; ' +
                        productos.precios[0].C8 + ' &nbsp; ' +
                        productos.precios[0].C9 + ' &nbsp; ' +
                        productos.precios[0].C10 + ' &nbsp; ' +
                        productos.precios[0].C11 + ' &nbsp; ' +
                        productos.precios[0].C12 + ' &nbsp; ' +
                        productos.precios[0].C13 + ' &nbsp; ' +
                        productos.precios[0].C14 + ' &nbsp; ' +
                        productos.precios[0].C15 + '</div></div></div>');
                });
                mostrar_contenido(contenedorinfo);
            }else{
                mostrar_contenido(contenedorinfo);
                errores_pizarra(contenedorlistado);
            }
            actualiza_scroll("#deslizante_pizarra");
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
            alerta_texto('Agroejido','Fallo en la lectura de datos. Inténtelo más tarde.');
        }
    });

}









/********************************************************************/





/**
 * errores_conexion(contenedorlistado)
 * metodo para mostrar por pantalla el error de que no hay noticias sin conexion
 * @param contenedorlistado
 */
function errores_conexion(contenedorlistado){
    $('.capa_anima_carga').css("display","none");
    $('.contenedor_alerta').css("display","inherit");
    $(contenedorlistado).css("display","none");
    $('.contenedor_alerta').append("<div style='width:100%; text-align:center; margin-top:150px;'><img src='./imagenes/alerta.png' /><br />No tiene datos en memoria.<br />Necesita Internet para cargarlos.</div>");
    $('.contenedor_alerta').animate({"opacity": 1}, 200);
}









/***** ACCIONES DE CARGA DE NOTICIAS ******/
/******************************************/

/****** funciones de carga del listado de noticias ******/
/**
 * obtener_datos_noticias_locales()
 * metodo para guardar en la variable de datos_en_memoria las noticias del tipo elegido desde la memoria
 */
function obtener_datos_noticias_locales(){
    datos_en_memoria = JSON.parse(localStorage.getItem('info_noticias'));
}
/**
 * insertar_noticias_dinamicas(contenedorlistado)
 * método para cargar las noticias desde el json haciendo llamada al servidor
 * @param contenedorlistado
 */
function insertar_noticias_dinamicas(contenedorlistado){
    $(contenedorlistado).animate({"opacity": 0}, 0);

    datos_en_memoria = JSON.parse(localStorage.getItem('info_noticias'));

    $.each(datos_en_memoria.noticias, function(i,noticia){
        var str= noticia.entradilla;
        str = str.substring(0,150) + "...";
        $(contenedorlistado).append('<div class="noticia_listado" id="not_' +
        noticia.idnoticia +'"><div class="boton_mas_listado"><img src="./imagenes/boton_mas.png" alt=""/></div><div class="contenido_noticia_listado">'+
        noticia.fecha +'<br/><span class="titular_listado">'+
        noticia.titulo +'</span><br/><br/>'+
        str +'</div></div>');
    });
    actualiza_scroll("#deslizante_noticias");
}
/**
 * insertar_noticias_sinconexion(contenedorlistado)
 * método para cargar las noticias desde la memoria
 * @param contenedorlistado
 */
function insertar_noticias_sinconexion(contenedorlistado){
    $(contenedorlistado).animate({"opacity": 0}, 0);

    datos_en_memoria = JSON.parse(localStorage.getItem('info_noticias'));

    $.each(datos_en_memoria.noticias, function(i,noticia){
        $(contenedorlistado).append('<div class="noticia_listado" id="not_' +
        noticia.idnoticia +'"><div class="boton_mas_listado"><img src="./imagenes/boton_mas.png" alt=""/></div><div class="contenido_noticia_listado">'+
        noticia.fecha +'<br/><span class="titular_listado">'+
        noticia.titulo +'</span><br/><br/>'+
        noticia.entradilla +'</div></div>');
    });
    actualiza_scroll("#deslizante_noticias");
}

/**
 * mostrar_contenido(contenedorlistado)
 * método para mostrar el contenido oculto desde un principio
 * @param contenedorlistado
 */
function mostrar_contenido(contenedorlistado){
    $('.capa_anima_carga').css("display","none");
    $(contenedorlistado).animate({"opacity": 1}, 0);
}
/**
 * cargar_noticias()
 * Método para cargar las noticias, crearlas e inyectarlas
 */
function cargar_noticias(){
	var noticia_memoria = sessionStorage.getItem('tipo_de_noticia_memoria');
	var noticia_actual = sessionStorage.getItem('tipo_de_noticia');
	var contenedorlistado = "#contenedor_detalle_listado_noticias";
	var url = ruta_aplicacion + 'noticias.ashx' + "?firma=" + Generar_Firma("");


    //actualizamos el tipo de noticia en memoria
    sessionStorage.setItem('tipo_de_noticia_memoria',noticia_actual);
    mensaje_consola("entrada carga noticias nuevas");
    $.ajax({
        url: url,
        dataType: 'jsonp',
        data: {},
        global: false,
        cache: false,
        crossDomain: true,
        success: function(data){
            //salvamos los datos en local con datos nuevos
            localStorage.setItem('info_noticias', JSON.stringify(data));
            datos_en_memoria = JSON.parse(localStorage.getItem('info_noticias'));
            //Recorremos los datos para crear dinámicamente las noticias
            insertar_noticias_dinamicas(contenedorlistado);
            mostrar_contenido(contenedorlistado);

            //reseteo de la ultima actualizacion
            var nueva_carga = new Date();
            localStorage.setItem('ultima_actualizacion_noticias',nueva_carga);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
            alerta_texto('Agroejido','Fallo en la lectura de datos. Inténtelo más tarde.');
        }
    });


}
/**
 * botones_noticias()
 * Método con las acciones a realizar al pulsar en una noticia del listado
 */
function botones_noticias() {
    $(document).on('tap', ".noticia_listado", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background","#1f9a1d");
        $(this).css("color","#fff");
        var numero_noticia = $(this).attr("id");
        var numero_noticia = numero_noticia.substring(4,numero_noticia.length);
        sessionStorage.setItem("id_noticia",numero_noticia);
        window.setTimeout('cambio_noticias()',respuestaboton);
    });
}





/****** funciones de carga del listado de noticias ******/
/**
 * ver_galeria_noticia()
 * función de evento para ver una galería de una determinada noticia
 */
function ver_galeria_noticia(){
    $(document).on('tap', ".boton_ver_galeria", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background","url(./imagenes/enlacegaleria.png) top left no-repeat #004421").css("background-position","0 35%");
        sessionStorage.setItem("pagina_navegar", "detalle_galeria_noticia");
        window.setTimeout("cambio_pagina()",respuestaboton);
    });
}
/**
 * abrir_documento()
 * función para abrir una ventana con la url del documento
 */
function abrir_documento() {
	$(".boton_descargar_documento").css("background","url(./imagenes/enlacedocumento.png) top left no-repeat #f2f2f2");
	$(".boton_descargar_documento").css("color","#565656");
	var url = sessionStorage.getItem("valor_documento");
	window.open(url, '_system', 'location=yes');
}
/**
 * descargar_documento_noticia()
 * función de evento para controlar el pulsado de la descarga de un documento en una noticia
 */
function descargar_documento_noticia(){
    $(document).on('tap', ".boton_descargar_documento", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background","url(./imagenes/enlacedocumento.png) top left no-repeat #388D30");
        $(this).css("color","#fff");
        var aux = $(this).attr("rel");
        sessionStorage.setItem("valor_documento",aux);
        window.setTimeout("abrir_documento()",respuestaboton);
    });
}

/**
 * detalle_noticia()
 * Método para cargar las noticias, crearlas e inyectarlas
 */
function detalle_noticia(){
	var contenedorinfo = pagina_actual("#contenedor_detalle_de_noticia");
	var contenedoradjuntos = pagina_actual("#contenedor_adjuntos_detalle_noticias");
	
    //Recuperamos los datos locales para tratarlos después
    datos_en_memoria = localStorage.getItem('detalle_noticia');

    var url = ruta_aplicacion + 'noticia.ashx?idnoticia=' + sessionStorage.getItem('id_noticia') + "&firma=" + Generar_Firma("");

    $.ajax({
        url: url,
        dataType: 'jsonp',
        data: {},
        global: false,
        cache: false,
        crossDomain: true,
        success: function(data){
            //salvamos los datos en local
            localStorage.setItem('detalle_noticia', JSON.stringify(data));
            datos_en_memoria = JSON.parse(localStorage.getItem('detalle_noticia'));
            $(contenedorinfo).animate({"opacity": 0}, 0);
            //CARGA DE INFORMACION DE LA NOTICIA
            $.each(datos_en_memoria.noticia, function(i,noticia){
                $(contenedorinfo).append('<div class="contenido_detalle_noticia" style="width:100%; float:left;" id="noti_' +
                noticia.idnoticia +'"><div style="width:94%; float:left; padding:15px 3%;"><span class="fecha_detalle_noticia">'+
                noticia.fecha +'</span><br/><span class="titular_detalle_noticia">'+
                noticia.titulo +'</span><br/><br/><span class="entradilla_detalle_noticia"><div class="foto_producto_catalogo"><img src="./imagenes/trans.png" style="background:url('+ noticia.zoomimagen +') top center no-repeat;background-size:cover;"></div>'+
                noticia.entradilla +'</span><br/><br/><span class="detalle_detalle_noticia">'+
                noticia.detalle +'</span></div></div>');
                if (noticia.imagen == "") {$(".foto_producto_catalogo").css("display","none");}
            });
            //CARGA DE LA GALERIA DE LA NOTICIA
            if (datos_en_memoria.galeria.length != 0) {
                $(contenedoradjuntos).append('<div class="boton_ver_galeria"><div style="color:#fff;">DETALLE GALERIA</div></div>');
                ver_galeria_noticia();
            }
            //CARGA DE LOS DOCUMENTOS DE LA NOTICIA
            if (datos_en_memoria.documentos.length != 0) {
                $.each(datos_en_memoria.documentos, function(i,documento){
                    $(contenedoradjuntos).append("<div class='boton_descargar_documento' rel='"+ documento.enlace +"'><div class='nombre_documento_noticia'>"+ documento.descripcion +"</div><br/></div>");
                });
                descargar_documento_noticia();
            }
            mostrar_contenido(contenedorinfo);
            window.setTimeout('actualiza_scroll("#deslizante_detalle_noticia")',500);
         },
         error: function(XMLHttpRequest, textStatus, errorThrown) {
            alerta_texto('Agroejido','Fallo en la lectura de datos. Inténtelo más tarde.');
        }
    });

}

function enlaces_noticia() {
    $(document).on('tap taphold', ".entradilla_detalle_noticia a", function (event) {
        event.preventDefault();
        event.stopImmediatePropagation();
        aux = $(this).attr("rel");
        aux = aux.replace("\"", "");
        aux = aux.replace("\"", "");
        window.open(aux, '_system', 'location=yes');
    });
    $(document).on('tap taphold', ".detalle_detalle_noticia a", function (event) {
        event.preventDefault();
        event.stopImmediatePropagation();
        aux = $(this).attr("rel");
        aux = aux.replace("\"", "");
        aux = aux.replace("\"", "");
        window.open(aux, '_system', 'location=yes');
    });
}



/***** MÉTODOS DE CARGA DE LAS GALERIAS EN LAS NOTICIAS ******/
/**
 * detalle_galeria(contenedor,tipo_galeria,contenedor_detalle)
 * método universal para cargar el detalle de una galeria, ya sea de noticias, productos o de las propias galerias
 * @param contenedor
 * @param tipo_galeria
 * @param contenedor_detalle
 * @returns {boolean}
 */
function detalle_galeria(contenedor,tipo_galeria,contenedor_detalle){
    var contenedorinfo = pagina_actual(contenedor);
    var total = 0;

    datos_en_memoria = JSON.parse(localStorage.getItem(tipo_galeria));

    //CARGA DE LA GALERIA DE LA NOTICIA
    if (datos_en_memoria.galeria.length != 0) {
        mensaje_consola("con fotos");
        $.each(datos_en_memoria.galeria, function(i,galeria){
            $(contenedorinfo).append("<div class='contenedor_info_galerias'><div class='imagen_fondo_galerias'  style='background:url("+
                galeria.imagen +") center center no-repeat #388D30; background-size:auto 100%;'><a href='" + galeria.zoomimagen +"' rel='external' valor='"+
            total+"'><img src='./imagenes/transparente.png'/></a></div></div>");
            total = total + 1;
        });
        window.setTimeout('actualiza_scroll("#deslizante_galeria_noticia")',1000);
    }
    $('#num_fotos_galeria').append(total);
    $('.capa_anima_carga').css("display","none");

     //Creamos el objeto de la galeria para guardar en el objeto las distintas fotografias
    var myPhotoSwipe = $(".imagen_fondo_galerias a").photoSwipe({
        jQueryMobile: false,
        loop: true,
        enableMouseWheel: false,
        enableKeyboard: false
    });

    //Evento para mostrar la foto de la galeria que queremos
    $(document).on('tap taphold', ".imagen_fondo_galerias a", function (event) {
        event.preventDefault();
        event.stopImmediatePropagation();
        valor = $(this).attr("valor");
        mensaje_consola(valor);
        valor = parseInt(valor);
        myPhotoSwipe.show(valor);
    });

	return true;
}

/********************************************************************/







/***** ACCIONES PARA LOS PRODUCTOS ******/
/****************************************/
/**
 * botones_productos()
 * Método para inyectar los distintos botones de los productos de la sección productos
 */
function botones_productos(){
    var capa_cargadora = "#capa_cargadora_productos";
    $(capa_cargadora).animate({"opacity": 0}, 0);

    $(capa_cargadora).append('<div class="contenedor_producto" id="bot_pimiento"> <div class="foto_producto"> <img src="imagenes/trans.png" class="foto_pimiento"></div> <div class="mas_producto"> <div>+</div>PIMIENTO </div></div><div class="contenedor_producto" id="bot_pepino"> <div class="foto_producto"><img src="imagenes/trans.png" class="foto_pepino"></div> <div class="mas_producto"> <div>+</div>PEPINO </div></div><div class="contenedor_producto" id="bot_calabacin"><div class="foto_producto"><img src="imagenes/trans.png" class="foto_calabacin"></div><div class="mas_producto"><div>+</div>CALABACÍN</div></div><div class="contenedor_producto" id="bot_judia"><div class="foto_producto"><img src="imagenes/trans.png" class="foto_judia"></div><div class="mas_producto"><div>+</div>JUDÍA</div></div><div class="contenedor_producto" id="bot_berenjena"> <div class="foto_producto"><img src="imagenes/trans.png" class="foto_berenjena"></div> <div class="mas_producto"><div>+</div>BERENJENA</div></div><div class="contenedor_producto" id="bot_tomate"><div class="foto_producto"><img src="imagenes/trans.png" class="foto_tomate"></div><div class="mas_producto"><div>+</div>TOMATE</div></div><div class="contenedor_producto" id="bot_melon"><div class="foto_producto"><img src="imagenes/trans.png" class="foto_melon"></div><div class="mas_producto"><div>+</div>MELÓN</div></div><div class="contenedor_producto" id="bot_sandia"><div class="foto_producto"><img src="imagenes/trans.png" class="foto_sandia"></div><div class="mas_producto"><div>+</div>SANDÍA</div></div><div class="contenedor_producto" id="bot_guisante"> <div class="foto_producto"><img src="imagenes/trans.png" class="foto_guisante"></div> <div class="mas_producto"> <div>+</div> GUISANTE Y TIRABEQUE </div></div>');




    mostrar_contenido(capa_cargadora);
    window.setTimeout('actualiza_scroll("#deslizante_productos")',500);

    botones_listadoproductos();
}

/**
 * botones_listadoproductos()
 * Métodos para las acciones de los botones de inicio
 */
function botones_listadoproductos() {
    $(document).on('tap taphold', '.contenedor_producto', function (event) {
        event.preventDefault();event.stopImmediatePropagation();

        var ruta = $(this).attr("id");
        var ruta = "#"+ruta + " .mas_producto > div";
        $(ruta).css("background","#E28E0A");

        valor = $(this).attr("id");
        valor = valor.substring(4,valor.length);
        sessionStorage.setItem("pagina_navegar", valor);

        //Cargamos la pagina con un poco de retardo para simular el pulsado de botón
        window.setTimeout('cambio_pagina()',respuestaboton);
    });
}
/********************************************************************/



/********** ABRIR ENLACES EXTERNOS **********/
/**
 * abrir_facebook()
 * función para abrir una ventana con facebook
 */
function abrir_facebook(){
	window.open("https://www.facebook.com/agroejido", '_system', 'location=yes');
}
/**
 * abrir_twitter()
 * función para abrir una ventana con twitter
 */
function abrir_twitter(){
	window.open("https://twitter.com/agroejido", '_system', 'location=yes');
}
/********************************************************************/
















/***** MÉTODOS PARA EL ACCESO AL ÁREA DE AGRICULTORES ******/
/***********************************************************/




//Botones del área de agricultor, ya una vez dentro
function motor_acceso_formulario(){

    mensaje_consola("token nuestro -> " + localStorage.getItem("token_agricultor"));

    if((localStorage.getItem("token_agricultor") != null)&&(localStorage.getItem("token_agricultor") != "")){
        $.ajax({
            url: ruta_aplicacion + "agricultores/autenticar.aspx",
            type: "POST",
            data:{usuario: "", clave: "",token: localStorage.getItem("token_agricultor"), uid: sessionStorage.getItem("iddispositivo"), plataforma: sessionStorage.getItem("plataforma"),firma: Generar_Firma("")},
            dataType: "json",
            global: false,
            cache: false,
            crossDomain: true,
            success: function (data) {

                if(data.entrada[0].resultado == "correcto"){

                    sessionStorage.setItem("nombre_agricultor",data.entrada[0].nombre);
                    localStorage.setItem("token_agricultor",data.entrada[0].token);
                    $.mobile.changePage( "entrada_agricultores.html", {transition: "none",reverse: true,changeHash: true,reloadPage: false});


                } else if(data.entrada[0].resultado == "error"){

                    $(".capa_anima_carga").css("display","none");
                    $('.contenedor_alerta').css("display","none");
                    $('#contenedor_formulario_acceso').css("display","inherit");
                    $("#mensaje_formulario").empty();
                    $("#mensaje_formulario").css("color","#B20000");
                    $("#mensaje_formulario").append("Sesión caducada. Vuelva a autenticarse.");

                    localStorage.setItem("token_agricultor","");
                    boton_entrada_formulario();
                }
            },
            error: function(data) {

                $(".capa_anima_carga").css("display","none");
                $('.contenedor_alerta').css("display","none");
                $('#contenedor_formulario_acceso').css("display","inherit");
                $("#mensaje_formulario").empty();
                $("#mensaje_formulario").css("color","#B20000");
                $("#mensaje_formulario").append("Sesión caducada. Vuelva a autenticarse.");
                localStorage.setItem("token_agricultor","");
                boton_entrada_formulario();
            }
        });
    }else{
        $.ajax({
            url: ruta_aplicacion + "agricultores/autenticar.aspx",
            type: "POST",
            data:{usuario: $("#campo_usuario").val(), clave: $("#campo_clave").val(),token: "", uid: sessionStorage.getItem("iddispositivo"), plataforma: sessionStorage.getItem("plataforma"),firma: Generar_Firma("")},
            dataType: "json",
            global: false,
            cache: false,
            crossDomain: true,
            success: function (data) {
                if(data.entrada[0].resultado == "correcto"){

                    sessionStorage.setItem("nombre_agricultor",data.entrada[0].nombre);
                    localStorage.setItem("token_agricultor",data.entrada[0].token);

                    $.mobile.changePage( "entrada_agricultores.html", {transition: "none",reverse: true,changeHash: true,reloadPage: false});

                } else if(data.entrada[0].resultado == "error"){
                    $(".capa_anima_carga").css("display","none");
                    $('.contenedor_alerta').css("display","none");
                    $('#contenedor_formulario_acceso').css("display","inherit");
                    $("#mensaje_formulario").empty();
                    $("#mensaje_formulario").css("color","#B20000");
                    $("#mensaje_formulario").append("Datos incorrectos. Inténtelo de nuevo.");
                    localStorage.setItem("token_agricultor","");
                    boton_entrada_formulario();
                }
            },
            error: function(data) {
                $(".capa_anima_carga").css("display","none");
                $('.contenedor_alerta').css("display","none");
                $('#contenedor_formulario_acceso').css("display","inherit");
                $("#mensaje_formulario").empty();
                $("#mensaje_formulario").css("color","#B20000");
                $("#mensaje_formulario").append("Datos incorrectos. Inténtelo de nuevo.");
                localStorage.setItem("token_agricultor","");
                boton_entrada_formulario();
            }
        });
    }
}


function volver_verde(){
	$("#boton_entrar_formulario").css("background","#1F9A1D");
}

function boton_entrada_formulario(){
    //Evento de pulsado de boton entrar del formulario de agricultor
    $(document).on('tap taphold', "#boton_entrar_formulario", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background","#004421");

        if (($("#campo_usuario").val() != "")&&($("#campo_clave").val() != "")) {
            motor_acceso_formulario();
            window.setTimeout('volver_verde()',respuestaboton);
        }else{
            $("#mensaje_formulario").empty();
            $("#mensaje_formulario").css("font-size","14px");
            $("#mensaje_formulario").css("color","#B20000");
            $("#mensaje_formulario").append("Necesita introducir todos los datos para acceder.");
            window.setTimeout('volver_verde()',respuestaboton);
        }
    });
}

/**
 * entrada_formulario()
 * Método para acceder desde el formulario al área de agricultores, teniendo en cuenta el guardado de la firma, sesión, control de acceso,...
 */
function entrada_formulario(){



	if(sessionStorage.getItem('estado_conexion') == "si"){
		$(".capa_anima_carga").css("display","inherit");
	    $("#contenedor_formulario_acceso").css("display","none");

        //nos aseguramenos que el mensaje inicial sea este:
        $("#mensaje_formulario").empty();
        $("#mensaje_formulario").css("color","#555");
        $("#mensaje_formulario").css("font-size","14px");
        $("#mensaje_formulario").append("Introduzca sus datos para entrar en el área de agricultores:");

		var autenticado = localStorage.getItem("token_agricultor");
		if ((autenticado != null)&&(autenticado != "")) {
			motor_acceso_formulario();

		}else{
            $(".capa_anima_carga").css("display","none");
            $("#contenedor_formulario_acceso").css("display","inherit");

			boton_entrada_formulario();
		}
	}
	//CUANDO NO HAY CONEXION
	else{
		$(".capa_anima_carga").css("display","none");
		$('.contenedor_alerta').css("display","inherit");
		$('#contenedor_formulario_acceso').css("display","none");
		$('.contenedor_alerta').append("<div style='width:100%; text-align:center; padding-bottom:50px;'><img src='./imagenes/alerta.png' /><br /><strong>No hay conexión a Internet.</strong><br />Necesita conectarse para acceder.</div>");
	}
}




/*----------- SECCIÓN AGRICULTORES ---------------------------------*/
/**
 * entrada_agricultor()
 * Método para asignarle las acciones a los botones de la sección agricultores.html
 */
function entrada_agricultor(){
	//Limpiamos la sesión para consultar una fecha de histórico de vales o no
	sessionStorage.setItem("fecha_historico_agicultor","");
	$("#nombre_del_agricultor").empty();
	$("#nombre_del_agricultor").append(sessionStorage.getItem("nombre_agricultor"));

    sessionStorage.setItem("recarga_albaranes","si");

	//Eventos de botón del menú del área de agricultor
	$(document).on('tap taphold', ".boton_area_agricultor", function (event) {
        event.preventDefault(); event.stopImmediatePropagation();

        var valor = $(this).attr("id");
		valor = valor.substring(6,valor.length);
		$(this).css("background","#004421");

		if (valor != "salir") {
			sessionStorage.setItem("pagina_navegar", valor);
			window.setTimeout('cambio_pagina()',respuestaboton);
		}else{

			//SI HAY CONEXION
			if(sessionStorage.getItem('estado_conexion') == "si"){
				navigator.notification.confirm(
					'Si cierra su sesión, dejará de recibir notificaciones.',
					salida_agricultor,
					'¿Desea cerrar la sesión?',
					['Salir','Cancelar']
				);
			}else{
				$(this).css("background","#004421");
				alerta_texto('Información Agroejido','No puede cerrar la sesión si no dispone de conexión a Internet.');
			}
		}
    });
}

/**
* salida_agricultor(button)
* Método para realizar la salida o no de la sesión del agricultor
*/
function salida_agricultor(button){
   if(button == "1"){
       mensaje_consola("hemos pulsado aceptar para salir");
        $("#boton_salir").css("background","#88CD00");
        //anulamos el registro en la plataforma
        $.ajax({
            url: ruta_aplicacion + "agricultores/cerrar.aspx",
            type: "POST",
            data:{uid: sessionStorage.getItem("iddispositivo"), plataforma: sessionStorage.getItem("plataforma"), token: localStorage.getItem("token_agricultor")},
            dataType: "json",
            global: false,
            cache: false,
            crossDomain: true,
            success: function (data) {
                if(data.cerrar[0].resultado == "correcto"){

                    mensaje_consola("salida correcta");
                    localStorage.setItem("token_agricultor","");
                    $.mobile.changePage( compruebaInicio(), {transition: "none",reverse: true,changeHash: true,reloadPage: false});

                } else if(data.cerrar[0].resultado == "error"){
                    mensaje_consola("no ha salido");
                }
            },
            error: function(data) {
                handleRequestError(data);
            }
        })
   }else{
       mensaje_consola("hemos pulsado aceptar para cancelar");
       $("#boton_salir").css("background","#1F9A1D");
   }
}




/*  ----------------- INYECCION DE CONTENIDO AVISOS, NOTICIAS Y DATOS AGRICULTOR ------------------------*/
/**
 * inyectar_contenido_agricultor(contenedorlistado,cargadorscroll,tipo)
 * método para cargar las noticias desde la memoria
 * @param contenedorlistado
 * @param cargadorscroll
 * @param tipo
 */
function inyectar_contenido_agricultor(contenedorlistado,cargadorscroll,tipo){
    $(contenedorlistado).animate({"opacity": 0}, 0);
    var total = 0;



    if(tipo == "avisos") {
        $.each(datos_en_memoria.avisos[0].avisos, function (i, avisos) {
            $(contenedorlistado).append('<div class="noticia_listado_agricultor" id="not_' +
                avisos.idnoticia + '"><div class="boton_mas_listado"><img src="./imagenes/boton_aviso.png" alt=""/></div><div class="contenido_noticia_listado">' +
                avisos.fecha + '<br/><span class="titular_listado_naranja">' +
                avisos.titulo + '</span><br/><br/>' +
                avisos.entradilla + '</div></div>');
            total = total + 1;
        });
    }
    if(tipo == "noticias") {
        $.each(datos_en_memoria.noticias[0].noticias, function (i, noticias) {
            $(contenedorlistado).append('<div class="noticia_listado_agricultor" id="not_' +
                noticias.idnoticia + '"><div class="boton_mas_listado"><img src="./imagenes/boton_aviso.png" alt=""/></div><div class="contenido_noticia_listado">' +
                noticias.fecha + '<br/><span class="titular_listado_naranja">' +
                noticias.titulo + '</span><br/><br/>' +
                noticias.entradilla + '</div></div>');
            total = total + 1;
        });
    }
    if(tipo == "datos") {
        $.each(datos_en_memoria.misdatos[0].misdatos, function (i, misdatos) {
            $(contenedorlistado).append('<div class="ficha_datos"><div class="capa_cien"><strong>Cuenta:</strong>  ' +
                misdatos.Cuenta + '<br /><strong>Nombre:</strong>  <span>' +
                misdatos.Nombre + '</span><br /><br /><strong>DNI:</strong>  ' +
                misdatos.DNI +'<br /><strong>Dirección:</strong>  ' +
                misdatos.Direccion +'<br /><strong>C.P.:</strong>  ' +
                misdatos.CP + '<br /><strong>Población:</strong>  ' +
                misdatos.Poblacion +'<br /><strong>Provincia:</strong>  ' +
                misdatos.Provincia +'<br /><strong>Teléfono:</strong>  ' +
                misdatos.Telefono +'<br /><strong>Fax.:</strong> ' +
                misdatos.Fax +'<br /><strong>Móvil:</strong> '+
                misdatos.Movil + '</div></div>');
            total = total + 1;
        });
    }
    if (total == 0) {
        $('.capa_anima_carga').css("display","none");
        $('.contenedor_alerta').css("display","inherit");
        $(contenedorlistado).css("display","none");
        //$('.contenedor_alerta').append("<div style='width:100%; text-align:center;'><img src='./imagenes/logoagroejido.png' /><br /><strong>No hay datos disponibles.</strong></div>");
        $('.contenedor_alerta').append("<div style='width:100%; text-align:center;'><img src='./imagenes/trans.png' class='imagen_alerta_agroejido' /><br /><strong>No hay datos disponibles.</strong></div>");
        actualiza_scroll(cargadorscroll);
    }else{
        $('.capa_anima_carga').css("display","none");
        actualiza_scroll(cargadorscroll);
    }

}
/********************************************************************/



/*--------- AVISOS AGRICULTOR --------*/
/**
 * inyeccion_avisos_dinamico()
 * Método para inyectar los avisos de alerta al agricultor
 */
function inyeccion_avisos_dinamico() {

    var autenticado = localStorage.getItem("token_agricultor");

	if ((autenticado != null)&&(autenticado != "")) {

        var contenedorlistado = "#contenedor_avisos";
        var contenedorscroll = "#deslizante_avisos";
        var url = ruta_aplicacion + 'agricultores/avisos.aspx';

        $.ajax({
            url: url,
            type: "POST",
            data:{token: autenticado,firma: Generar_Firma("")},
            dataType: "json",
            global: false,
            cache: false,
            crossDomain: true,
            success: function (data) {
                if(data.avisos[0].resultado == "correcto"){

                    //salvamos los datos en local con datos nuevos
                    sessionStorage.setItem('info_avisos', JSON.stringify(data));
                    datos_en_memoria = JSON.parse(sessionStorage.getItem('info_avisos'));

                    //Recorremos los datos para crear dinámicamente las noticias
                    inyectar_contenido_agricultor(contenedorlistado,contenedorscroll,"avisos",datos_en_memoria);
                    mostrar_contenido(contenedorlistado);

                    actualiza_scroll(contenedorscroll);

                    //reseteo de la ultima actualizacion
                    var nueva_carga = new Date();
                    sessionStorage.setItem('ultima_actualizacion_avisos', nueva_carga);

                } else if(data.avisos[0].resultado == "error"){
                     alerta_texto('Agroejido', 'Fallo en la lectura de datos. Inténtelo más tarde.');
                }
            },
            error: function(data) {
                 alerta_texto('Agroejido', 'Fallo en la carga de avisos.');
            }
        });
	}else{
		$.mobile.changePage( "entrada_agricultores.html", {
			transition: "none",
			reverse: true,
			changeHash: true,
			reloadPage: false
		});
	}
}
/********************************************************************/




/*--------- NOTICIAS AGRICULTOR --------*/
/**
 * inyeccion_noticias_dinamico()
 * Método para inyectar las noticias de alerta al agricultor
 */
function inyeccion_noticias_dinamico() {
	var autenticado = localStorage.getItem("token_agricultor");
	if ((autenticado != null)&&(autenticado != "")) {

        var contenedorlistado = "#contenedor_noticias_agricultores";
        var contenedorscroll = "#deslizante_noticias_agricultores";
        var url = ruta_aplicacion + 'agricultores/noticias.aspx';

        $.ajax({
            url: url,
            type: "POST",
            data:{token: autenticado,firma: Generar_Firma("")},
            dataType: "json",
            global: false,
            cache: false,
            crossDomain: true,
            success: function (data) {
                if(data.noticias[0].resultado == "correcto"){

                    //salvamos los datos en local con datos nuevos
                    sessionStorage.setItem('info_noticias_agricultores', JSON.stringify(data));
                    datos_en_memoria = JSON.parse(sessionStorage.getItem('info_noticias_agricultores'));

                    //Recorremos los datos para crear dinámicamente las noticias
                    inyectar_contenido_agricultor(contenedorlistado,contenedorscroll,"noticias");
                    mostrar_contenido(contenedorlistado);

                    actualiza_scroll(contenedorscroll);

                    //reseteo de la ultima actualizacion
                    var nueva_carga = new Date();
                    sessionStorage.setItem('ultima_actualizacion_noticias_agricultores', nueva_carga);

                } else if(data.noticias[0].resultado == "error"){
                     alerta_texto('Agroejido', 'Fallo en la lectura de datos. Inténtelo más tarde.');
                }
            },
            error: function(data) {
                 alerta_texto('Agroejido', 'Fallo en la lectura de datos. Inténtelo más tarde.');
            }
        });


	}else{
		$.mobile.changePage( "entrada_agricultores.html", {
			transition: "none",
			reverse: true,
			changeHash: true,
			reloadPage: false
		});
	}
}
/********************************************************************/





/*--------- ALBARANES DEL AGRICULTOR --------*/
/**
 * listado_albaranes()
 * método para cargar las fichas de los albaranes de cada agricultor
 */
function listado_albaranes(mes,anio,cuenta) {
    var autenticado = localStorage.getItem("token_agricultor");
	if ((autenticado != null)&&(autenticado != "")) {
        var contenedorlistado = "#contenedor_albaranes";
        var contenedorscroll = "#deslizante_albaranes";
        var url = ruta_aplicacion + 'agricultores/albaranes.aspx';




            //las entre cargas de albaranes, mostramos el cargando y ocultamos las otras capas
            $(contenedorlistado).css("display", "none");
            $('.contenedor_alerta').css("display", "none");
            $('.contenedor_alerta').empty();
            $('.capa_anima_carga').css("display", "inherit");

            //limpiamos la sesion para recargar sin mierda
            sessionStorage.removeItem('info_albaranes');





            if((cuenta == undefined)||(cuenta == null)||(cuenta == "")){
                cuenta = "-1"
            }



            if(sessionStorage.getItem("recarga_albaranes") == "si") {

                mensaje_consola("cargando de la nube");

                $.ajax({
                    url: url,
                    type: "POST",
                    data: {token: autenticado, anio: anio, mes: mes, codigo: cuenta, firma: Generar_Firma("")},
                    dataType: "json",
                    global: false,
                    cache: false,
                    crossDomain: true,
                    success: function (data) {
                        if (data.albaranes[0].resultado == "correcto") {

                            //salvamos los datos en local con datos nuevos
                            localStorage.setItem('info_albaranes', JSON.stringify(data));
                            datos_en_memoria = JSON.parse(localStorage.getItem('info_albaranes'));

                            //Recorremos los datos para crear dinámicamente los albaranes
                            var total = 0;

                            $(contenedorlistado).empty();
                            $.each(datos_en_memoria.albaranes[0].albaranes, function (i, albaranes) {
                                $(contenedorlistado).append('<div class="ficha_albaran" id="albaran_' +
                                albaranes.NAlb + '"><div class="fecha_albaran"><div class="cont_info_albaran"><strong>Fecha: </strong> ' +
                                albaranes.Fecha + ' </div></div><div class="numero_albaran"><div class="cont_info_albaran"><strong>Albarán: </strong><span class="serie_albaran" rel="' +
                                albaranes.SerieAlb + '">' + albaranes.SerieAlb + ' ' + albaranes.NAlb + ' </div></div><div class="datos_albaran"><div class="datos_izquierda_albaran"><div class="cont_datos_albaran"><div class="contenido_datos_albaran numero_cuenta_albaran" rel="' +
                                albaranes.Codigo + '"> <strong>Cuenta:</strong><br /> ' +
                                albaranes.Codigo + '</div><div class="contenido_datos_albaran"><strong>Tipo:</strong><br /><span class="tipo_albaran" rel="' +
                                albaranes.Tipo + '"> ' +
                                albaranes.Tipo + ' </span></div></div></div><div class="datos_derecha_albaran"><div class="cont_datos_albaran"><strong>Kilos: </strong><br /><span style="font-size: 26px; font-weight: 700;"> ' +
                                albaranes.Kilos + ' Kg</span></div></div></div></div>');
                                total = total + 1;
                            });

                            if (total == 0) {
                                $('.capa_anima_carga').css("display", "none");
                                $('.contenedor_alerta').css("display", "inherit");
                                $('#buscador_albaranes').css("display", "inherit");
                                $(contenedorlistado).css("display", "none");
                                $('.contenedor_alerta').empty();
                                //$('.contenedor_alerta').append("<div style='width:100%; text-align:center;'><img src='./imagenes/logoagroejido.png' /><br /><strong>No hay datos disponibles.</strong></div>");
                                $('.contenedor_alerta').append("<div style='width:100%; text-align:center;'><img src='./imagenes/trans.png' class='imagen_alerta_agroejido' /><br /><strong>No hay datos disponibles.</strong></div>");

                                actualiza_scroll(contenedorscroll);

                            } else {
                                $('.capa_anima_carga').css("display", "none");
                                $('#buscador_albaranes').css("display", "inherit");
                                $(contenedorlistado).css("display", "inherit");
                                $('.contenedor_alerta').css("display", "none");
                                actualiza_scroll(contenedorscroll);
                            }

                            actualiza_scroll(contenedorscroll);

                        } else if (data.misdatos[0].resultado == "error") {
                            alerta_texto('Agroejido', 'Fallo en la lectura de datos. Inténtelo más tarde.');
                        }
                    },
                    error: function (data) {
                        alerta_texto('Agroejido', 'Fallo en la lectura de datos. Inténtelo más tarde.');
                    }
                });
            }else{
                mensaje_consola("cargando de local");
                if ((localStorage.getItem('info_albaranes') != "")&&(localStorage.getItem('info_albaranes') != null)) {
                    datos_en_memoria = JSON.parse(localStorage.getItem('info_albaranes'));

                    //Recorremos los datos para crear dinámicamente los albaranes
                    var total = 0;

                    $(contenedorlistado).empty();
                    $.each(datos_en_memoria.albaranes[0].albaranes, function (i, albaranes) {
                        $(contenedorlistado).append('<div class="ficha_albaran" id="albaran_' +
                        albaranes.NAlb + '"><div class="fecha_albaran"><div class="cont_info_albaran"><strong>Fecha: </strong> ' +
                        albaranes.Fecha + ' </div></div><div class="numero_albaran"><div class="cont_info_albaran"><strong>Albarán: </strong><span class="serie_albaran" rel="'+
                        albaranes.SerieAlb + '">'+albaranes.SerieAlb + ' '+ albaranes.NAlb + ' </div></div><div class="datos_albaran"><div class="datos_izquierda_albaran"><div class="cont_datos_albaran"><div class="contenido_datos_albaran numero_cuenta_albaran" rel="'+
                        albaranes.Codigo + '"> <strong>Cuenta:</strong><br /> ' +
                        albaranes.Codigo + '</div><div class="contenido_datos_albaran"><strong>Tipo:</strong><br /><span class="tipo_albaran" rel="'+
                        albaranes.Tipo +'"> ' +
                        albaranes.Tipo + ' </span></div></div></div><div class="datos_derecha_albaran"><div class="cont_datos_albaran"><strong>Kilos: </strong><br /><span style="font-size: 26px; font-weight: 700;"> ' +
                        albaranes.Kilos + ' Kg</span></div></div></div></div>');
                        total = total + 1;
                    });

                    if (total == 0) {
                        $('.capa_anima_carga').css("display", "none");
                        $('.contenedor_alerta').css("display", "inherit");
                        $('#buscador_albaranes').css("display", "inherit");
                        $(contenedorlistado).css("display", "none");
                        $('.contenedor_alerta').empty();
                        $('.contenedor_alerta').append("<div style='width:100%; text-align:center;'><img src='./imagenes/trans.png' class='imagen_alerta_agroejido' /><br /><strong>No hay datos disponibles.</strong></div>");

                        actualiza_scroll(contenedorscroll);

                    } else {
                        $('.capa_anima_carga').css("display", "none");
                        $('#buscador_albaranes').css("display", "inherit");
                        $(contenedorlistado).css("display", "inherit");
                        $('.contenedor_alerta').css("display", "none");
                        actualiza_scroll(contenedorscroll);
                    }

                    $("#fecha_albaran").val(sessionStorage.getItem("ultima_busqueda"));



                    actualiza_scroll(contenedorscroll);

                } else {
                    mensaje_consola("datos en memoria esta vacio");
                    alerta_texto('Agroejido', 'Fallo en la lectura de datos. Inténtelo más tarde.');
                }
            }

            selector_fecha_albaran();

	}else{
		$.mobile.changePage( "entrada_agricultores.html", {
			transition: "none",
			reverse: true,
			changeHash: true,
			reloadPage: false
		});
	}

    //acciones de los botones de las fichas de los albaranes
    $(document).on('tap taphold', ".ficha_albaran", function (event) {
        event.preventDefault();
        event.stopImmediatePropagation();

        var valor = $(this).attr("id");
        //sacamos todos los valores de la ficha
        var idalbaran = valor.substring(8,valor.length);
        var tipo = "#" + valor + " .tipo_albaran";
        var tipofinal = $(tipo).attr("rel");
        var tipos = "#" + valor + " .serie_albaran";
        var seriefinal = $(tipos).attr("rel");
        var cuenta = "#" + valor + " .numero_cuenta_albaran";
        var numcuenta = $(cuenta).attr("rel");

        valor = "#" + valor + " .datos_albaran";
        $(valor).css("background","#C6C1B8");

        sessionStorage.setItem("tipo_albaran", tipofinal);
		sessionStorage.setItem("numero_albaran", idalbaran);
        sessionStorage.setItem("serie_albaran", seriefinal);
        sessionStorage.setItem("cuenta_albaran",numcuenta);

		sessionStorage.setItem("pagina_navegar", "detalle_albaran");
		window.setTimeout('cambio_pagina()',150);
    });
}


/**
 * cargar_cuentas()
 * método para cargar las cuentas en el select del buscador de los albaranes
 */
function cargar_cuentas(){
    var autenticado = localStorage.getItem("token_agricultor");
	if ((autenticado != null)&&(autenticado != "")) {
        var urlcuentas = ruta_aplicacion + 'agricultores/cuentas.aspx';




        $.ajax({
            url: urlcuentas,
            type: "POST",
            data: {token: autenticado,firma: Generar_Firma("")},
            dataType: "json",
            global: false,
            cache: false,
            crossDomain: true,
            success: function (data) {
                if (data.cuentas[0].resultado == "correcto") {

                    //salvamos los datos en local con datos nuevos
                    sessionStorage.setItem('info_cuentas', JSON.stringify(data));
                    datos_en_memoria = JSON.parse(sessionStorage.getItem('info_cuentas'));


                    $("#selector_cuenta").empty();

                    if(sessionStorage.getItem("recarga_albaranes") == "si"){
                        $("#selector_cuenta").append('<option value="-1" selected>---</option>');
                    }else{
                        $("#selector_cuenta").append('<option value="-1">---</option>');
                    }

                    $.each(datos_en_memoria.cuentas[0].cuentas, function (i, cuentas) {
                        $("#selector_cuenta").append('<option val="' + cuentas.Cuenta + '">' + cuentas.Cuenta + '</option>');
                    });
                    $("#selector_cuenta").selectmenu('refresh');

                    if(sessionStorage.getItem("recarga_albaranes") == "no"){
                        $("#selector_cuenta").val(sessionStorage.getItem("ultima_cuenta"));
                        $("#selector_cuenta").selectmenu('refresh');
                    }

                } else if (data.cuentas[0].resultado == "error") {
                    alerta_texto('Agroejido', 'Fallo en la lectura de datos. Inténtelo más tarde.');
                }
            },
            error: function (data) {
                alerta_texto('Agroejido', 'Fallo en la lectura de datos. Inténtelo más tarde.');
            }
        });

    }
}


/**
 * evento_buscador_albaranes()
 * Eventos para la carga cuando se cambia la info del input o el select
 */
function evento_buscador_albaranes(){
    //evento para recargar los albaranes en caso de que se cambie la fecha o la cuenta
    $(document).on("change", "#selector_cuenta,#fecha_albaran", function( event ) {

        sessionStorage.setItem("recarga_albaranes","si");

        var cuenta = $("#selector_cuenta option:selected").val();
        var fecha = $("#fecha_albaran").val();
        var anio = fecha.substring(0,4);
        var mes = fecha.substring(5,7);

        var aniofinal = anio;
        var mesfinal = mes;

        //saco la fecha actual
        var d = new Date();
        var month = d.getMonth() + 1;
        var year = d.getFullYear();


        if((anio == undefined)||(anio == null)||(anio == "")){
            anio = "-1";
            aniofinal = year;
        }
        if((mes == undefined)||(mes == null)||(mes == "")){
            mes = "-1"
            mesfinal = month;
        }
        if((cuenta == undefined)||(cuenta == null)||(cuenta == "")){cuenta = "-1"}

        sessionStorage.setItem("ultima_busqueda", (aniofinal + "-" + mesfinal));
        sessionStorage.setItem("ultima_cuenta", cuenta);

        listado_albaranes(mes,anio,cuenta);
    });
}

/**
 * selector_fecha_albaran()
 * Método para las acciones de los botones del histórico de los albaranes, asi como para actualizar los albaranes
 * cuando se modifiquen o la fecha o la cuenta del usuario
 */
function selector_fecha_albaran(){
    //selección avanzada de fecha
    var picker = $( ".input_fecha", this );
    picker.mobipick();
    picker.on( "change", function() {
        var date = $( this ).val();
        var dateObject = $( this ).mobipick( "option", "date" );
    });
    $(".input_fecha").mobipick({
        locale: "es",
        accuracy: "month"
    });

    //enlaces en el selector de fecha que se abre para seleccionar
    $(document).on('vmousedown', '.mobipick-main a', function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background","#3A9137");

    });
    $(document).on('vmouseup', '.mobipick-main a', function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background","#69AC67");
    });


}


/**
 * detalle_albaran()
 * método para cargar el detalle de un albarán
 */
function detalle_albaran(){

    var autenticado = localStorage.getItem("token_agricultor");

	if ((autenticado != null)&&(autenticado != "")) {
        var contenedorlistado = "#contenedor_detalle_albaran";
        var contenedorscroll = "#deslizante_detalle_albaran";
        var urlcuentas = ruta_aplicacion + 'agricultores/albaran.aspx';




            $(contenedorlistado).css("display", "none");
            $('.contenedor_alerta').css("display", "none");
            $('.capa_anima_carga').css("display", "inherit");

            //obligamos a que se carguen los datos desde memoria al volver atrás
            sessionStorage.setItem("recarga_albaranes","no");


            $.ajax({
                url: urlcuentas,
                type: "POST",
                data: {token: autenticado,SerieAlb:sessionStorage.getItem("serie_albaran"),tipo:sessionStorage.getItem("tipo_albaran"),NAlb:sessionStorage.getItem("numero_albaran"),Codigo:sessionStorage.getItem("cuenta_albaran"),firma: Generar_Firma("")},
                dataType: "json",
                global: false,
                cache: false,
                crossDomain: true,
                success: function (data) {

                    mensaje_consola("resultado -> " + data.albaran[0].resultado);

                    if (data.albaran[0].resultado == "correcto") {

                        mensaje_consola("correcto");

                        //salvamos los datos en local con datos nuevos
                        sessionStorage.setItem('detalle_albaran', JSON.stringify(data));
                        datos_en_memoria = JSON.parse(sessionStorage.getItem('detalle_albaran'));

                        $("#numero_albaran").append(datos_en_memoria.albaran[0].albaran[0].SerieAlb + " " + datos_en_memoria.albaran[0].albaran[0].NAlb);
                        $("#fecha_albaran").append(datos_en_memoria.albaran[0].albaran[0].Fecha);
                        $("#cuenta_albaran").append(datos_en_memoria.albaran[0].albaran[0].Codigo);
                        $.each(datos_en_memoria.albaran[0].albaran[0].Lineas, function (i, lineaalbaran) {
                            $("#lineas_productos_albaranes").append('<div class="capa_cien_quince"><div class="campo_detalle_albaran"><div class="info_detalle_albaran">Artículo:</div><div class="info_datos_detalle_albaran"><strong>'+
                            lineaalbaran.Descripcion +'&nbsp;</strong></div></div><div class="campo_detalle_albaran"><div class="info_detalle_albaran">Categoría:</div><div class="info_datos_detalle_albaran"><strong>'+
                            lineaalbaran.Categoria +'&nbsp;</strong></div></div><div class="campo_detalle_albaran"><div class="info_detalle_albaran">Calibre:</div><div class="info_datos_detalle_albaran"><strong>'+
                            lineaalbaran.Calibre +'&nbsp;</strong></div></div> <div class="campo_detalle_albaran infobultos"><div class="info_detalle_albaran infobultos">Bultos:</div><div class="info_datos_detalle_albaran infobultos"><strong>'+
                            lineaalbaran.Bultos +'&nbsp;</strong></div></div><div class="campo_detalle_albaran"><div class="info_detalle_albaran">Kilos:</div><div class="info_datos_detalle_albaran">'+
                            lineaalbaran.Kilos +'&nbsp;Kg </div></div><div class="campo_detalle_albaran"> <div class="info_detalle_albaran">Precio:</div><div class="info_datos_detalle_albaran">'+
                            lineaalbaran.Precio +'&nbsp; € </div></div></div>' +
                            '<div class="capa_cien_cinco"><div class="importe_detalle_albaran">Importe:</div><div id="valor_importe_albaran"><strong>'+
                            lineaalbaran.Importe +'&nbsp; €</strong></div></div>');
                        });
                        $("#importetotal_albaran").append(datos_en_memoria.albaran[0].albaran[0].Total +"&nbsp;");

                        if(datos_en_memoria.albaran[0].albaran[0].Tipo != "SUBASTA"){
                            $(".infobultos").css("display","none");
                        }

                        $('.capa_anima_carga').css("display", "none");
                        $(contenedorlistado).css("display", "inherit");
                        $('.contenedor_alerta').css("display", "none");
                        actualiza_scroll(contenedorscroll);

                    } else if (data.albaran[0].resultado == "error") {
                        alerta_texto('Agroejido', 'Fallo en la lectura de datos. Inténtelo más tarde.');
                        $('.capa_anima_carga').css("display", "none");
                    }
                },
                error: function (data) {
                    alerta_texto('Agroejido', 'Fallo en la lectura de datos. Inténtelo más tarde.');
                    $('.capa_anima_carga').css("display", "none");
                }
            });

    }
}






/********************************************************************/



/*--------- DATOS DEL AGRICULTOR --------*/
/**
 * inyeccion_mis_datos()
 * Método para inyectar los datos de los agricultores
 */
function inyeccion_mis_datos() {

	var autenticado = localStorage.getItem("token_agricultor");

	if ((autenticado != null)&&(autenticado != "")) {
        var contenedorlistado = "#contenedor_mis_datos";
        var contenedorscroll = "#deslizante_mis_datos";
        var url = ruta_aplicacion + 'agricultores/misdatos.aspx';



        $.ajax({
            url: url,
            type: "POST",
            data:{token: autenticado,firma: Generar_Firma("")},
            dataType: "json",
            global: false,
            cache: false,
            crossDomain: true,
            success: function (data) {
                if(data.misdatos[0].resultado == "correcto"){
                    //salvamos los datos en local con datos nuevos
                    sessionStorage.setItem('info_mis_datos', JSON.stringify(data));
                    datos_en_memoria = JSON.parse(sessionStorage.getItem('info_mis_datos'));

                    //Recorremos los datos para crear dinámicamente las noticias
                    inyectar_contenido_agricultor(contenedorlistado,contenedorscroll,"datos");
                    mostrar_contenido(contenedorlistado);
                    actualiza_scroll(contenedorscroll);

                } else if(data.misdatos[0].resultado == "error"){
                     alerta_texto('Agroejido', 'Fallo en la lectura de datos. Inténtelo más tarde.');
                }
            },
            error: function(data) {
                 alerta_texto('Agroejido', 'Fallo en la lectura de datos. Inténtelo más tarde.');
            }
        });

	}else{
		$.mobile.changePage( "entrada_agricultores.html", {
			transition: "none",
			reverse: true,
			changeHash: true,
			reloadPage: false
		});
	}
}

/********************************************************************/





/*--------- MÉTODOS PARA CONTROLAR LA ORIENTACIÓN --------*/
/**
 * compruebaseccion(aux)
 * Método para según la orientación que le pasamos por parámetro, active u oculte capas según pa sección en la que esta.
 * @param aux Variable con la orientación a calcular
 */
function compruebaseccion(aux){
    var idPagina = $.mobile.activePage.attr( "id" );
    var orientacion = aux;

    if(sessionStorage.getItem("dispositivo") == "movil"){
        orientacion = "vertical";

        if(idPagina == "secportada"){
            $("body").css("background","url(./imagenes/fondoprecios.jpg) bottom");
            $("body").css("background-size","cover");
            $("body").css("background-repeat","no-repeat");
        }else{
            $("body").css("background","#fff");
        }
    }else{
        mensaje_consola("es tablet");
    }
}


/**
 * cambioOrientacion()
 * Método para recalcular la orientación, destinado cada vez que se recarga una pagina que necesita de este cálculo, y que llama al método compruebaseccion() para hacer los cambios
 */
function cambioOrientacion(){
	if(sessionStorage.getItem("dispositivo") != "movil"){
		switch(window.orientation) 
		{
			case 180:
				compruebaseccion("horizontal");
				sessionStorage.setItem("orientacion","horizontal");
			break;
			case 0:
				compruebaseccion("horizontal");
				sessionStorage.setItem("orientacion","horizontal");
			break; 
			case -90:
				compruebaseccion("vertical");
				sessionStorage.setItem("orientacion","vertical");
			break; 
			case 90:
				compruebaseccion("vertical");
				sessionStorage.setItem("orientacion","vertical");
			break;
			case 270:
				compruebaseccion("vertical");
				sessionStorage.setItem("orientacion","vertical");
			break;
		}
	}else{
        compruebaseccion("vertical");
    }
}
/********************************************************************/







/** EVENTOS DE CARGA DE LAS PAGINAS **/
/********************************************************************/

//PARTE PÚBLICA DE LA APP
//----------------------------------------------------------------------



//PORTADA MOVIL
$(document).on('pagebeforecreate', '#secportada', function (e) {
    sessionStorage.setItem("pagina_navegar", "index");
	sessionStorage.setItem("dispositivo","movil");
    sessionStorage.setItem("depuracion","false");
});
$(document).on("pagebeforeshow", "#secportada", function(e) {
    panel_izquierda("#panelsecportada","publico");
});
$(document).on("pageshow", "#secportada", function(e) {
    botones_cabecera();
    botones_portada();
    compruebaseccion("vertical");
    actualiza_scroll("#deslizante_secportada");
    actualiza_scrollpanel("#deslizante_panel_secportada");
});
$(document).on("pagehide","#secportada", function(e){
    reestablecer_botones_inicio();
});
//----------------------------------------------------------------------


//EVENTOS PARA LAS NOTICIAS
//NOTICIAS
$(document).on("pagebeforeshow", "#noticias", function(e) {
	panel_izquierda("#panelnoticias","publico");
	cargar_noticias();
});
$(document).on("pageshow", "#noticias", function(e) {
    botones_cabecera();
    cambioOrientacion();
    botones_noticias();
    actualiza_scrollpanel("#deslizante_panel_noticias");
});

//DETALLE NOTICIA
$(document).on("pagebeforeshow", "#detalle_noticia", function(e) {
    panel_izquierda("#paneldetalle_noticia","publico");
	detalle_noticia();
});
$(document).on("pageshow", "#detalle_noticia", function(e) {
    botones_cabecera();
    cambioOrientacion();
    enlaces_noticia();
    actualiza_scrollpanel("#deslizante_panel_detalle_noticia");
});

//DETALLE DE UNA GALERIA NOTICIA
$(document).on("pagebeforeshow", "#detalle_galeria_noticia", function(e) {
	panel_izquierda("#paneldetallegalerianoticia","publico");
});
$(document).on("pageshow", "#detalle_galeria_noticia", function(e) {
    botones_cabecera();
    cambioOrientacion();
    detalle_galeria('#contenedor_galeria_noticia','detalle_noticia','#detalle_galeria_noticia');
    actualiza_scrollpanel("#deslizante_panel_detalle_galeria_noticia");
});
$(document).on("pagehide","#detalle_galeria_noticia",function(e){
    var aux = sessionStorage.getItem("galeria_actual");
    if (typeof aux != "undefined" && aux != null) {
        $(aux).remove();
        sessionStorage.removeItem("galeria_actual");
    }
    return true;
});
//----------------------------------------------------------------------


//PRECIOS
$(document).on("pagebeforeshow", "#precios", function(e) {
	panel_izquierda("#panelprecios","publico");
	selector_fecha();
    listado_precios();
});
$(document).on("pageshow", "#precios", function(e) {
    botones_cabecera();
    cambioOrientacion();
    botones_pizarras();
    actualiza_scroll("#deslizante_precios");
    actualiza_scrollpanel("#deslizante_panel_precios");
});

//PIZARRA
$(document).on("pagebeforeshow", "#pizarra", function(e) {
	panel_izquierda("#panelpizarra","publico");

});
$(document).on("pageshow", "#pizarra", function(e) {
    botones_cabecera();
    cambioOrientacion();
    detalle_pizarra();
    actualiza_scrollpanel("#deslizante_panel_pizarra");
});

//----------------------------------------------------------------------


//EVENTOS PARA LOS PRODUCTOS
//PRODUCTOS
$(document).on("pagebeforeshow", "#productos", function(e) {
	panel_izquierda("#panelproductos","publico");
});
$(document).on("pageshow", "#productos", function(e) {
    botones_cabecera();
    cambioOrientacion();
    actualiza_scrollpanel("#deslizante_panel_productos");
    window.setTimeout('botones_productos()',500);
});

//DETALLE PRODUCTO
$(document).on("pagebeforeshow", ".detalle_producto", function(e) {
	panel_izquierda("#paneldetalleproducto","productos");
});
$(document).on("pageshow", ".detalle_producto", function(e) {
    botones_cabecera();
    cambioOrientacion();
    actualiza_scroll(".deslizante_productos");
    actualiza_scrollpanel("#deslizante_panel_detalle_producto");
});
//----------------------------------------------------------------------


//SECCIONES ESTÁTICAS DE LA APP
//SOBRE NOSOTROS
$(document).on("pagebeforeshow", "#sobre_nosotros", function(e) {
	panel_izquierda("#panelsobre_nosotros","publico");
});
$(document).on("pageshow", "#sobre_nosotros", function(e) {
    botones_cabecera();
    cambioOrientacion();
    actualiza_scroll("#deslizante_sobre_nosotros");
    actualiza_scrollpanel("#deslizante_panel_sobre_nosotros");
});

//CONTACTAR
$(document).on("pagebeforeshow", "#contactar", function(e) {
	panel_izquierda("#panelcontactar","publico");
});
$(document).on("pageshow", "#contactar", function(e) {
    botones_cabecera();
    cambioOrientacion();
    actualiza_scroll("#deslizante_contactar");
    actualiza_scrollpanel("#deslizante_panel_contactar");
});

//REDES SOCIALES
$(document).on("pagebeforeshow", "#rsociales", function(e) {
	panel_izquierda("#panelrsociales","publico");
});
$(document).on("pageshow", "#rsociales", function(e) {
    botones_cabecera();
    cambioOrientacion();
    actualiza_scroll("#deslizante_rsociales");
    actualiza_scrollpanel("#deslizante_panel_rsociales");

});
//----------------------------------------------------------------------


//PARTE PRIVADA DE LA APP
//-----------------------------------------------------------------------

//FORMULARIO AGRICULTORES
$(document).on("pagebeforeshow", "#formulario_agricultores", function(e) {
	panel_izquierda("#panelformulario_agricultores","publico");
});
$(document).on("pageshow", "#formulario_agricultores", function(e) {
    botones_cabecera();
    cambioOrientacion();
    entrada_formulario();
    actualiza_scroll("#deslizante_formulario_agricultores");
    actualiza_scrollpanel("#deslizante_panel_formulario_agricultores");
});
//----------------------------------------------------------------------

//ENTRADA AGRICULTORES
$(document).on("pagebeforeshow", "#entrada_agricultores", function(e) {
	panel_izquierda("#panelentrada_agricultores","privado");
});
$(document).on("pageshow", "#entrada_agricultores", function(e) {
    botones_cabecera();
    cambioOrientacion();
    entrada_agricultor();
    actualiza_scroll("#deslizante_entrada_agricultores");
    actualiza_scrollpanel("#deslizante_panel_entrada_agricultores");
    sessionStorage.setItem("recarga_albaranes","si");
});
//----------------------------------------------------------------------

//AVISOS
$(document).on("pagebeforeshow", "#avisos", function(e) {
	panel_izquierda("#panelavisos","privado");
});
$(document).on("pageshow", "#avisos", function(e) {
    botones_cabecera();
    cambioOrientacion();
    inyeccion_avisos_dinamico();
    actualiza_scrollpanel("#deslizante_panel_avisos");
});
//----------------------------------------------------------------------

//NOTICIAS AGRICULTORES
$(document).on("pagebeforeshow", "#noticias_agricultores", function(e) {
	panel_izquierda("#panelnoticias_agricultores","privado");
});
$(document).on("pageshow", "#noticias_agricultores", function(e) {
    botones_cabecera();
    cambioOrientacion();
    inyeccion_noticias_dinamico();
    actualiza_scrollpanel("#deslizante_panel_noticias_agricultores");
});
//----------------------------------------------------------------------

//ALBARANES
$(document).on("pagebeforeshow", "#albaranes", function(e) {
	panel_izquierda("#panelalbaranes","privado");
    cargar_cuentas();

});
$(document).on("pageshow", "#albaranes", function(e) {
    botones_cabecera();
    cambioOrientacion();
    listado_albaranes();
    window.setTimeout('evento_buscador_albaranes()',1000);
    actualiza_scrollpanel("#deslizante_panel_albaranes");
});
$(document).on("pagehide","#albaranes",function(e){
    //reiniciamos la recarga de los albaranes
    sessionStorage.setItem("recarga_albaranes","si");
});
//----------------------------------------------------------------------

//DETALLE ALBARAN
$(document).on("pagebeforeshow", "#detalle_albaran", function(e) {
	panel_izquierda("#paneldetalle_albaran","privado");
    sessionStorage.setItem("recarga_albaranes","no");
});
$(document).on("pageshow", "#detalle_albaran", function(e) {
    botones_cabecera();
    cambioOrientacion();
    detalle_albaran();
    actualiza_scrollpanel("#deslizante_panel_detalle_albaran");
});
//----------------------------------------------------------------------


//MIS DATOS
$(document).on("pagebeforeshow", "#mis_datos", function(e) {
	panel_izquierda("#panelmis_datos","privado");
});
$(document).on("pageshow", "#mis_datos", function(e) {
    botones_cabecera();
    cambioOrientacion();
    inyeccion_mis_datos();
    actualiza_scrollpanel("#deslizante_panel_mis_datos");
});
//----------------------------------------------------------------------