/**
 * Inicializamos las variables para:
 * @param pagina_navegar -> pagina a la que se debe recargar la app
 * @param crear_mapa -> variable para controlar si hay un mapa abierto o no
 * Tener en cuenta que son variables de sesión y cada vez que se entre en la App se reestablecen.
 */
sessionStorage.setItem("pagina_navegar", "index");
sessionStorage.setItem("crearmapa","si");
sessionStorage.setItem("fecha_pizarra","0");
sessionStorage.setItem("pizarra_avanzada","no");
sessionStorage.setItem("recargar_pizarra","si");
//activarmos la variable para las pruebas
sessionStorage.setItem("estado_conexion","si");

sessionStorage.setItem("orientacion","vertical");

//Otras variables
var datos_en_memoria;
var datos_en_memoria_pizarra;
var datos_recarga;
var datos_recarga_pizarra;

//Obtención de la hora local para saber si actualizar el contenido o no según haya pasado cierto tiempo
var ahora = new Date(); 
sessionStorage.setItem('hora_actual',ahora);

/**
 * calcular_fecha(f_actual, f_guardada)
 * Función para calcular la direfencia de la fecha y hora actual con la que tenga almacenada
 * @param f_actual La fecha y hora actual
 * @param f_guardada La fecha y hora que se tenga guardada en localStorage
 * @retun true false dependiendo de si la fecha es mayor a 15 minutos o no
 */
function calcular_fecha(f_actual, f_guardada){
    f_act = Date.parse(f_actual);
    f_ant = Date.parse(f_guardada);
    diferencia = f_act - f_ant;
    //15 minutos de recarga
    if(diferencia > 900000){
        return true;
    }else{
        return false;
    }
}

/**
 * Fecha_Hoy()
 * Metodo para calcular la fehca actual
 * @returns	date Variable con la fecha actual
 */
function Fecha_Hoy(){
    var d = new Date();
    var day = d.getDate();
    var month = d.getMonth() + 1;
    var year = d.getFullYear();
    if (day < 10) {
        day = "0" + day;
    }
    if (month < 10) {
        month = "0" + month;
    }
    var date = year + "-" + month + "-" + day;
    return date;        
}
  
/**
 * Generar_Firma()
 * Metodo para generar la firma con md5
 * @returns	aux cadena con el hash de la firma
 */  
function Generar_Firma()
{
    var hoy =new Date();
    var clave = "S6vAC6eh84";
    var aux = Fecha_Hoy();
    aux = aux + clave;
    aux = $.md5(aux);
    return aux;
}

/**
 * fecha_formateada
 * Metodo para dada una fecha cambiarle el formato para que sea atractiva a la vista
 * @param fecha	Variable con la fecha a transformar
 * @returns	date Variable con la fecha modificada en su orden de valores
 */
function fecha_formateada(fecha){

    var anio = fecha.substring(0,4);
    var mes = fecha.substring(5,7);
    var dia = fecha.substring(8,10);

    var date = dia + "/" + mes + "/" + anio;
    return date;        
}



/**
 * salir_app()
 * Método para salir de la app
 */
function salir_app(){
    //notificacion nativa
    navigator.notification.confirm(
        '¿Desea salir de la App?', 
        onConfirmQuit, 
        'Agrupaejido', 
        'Salir,Cancelar'  
    );
}
function onConfirmQuit(button){
    if(button == "1"){
        sessionStorage.clear();
        navigator.app.exitApp();
    }
}



function compruebaInicio(){
    var url;
    if(sessionStorage.getItem("dispositivo") == "tablet"){
        url = "index-tablet.html";
    }else{
        url = "index.html";
    }
    return url; 
}





/** BOTONES DE LA CABECERA **/
/****************************/
/**
 * botones_cabecera()
 * Método con las acciones de los botones que vamos a tener en la cabecera de la app
 */
function botones_cabecera() {
    //Acciones al cerrar
    $(document).on('vmousedown', ".icono_cerrar_cabecera img", function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        $(this).removeClass("boton_cerrar_off");
        $(this).addClass("boton_cerrar_on");
    });
    $(document).on('vmouseup', ".icono_cerrar_cabecera img", function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        $(this).removeClass("boton_cerrar_on");
        $(this).addClass("boton_cerrar_off");
    });
    //Acciones al volver al inicio
    $(document).on('vmousedown', ".icono_inicio_cabecera img", function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        $(this).removeClass("boton_inicio_off");
        $(this).addClass("boton_inicio_on");
    });
    $(document).on('vmouseup', ".icono_inicio_cabecera img", function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        $(this).removeClass("boton_inicio_on");
        $(this).addClass("boton_inicio_off");
        $.mobile.changePage( compruebaInicio(), {
            transition: "none",
            reverse: true,
            changeHash: true,
            reloadPage: false
        });
    });
    //Acciones del boton volver (un paso atrás)
    $(document).on('vmousedown', ".icono_volver_cabecera img", function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        $(this).removeClass("boton_volver_off");
        $(this).addClass("boton_volver_on");
    });
    $(document).on('vmouseup', ".icono_volver_cabecera img", function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        $(this).removeClass("boton_volver_on");
        $(this).addClass("boton_volver_off");
        if($.mobile.activePage.is('#historial')){
            $.mobile.changePage( "pizarra.html", {
                transition: "none",
                reverse: true,
                changeHash: true,
                reloadPage: false
            });
        }else{
            history.back(1);
        }
    });
    //Acciones del boton volver (un paso atrás)
    $(document).on('vmousedown', ".icono_pizarra_cabecera img", function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        $(this).removeClass("boton_pizarra_off");
        $(this).addClass("boton_pizarra_on");
    });
    $(document).on('vmouseup', ".icono_pizarra_cabecera img", function (event) {
        event.preventDefault();
        event.stopImmediatePropagation();
        $(this).removeClass("boton_pizarra_on");
        $(this).addClass("boton_pizarra_off");
        $.mobile.changePage( "seleccionpizarra.html", {
            transition: "none",
            reverse: true,
            changeHash: true,
            reloadPage: false
        });
    });
}





/***** ACCIONES DE CAMBIO DE PÁGINA ******/
/*****************************************/
/**
 * cambio_noticias()
 * Método para ir al detalle noticia
 */
function cambio_noticias(){
    $.mobile.changePage( "detalle-noticia.html", {
    transition: "slideup",
    reverse: false,
    changeHash: true,
    reloadPage: false,
    });
}
/**
 * cambio_pagina()
 * Método que utiliza la variable almacenada pagina_navegar para cargar la nueva sección en tiempo de ejecución
 */
function cambio_pagina(){
    final = sessionStorage.getItem("pagina_navegar");
    final = final + ".html";
    $.mobile.changePage( final, {
    transition: "slideup",
    reverse: false,
    changeHash: true,
    reloadPage: false
    });
}




/****** ACCIONES DE NOTICIAS ******/
/**********************************/
/**
 * botones_noticias()
 * Método con las acciones a realizar al pulsar en una noticia del listado
 */
function botones_noticias() {
    $(document).on('tap taphold', ".noticia_listado", function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        $(this).css("background","url(./imagenes/flechaverde.png) top left repeat-x #B2CE19");
        $(this).css("color","#fff");
        var numero_noticia = $(this).attr("id");
        var numero_noticia = numero_noticia.substring(4,numero_noticia.length);
        // asignamos el id_noticia para poder cargar la noticia en el detalle noticia
        sessionStorage.setItem("id_noticia",numero_noticia);
        //Cargamos las noticias
        window.setTimeout('cambio_noticias()',200);
    });
}




/***** ACCIONES PARA LA CARGA DE LOS CENTROS Y MAPAS ******/
/**********************************************************/
/**
 * crear_mapa()
 * Método para, dependiendo de la variable crearmapa de la sesión, monta la capa, carga datos y crea el mapa
 */
function crear_mapa(){
	if(sessionStorage.getItem("crearmapa") == "si"){
        $("#capa_cargadora_mapa").css("display","inherit");
		coordenadas = sessionStorage.getItem("coordenadas");
		nombre_centro = sessionStorage.getItem("nombre_centro");
	    var margen_superior = 0;
		margen_superior = ($("#map_canvas").offset().top) * -1;
		$('#map_canvas').gmap({'center': coordenadas, 'zoom': 10, 'disableDefaultUI':true, 'callback': function() {
		    var self = this;
		    self.addMarker({'position': this.get('map').getCenter() }).click(function() {
			self.openInfoWindow({ 'content': nombre_centro }, this);
			$('#map_canvas').gmap('refresh');
		    });
		}});
		$('#map_canvas').gmap('refresh');
		$('#map_canvas').css("top",margen_superior);
		sessionStorage.setItem("crearmapa","no");
	}
}
/**
 * preparar_carga()
 * Método para cargar las capas en las que se va a cargar la información de los mapas
 */
function preparar_carga(){
	$("#capa_cargadora_mapa").css("display","none");
	$("#capa_cargadora_mapa").remove();
	$("#capa_cargadora_informacion").append('<div id="capa_cargadora_mapa"></div>');
	$("#capa_cargadora_mapa").append('<div class="menu_cabecera_mapa"><div class="icono_cerrar_mapa"><img id="boton_cerrar_mapas" src="./imagenes/botones/trans.png" class="boton_mapa_off" /></div><img src="./imagenes/logo-cabecera.png" id="logo_central" /></div><div id="direccion_mapa"></div><div id="map_canvas"></div>');
	$("#direccion_mapa").empty();
}
/**
 * botones_mapas()
 * Método con las acciones de los distintos botones que se cargan en cada ficha de la sección centros
 * En su mayoría son eventos de pulsado de pantalla (tap) y las secciones asociadas a los estados de cada botón
 */
function botones_mapas() {
    //Cerrar el mapa
    $(document).on('vmousedown', ".icono_cerrar_mapa img", function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation(); 
        $(this).removeClass("boton_mapa_off");
        $(this).addClass("boton_mapa_on");
    });
    $(document).on('vmouseup', ".icono_cerrar_mapa img", function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        $(this).removeClass("boton_mapa_on");
        $(this).addClass("boton_mapa_off"); 
        $(".ampliar_mapa").attr("src","./imagenes/botones/mapa_off.png");
        $("#seccentros").css("overflow","");
        $("#capa_cargadora_mapa").css("display","none");
        $("#capa_cargadora_mapa").empty();
        sessionStorage.setItem("crearmapa","si");
    });
    //Enviar correo electrónico
    $(document).on('vmousedown', ".enviar_correo", function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        $(this).attr("src","./imagenes/botones/correo_on.png");
    });
    $(document).on('vmouseup', ".enviar_correo", function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        $(this).attr("src","./imagenes/botones/correo_off.png");
    });
    //Llamar por teléfono
    $(document).on('vmousedown', ".llamar_telefono", function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        $(this).attr("src","./imagenes/botones/telefono_on.png");
    });
    $(document).on('vmouseup', ".llamar_telefono", function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        $(this).attr("src","./imagenes/botones/telefono_off.png");
    });
    //Más información del centro
    $(document).on('vmousedown', ".mas_info", function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        $(this).attr("src","./imagenes/botones/info_on.png");
    });
    $(document).on('vmouseup', ".mas_info", function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        $(this).attr("src","./imagenes/botones/info_off.png");
        var valor_ficha = "#fich" + $(this).attr("id") + " .extra_ficha_centro";
        $(valor_ficha).toggle();
        
    });
    //Cuando pulsamos para abrir un mapa en detalle
    $(document).on('vmousedown', ".ampliar_mapa", function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();  
        if(sessionStorage.getItem("estado_conexion") == "si"){
            $(this).attr("src","./imagenes/botones/mapa_on.png"); 
            sessionStorage.setItem("crearmapa","si");
            var num_centro = $(this).attr("id");
            //Dependiendo del centro cargamos la información adecuada
            switch(num_centro)
             {
                case 'centro_1':
                    coordenadas = sessionStorage.setItem('coordenadas','36.75157337800899,-2.6968002319335938');
                    nombre_centro = sessionStorage.setItem('nombre_centro','Mojonera - Pandal');
                    preparar_carga();
                    $("#direccion_mapa").append('<h3>Mojonera - Pandal</h3>Ctra. Las Norias, Pol. El Olivo 5 y 7<br />04745 La Mojonera - ALMERIA<br />Tlf. 950339900 - Fax 950339951');
                break;
                case 'centro_2':
                    coordenadas = sessionStorage.setItem('coordenadas','36.782737,-2.751306');
                    nombre_centro = sessionStorage.setItem('nombre_centro','La Redonda');
                    preparar_carga();
                    $("#direccion_mapa").append('<h3>La Redonda</h3>Ctra. Nacional 340, Km. 414<br/>04700 El Ejido - ALMERIA<br/>Tlf. 950580850 - Fax 950580195');
                break;
                case 'centro_3':
                    coordenadas = sessionStorage.setItem('coordenadas','36.760002,-2.986018');
                    nombre_centro = sessionStorage.setItem('nombre_centro','Adra');
                    preparar_carga();
                    $("#direccion_mapa").append('<h3>Adra</h3>C/ Sevilla, s/n<br/>04779 Puente del Rio – Adra - ALMERIA<br/>Tlf. 950607171 - Fax 950607172');
                break;
                case 'centro_4':
                    coordenadas = sessionStorage.setItem('coordenadas','36.945184,-2.126039');
                    nombre_centro = sessionStorage.setItem('nombre_centro','Nijar');
                    preparar_carga();
                    $("#direccion_mapa").append('<h3>Nijar</h3>Camino de Vera, s/n .Km. 37<br/>04117 Campohermoso – Níjar - ALMERIA<br/>Tlf. 950611363 - Fax 950386530');
                break;
                case 'centro_5':
                    coordenadas = sessionStorage.setItem('coordenadas','36.7588645,-2.6447875');
                    nombre_centro = sessionStorage.setItem('nombre_centro','Cortijos de Marín');
                    preparar_carga();
                    $("#direccion_mapa").append('<h3>Cortijos de Marín</h3>Plaza Huerta de Europa, s/n<br/>04741 Cortijos de Marin- Roquetas de Mar - ALMERIA<br/>Tlf. 950327280 - Fax 950329036');
                break;
                case 'centro_6':
                    coordenadas = sessionStorage.setItem('coordenadas','36.790750,-2.704537');
                    nombre_centro = sessionStorage.setItem('nombre_centro','El Viso');
                    preparar_carga();
                    $("#direccion_mapa").append('<h3>El Viso</h3>Ctra. Nacional 340, Km. 419<br/>04746 El Viso-La Mojonera - ALMERIA<br/>Tlf. 670261116 - Fax 950558131');
                break;
                default:
                    coordenadas = sessionStorage.setItem('coordenadas','36.75157337800899,-2.6968002319335938');
                    nombre_centro = sessionStorage.setItem('nombre_centro','Mojonera - Pandal');
                    preparar_carga();
                    $("#direccion_mapa").append('<h3>Mojonera - Pandal</h3>Ctra. Las Norias, Pol. El Olivo 5 y 7<br />04745 La Mojonera - ALMERIA<br />Tlf. 950339900 - Fax 950339951');
            }
            window.setTimeout('crear_mapa()',500);
            //ocultamos el scroll vertical
            $("#seccentros").css("overflow","hidden");
        }
    });
}




/***** ACCIONES PARA LA PIZARRA ******/
/*************************************/
/**
 * botones_pizarra()
 * Método con las acciones de las fichas de la pizarra, para desplegarlas u ocultarlas y para cambiar el icono de más o menos información
 */
function botones_pizarra(){
    $(document).on('tap', ".ficha_producto_pizarra", function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        var actual = "#" + $(this).attr("id");
        var actual = actual;
        var boton_actual = actual + " .boton_mas_pizarra img";
        var ocultar_clase = actual + " .capa_extra_pizarra div";
        if($(boton_actual).attr("class") == "bot_pizarra_off"){
            $(boton_actual).removeClass("bot_pizarra_off");
            $(boton_actual).addClass("bot_pizarra_on");
        }else{
            $(boton_actual).removeClass("bot_pizarra_on");
            $(boton_actual).addClass("bot_pizarra_off");
        }
        if($(ocultar_clase).attr("class") == "capa_extra_pizarra_off"){
            $(ocultar_clase).removeClass("capa_extra_pizarra_off");
            $(ocultar_clase).addClass("capa_extra_pizarra_on");
        }else{
            $(ocultar_clase).removeClass("capa_extra_pizarra_on");
            $(ocultar_clase).addClass("capa_extra_pizarra_off");
        } 
    });
    
    $(document).on('tap taphold', ".boton_historial_off", function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        $(this).removeClass("boton_historial_off");
        $(this).addClass("boton_historial_on");
        sessionStorage.setItem("pagina_navegar", "historial");
        window.setTimeout('cambio_pagina()',200);
    });
    
}




/***** ACCIONES PARA LOS PRODUCTOS ******/
/****************************************/
/**
 * botones_productos()
 * Método para inyectar los distintos botones de los productos de la sección productos
 */
function botones_productos(){
	console.log("botones cargados");
    $('#capa_cargadora_informacion').animate({"opacity": 0}, 0);
    $("#capa_cargadora_informacion").empty();
    $("#capa_cargadora_informacion").append('<div class="boton_menu_producto"><img id="bio" src="./imagenes/botones/trans.png" class="boton_bio_off" /><br />Agrupaejido Bio</div>');
    $("#capa_cargadora_informacion").append('<div class="boton_menu_producto"><img id="sandistar" src="./imagenes/botones/trans.png" class="boton_sandistar_off" /><br />Sandistar</div>');
    $("#capa_cargadora_informacion").append('<div class="boton_menu_producto"><img id="pimientocorto" src="./imagenes/botones/trans.png" class="boton_pimientocorto_off" /><br/>Pimiento Corto</div>');
    $("#capa_cargadora_informacion").append('<div class="boton_menu_producto"><img id="pimientoitaliano" src="./imagenes/botones/trans.png" class="boton_pimientoitaliano_off" /><br/>Pimiento Italiano</div>');
    $("#capa_cargadora_informacion").append('<div class="boton_menu_producto"><img id="pimientolargo" src="./imagenes/botones/trans.png" class="boton_pimientolargo_off" /><br/>Pimiento Largo</div>');
    $("#capa_cargadora_informacion").append('<div class="boton_menu_producto"><img id="calabacin" src="./imagenes/botones/trans.png" class="boton_calabacin_off" /><br/>Calabacín</div>');
    $("#capa_cargadora_informacion").append('<div class="boton_menu_producto"><img id="pepinoalmeria" src="./imagenes/botones/trans.png" class="boton_pepinoalmeria_off" /><br/>Pepino Almería</div>');
    $("#capa_cargadora_informacion").append('<div class="boton_menu_producto"><img id="pepinoespanol" src="./imagenes/botones/trans.png" class="boton_pepinoespanol_off" /><br/>Pepino Español</div>');
    $("#capa_cargadora_informacion").append('<div class="boton_menu_producto"><img id="pepinofrances" src="./imagenes/botones/trans.png" class="boton_pepinofrances_off" /><br/>Pepino Francés</div>');
    $("#capa_cargadora_informacion").append('<div class="boton_menu_producto"><img id="berenjenalarga" src="./imagenes/botones/trans.png" class="boton_berenjenalarga_off" /><br />Berenjena Larga</div>');
    $("#capa_cargadora_informacion").append('<div class="boton_menu_producto"><img id="berenjenaredonda" src="./imagenes/botones/trans.png" class="boton_berenjenaredonda_off" /><br/>Berenjena Redonda</div>');
    $("#capa_cargadora_informacion").append('<div class="boton_menu_producto"><img id="tomatelonglife" src="./imagenes/botones/trans.png" class="boton_tomatelonglife_off" /><br/>Tomate Long Life</div>');
    $("#capa_cargadora_informacion").append('<div class="boton_menu_producto"><img id="tomateramillete" src="./imagenes/botones/trans.png" class="boton_tomateramillete_off" /><br/>Tomate Ramillete</div>');
    $("#capa_cargadora_informacion").append('<div class="boton_menu_producto"><img id="tomateverde" src="./imagenes/botones/trans.png" class="boton_tomateverde_off" /><br/>Tomate Verde</div>'); 
    $("#capa_cargadora_informacion").append('<div class="boton_menu_producto"><img id="judiacilindrica" src="./imagenes/botones/trans.png" class="boton_judiacilindrica_off" /><br/> Judía Cilíndrica</div>');
    $("#capa_cargadora_informacion").append('<div class="boton_menu_producto"><img id="judiaplana" src="./imagenes/botones/trans.png" class="boton_judiaplana_off" /><br/>Judía Plana</div>');   
    $("#capa_cargadora_informacion").append('<div class="boton_menu_producto"><img id="sandia" src="./imagenes/botones/trans.png" class="boton_sandia_off" /><br/>Sandía</div>');
    $("#capa_cargadora_informacion").append('<div class="boton_menu_producto"><img id="melonamarillo" src="./imagenes/botones/trans.png" class="boton_melonamarillo_off" /><br/>Melón Amarillo</div>');
    $("#capa_cargadora_informacion").append('<div class="boton_menu_producto"><img id="meloncantaloup" src="./imagenes/botones/trans.png" class="boton_meloncantaloup_off" /><br/>Melón Cantaloup</div>');
    $("#capa_cargadora_informacion").append('<div class="boton_menu_producto"><img id="melongalia" src="./imagenes/botones/trans.png" class="boton_melongalia_off" /><br/>Melón Galia</div>');
    $("#capa_cargadora_informacion").append('<div class="boton_menu_producto"><img id="melonnegro" src="./imagenes/botones/trans.png" class="boton_melonnegro_off" /><br/>Melón Negro</div>');
    $('#capa_anima_carga').css("display","none");
    $('#capa_cargadora_informacion').animate({"opacity": 1}, 100);
    botones_listadoproductos();
}

/**
 * botones_listadoproductos()
 * Métodos para las acciones de los botones de inicio
 */
function botones_listadoproductos() {
    $(document).on('tap taphold', '.boton_menu_producto img', function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        valor = $(this).attr("id");
        sessionStorage.setItem("pagina_navegar", valor);
        valor = "boton_" + valor;
        valor_on = valor + "_on";
        valor_off = valor + "_off";
        $(this).removeClass(valor_off);
        $(this).addClass(valor_on);
        //Cargamos la pagina con un poco de retardo para simular el pulsado de botón
        window.setTimeout('cambio_pagina()',200);
    });
}




/***** ACCIONES PARA LA PORTADA ******/
/*************************************/
/**
 * botones_portada()
 * Método para inyectar los botones a la portada de la app
 */
function botones_portada(){
    $("#capa_botonera").empty();
    $("#capa_botonera").append('<div class="boton_menu_inicio"><img id="seleccionpizarra" src="./imagenes/botones/trans.png" class="boton_seleccionpizarra_off" /></div><div class="boton_menu_inicio"><img id="noticias" src="./imagenes/botones/trans.png" class="boton_noticias_off" /></div><div class="boton_menu_inicio"><img id="productos" src="./imagenes/botones/trans.png" class="boton_productos_off" /></div><div class="boton_menu_inicio"><img id="centros" src="./imagenes/botones/trans.png" class="boton_centros_off" /></div><div class="boton_menu_inicio"><img id="historia" src="./imagenes/botones/trans.png" class="boton_historia_off" /></div><div class="boton_menu_inicio"><img id="social" src="./imagenes/botones/trans.png" class="boton_social_off" /></div>');
}
/**
 * botones_inicio()
 * Métodos para las acciones de los botones de inicio
 */
function botones_inicio() {
	$(".pie_acceso_agricultores").css("background","url(./imagenes/pie_acceso.png) top center no-repeat");
	$(".pie_acceso_agricultores_t").css("background","url(./imagenes/pie_acceso.png) top center no-repeat");
	
    $(document).on('tap taphold', '.boton_menu_inicio img', function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        valor = $(this).attr("id");
        sessionStorage.setItem("pagina_navegar", valor);
        valor = "boton_" + valor;
        valor_on = valor + "_on";
        valor_off = valor + "_off";
        $(this).removeClass(valor_off);
        $(this).addClass(valor_on);
        //Cargamos la pagina con un poco de retardo para simular el pulsado de botón
        window.setTimeout('cambio_pagina()',200);
    });
	
	$(document).on('tap taphold', '.boton_entrada_agricultores,.boton_entrada_agricultores_t', function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        sessionStorage.setItem("pagina_navegar", "accesoagricultores");
        $(".pie_acceso_agricultores,.pie_acceso_agricultores_t").css("background","url(./imagenes/pie_acceso_on.png) top center no-repeat");
        //Cargamos la pagina con un poco de retardo para simular el pulsado de botón
        window.setTimeout('cambio_pagina()',200);
    });
}






/***** ACCIONES DE CARGA DE NOTICIAS ******/
/******************************************/
/**
 * cargar_noticias()
 * Método para cargar las noticias, crearlas e inyectarlas
 */
function cargar_noticias(){
    //Recuperamos los datos locales para tratarlos después
    datos_en_memoria = localStorage.getItem('info_noticia');
    datos_recarga = localStorage.getItem('ultima_actualizacion_noticias');

    //reseteo de la hora actual a la hora en la que se carga una noticia
    var ahora = new Date(); 
    sessionStorage.setItem('hora_actual',ahora);

		$.ajax({
			url: 'http://www.agrupaejido.com/noticias_agrupaejido_app.php?firma=' + Generar_Firma(),
			dataType: 'jsonp',
			data: {},
			global: false,
			cache: false,
			crossDomain: true,
			success: function(data){
				//salvamos los datos en local
				localStorage.setItem('info_noticia', JSON.stringify(data));
				datos_en_memoria = JSON.parse(localStorage.getItem('info_noticia'));

				$('#capa_cargadora_informacion').animate({"opacity": 0}, 0);
				
				//Recorremos los datos para crear dinámicamente las noticias
				$.each(datos_en_memoria.noticias, function(i,noticia){
					var str= noticia.entradilla;
					str = str.substring(0,150) + "...";
					
					$('#capa_cargadora_informacion').append("<div class='noticia_listado' id='not_" +
					noticia.idnoticia + "'><div class='linea_flechas'><div class='contenido_noticia_listado'>"+
					noticia.fecha + "<br/><span class='titular_listado'>"+
					noticia.titulo + "</span><div class='texto_noticia_listado'>" +
					str + "</div></div></div></div>");
				});
				$('#capa_anima_carga').css("display","none");
				$('#capa_cargadora_informacion').animate({"opacity": 1}, 200);
				
				//reseteo de la ultima actualizacion
				var nueva_carga = new Date(); 
				localStorage.setItem('ultima_actualizacion_noticias',nueva_carga);
				
			 },
			 error: function(XMLHttpRequest, textStatus, errorThrown) {
				alert('Fallo en la lectura de datos. Inténtelo más tarde.');
			}
		});

}

/**
 * detalle_noticia()
 * Método para cargar las noticias, crearlas e inyectarlas
 */
function detalle_noticia(){
    //Recuperamos los datos locales para tratarlos después
    datos_en_memoria = localStorage.getItem('info_noticia');

        datos_en_memoria = JSON.parse(localStorage.getItem('info_noticia'));
        $('#capa_cargadora_informacion').animate({"opacity": 0}, 0);
        //Recorremos los datos para crear dinámicamente las noticias
        $.each(datos_en_memoria.noticias, function(i,noticia){
            if(noticia.idnoticia == sessionStorage.getItem("id_noticia")){
                $('#capa_cargadora_informacion').append("<div class='detalle_interior'>"+
                noticia.fecha + "<br/><span class='titular_listado'>"+
                noticia.titulo + "</span><div class='texto_noticia_listado'>" +
                noticia.entradilla + "<br/><br/></div><div class='imagen_detalle_noticia'><span>Foto de la noticia:</span>&nbsp;&nbsp;<a title='"+
                noticia.titulo +"' href='"+
                noticia.zoomimagen +"' rel='external'><img src='"+
                noticia.imagen +"' /></a></div>");
            }
        });
        $('#capa_cargadora_informacion').trigger('create');
        $('#capa_anima_carga').css("display","none");
        $('#capa_cargadora_informacion').animate({"opacity": 1}, 200);
        
        var 
        currentPage = $("#detalle-galeria"),
        options = {},
        photoSwipeInstance = $(".imagen_detalle_noticia a", "#secdetallenoticia").photoSwipe(options,  currentPage.attr('atributo'));
        sessionStorage.setItem("galeria_actual",photoSwipeInstance.id);
        return true;
    
}





/***** ACCIONES DE CARGA DE LA PIZARRA ******/
/********************************************/

/**
 * botones_seleccionpizarra()
 * Método para inyectar los botones de la selección de subasta
 */
function botones_seleccionpizarra(){
    $('#capa_cargadora_informacion').animate({"opacity": 0}, 0);
    $("#capa_cargadora_informacion").empty();
    $("#capa_cargadora_informacion").append('<div class="boton_menu_pizarra"><img id="pizarra_1" src="./imagenes/botones/trans.png" class="boton_pizarra_1_off" /><br />La Redonda</div>');
    $("#capa_cargadora_informacion").append('<div class="boton_menu_pizarra"><img id="pizarra_28" src="./imagenes/botones/trans.png" class="boton_pizarra_28_off" /><br />El Viso</div>');
    $("#capa_cargadora_informacion").append('<div class="boton_menu_pizarra"><img id="pizarra_3" src="./imagenes/botones/trans.png" class="boton_pizarra_3_off" /><br/>Cortijos de Marín</div>');
    $("#capa_cargadora_informacion").append('<div class="boton_menu_pizarra"><img id="pizarra_9" src="./imagenes/botones/trans.png" class="boton_pizarra_9_off" /><br/>Níjar</div>');
    $('#capa_anima_carga').css("display","none");
    $('#capa_cargadora_informacion').animate({"opacity": 1}, 200);
}

/*
 * botones_subasta()
 * Método con las acciones de los botones de selección de subasta
 */
function botones_subastas(){
    $(document).on('tap taphold', '.boton_menu_pizarra img', function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        valor = $(this).attr("id");
        sessionStorage.setItem("pagina_navegar", "pizarra");
        valor = "boton_" + valor;
        var id_subasta = valor.substring(14,valor.length);
        sessionStorage.setItem("pizarra_actual", id_subasta);
        sessionStorage.setItem("fecha_pizarra","0");
        sessionStorage.setItem("recargar_pizarra","si");
        valor_on = valor + "_on";
        valor_off = valor + "_off";
        $(this).removeClass(valor_off);
        $(this).addClass(valor_on);
        //Cargamos la pagina con un poco de retardo para simular el pulsado de botón
        window.setTimeout('cambio_pagina()',200);
    });
}

/**
 * info_centro(tipo,fecha)
 * Método para insertar el nombre de la subasta y la fecha de la consulta
 * @param tipo Número del centro para saber su nombre
 * @param fecha Fecha de la consulta actual de la pizarra
 */
function info_centro(tipo,fecha){
    switch(tipo)
    {
        case '1':
            $('#capa_localizador_pizarra').append('Centro: <strong>La Redonda</strong><br/>Fecha: <strong>' + fecha + '</strong><br/>');
        break;
        case '28':
            $('#capa_localizador_pizarra').append('Centro: <strong>El Viso</strong><br/>Fecha: <strong>' + fecha + '</strong><br/>');
        break;
        case '3':
            $('#capa_localizador_pizarra').append('Centro: <strong>Cortijos de Marín</strong><br/>Fecha: <strong>' + fecha + '</strong><br/>');
        break;
        case '9':
            $('#capa_localizador_pizarra').append('Centro: <strong>Níjar</strong><br/>Fecha: <strong>' + fecha + '</strong><br/>');
        break;
    }
}

/**
 * info_centro_pizarra(tipo,fecha)
 * Método para insertar el nombre d ela subasta en el historial de una pizarra
 * @param tipo Número del centro para saber su nombre
 */
function info_centro_pizarra(tipo){
    switch(tipo)
    {
        case '1':
            $('#centro_subasta').append('La Redonda');
        break;
        case '28':
            $('#centro_subasta').append('El Viso');
        break;
        case '3':
            $('#centro_subasta').append('Cortijos de Marín');
        break;
        case '9':
            $('#centro_subasta').append('Níjar');
        break;
    }
}

/**
 * cargar_pizarra()
 * Método para cargar los datos de una pizarra
 */
function cargar_pizarra(){
    //Recuperamos los datos locales para tratarlos después
    datos_en_memoria_pizarra = localStorage.getItem('info_pizarra');
    datos_recarga_pizarra = localStorage.getItem('ultima_actualizacion_pizarra');
    
  
    
    var tipo_centro = sessionStorage.getItem("pizarra_actual");
    var fecha_actual = sessionStorage.getItem("fecha_pizarra");
    
    var url_busqueda;
    var foto_ficha;
    
    
    //Asignar el tipo de búsqueda y la url de búsqueda
    //if(sessionStorage.getItem("fecha_pizarra") != "0"){
    if(fecha_actual != "0"){
        url_busqueda = 'http://www.agrupaejido.com/historico_pizarra_agrupaejido_app.php?centro='+ tipo_centro +'&fecha=' + fecha_actual +'&firma=' + Generar_Firma();
        var historico = "historico_" + tipo_centro + "_" + fecha_actual;
        sessionStorage.setItem("pizarra_avanzada",historico);
    }
    else{
        url_busqueda = 'http://www.agrupaejido.com/ultima_pizarra_agrupaejido_app.php?centro='+ tipo_centro +'&firma=' + Generar_Firma();
    }

   
        
            $.ajax({
                url: url_busqueda,
                dataType: 'jsonp',
                data: {},
                global: false,
                cache: false,
                crossDomain: true,
                success: function(data){
                    //salvamos los datos en local
                    localStorage.setItem('info_pizarra', JSON.stringify(data));
                    datos_en_memoria_pizarra = JSON.parse(localStorage.getItem('info_pizarra'));
                    $('#capa_cargadora_informacion').animate({"opacity": 0}, 0);
                    //Recorremos los datos para crear dinámicamente las noticias
                    $.each(datos_en_memoria_pizarra.pizarra, function(i,pizarra){
                        fecha_actual = pizarra.fecha;
                        
                        if(pizarra.idproducto == ""){
                            foto_ficha = pizarra.familia;
                        }else{
                            foto_ficha = (pizarra.familia + pizarra.idproducto);
                        }
                        
                        //fichas
                        $('#contenedor_fichas_pizarra').append("<div class='ficha_producto_pizarra' id='producto_" +
                        pizarra.id + "'><div class='pizarra_"+
                        pizarra.familia +"'><div class='cabecera_" +
                        pizarra.familia + "'><div class='nombre_producto_pizarra'>" +
                        pizarra.producto +"<div class='boton_mas_pizarra'><img src='./imagenes/botones/trans.png' class='bot_pizarra_off' /></div></div></div><div class='precios_producto_pizarra'><div class='foto_producto_pizarra'><img src='./imagenes/botones/trans.png' class='foto_pizarra_" +
                        foto_ficha +"' /></div><div class='valor_producto_pizarra'><span class='valor_maximo'>Máximo:</span><span class='valor_precio'>" +
                        pizarra.maximo + "€</span></div><div class='valor_producto_pizarra'><span class='valor_minimo'>Mínimo:</span><span class='valor_precio'>" +
                        pizarra.minimo + "€</span></div></div><div class='capa_extra_pizarra'><div class='capa_extra_pizarra_off'><div class='titulo_extra_pizarra'><img src='./imagenes/hoja.png' />&nbsp;&nbsp;<strong>Listado de precios</strong></div><div class='precios_extra_pizarra'> " +
                        pizarra.precios + "</div></div></div></div></div>");
                        //tabla
                        $('#contenedor_tabla_pizarra').append("<div class='fila_tabla'><div class='nombre_tabla'>" +
                        pizarra.producto + "</div><div class='producto_tabla'>" +
                        pizarra.precios + "</div></div>");  
                    });
                    info_centro(tipo_centro,fecha_actual);
                    $('#capa_anima_carga').css("display","none");
                    $('#capa_localizador_pizarra').css("display","inherit");
                    $('#boton_volver_pizarra').css("display","inherit");
                    $('#b_historial').css("display","inherit");
                    $('#capa_cargadora_informacion').animate({"opacity": 1}, 200);
                    sessionStorage.setItem("recargar_pizarra","no");
                },
                 error: function(XMLHttpRequest, textStatus, errorThrown) {
                    info_centro(tipo_centro,fecha_formateada(fecha_actual));
                    $('#capa_cargadora_informacion').animate({"opacity": 1}, 0);
                    $('#capa_localizador_pizarra').css("display","inherit");
                    $('#capa_anima_carga').css("display","none");
                    $('#contenedor_fichas_pizarra').empty();
                    $('#contenedor_tabla_pizarra').empty();
                    $('#contenedor_alerta').css("display","inherit");
                    $('#boton_volver_pizarra').css("display","inherit");
                    $('#b_historial').css("display","inherit");
                    $('#contenedor_alerta').append("<div style='width:100%; text-align:center;'><img src='./imagenes/alerta.png' /><br /><strong>No hay subasta disponible.</strong><br />Escoja otra fecha.<br/><br/> Recuerde que sólo se puede consultar la capaña actual.</div>");
                    $('#contenedor_alerta').animate({"opacity": 1}, 200);
                }
            });
       
    
}

/**
 * cargar_dias_historico()
 * Método para cargar botones con los días específicos en lo que hay subasta
 */
function cargar_dias_historico(){
    Date.prototype.addDays = function(days) {
      this.setDate( this.getDate()  + days);
      return this;
    };
    function Array_Fechas()
    {
        var d = new Date();
        var fechas = new Array();
        var i = 0;
        while (i<7)
        {
            d = d.addDays(-1);            
            dia = d.getDay();
            if (dia>0)
            {
                var day = d.getDate();   
                var month = d.getMonth() + 1;
                var year = d.getFullYear();
                console.log("mes - > " + month);
                if (day < 10) {
                    day = "0" + day;
                }
                if (month < 10) {
                    month = "0" + month;
                }
                fechas[i] = year + "-" + month + "-" + day;
                i++;                
            }
        }
        return fechas;        
    }
    var fechas = Array_Fechas(); 
    var i = 6;
    while (i>=0)
    {
        var fecha = new Date(fechas[i]);
        $("#contenedor_ultimos_dias").append("<div class='fecha_busqueda_pizarra' id='dia_"+ fecha.getFullYear() + "-" + (fecha.getMonth() + 1) +"-" + fecha.getDate() + "'>Día<br/><strong>"+ fecha.getDate() +"</strong></div>");
        i--;
    }
}

/**
 * SELECTOR_FECHA()
 * Método para las acciones de los botones del histórico de las pizarras y para la selección avanzada de fecha
 */
function selector_fecha(){
    //selección avanzada de fecha
    var picker = $( "input[type='text']", this );
    picker.mobipick();
    picker.on( "change", function() {          
        var date = $( this ).val();
        var dateObject = $( this ).mobipick( "option", "date" );
    });
    $("input[type='text']").mobipick({
        locale: "es"
    });
    
    $(document).on('vmousedown', '.mobipick-main a', function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        $(this).css("background","#B2CE19");  
    });
    $(document).on('vmouseup', '.mobipick-main a', function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        $(this).css("background","#385B36");  
    });
    
    //Acciones botones de día específico
     $(document).on('tap taphold', '.fecha_busqueda_pizarra', function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        sessionStorage.setItem("pagina_navegar", "pizarra");
        $(this).css("background","#385B36");
        var fecha_pizarra = $(this).attr("id");
        var fecha_pizarra = fecha_pizarra.substring(4,fecha_pizarra.length);
        sessionStorage.setItem("fecha_pizarra",fecha_pizarra);
        
        window.setTimeout('cambio_pagina()',200);
    });
     
    $(document).on('tap taphold', '#boton_buscar_historia', function (event) {
        event.preventDefault();    
        event.stopImmediatePropagation();
        if($("#fecha_avanzada").val() != ""){
            $(this).css("background","#3E6F3B");
            sessionStorage.setItem("pagina_navegar", "pizarra");
            sessionStorage.setItem("fecha_pizarra",$("#fecha_avanzada").val());
            window.setTimeout('cambio_pagina()',200);
        }else{
            alert("Debe seleccionar una fecha específica");
            $(this).css("background","#B2CE19");
        }
    });
    
}










//funcion para cargar secciones estaticas con fade
function cargar_seccion(){
    $('#capa_cargadora_informacion').animate({"opacity": 0}, 0);
    $('#capa_anima_carga').css("display","none");
    $('#capa_cargadora_informacion').animate({"opacity": 1}, 100);
}

/*------- FUNCIONES PARA ABRIR LAS REDES SOCIALES ------- */
function abrir_facebook(){
	window.open("https://www.facebook.com/GrupoAgrupaEjido", '_system', 'location=yes');
}
function abrir_twitter(){
	window.open("https://twitter.com/agrupaejido", '_system', 'location=yes');
}
function abrir_youtube(){
	window.open("http://www.youtube.com/user/agrupaejidotv/videos", '_system', 'location=yes');
}
/*--------------------------------------------------------*/











/**
 * comprobar_fondo()
 * Método para asignar el fondo del pie del body en el caso de que sea la portada de un tablet, sino, lo anula.
 */
function comprobar_fondo(){
    if($.mobile.activePage.is('#secportadatablet')){
        $("body").css("background","url(./imagenes/bodegon_inicio.jpg) bottom center no-repeat");
    }else{
        $("body").css("background","#fff");
    }
}
/*--------------------------------------------------------*/





/**
 * EVENTOS DE CADA PAGINA
 * Acciones segun la carga de una pagina u otra
 */

$(document).on('pagebeforecreate', '#secportada', function (e) {
	sessionStorage.setItem("pagina_navegar", "index");
    sessionStorage.setItem("dispositivo","movil");
	botones_cabecera();
});
$(document).on('pagebeforeshow', '#secportada', function (e) {
	botones_inicio();
    botones_portada();
});



//SELECCION DE PIZARRA
$(document).on('pagebeforeshow', '#seleccionpizarra', function (e) {
	sessionStorage.setItem("fecha_pizarra","0");
	sessionStorage.setItem("pizarra_avanzada","si");
});
$(document).on('pageshow', '#seleccionpizarra', function (e) {
	botones_seleccionpizarra();
	botones_subastas();
	//retrasamos para evitar clicks duplicados
	window.setTimeout('botones_cabecera()',1000);
    comprobar_fondo();
});

//PIZARRA
$(document).on('pagebeforeshow', '#secpizarra', function (e) {
	botones_cabecera();
	botones_pizarra();
	window.setTimeout('cargar_pizarra()',500);
});
$(document).on('pageshow', '#secpizarra', function (e) {
    comprobar_fondo()
});

//HISTORIAL
$(document).on('pagebeforeshow', '#historial', function (e) {
	botones_cabecera();
	selector_fecha();
	cargar_dias_historico();
});
$(document).on('pageshow', '#historial', function (e) {
    comprobar_fondo()
	info_centro_pizarra(sessionStorage.getItem("pizarra_actual"));
});

//NOTICIAS
$(document).on('pagebeforeshow', '#secnoticias', function (e) {
	botones_cabecera();
	botones_noticias();
	window.setTimeout('cargar_noticias()',1000);
});
$(document).on('pageshow', '#secnoticias', function (e) {
    comprobar_fondo();
});

//DETALLE DE UNA NOTICIA
$(document).on('pagebeforeshow', '#secdetallenoticia', function (e) {
	botones_cabecera();
	window.setTimeout('detalle_noticia()',1000);
});
$(document).on('pageshow', '#secdetallenoticia', function (e) {
    comprobar_fondo();
});
$(document).on("pagehide","#secdetallenoticia",function(e){
    var aux = sessionStorage.getItem("galeria_actual");
    if (typeof aux != "undefined" && aux != null) {
        $(aux).remove();
        sessionStorage.removeItem("galeria_actual");
    }
    return true;
});

//PRODUCTOS
$(document).on('pagebeforeshow', '#secproductos', function (e) {
	botones_cabecera();
});
$(document).on('pageshow', '#secproductos', function (e) {
	botones_productos();
    comprobar_fondo();
});

//CENTROS
$(document).on('pagebeforecreate', '#seccentros', function (e) {
    $("body").css("background","#fff");
	$("#capa_cargadora_mapa").empty();
	$("#capa_cargadora_mapa").remove();
	
});
$(document).on('pagebeforeshow', '#seccentros', function (e) {
	botones_cabecera();
	botones_mapas();
	cargar_seccion();
    comprobar_fondo();
});
$(document).on('pageshow', '#seccentros', function (e) {

    //window.setTimeout('$("#seccentros").css("overflow","auto")',2000);
    $("#seccentros").css("overflow","");
    //$("#seccentros").css("top","0");
});


//HISTORIA
$(document).on('pagebeforeshow', '#sechistoria', function (e) {
	botones_cabecera();
	cargar_seccion();
});
$(document).on('pageshow', '#sechistoria', function (e) {
    comprobar_fondo();
});

//REDES SOCIALES
$(document).on('pagebeforeshow', '#secsocial', function (e) {
	botones_cabecera();
	cargar_seccion();
});
$(document).on('pageshow', '#secsocial', function (e) {
    comprobar_fondo();
});

//PRODUCTOS
$(document).on('pagebeforeshow', '.pagina_productos', function (e) {
	botones_cabecera();
	cargar_seccion();
    comprobar_fondo();
});


/*--------------------------------------------------------*/