ig.module(
	'game.entities.bossplane'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
BossPlane = ig.Entity.extend({
	size: {x: 50, y: 45},
	
	type: ig.Entity.TYPE.B, // Evil enemy group
	checkAgainst: ig.Entity.TYPE.A, // Check against friendly
	collides: ig.Entity.COLLIDES.PASSIVE,
	timebullet: 0,
	health: 300,
	speed: 3,
	flag : 1,
	tp: 'bossplane',
	animSheet: new ig.AnimationSheet( 'media/boss_plane.png', 50, 45 ),
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		this.addAnim( 'crawl', 0.08, [0] );
		this.speed = 3 * ig.game.speedrate;
	},
	
	
	update: function() {
		if (this.pos.y > ig.game.screen.y - 40)
		{
			this.timebullet ++;
			if (this.timebullet == 16)
			{
				ig.game.spawnEntity( bullet_boss, this.pos.x+10, this.pos.y+22);
				ig.game.spawnEntity( bullet_boss, this.pos.x+30, this.pos.y+22);

			}

			if (this.timebullet == 32)
			{
				this.timebullet =0;
			}
			this.pos.x -= this.speed * this.flag;
			if (this.pos.x < 0)
			{
				this.flag = -1;
			}
			if (this.pos.x > 275)
			{
				this.flag = 1;
			}
		}
		this.parent();
	},
	
	
	
});

bullet_boss = ig.Entity.extend({
	speed: 5,
	type: ig.Entity.TYPE.NONE,
	checkAgainst: ig.Entity.TYPE.A, // Check Against B - our evil enemy group
	collides: ig.Entity.COLLIDES.PASSIVE, 
		
	animSheet: new ig.AnimationSheet( 'media/bullet.png', 11, 15 ),
	
	init: function( x, y, settings ) {
		this.addAnim( 'b4', 1, [8] );
		this.currentAnim = this.anims.b4;
		this.speed = 5 * ig.game.speedrate;
		this.parent( x, y, settings );
	},

	update: function() {
	
		this.pos.y += this.speed;
		if (this.pos.y > ig.game.screen.y + ig.system.height)
		{
			this.kill();
		}
		this.parent();
	},
	
	// This function is called when this entity overlaps anonther entity of the
	// checkAgainst group. I.e. for this entity, all entities in the B group.
		
	check: function( other ) {
		
		if (other.tp == 'player')
		{
			other.receiveDamage(40,this);
			this.kill();
		}
	}
	
});	


});