ig.module(
	'game.entities.building_big'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
Building_Big = ig.Entity.extend({
	size: {x: 18, y: 20},
	maxVel: {x: 100, y: 100},
	friction: {x: 150, y: 0},
	
	type: ig.Entity.TYPE.B, // Evil enemy group
	checkAgainst: ig.Entity.TYPE.A, // Check against friendly
	collides: ig.Entity.COLLIDES.PASSIVE,
	
	health: 10,
	speed: 20,
	flip: true,
	firstY: 0,
	firstX: 0,
	width: 18,
	isKill: false,
		
//	animSheet: new ig.AnimationSheet( 'media/crow.png', 18, 20 ),
	
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		this.addAnim( 'crawl', 0.08, [0] );
		
		this.firstY = this.pos.y;
		this.firstX = this.pos.x;
		this.width = settings.width || 20;
		this.speed = settings.speed || 20;

	},
	
	
	update: function() {
		// near an edge? return!
		var xdir = this.flip ? -1 : 1;
		this.vel.x = this.speed * xdir;
		this.parent();
	},
	
	
	handleMovementTrace: function( res ) {
		this.parent( res );
		this.pos.y = this.firstY;
		// collision with a wall? return!
		
		if( res.collision.x || this.pos.x < this.firstX - this.width || this.pos.x > this.firstX + this.width) {
			this.flip = !this.flip;
			this.currentAnim.flip.x = !this.flip;
		}
	}
});

});