ig.module(
	'game.entities.cannon'
)
.requires(
	'impact.entity',
	'game.entities.player'
)
.defines(function(){
	
Cannon = ig.Entity.extend({
	size: {x: 16, y: 16},
	type: ig.Entity.TYPE.B, // Evil enemy group
	checkAgainst: ig.Entity.TYPE.A, // Check against friendly
	collides: ig.Entity.COLLIDES.PASSIVE,
	timebullet: 0,
	health: 10,
	tp: 'cannon',
	animSheet: new ig.AnimationSheet( 'media/cannon.png', 16, 16 ),
	
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		this.addAnim( 'cannon', 0.08, [0] );
	},
	
	
	update: function() {

		if (this.pos.y > ig.game.screen.y)
		{
			this.timebullet ++;
			if (this.timebullet == 7)
			{
				ig.game.spawnEntity( bullet, this.pos.x, this.pos.y );
			}
			if (this.timebullet == 14)
			{
				this.timebullet = 0;
			}
		}
		if (this.pos.y > ig.game.screen.y + ig.system.height)
		{
			this.kill();
		}
		this.parent();
	}
	
});

});