ig.module(
	'game.entities.plane_1'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
Plane_1 = ig.Entity.extend({
	size: {x: 33, y: 31},
	type: ig.Entity.TYPE.B, // Evil enemy group
	checkAgainst: ig.Entity.TYPE.A, // Check against friendly
	collides: ig.Entity.COLLIDES.PASSIVE,
	health: 10,
	speed: 2,
	timebullet: 0,
	tp: 'plane1',
	animSheet: new ig.AnimationSheet( 'media/enemyplane1.png', 33, 31 ),
	
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		this.addAnim( 'enemyplane1', 0.08, [0] );
        this.speed = 2 * ig.game.speedrate;
	},
	
	
	update: function() {
		if (this.pos.y > ig.game.screen.y - 10)
		{
			this.timebullet ++;
			if (this.timebullet == 10)
			{
				ig.game.spawnEntity( bullet, this.pos.x+10, this.pos.y);
			}
			if (this.timebullet == 20)
			{
				this.timebullet = 0;
			}
			this.pos.y +=this.speed;
		}
		if (this.pos.y > ig.game.screen.y + ig.system.height)
		{
			this.kill();
		}
		this.parent();
	},
	
	
});

});