ig.module(
	'game.entities.plane_2'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
Plane_2 = ig.Entity.extend({
	size: {x: 24, y: 21},
	
	type: ig.Entity.TYPE.B, // Evil enemy group
	checkAgainst: ig.Entity.TYPE.A, // Check against friendly
	collides: ig.Entity.COLLIDES.PASSIVE,
	timebullet: 0,
	health: 10,
	speed: 3,
	tp: 'plane2',
	animSheet: new ig.AnimationSheet( 'media/enemyplane2.png', 24, 21 ),
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		this.addAnim( 'enemyplane2', 0.08, [0] );
        this.speed = 3 * ig.game.speedrate;
	},
	
	
	update: function() {
		if (this.pos.y > ig.game.screen.y - 10)
		{
			this.timebullet ++;
			if (this.timebullet == 9)
			{
				ig.game.spawnEntity( bullet, this.pos.x, this.pos.y);
				ig.game.spawnEntity( bullet, this.pos.x+10, this.pos.y);
			}
			if (this.timebullet == 18)
			{
				this.timebullet = 0;
			}
			this.pos.y +=this.speed;
		}
		if (this.pos.y > ig.game.screen.y + ig.system.height)
		{
			this.kill();
		}
		this.parent();
	},
	
	
});

});