ig.module(
	'game.entities.plane_4'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
Plane_4 = ig.Entity.extend({
	size: {x: 17, y: 22},
	
	type: ig.Entity.TYPE.B, // Evil enemy group
	checkAgainst: ig.Entity.TYPE.A, // Check against friendly
	collides: ig.Entity.COLLIDES.PASSIVE,
	timebullet: 0,
	health: 10,
	speed: 0.5,
	tp: 'plane4',
	animSheet: new ig.AnimationSheet( 'media/enemyplane4.png', 17, 22 ),
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		this.addAnim( 'enemyplane2', 0.08, [0] );
        this.speed = 0.5 * ig.game.speedrate;
	},
	
	
	update: function() {
		if (this.pos.y > ig.game.screen.y )
		{
			this.timebullet ++;
			if (this.timebullet == 9)
			{
				ig.game.spawnEntity( bullet2, this.pos.x, this.pos.y);
			}
			if (this.timebullet == 18)
			{
				this.timebullet = 0;
			}
			this.pos.x +=this.speed;
			this.pos.y +=this.speed;
		}
		if (this.pos.y > ig.game.screen.y + ig.system.height)
		{
			this.kill();
		}
		this.parent();
	},
	
	
});

});