ig.module(
	'game.entities.tank_1'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
Tank_1 = ig.Entity.extend({
	size: {x: 34, y: 17},
	type: ig.Entity.TYPE.B, // Evil enemy group
	checkAgainst: ig.Entity.TYPE.A, // Check against friendly
	collides: ig.Entity.COLLIDES.PASSIVE,
	health: 10,
	timebullet: 0,
	tp: 'tank1',
	destx: 0,
	animSheet: new ig.AnimationSheet( 'media/tank1.png', 34, 17 ),
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		this.addAnim( 'run', 0.08, [0] );
		this.addAnim( 'stop', 0.08, [1] );
		this.destx = this.pos.x + 30;
	},
	
	
	update: function() {
		if (this.pos.y > ig.game.screen.y-3)
		{
			this.timebullet ++;
			if (this.destx > this.pos.x)
			{
				this.pos.x++;		
			}
			else
				this.currentAnim=this.anims.stop;
			if (this.timebullet == 7)
			{
					ig.game.spawnEntity( bullet, this.pos.x+16, this.pos.y);
			}
			if (this.timebullet == 14)
			{
				this.timebullet = 0;
			}
		}
		if (this.pos.y > ig.game.screen.y + ig.system.height)
		{
			this.kill();
		}

		this.parent();
	},
	
	

});

});