ig.module(
	'game.entities.tank_3'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
Tank_3 = ig.Entity.extend({
	size: {x: 23, y: 31},

	type: ig.Entity.TYPE.B, // Evil enemy group
	checkAgainst: ig.Entity.TYPE.A, // Check against friendly
	collides: ig.Entity.COLLIDES.PASSIVE,
	
	health: 10,
	timebullet: 0,
	tp: 'tank3',
	animSheet: new ig.AnimationSheet( 'media/tank3.png', 23, 31 ),
	
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		this.addAnim( 'tank3', 0.08, [0] );

	},
	
	
	update: function() {
		if (this.pos.y > ig.game.screen.y)
		{
			this.timebullet ++;
			if (this.timebullet == 7)
			{
				ig.game.spawnEntity( bullet, this.pos.x+10, this.pos.y);
				ig.game.spawnEntity( bullet, this.pos.x+5, this.pos.y);
			}
			if (this.timebullet == 14)
			{
				this.timebullet = 0;
			}
		}
		if (this.pos.y > ig.game.screen.y + ig.system.height)
		{
			this.kill();
		}

		this.parent();
	},
	
	
});

});