ig.module(
	'game.entities.tower'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
Tower = ig.Entity.extend({
	size: {x: 16, y: 32},
	type: ig.Entity.TYPE.B, // Evil enemy group
	checkAgainst: ig.Entity.TYPE.A, // Check against friendly
	collides: ig.Entity.COLLIDES.PASSIVE,
	timebullet: 0,
	health: 10,
	tp: 'tower',
	animSheet: new ig.AnimationSheet( 'media/tower.png', 16, 32 ),
	
	init: function( x, y, settings ) {
		this.addAnim('stand',1,[0]);
		this.parent( x, y, settings );
	},
	
	
	update: function() {
		if (this.pos.y > ig.game.screen.y)
		{
			this.timebullet ++;
			if (this.timebullet == 7)
			{
				ig.game.spawnEntity( bullet, this.pos.x, this.pos.y);
			}
			if (this.timebullet == 14)
			{
				this.timebullet = 0;
			}
		}
		this.parent();
	},
	
	
});

});