ig.module(
	'game.main' 
)
.requires(
	'impact.game',
	'impact.font',
	'impact.image',
	'impact.timer' ,
	'game.entities.player',
	'game.entities.cannon',
	'game.entities.cannon_ground',
	'game.entities.plane_1',
	'game.entities.plane_2',
	'game.entities.plane_3',
	'game.entities.plane_4',
	'game.entities.bossplane',
	'game.entities.tank_1',
	'game.entities.tank_2',
	'game.entities.tank_3',
	'game.entities.building_3',
	'game.entities.building_2',
	'game.entities.building_1',
	'game.entities.building_big',
	'game.entities.building_4',
	'game.entities.cannon_water',
	'game.entities.bullet',
	'game.entities.tower',
	'game.entities.bullet1',
	'game.entities.bullet2',
	'game.entities.oil_barrels',
	'game.entities.energy',
	'game.levels.round10',
	'game.levels.round9',
	'game.levels.round8',
	'game.levels.round7',
	'game.levels.round6',
	'game.levels.round5',
	'game.levels.round4',
	'game.levels.round3',
	'game.levels.round2',
	'game.levels.round1'
)
.defines(function(){
FullsizeLogoScreen = ig.Image.extend({
    draw: function() {
        if( !this.loaded ) { return; }
        ig.system.context.drawImage( this.data, 0, 0 );
    }
});    

MyGame = ig.Game.extend({
	// Load a font & images
	font: new ig.Font( 'media/menu_score_font.png' ),
	imgStar: new ig.Image( 'media/star.png' ),
	logo: new FullsizeLogoScreen( 'media/logo.jpg' ),
    title: new FullsizeLogoScreen( 'media/cover.png' ),
	menuScreen: new ig.Image( 'media/aircombat-menu.jpg' ),
	scoreScreen: new ig.Image( 'media/back2.jpg' ),	
	successScreen: new FullsizeLogoScreen( 'media/levelcomplete.png' ),
	dashBoard: new ig.Image( 'media/status.png' ),
	scorePanel: new ig.Image( 'media/levelscore.png' ),
	levelPanel: new ig.Image( 'media/levelscore.png' ),
	text: new ig.Image( 'media/landingtext.png' ),	
	bossflag: 0,

	health: 300,
	fuellevel: 6,
	old_health: 300,	
	gamestate: '',
    isPlaying: false,
    goMenu: false,
	fps: 60,
	timer: new ig.Timer(1),
	name:'',
	arrHighScore: [],
	level:1,
	score: 0,
	old_score: 0,
	old_numstars: 0,
	numhostages: 0,
	old_numhostages: 0,
	numstars:0,
	player_life: 3,	
	touchX:0,
	touchY:0,
	numpowers: 1,
	islanding: 0,
	drawy: 0,
	topY:20,
	stepbrowser: 6,
    speedrate: 4,
	flag: 0,
	panelpos:0,
	init: function() {
		// Bind keys
		ig.input.bind(ig.KEY.MOUSE1, 'go');   
//		ig.input.bind(ig.KEY.DBLTAP, 'land');   
		ig.input.initMouse();
		if( ig.ua.android ) {
			this.drawy = 20;
			this.speedrate = 6;
		}
		else if( ig.ua.iPhone ) {
			this.drawy = 11;		
		} else {
			this.drawy = 0;
		}
		
	},
//-----------------------------------------------------------------------------------------------------------------------
	update: function() 
	{
		var ys = new Array();
		if( ig.ua.iPhone ) {
			ys[1]=130-this.drawy;	ys[3]=270-this.drawy;	ys[5]=340-this.drawy;
			ys[2]=170-this.drawy;	ys[4]=310-this.drawy;	ys[6]=380-this.drawy;
			ys[7]=440-this.drawy;	ys[8]=465-this.drawy;	ys[9]=67;
			ys[10]=102;  ys[11]=200-this.drawy; ys[12]=240-this.drawy;
			ys[13]=410-this.drawy;	ys[14]=450-this.drawy;
            this.panelpos = 40;
			//10 is level & life,  ys[7,8]is back  ,9 is scorepanel  15 is score
		}
		else if( ig.ua.android ) {
			ys[1]=150-this.drawy;	ys[3]=290-this.drawy;	ys[5]=360-this.drawy;
			ys[2]=190-this.drawy;	ys[4]=330-this.drawy;	ys[6]=400-this.drawy;
			ys[7]=450-this.drawy;	ys[8]=475-this.drawy;	ys[9]=67;
			ys[10]=102;  ys[11]=220-this.drawy; ys[12]=260-this.drawy;
			ys[13]=430-this.drawy;	ys[14]=470-this.drawy;
            this.panelpos = 40;
			//10 is level & life,  ys[7,8]is back  ,9 is scorepanel  15 is score
		}
		else {
			ys[1]=110;	ys[3]=252;	ys[5]=322;
			ys[2]=146;	ys[4]=288;	ys[6]=357;
			ys[7]=416;	ys[8]=432;	ys[9]=15;
			ys[10]=60;  ys[11]=180; ys[12]=218;
			ys[13]=388;	ys[14]=422; 
			this.panelpos = 15;
		}

		// Update all entities and backgroundMaps
		if (this.isPlaying == false){
			if( ig.input.pressed('go')) 
			{ 
				var x = ig.input.mouse.x; 
				var y = ig.input.mouse.y; 
				if(this.goMenu==false&&this.timer.delta()>=0){
		            this.goMenu=true; 
					this.gamestate='menu';
			    }
				else if(this.gamestate=='menu'){
					if( x>60 && x<267){
						if( y>ys[1] && y<ys[2] ){							
 						//if( y>208 && y<240 ){	
							var self = this;
							adManager.showAd(function() {
								self.player_life = 3;
								self.gamestate='ready';
								self.level = 1;
								self.score = 0;
								self.numstars = 0;
								self.numhostages = 0;
        			});
						}
						if( y>ys[3] && y<ys[4] ){
							//this.gamestate='help';
							this.gamestate='about';	
						}
						if( y>ys[5] && y<ys[6] ){
							//this.gamestate='about';					         
						}
						if( y>ys[11] && y<ys[12] ){
						   //	this.gamestate='highscore';
							this.gamestate='help';		
							//this.getscore();
						}
						if( y>ys[13] && y<ys[14] ){
							//more game부분
						}
					} 
                } // by kss on loading level
				else if (this.gamestate=='ready'){
						this.touchX = 0; 	this.touchY = 0;
						switch(this.level){
							case 1: this.loadLevel( LevelRound1 ); this.bossflag = 0;  break;//
							case 2: this.loadLevel( LevelRound2 ); this.bossflag = 0;  break;//
							case 3: this.loadLevel( LevelRound3 ); this.bossflag = 0;  break;//
							case 4: this.loadLevel( LevelRound4 ); this.bossflag = 0;  break;//
							case 5: this.loadLevel( LevelRound5 ); this.bossflag = 0;  break;//
							case 6: this.loadLevel( LevelRound6 ); this.bossflag = 0;  break;//
							case 7: this.loadLevel( LevelRound7 ); this.bossflag = 0;  break;//
							case 8: this.loadLevel( LevelRound8 ); this.bossflag = 0;  break;//
							case 9: this.loadLevel( LevelRound9 ); this.bossflag = 0;  break;//
							case 10: this.loadLevel( LevelRound10 ); this.bossflag = 0;  break;//
						}						
						
						this.isPlaying = true;
						this.gamestate='round';
						this.score = this.old_score;
										
                }
				else if (this.gamestate == 'gameover'){
					/*this.gamestate = 'inputname';
					this.goMenu = true;
					this.old_score = 0;*/
					this.gamestate = 'menu';
					this.goMenu = true;
					this.level = 1;
				}
				else if (this.gamestate == 'success'){
					this.gamestate = 'inputname';
				}
				else if (this.gamestate=='highscore'){
					if(x > 10 && x < 50 && y > ys[7] && y < ys[8]){//press back to menu
						this.gamestate = 'menu';
						this.goMenu = true;
						this.level = 1;
					}
				}
				else if (this.gamestate=='help'){
					if(x > 10 && x < 50 && y > ys[7] && y < ys[8]){//press back to menu
						this.gamestate = 'menu';
						this.goMenu = true;
						this.level = 1;
					}
				}
				else if (this.gamestate=='about'){
					if(x > 10 && x < 50 && y > ys[7] && y < ys[8]){//press back to menu
						this.gamestate = 'menu';
						this.goMenu = true;
						this.level = 1;
					}
				}
				
            }
            
        }
		else{
			
			var player = this.getEntitiesByType( EntityPlayer )[0];
			
			if ( player ) 
			{  
				if(this.screen.y > 0)
				{
					this.screen.y -= this.stepbrowser/2 * this.speedrate;
					player.pos.y -= this.stepbrowser/2 * this.speedrate;
				}
				//player.pos.y -= this.stepbrowser/2 * this.speedrate;
				if (this.screen.y < 0 )
				{
					if (this.level ==1)
					{
						player.pos.y -= this.stepbrowser/2 * this.speedrate;
					}
					else if (this.level == 10)
					{
						if (this.bossflag > 1)
						{
							player.pos.y -= this.stepbrowser/2 * this.speedrate;
						}
						else
							player.pos.y -= 0;
					}
					else
					{
						if (this.bossflag == 0)
						{
							player.pos.y -= 0;
						}
						else
						{
							player.pos.y -= this.stepbrowser/2 * this.speedrate;
						}
					}
				}

				if (player.fuel >= 0)
				{
					player.fuel -= 0.8;
				}

				this.fuellevel = Math.round(player.fuel/100);
				
				this.health = player.health;
				if (this.screen.y <= 0 && player.pos.y < 10)
				{//// if round ended, continue next
					if(this.level < 10 && this.level > 1 && this.bossflag == 1){
						this.gamestate = 'ready';
						this.screen.y = 0;
						this.level += 1 ;
						this.isPlaying = false;
						//save previous level's score,stars,hostages
						this.old_score = this.score;
						this.old_numstars = this.numstars;
						this.old_numhostages = this.numhostages;
						this.old_health = this.health;
					}
					if (this.level == 1)
					{
						this.gamestate = 'ready';
						this.screen.y = 0;
						this.level += 1 ;
						this.isPlaying = false;
						//save previous level's score,stars,hostages
						this.old_score = this.score;
						this.old_numstars = this.numstars;
						this.old_numhostages = this.numhostages;
						this.old_health = this.health;
					}
					if (this.level == 10)
					{
					
						if (this.bossflag >= 2)
						{
							this.old_score = 0;
							this.gamestate = 'success';
							this.isPlaying = false;
							this.numpowers = 1;
						}
					}
					
				}

				if(player.pos.y - this.screen.y +52 > ig.system.height)
					player.pos.y = this.screen.y + ig.system.height - 52;
			}else //if player is killed
			{	
		
				this.player_life -= 1;
				this.touchX = 0;
				this.touchY = 0;
				if(this.player_life > 0)
				{			
					this.gamestate = 'ready';
					this.isPlaying = false;
					// restore previous level's score,stars,hostages
					this.score = this.old_score;
					this.numstars = this.old_numstars ;
					this.numhostages = this.old_numhostages ;
					
				}
				else
				{// if game over
					this.gamestate='gameover';
					this.isPlaying = false;
				}
			
			}
			
		}
		this.parent();
	},
//------------------------------------------------------------------------------------------------------------------------
	savescore: function(){
				
		$('#highscore').blur();
		$('#canvas').focus();
		$('#highscore').css('z-index', 0);
		$('#canvas').css('z-index', 10);
		
		if( this.name == '' ) {
			this.getscore();
			return;
		}
		var that = this;
		var req = $.ajax({
			url:( "game.php" + '?nocache=' + Math.random() ), 
			data: {a: 's', n: that.name, s: that.score},
			dataType: 'json',
			async:false,
			success:function(scores) {
				that.arrHighScore = scores;
				document.getElementById('highscore').blur();
				that.gamestate = 'highscore';
				window.scrollTo(0,1);
				this.name = '';
			}
		});
		
	},
	getscore: function(){
		var that = this;
		var req = $.ajax({
			url:( "game.php" + '?nocache=' + Math.random() ), 
			data: {a: 'l'},
			dataType: 'json',
			async:false,
			success:function(scores) {
				that.arrHighScore = scores;
				that.gamestate = 'highscore';
			}
		});	
	},
//------------------------------------------------------------------------------------------------------------------------
	preDraw: function() {
	},
	drawScore: function(){

			this.scorePanel.draw(2,this.panelpos);
			this.levelPanel.draw(180,this.panelpos);
			this.font.draw( 'SCORE ' + this.score, 12, this.panelpos+4 );
			this.font.draw( 'LEVEL  '+this.level,189,this.panelpos+4);
			this.font.draw( ' X ' + this.player_life, 270, this.panelpos+4 );

	},
//------------------------------------------------------------------------------------------------------------------------
	draw: function() {
		
		this.preDraw();
		this.parent();
        if (this.isPlaying == false && this.gamestate!='ready'&& this.gamestate!='success'
					&& this.gamestate!='gameover'&& this.gamestate!='highscore'&& this.gamestate!='inputname'
					&& this.gamestate!='ready')
        {
        	if(this.timer.delta()>=0 && this.goMenu==false)
	            this.title.draw();
        
			else if(this.goMenu==true && this.timer.delta()>=0)
                this.menuScreen.draw(0,this.drawy,0,0,320,480);
            else if(this.isPlaying==false)
				this.logo.draw();
		}
		else if (this.isPlaying == true){
 			this.drawScore();
			this.drawDash();
			this.drawtext();
			this.checkButtonPressed();
		}
		/////by kss about ready screen
			
		switch(this.gamestate){
			case 'ready': 
				if(this.level==1){
					var readyScreen = new ig.Image( 'media/ready.jpg' );	
					readyScreen.draw(0,this.drawy,0,0,320,480);
				}
				else{
					var readyScreen = new FullsizeLogoScreen( 'media/levelcomplete.png' );	
					readyScreen.draw();
					}				
				break;
			case 'success':
				this.successScreen.draw();
				break;
			case 'inputname':
				this.inputname();
				break;
			case 'highscore':
				this.scoreScreen.draw(0,this.drawy,0,0,320,480);
				this.font.draw('H I G H  S C O R E S',80, this.topY + 40);
				this.showHighScore();
				break;
			case 'about':				
				this.scoreScreen.draw(0,this.drawy,0,0,320,480);
				this.font.draw('A   B   O   U   T',80, this.topY + 70);
                this.font.draw('AIR COMBAT, ',105, this.topY + 130);
				this.font.draw('DEVELOPED BY TWEENSOFT INC.',50, this.topY + 170);
				this.font.draw('WWW.TWEENSOFT.COM',90, this.topY + 210);
				//this.font.draw('TWEENSOFT INC.',70, this.topY + 220);
				//this.font.draw('WWW.TWEENSOFT.COM',70, this.topY + 250);
				break;
			case 'help':
				this.scoreScreen.draw(0,this.drawy,0,0,320,480);
				this.font.draw('H  E  L  P',120, this.topY + 60);
				this.font.draw('ARE  YOU  READY  PILOT ?',55, this.topY + 140);
				this.font.draw('SHOOT AS MANY ENEMIES AS POSSIBLE.',17, this.topY + 180);
				//this.font.draw('ENEMIES AS POSSIBLE.',5, this.topY + 160);
				this.font.draw('COLLECT EXTRA ENERGY, FIRE POWER,',27, this.topY + 220);
				//this.font.draw('FIRE POWER,HOSTAGES',5, this.topY + 240);
				this.font.draw('HOSTAGES AND STARS.',80, this.topY + 260);
				this.font.draw('TO INCREASE YOUR SCORE.',67, this.topY + 300);
				break;
			case 'gameover':
				var readyScreen = new FullsizeLogoScreen( 'media/GameOver.png' );	
				readyScreen.draw();
				break;
		}
	},
	drawDash: function(){

		
		var dashpos_y = 449;
		if(ig.ua.iPhone)
			dashpos_y = 419;
		this.dashBoard.draw(0,dashpos_y);
		this.font.draw( this.numstars , 255, dashpos_y+14);		
		this.font.draw( this.numhostages , 217, dashpos_y+14);
		
		var energylevel = this.health / 50 ;
		if(energylevel > 6) energylevel = 6;
		var imgEnergyStatus = new ig.Image('media/energy.png');
		imgEnergyStatus.draw(85,dashpos_y+16,Math.round(6-energylevel)*13,0,13,12);
		
		var imgFuel = new ig.Image('media/fuel.png');
		imgFuel.draw(145,dashpos_y+16,Math.round(6-this.fuellevel)*7,0,7,13);
		
		var imgAltitude = new ig.Image('media/altitude.png');
		if (this.islanding == 0)
		{
			imgAltitude.draw(115,dashpos_y+16,0,0,9,11);
		}
		else
			imgAltitude.draw(115,dashpos_y+16,36,0,9,11);
		
		
	},

	drawtext: function()
	{

		var arrY2 = new Array();
		arrY2[2] = 1848;arrY2[7] = 1342;
		arrY2[3] = 946; arrY2[8] = 1254;
		arrY2[4] = 396; arrY2[9] = 1254;
		arrY2[5] = 550; arrY2[10] = 704;
		arrY2[6] = 1584; 

		var player = this.getEntitiesByType( EntityPlayer )[0];
		if (this.level == 1)
		{
			if (this.screen.y < 1738 - 100 && this.screen.y > 1738 - 500 && this.islanding == 0)
			{
				this.text.draw(70,200,0,0,200,35);
			}
			if (this.screen.y < 836 - 100 && this.screen.y > 836 - 500 && this.islanding == 0)
			{
				this.text.draw(70,200,0,0,200,35);
			}
		}
		else
		{
			if (this.screen.y < arrY2[this.level] - 100 && this.screen.y > arrY2[this.level] - 600 && this.islanding == 0)
			{
				this.text.draw(70,200,0,0,200,35);
			}

		}
	
	},

	inputname: function()
	{
		$('#canvas').blur();
		$('#highscore').focus();
		$('#highscore').css('z-index', 10);
		$('#canvas').css('z-index', 0);
		var namescreen = new FullsizeLogoScreen('media/back.png');
		namescreen.draw();
		this.font.draw('INPUT YOUR NAME AND',75, this.topY + 80);
		this.font.draw('TAP TO CONTINUE',95, this.topY + 110);

		this.name = ig.$( '#highscore' ).value.toUpperCase();
		var length = this.name.length;
		this.font.draw( this.name, 150 - length * 7, 240 );
	},
	
	showHighScore: function() {		
		for( i = 0; i < 10; i++ ) {
			this.font.draw( i + 1 + '.', 20, 30 * i + 100 );
			
			if( this.arrHighScore[i] != undefined ) { 
				this.font.draw( this.arrHighScore[i].name, 50, 30 * i + 100 ); 
				this.font.draw( this.arrHighScore[i].score, 230, 30 * i + 100 ); 				
			} else {
				this.font.draw( '.....', 80, 30 * i + 100 );
			}
		}
		
		
	},
//------------------------------------------------------------------------------------------------------------------------

	
	checkButtonPressed: function()
	{
		var player = this.getEntitiesByType( EntityPlayer )[0];
		
		if( ig.input.pressed('go')) 
		{

			var x = ig.input.mouse.x+this.screen.x;
			var y = ig.input.mouse.y+this.screen.y;
			var dx = x - player.pos.x;
			var dy = y - player.pos.y;
			var unitspeed = this.stepbrowser * this.speedrate;
			if (ig.input.mouse.y < 450 && ig.input.mouse.y > 20)
			{
				player.destX = dx - 16;
				player.destY = dy - 32;
				dx = player.destX;
				dy = player.destY;
				
				//this.touchX = unitspeed * this.speedrate;
				//this.touchY = unitspeed * Math.abs(player.destY/player.destX) * this.speedrate;
				
				
				this.touchX = Math.abs(dx * unitspeed /Math.sqrt(dy * dy + dx * dx));
				this.touchY = Math.abs(dy * unitspeed /Math.sqrt(dy * dy + dx * dx));
			

    			if (player.cp == 1)
    			{
    				this.cp = 0;
    				this.stepbrowser = 6;
    				this.islanding = 0;
    				player.currentAnim = player.anims.shoot;
    				player.isShooting = 1;
    			}
			}
		}
	}
	
});
fpsIPhone = 60;
fpsPC = 10;
	

adManager.init();
	
if (ig.ua.iPhone||ig.ua.android)
{
	window.scrollTo(0,1);
	ig.main('#canvas', MyGame, fpsIPhone, 320, 480, 1);
}
else if (ig.ua.iPad)
{
	window.scrollTo(0,1);
	ig.main('#canvas', MyGame, fpsIPhone, 320, 480, 2);
}
else{
	ig.main('#canvas', MyGame, fpsPC, 320, 480, 1 );
}


});