ig.module(
	'game_ipad.entities.bullet1'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
bullet1 = ig.Entity.extend({
	size: {x: 11, y: 15},
	speed: 5,
	type: ig.Entity.TYPE.NONE,
	checkAgainst: ig.Entity.TYPE.A, // Check Against B - our evil enemy group
	collides: ig.Entity.COLLIDES.PASSIVE, 
		
	animSheet: new ig.AnimationSheet( 'media_ipad/bullet.png', 22, 30 ),
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		this.addAnim( 'shoot', 0.5, [0] );
		this.speed = 5 * ig.game.speedrate;
	},
	update: function() {
		this.pos.y += this.speed;			
		this.pos.x -= this.speed;			
		if (this.pos.y > ig.game.screen.y + ig.system.height)
		{
			this.kill();
		}
		this.parent();

	},
	
	// This function is called when this entity overlaps anonther entity of the
	// checkAgainst group. I.e. for this entity, all entities in the B group.
		
	check: function( other ) {
		
		if (other.tp == 'player')
		{
			other.receiveDamage(10,this);
			this.kill();
		}
	}
})	
});	