ig.module(
	'game_ipad.entities.cannon_water'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
Cannon_Water = ig.Entity.extend({
	size: {x: 16, y: 16},
	type: ig.Entity.TYPE.B, // Evil enemy group
	checkAgainst: ig.Entity.TYPE.A, // Check against friendly
	collides: ig.Entity.COLLIDES.PASSIVE,
	health: 10,
	speed: 20,
	timing: 0,
	visible: 0,
	timebullet: 0,
	tp: 'Cannon_Water',
	animSheet: new ig.AnimationSheet( 'media_ipad/gatling_cannon_water.png', 32, 32 ),
	
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
//		this.addAnim( 'cannon_ground', 5, [0,1,2,3] );
		this.addAnim('one', 1, [0]);
		this.addAnim('two', 1, [1]);
		this.addAnim('three', 1, [2]);
		this.addAnim('four', 1, [3]);
		this.addAnim('five', 1, [1]);
	},
	
	
	update: function() {
		if (this.pos.y > ig.game.screen.y)
		{
			this.timing ++;
		switch (this.timing)
		{
		case 1: 
			this.currentAnim = this.anims.one;
			this.visible = 0;
			break;
		case 31:
			this.currentAnim = this.anims.two;
			this.visible = 0;
			break;
		case 61:
			this.currentAnim = this.anims.three;
			this.visible = 1;
			break;
		case 71:
			this.currentAnim = this.anims.four;
			this.visible = 1;
			break;
		case 161:
			this.currentAnim = this.anims.five;
			break;
		case 190:
			this.timing = 0;
			break;
		}
		if (this.timing > 71 && this.timing < 161)
		{
			this.timebullet ++;
			
			if (this.timebullet == 13)
			{
				ig.game.spawnEntity( bullet, this.pos.x, this.pos.y);
				ig.game.spawnEntity( bullet, this.pos.x+10, this.pos.y);
			}
			if (this.timebullet == 26)
			{
				this.timebullet = 0;
			}
		}
		}
		if (this.pos.y > ig.game.screen.y + ig.system.height)
		{
			this.kill();
		}

		this.parent();
	},
	
	
});



});