ig.module(
	'game_ipad.entities.energy'
)
.requires(
	'impact.entity'
)
.defines(function(){


EnergyStatus = ig.Entity.extend({
	
	type: ig.Entity.TYPE.NONE,
	checkAgainst: ig.Entity.TYPE.NONE, 
	animSheet: new ig.AnimationSheet( 'media_ipad/energy.png', 26, 24),
	health: 6,
	init: function( x, y, settings ) {
		this.parent( x, y, settings );

		this.addAnim( 'status6', 2, [0] );
		this.addAnim( 'status5', 2, [1] );
		this.addAnim( 'status4', 2, [2] );
		this.addAnim( 'status3', 2, [3] );
		this.addAnim( 'status2', 2, [4] );
		this.addAnim( 'status1', 2, [5] );
		this.addAnim( 'status0', 2, [6] );
		
	},
	
	update: function()
	{
		switch (this.health)
		{
		case 0:
			this.currentAnim = this.anims.status6;
			break;
		case 1:
			this.currentAnim = this.anims.status5;
			break;
		case 2:
			this.currentAnim = this.anims.status4;
			break;
		case 3:
			this.currentAnim = this.anims.status3;
			break;
		case 4:
			this.currentAnim = this.anims.status2;
			break;
		case 5:
			this.currentAnim = this.anims.status1;
			break;
		case 6:
			this.currentAnim = this.anims.status0;
			break;
		}
	this.parent();

	}

});

});