ig.module(
	'game_ipad.entities.plane_5'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
Plane_5 = ig.Entity.extend({
	size: {x: 18, y: 20},

	type: ig.Entity.TYPE.B, // Evil enemy group
	checkAgainst: ig.Entity.TYPE.A, // Check against friendly
	collides: ig.Entity.COLLIDES.PASSIVE,
	timebullet: 0,
	health: 10,
	speed: 1,
	tp: 'plane5',
	animSheet: new ig.AnimationSheet( 'media_ipad/enemyplane5.png', 36, 40 ),
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		this.addAnim( 'enemyplane5', 0.08, [0] );
        this.speed = 1 * ig.game.speedrate;
	},
	
	
	update: function() {
		if (this.pos.y > ig.game.screen.y )
		{
			this.timebullet ++;
			if (this.timebullet == 9)
			{
				ig.game.spawnEntity( bullet, this.pos.x, this.pos.y);
			}
			if (this.timebullet == 18)
			{
				this.timebullet = 0;
			}
			this.pos.x +=this.speed;
			this.pos.y +=this.speed;
		}

		if (this.pos.y > ig.game.screen.y + ig.system.height)
		{
			this.kill();
		}
		this.parent();
	},
	
	
});

});