ig.module(

	'game_ipad.entities.player'
)
.requires(
	'impact.entity',
	'impact.timer'
)
.defines(function(){

EntityPlayer = ig.Entity.extend({
	
	// The players (collision) size is a bit smaller than the animation
	// frames, so we have to move the collision box a bit (offset)
	size: {x: 64, y: 64},
	tp: 'player',	
	type: ig.Entity.TYPE.A, // Player friendly group
	checkAgainst: ig.Entity.TYPE.B,
	collides: ig.Entity.COLLIDES.PASSIVE,	
	animSheet: new ig.AnimationSheet( 'media_ipad/plane.png', 70, 64 ),
    isShooting: 1,
	health: 300,
	cp: 0,
	timer: new ig.Timer(),
	timebullet: 0,
    fuel: 600,
    destX: 0,
    destY: 0,
    screenratex:2.1875,
	screenratey:2.136,
	shooting: 2,
//-------------------------------------------------------------------------------------------------------------------------
	init: function( x, y, settings ) {
		
		this.isKill = false;
		this.addAnim( 'shoot', 0.07, [1] );
		this.addAnim('landing',1,[6]);
		this.pos.y = y;
		this.pos.x = x;
		this.zIndex = 5;
		this.parent( x, y, settings );
	},
//-------------------------------------------------------------------------------------------------------------------------
	update: function() {
		var arrX1 = new Array();
		arrX1[2] = 176*this.screenratex;		arrX1[6] = 88*this.screenratex;	
		arrX1[3] = 110*this.screenratex;		arrX1[7] = 44*this.screenratex;	
		arrX1[4] = 22*this.screenratex;			arrX1[8] = 88*this.screenratex;	
		arrX1[5] = 88*this.screenratex;			arrX1[9] = 88*this.screenratex;	
		arrX1[10] = 88*this.screenratex;	
		
		var arrX2 = new Array();
		arrX2[2] = 220*this.screenratex;		arrX2[7] = 110*this.screenratex;	
		arrX2[3] = 176*this.screenratex;		arrX2[8] = 132*this.screenratex;	
		arrX2[4] = 88*this.screenratex;			arrX2[9] = 132*this.screenratex;	
		arrX2[5] = 154*this.screenratex;		arrX2[10] = 132*this.screenratex;	
		arrX2[6] = 154*this.screenratex;	

		var arrY1 = new Array();
		arrY1[2] = 1672*this.screenratey;		arrY1[7] = 1100*this.screenratey;
		arrY1[3] = 748*this.screenratey;		arrY1[8] = 1100*this.screenratey;
		arrY1[4] = 176*this.screenratey;		arrY1[9] = 1122*this.screenratey;
		arrY1[5] = 330*this.screenratey;		arrY1[10] = 462*this.screenratey;
		arrY1[6] = 1364*this.screenratey; 

		var arrY2 = new Array();
		arrY2[2] = 1848*this.screenratey;		arrY2[7] = 1342*this.screenratey;
		arrY2[3] = 946*this.screenratey;		arrY2[8] = 1254*this.screenratey;
		arrY2[4] = 396*this.screenratey;		arrY2[9] = 1254*this.screenratey;
		arrY2[5] = 550*this.screenratey;		arrY2[10] = 704*this.screenratey;
		arrY2[6] = 1584*this.screenratey; 

		if(this.isKill) {
			if(this.timer.delta() > 0) {
				this.kill();
			} else {
				this.parent();
			}
			return;
		}
		
		if (this.fuel == 0)
			this.kill();


		
		if (Math.abs(this.destX) > 0){
			if (Math.abs(this.destX) < ig.game.touchX){
				this.pos.x += this.destX;
				ig.game.touchX = 0;
				this.destX = 0;
			}
			else{
				this.pos.x += ig.game.touchX  * (this.destX > 0 ? 1 : -1);
				this.destX += ig.game.touchX  * (this.destX > 0 ? -1 : 1);
			}
		}
		
		if (Math.abs(this.destY) > 0){
		
			if (Math.abs(this.destY) < ig.game.touchY){
				this.pos.y += this.destY;
				ig.game.touchY = 0;
				this.destY = 0;
			}
			else{
				
				this.pos.y += ig.game.touchY  * (this.destY > 0 ? 1 : -1);
				this.destY += ig.game.touchY  * (this.destY > 0 ? -1 : 1);
			}
			//alert(this.destY + " : " + this.pos.y);
		}
		



		if(this.pos.x < 0)
		{
			this.pos.x = 0;
		}
		if(this.pos.x + 32 > ig.system.width)
		{
			this.pos.x = ig.system.width-32;
		}
		if (this.pos.y < ig.game.screen.y+5)
		{
			this.pos.y = ig.game.screen.y+5;
		}
	
		if( ig.input.pressed('land')) {
			if (ig.game.level == 1)
			{							
			
				if (ig.game.screen.y + ig.input.mouse.y < 830*this.screenratey &&
						ig.game.screen.y + ig.input.mouse.y > 654*this.screenratey && ig.input.mouse.x > 176*this.screenratex && ig.input.mouse.x < 220*this.screenratex)
				{

					if (this.pos.x < 170*this.screenratex-(this.size.x/4) || this.pos.x > 230*this.screenratex+(this.size.x/4) || this.pos.y >838*this.screenratey+(this.size.x/4) || this.pos.y < 646*this.screenratey-(this.size.x/4))
					{
						this.kill();
					}
					if (this.pos.x > 170*this.screenratex-(this.size.x/4) && this.pos.x < 230*this.screenratex+(this.size.x/4) && this.pos.y <838*this.screenratey+(this.size.x/4) && this.pos.y > 646*this.screenratey-(this.size.x/4) )
					{
						this.health = 300;
						this.isShooting = 0;
						this.cp = 1;
						ig.game.stepbrowser = 0;
						ig.game.islanding = 1;
						this.currentAnim = this.anims.landing;
						this.fuel = 600;
					}
					
				}
				if (ig.game.screen.y + ig.input.mouse.y < 1738*this.screenratey && 
						ig.game.screen.y + ig.input.mouse.y > 1694*this.screenratey )
				{
					if ( this.pos.y >1746*this.screenratey || this.pos.y < 1686*this.screenratey)
						this.kill();
					if ( this.pos.y <1746*this.screenratey && this.pos.y > 1686*this.screenratey)
					{
						this.health = 300;
						this.isShooting = 0;
						this.cp = 1;
						ig.game.stepbrowser = 0;
						ig.game.islanding = 1;
						this.currentAnim = this.anims.landing;
						this.fuel = 600;
					}
					
				}
			}
			else
			{
				if (ig.game.screen.y + ig.input.mouse.y <arrY2[ig.game.level]  && 
						ig.game.screen.y + ig.input.mouse.y > arrY1[ig.game.level] && ig.input.mouse.x > arrX1[ig.game.level] && ig.input.mouse.x < arrX2[ig.game.level])
				{
					
					if (this.pos.x < arrX1[ig.game.level]-(this.size.x/4) || this.pos.x > arrX2[ig.game.level]+(this.size.x/4) || this.pos.y >arrY2[ig.game.level]+(this.size.x/4) || this.pos.y < arrY1[ig.game.level]-(this.size.x/4))
					{
						this.kill();
					}
					if (this.pos.x > arrX1[ig.game.level]-(this.size.x/4) && this.pos.x < arrX2[ig.game.level]+(this.size.x/4) && this.pos.y <arrY2[ig.game.level]+(this.size.x/4) && this.pos.y > arrY1[ig.game.level]-(this.size.x/4) )
					{
						this.health = 300;
						this.isShooting = 0;
						this.cp = 1;
						ig.game.stepbrowser = 0;
						ig.game.islanding = 1;
						this.currentAnim = this.anims.landing;
						this.fuel = 600;
					}
					
				}

			}

		}
		
	if (this.isShooting == 1)
		{
		
		if (ig.game.numpowers < 17)
		{
		
			if (ig.game.numpowers % 4 == 3 )//&& ig.game.numpowers < 17)
			{

				this.timebullet ++;
				if (this.timebullet == this.shooting)
				{
					ig.game.spawnEntity( EntitySlimeGrenade, this.pos.x, this.pos.y, {flip:this.flip} );
					ig.game.spawnEntity( EntitySlimeGrenade, this.pos.x+40, this.pos.y, {flip:this.flip} );
				}
				if (this.timebullet >= this.shooting*2)
					this.timebullet = 0;
			}
			if (ig.game.numpowers % 4 == 2 )//&& ig.game.numpowers % 4 != 0)// && ig.game.numpowers < 17)
			{
				this.timebullet ++;
				if (this.timebullet == this.shooting/2 )
				{
					ig.game.spawnEntity( EntitySlimeGrenade, this.pos.x+16, this.pos.y, {flip:this.flip} );
				}
				if (this.timebullet >= this.shooting)
				{
					this.timebullet = 0;
				}
			}
			if (ig.game.numpowers % 4 == 0)
			{	
				this.timebullet ++;
				if (this.timebullet == this.shooting/2)
				{
					ig.game.spawnEntity( EntitySlimeGrenade, this.pos.x, this.pos.y, {flip:this.flip} );
					ig.game.spawnEntity( EntitySlimeGrenade, this.pos.x+40, this.pos.y, {flip:this.flip} );
				}
				if (this.timebullet >= this.shooting)
				{
					this.timebullet=0;
				}
			}
			if (ig.game.numpowers % 4 == 1)
			{
				this.timebullet ++;
				if (this.timebullet == this.shooting)
				{
					ig.game.spawnEntity( EntitySlimeGrenade, this.pos.x+16, this.pos.y, {flip:this.flip} );
				}
				if (this.timebullet >= this.shooting*2)
				{
					this.timebullet=0;
				}
			}

		}
		
		if (ig.game.numpowers >= 17)
		{
			this.timebullet ++;
			if (ig.game.numpowers == 17)
			{
				if (this.timebullet == this.shooting)
				{
					ig.game.spawnEntity( leftbullet, this.pos.x-4, this.pos.y, {flip:this.flip} );
					ig.game.spawnEntity( EntitySlimeGrenade, this.pos.x+7, this.pos.y, {flip:this.flip} );
					ig.game.spawnEntity( EntitySlimeGrenade, this.pos.x+21, this.pos.y, {flip:this.flip} );
					ig.game.spawnEntity( rightbullet, this.pos.x+29, this.pos.y, {flip:this.flip} );
				}

			}
			if (ig.game.numpowers == 18)
			{
				if (this.timebullet == this.shooting/2)
				{
					ig.game.spawnEntity( leftbullet, this.pos.x-2, this.pos.y, {flip:this.flip} );
					ig.game.spawnEntity( EntitySlimeGrenade, this.pos.x+13, this.pos.y, {flip:this.flip} );
					ig.game.spawnEntity( rightbullet, this.pos.x+25, this.pos.y, {flip:this.flip} );
				}

			}
			if (this.timebullet >= this.shooting)
			{
				this.timebullet = 0;
			}			

		}
		}
	
		
		//this.currentAnim = this.anims.shoot;
		
		this.parent();
		
	},
//-------------------------------------------------------------------------------------------------------------------------
	kill: function() {
		if (ig.game.islanding == 1 )
		{


			ig.game.islanding = 0;
			ig.game.stepbrowser = 6;
			this.cp = 0;
			this.isShooting = 1;

   		}
		if(this.isKill == false) {

			ig.game.player_pos_x = this.pos.x;
			this.isKill = true;
			this.vel.x = 0;
			this.vel.y = 0;
			this.accel.x = 0;
			this.currentAnim = this.anims.die;
			this.timer.set(1);
			ig.game.numpowers = 1;
			ig.game.spawnEntity( explosion, this.pos.x, this.pos.y );
			ig.game.click = 0;

		} else {
			
			if(this.timer.delta() > 0) 
			{
				this.parent();				
			}
			
		}
	},

	check: function( other ) {
		if (other.tp =='plane1' || other.tp =='plane2' || other.tp =='plane3' || other.tp =='plane4' || other.tp =='bossplane' )
		{
			this.health -= 10;
			if (this.health <=0)
			{
				this.isKill= true;
			}
		}
	},
});



EntitySlimeGrenade = ig.Entity.extend({
	speed: 15,
	type: ig.Entity.TYPE.NONE,
	checkAgainst: ig.Entity.TYPE.B, // Check Against B - our evil enemy group
	collides: ig.Entity.COLLIDES.PASSIVE, 
	animSheet: new ig.AnimationSheet( 'media_ipad/bullet.png', 22, 30 ),
	
	init: function( x, y, settings ) {
		this.addAnim( 'b1', 1, [1] );
		this.addAnim( 'b2', 1, [3] );
		this.addAnim( 'b3', 1, [4] );
		this.addAnim( 'b4', 1, [6] );
			
		
		if (ig.game.numpowers >=1 && ig.game.numpowers <= 4)
		{
			this.currentAnim = this.anims.b1;
		}
		if (ig.game.numpowers >=5 && ig.game.numpowers <= 8)
		{
			this.currentAnim = this.anims.b2;
		}
		if (ig.game.numpowers >=9 && ig.game.numpowers <= 12)
		{
			this.currentAnim = this.anims.b3;
		}
		if (ig.game.numpowers >=13 && ig.game.numpowers <= 16)
		{
			this.currentAnim = this.anims.b4;
		}
		if (ig.game.numpowers == 17)
		{
			this.currentAnim = this.anims.b1;
		}
		if (ig.game.numpowers == 18)
		{
			this.currentAnim = this.anims.b4;
		}
		this.parent( x, y, settings );

        this.speed = 10 * ig.game.speedrate;
	
	},
	update: function() {
		this.pos.y -= this.speed;
		if (this.pos.y < ig.game.screen.y)
		{
			this.kill();
		}
		this.parent();
	},
		
	check: function( other ) {
		this.timing ++;
		

		if (other.tp == 'Cannon_Water')
		{
			if (other.visible == 1)
			{
				other.receiveDamage( 10, this );
				ig.game.spawnEntity( star, other.pos.x, other.pos.y);
			}
	
		}
		else {
			if (ig.game.numpowers >=1 && ig.game.numpowers <= 4)
				other.receiveDamage( 10, this );
			if (ig.game.numpowers >=5 && ig.game.numpowers <= 8)
				other.receiveDamage( 20, this );
			if (ig.game.numpowers >=9 && ig.game.numpowers <= 12)
				other.receiveDamage( 30, this );
			if (ig.game.numpowers >=13 && ig.game.numpowers <= 16)
				other.receiveDamage( 40, this );
			if (ig.game.numpowers == 17)
				other.receiveDamage( 10, this );
			if(ig.game.numpowers > 17)
				other.receiveDamage( 50, this ); 
						
			
			if (other.tp == 'plane1' )
			{
				ig.game.spawnEntity( power, other.pos.x, other.pos.y);
			}
			if (other.tp == 'bossplane' && other.health == 0)
			{
				ig.game.spawnEntity( power, other.pos.x, other.pos.y);
			}
			if (other.tp == 'gatlingcannon' || other.tp == 'tower' )
			{
				ig.game.spawnEntity( hostage, other.pos.x, other.pos.y);
			}

			if (other.tp == 'tank2' || other.tp == 'plane2' || other.tp == 'barrel' || other.tp == 'building1')
			{
				ig.game.spawnEntity( energy, other.pos.x, other.pos.y);
			}

			if (other.tp == 'cannon' || other.tp == 'tank1' || other.tp == 'tank3' || other.tp == 'plane3'|| other.tp == 'plane4')
			{
				ig.game.spawnEntity( star, other.pos.x, other.pos.y);
			}
		}
		if ( other.health <= 0)
		{
			ig.game.spawnEntity( explosion, other.pos.x, other.pos.y);
			if (other.tp == 'cannon' || other.tp == 'building1')
			{
				ig.game.score += 100;
			}
			if (other.tp == 'Cannon_Water' || other.tp == 'gatlingcannon')// ep3,4,5
			{			
				ig.game.score += 150;
			}
			if (other.tp == 'plane1')
			{
				ig.game.score += 200;
			}
			if (other.tp == 'tower')	//hostage
			{
				ig.game.score += 1250;
			}
			if (other.tp == 'plane2') 
			{
				ig.game.score += 250;
			}
			if (other.tp == 'tank1' || other.tp == "tank2")
			{
				ig.game.score += 1300;
			}
			if (other.tp == 'tank3')
			{
				ig.game.score += 1500;
			}
			if (other.tp == 'bossplane')
			{
				if (ig.game.level == 10)
				{
					ig.game.score += 3000;
					ig.game.bossflag ++;
				}
				else{
					ig.game.score += 3000;
					ig.game.bossflag = 1;
				}
			}
		}
		this.kill();
	
	}
	
});	

leftbullet = ig.Entity.extend({
	speed: 10,

	type: ig.Entity.TYPE.NONE,
	checkAgainst: ig.Entity.TYPE.B, // Check Against B - our evil enemy group
	collides: ig.Entity.COLLIDES.PASSIVE, 
		
	animSheet: new ig.AnimationSheet( 'media_ipad/bullet.png', 22, 30 ),
	
	init: function( x, y, settings ) {
		this.addAnim( 'b5', 1, [0] );
		//this.addAnim( 'b6', 1, [2] );
		this.addAnim( 'b7', 1, [5] );
		//this.addAnim( 'b8', 1, [7] );
		switch (ig.game.numpowers)
		{
		case 17:
			this.currentAnim = this.anims.b5;
			break;
		
		case 18:
			this.currentAnim = this.anims.b7;
			break;
		}
		this.parent( x, y, settings );
	    this.speed = 10*ig.game.speedrate;
	},
	update: function() {
		this.pos.x -= this.speed / 4;
		this.pos.y -= this.speed;
		if (this.pos.y < ig.game.screen.y)
		{
			this.kill();
		}
		this.parent();
	},
		
	check: function( other ) {
		this.timing ++;
		

		if (other.tp == 'Cannon_Water')
		{
			if (other.visible == 1)
			{
				other.receiveDamage( 10, this );
				ig.game.spawnEntity( star, other.pos.x, other.pos.y);
			}
	
		}
		else {
			other.receiveDamage( 10, this );
			if (other.tp == 'plane1' )
			{
				ig.game.spawnEntity( power, other.pos.x, other.pos.y);
			}
			if (other.tp == 'bossplane' && other.health == 0)
			{
				ig.game.spawnEntity( power, other.pos.x, other.pos.y);
			}
			if (other.tp == 'gatlingcannon' || other.tp == 'tower' )
			{
				ig.game.spawnEntity( hostage, other.pos.x, other.pos.y);
			}

			if (other.tp == 'tank2' || other.tp == 'plane2' || other.tp == 'barrel' || other.tp == 'building1')
			{
				ig.game.spawnEntity( energy, other.pos.x, other.pos.y);
			}

			if (other.tp == 'cannon' || other.tp == 'tank1' || other.tp == 'tank3' || other.tp == 'Plane4'|| other.tp == 'Plane3')
			{
				ig.game.spawnEntity( star, other.pos.x, other.pos.y);
			}
		}
		if ( other.health <= 0)
		{
			ig.game.spawnEntity( explosion, other.pos.x, other.pos.y);
			if (other.tp == 'cannon' || other.tp == 'building1')
			{
				ig.game.score += 100;
			}
			if (other.tp == 'Cannon_Water' || other.tp == 'gatlingcannon')// ep3,4,5
			{			
				ig.game.score += 150;
			}
			if (other.tp == 'plane1')
			{
				ig.game.score += 200;
			}
			if (other.tp == 'tower')	//hostage
			{
				ig.game.score += 1250;
			}
			if (other.tp == 'plane2') 
			{
				ig.game.score += 250;
			}
			if (other.tp == 'tank1' || other.tp == "tank2")
			{
				ig.game.score += 1300;
			}
			if (other.tp == 'tank3')
			{
				ig.game.score += 1500;
			}
			if (other.tp == 'bossplane')
			{
				if (ig.game.level == 10)
				{
					ig.game.score += 3000;
					ig.game.bossflag ++;
				}
				else{
					ig.game.score += 3000;
					ig.game.bossflag = 1;
				}
			}
		}
		this.kill();
	
	}
	
});	

rightbullet = ig.Entity.extend({
	speed: 10,

	type: ig.Entity.TYPE.NONE,
	checkAgainst: ig.Entity.TYPE.B, // Check Against B - our evil enemy group
	collides: ig.Entity.COLLIDES.PASSIVE, 
		
	animSheet: new ig.AnimationSheet( 'media_ipad/bullet.png', 22, 30 ),
	
	init: function( x, y, settings ) {
		//this.addAnim( 'b5', 1, [0] );
		this.addAnim( 'b6', 1, [2] );
		//this.addAnim( 'b7', 1, [5] );
		this.addAnim( 'b8', 1, [7] );
		switch (ig.game.numpowers)
		{
		case 17:
			this.currentAnim = this.anims.b6;
			break;
		case 18:
			this.currentAnim = this.anims.b8;
			break;
		}
		this.parent( x, y, settings );
	    this.speed = 10*ig.game.speedrate;
	},
	update: function() {
		this.pos.x += this.speed / 4;
		this.pos.y -= this.speed;
		if (this.pos.y < ig.game.screen.y){
			this.kill();
		}
		this.parent();
	},
		
	check: function( other ) {
		this.timing ++;
		

		if (other.tp == 'Cannon_Water')
		{
			if (other.visible == 1)
			{
				other.receiveDamage( 10, this );
				ig.game.spawnEntity( star, other.pos.x, other.pos.y);
			}
	
		}
		else {
			other.receiveDamage( 10, this );
			if (other.tp == 'plane1' )
			{
				ig.game.spawnEntity( power, other.pos.x, other.pos.y);
			}
			if (other.tp == 'bossplane' && other.health == 0)
			{
				ig.game.spawnEntity( power, other.pos.x, other.pos.y);
			}
			if (other.tp == 'gatlingcannon' || other.tp == 'tower' )
			{
				ig.game.spawnEntity( hostage, other.pos.x, other.pos.y);
			}

			if (other.tp == 'tank2' || other.tp == 'plane2' || other.tp == 'barrel' || other.tp == 'building1')
			{
				ig.game.spawnEntity( energy, other.pos.x, other.pos.y);
			}

			if (other.tp == 'cannon' || other.tp == 'tank1' || other.tp == 'tank3' || other.tp == 'Plane4'|| other.tp == 'Plane3')
			{
				ig.game.spawnEntity( star, other.pos.x, other.pos.y);
			}
		}
		if ( other.health <= 0)
		{
			ig.game.spawnEntity( explosion, other.pos.x, other.pos.y);
			if (other.tp == 'cannon' || other.tp == 'building1')
			{
				ig.game.score += 100;
			}
			if (other.tp == 'Cannon_Water' || other.tp == 'gatlingcannon')// ep3,4,5
			{			
				ig.game.score += 150;
			}
			if (other.tp == 'plane1')
			{
				ig.game.score += 200;
			}
			if (other.tp == 'tower')	//hostage
			{
				ig.game.score += 1250;
			}
			if (other.tp == 'plane2') 
			{
				ig.game.score += 250;
			}
			if (other.tp == 'tank1' || other.tp == "tank2")
			{
				ig.game.score += 1300;
			}
			if (other.tp == 'tank3')
			{
				ig.game.score += 1500;
			}
			if (other.tp == 'bossplane')
			{
				if (ig.game.level == 10)
				{
					ig.game.score += 3000;
					ig.game.bossflag ++;
				}
				else{
					ig.game.score += 3000;
					ig.game.bossflag = 1;
				}
			}
		}
		this.kill();
	
	}
	
});	

star = ig.Entity.extend({
	
	type: ig.Entity.TYPE.NONE,
	checkAgainst: ig.Entity.TYPE.A, 
	animSheet: new ig.AnimationSheet( 'media_ipad/star.png', 20, 18 ),
	timing: 0,

	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		this.addAnim( 'idle', 2, [0] );
	},

	check: function( other )
	 {
		
		if (other.tp == 'player')
			{
				ig.game.numstars++;
				this.kill();
				
			}
	}
});

energy = ig.Entity.extend({
	
	type: ig.Entity.TYPE.NONE,
	checkAgainst: ig.Entity.TYPE.A, 
	animSheet: new ig.AnimationSheet( 'media_ipad/energy_bonus.png', 34, 18 ),
		
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		this.addAnim( 'idle', 2, [0] );
	},
	check: function( other )
	 {
		
		if (other.tp == 'player')
			{
				other.health += 20;
				this.kill();
			}
	}
});

hostage = ig.Entity.extend({
	
	type: ig.Entity.TYPE.NONE,
	checkAgainst: ig.Entity.TYPE.A, 
	animSheet: new ig.AnimationSheet( 'media_ipad/hostage.png', 18, 24 ),
		
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		this.addAnim( 'idle', 2, [0] );
	},
	check: function( other )
	 {
		
		if (other.tp == 'player')
			{
				ig.game.numhostages++;
				this.kill();
			}
	}
});

power = ig.Entity.extend({
	
	type: ig.Entity.TYPE.NONE,
	checkAgainst: ig.Entity.TYPE.A, 
	animSheet: new ig.AnimationSheet( 'media_ipad/power.png', 40, 22 ),
		
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		this.addAnim( 'idle', 2, [0] );
	},
	check: function( other )
	 {
		
		if (other.tp == 'player')
			{
				if (ig.game.numpowers < 18)
				{
					ig.game.numpowers++;
				}
				this.kill();
			}
	}
});

explosion = ig.Entity.extend({
	
	type: ig.Entity.TYPE.NONE,
	checkAgainst: ig.Entity.TYPE.NONE, 
	animSheet: new ig.AnimationSheet( 'media_ipad/explosion.png', 48, 48 ),
	timing: 0,
	init: function( x, y, settings ) {
		this.parent( x, y, settings );

		this.addAnim( 'run0', 2, [0] );
		this.addAnim( 'run1', 2, [1] );
		this.addAnim( 'run2', 2, [2] );
		this.addAnim( 'run3', 2, [3] );
		this.addAnim( 'run4', 2, [4] );
		this.addAnim( 'run5', 2, [5] );
		this.addAnim( 'run6', 2, [6] );
		this.addAnim( 'run7', 2, [7] );
		this.addAnim( 'run8', 2, [8] );
		this.addAnim( 'run9', 2, [9] );
	},
	
	update: function()
	{
		this.timing ++;
		switch (this.timing)
		{
		case 1:
			this.currentAnim = this.anims.run0;
			break;
		case 2:
			this.currentAnim = this.anims.run1;
			break;
		case 3:
			this.currentAnim = this.anims.run2;
			break;
		case 4:
			this.currentAnim = this.anims.run3;
			break;
		case 5:
			this.currentAnim = this.anims.run4;
			break;
		case 6:
			this.currentAnim = this.anims.run5;
			break;
		case 7:
			this.currentAnim = this.anims.run6;
			break;
		case 8:
			this.currentAnim = this.anims.run7;
			break;
		case 9:
			this.currentAnim = this.anims.run8;
			break;
		case 10:
			this.kill();
			break;
		}
	this.parent();

	}

});

});

