ig.module(
	'game_ipad.entities.tank_2'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
Tank_2 = ig.Entity.extend({
	size: {x: 16, y: 33},
	type: ig.Entity.TYPE.B, // Evil enemy group
	checkAgainst: ig.Entity.TYPE.A, // Check against friendly
	collides: ig.Entity.COLLIDES.PASSIVE,
	desty: 0,
	health: 10,
	timebullet: 0,
	tp: 'tank2',
	animSheet: new ig.AnimationSheet( 'media_ipad/tank2.png', 32, 66 ),
	
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		this.addAnim( 'run', 0.08, [0] );
		this.addAnim( 'stop', 0.08, [1] );
		this.desty=this.pos.y+43;

	},
	
	
	update: function() {
		if (this.pos.y > ig.game.screen.y)
		{
			this.timebullet ++;
			if (this.desty > this.pos.y)
			{
				this.pos.y++;		
			}
			else
				this.currentAnim=this.anims.stop;
			if (this.timebullet == 7)
			{
					ig.game.spawnEntity( bullet, this.pos.x+5, this.pos.y);
			}
			if (this.timebullet == 14)
			{
				this.timebullet = 0;
			}
		}
		if (this.pos.y > ig.game.screen.y + ig.system.height)
		{
			this.kill();
		}

		this.parent();
	},
	

});

});