if(!Function.prototype.bind){Function.prototype.bind=function(oThis){"use strict";if(typeof this!=="function"){throw new TypeError("Function.prototype.bind - what is trying to be bound is not callable")}var aArgs=Array.prototype.slice.call(arguments,1),fToBind=this,FNOP=function(){},fBound=function(){return fToBind.apply(this instanceof Function&&oThis?this:oThis,aArgs.concat(Array.prototype.slice.call(arguments)))};FNOP.prototype=this.prototype;fBound.prototype=new FNOP;return fBound}}if(!Array.prototype.find){Array.prototype.find=function(callback,thisObject){"use strict";var i,len,fct;if(typeof callback!=="function"){throw new TypeError}if(typeof thisObject==="undefined"){fct=callback}else{fct=function(){return callback.apply(thisObject,arguments)}}for(i=0,len=this.length;i<len;i++){if(fct(this[i],i,this)===true){return this[i]}}}}if(!Array.prototype.findIndex){Array.prototype.findIndex=function(callback,thisObject){"use strict";var i,len,fct;if(typeof callback!=="function"){throw new TypeError}if(typeof thisObject==="undefined"){fct=callback}else{fct=function(){return callback.apply(thisObject,arguments)}}for(i=0,len=this.length;i<len;i++){if(fct(this[i],i,this)===true){return i}}return-1}}if(typeof window.Float64Array==="undefined"){window.Float64Array={}}(function(global){function getPromise(builder){var promise;if(typeof builder==="function"){setTimeout(function(){try{builder(promise)}catch(e){promise.reject(e)}},0)}var consumers=[],success,result;function notifyConsumer(consumer){if(success){var nextValue;if(consumer.fulfilled){try{nextValue=[consumer.fulfilled.apply(null,result)]}catch(exc){consumer.promise.reject(exc);return}}else{nextValue=result}if(nextValue[0]&&typeof nextValue[0].then==="function"){nextValue[0].then(consumer.promise.fulfill,consumer.promise.reject)}else{consumer.promise.fulfill.apply(null,nextValue)}}else{if(consumer.rejected){var ret;try{ret=consumer.rejected.apply(null,result)}catch(exc){consumer.promise.reject(exc);return}if(ret&&typeof ret.then==="function"){ret.then(consumer.promise.fulfill,consumer.promise.reject)}else{consumer.promise.fulfill(ret)}}else{consumer.promise.reject.apply(null,result)}}}function resolve(succ,res){if(result){console.error("WARNING: Can't resolve promise, already resolved!");return}success=succ;result=Array.prototype.slice.call(res);setTimeout(function(){var cl=consumers.length;if(cl===0&&!success){console.error("Possibly uncaught error: ",result,result[0]&&result[0].stack)}for(var i=0;i<cl;i++){notifyConsumer(consumers[i])}consumers=undefined},0)}promise={then:function(fulfilled,rejected){var consumer={fulfilled:typeof fulfilled==="function"?fulfilled:undefined,rejected:typeof rejected==="function"?rejected:undefined,promise:getPromise()};if(result){setTimeout(function(){notifyConsumer(consumer)},0)}else{consumers.push(consumer)}return consumer.promise},fulfill:function(){resolve(true,arguments);return this},reject:function(){resolve(false,arguments);return this}};return promise}global.promising=getPromise})(typeof window!="undefined"?window:global);(function(global){function logError(error){if(typeof error==="string"){console.error(error)}else{console.error(error.message,error.stack)}}function emitUnauthorized(status){var args=Array.prototype.slice.call(arguments);if(status===403||status===401){this._emit("error",new RemoteStorage.Unauthorized)}var p=promising();return p.fulfill.apply(p,args)}function shareFirst(path){return this.backend==="dropbox"&&path.match(/^\/public\/.*[^\/]$/)}var SyncedGetPutDelete={get:function(path,maxAge){var self=this;if(this.local){return this.local.get(path,maxAge)}else{return this.remote.get(path)}},put:function(path,body,contentType){if(shareFirst.bind(this)(path)){return SyncedGetPutDelete._wrapBusyDone.call(this,this.remote.put(path,body,contentType))}else if(this.local){return this.local.put(path,body,contentType)}else{return SyncedGetPutDelete._wrapBusyDone.call(this,this.remote.put(path,body,contentType))}},delete:function(path){if(this.local){return this.local.delete(path)}else{return SyncedGetPutDelete._wrapBusyDone.call(this,this.remote.delete(path))}},_wrapBusyDone:function(result){var self=this;this._emit("wire-busy");return result.then(function(){var promise=promising();self._emit("wire-done",{success:true});return promise.fulfill.apply(promise,arguments)},function(err){self._emit("wire-done",{success:false});throw err})}};var RemoteStorage=function(){RemoteStorage.eventHandling(this,"ready","connected","disconnected","not-connected","conflict","error","features-loaded","connecting","authing","wire-busy","wire-done");this._pending=[];this._setGPD({get:this._pendingGPD("get"),put:this._pendingGPD("put"),delete:this._pendingGPD("delete")});this._cleanups=[];this._pathHandlers={change:{}};this.apiKeys={};if(this.localStorageAvailable()){try{this.apiKeys=JSON.parse(localStorage["remotestorage:api-keys"])}catch(exc){}this.setBackend(localStorage["remotestorage:backend"]||"remotestorage")}var origOn=this.on;this.on=function(eventName,handler){if(eventName==="ready"&&this.remote.connected&&this._allLoaded){setTimeout(handler,0)}else if(eventName==="features-loaded"&&this._allLoaded){setTimeout(handler,0)}return origOn.call(this,eventName,handler)};this._init();this.on("ready",function(){if(this.local){setTimeout(this.local.fireInitial.bind(this.local),0)}}.bind(this))};RemoteStorage.DiscoveryError=function(message){Error.apply(this,arguments);this.message=message};RemoteStorage.DiscoveryError.prototype=Object.create(Error.prototype);RemoteStorage.Unauthorized=function(){Error.apply(this,arguments)};RemoteStorage.Unauthorized.prototype=Object.create(Error.prototype);RemoteStorage.log=function(){if(RemoteStorage._log){console.log.apply(console,arguments)}};RemoteStorage.prototype={connect:function(userAddress){this.setBackend("remotestorage");if(userAddress.indexOf("@")<0){this._emit("error",new RemoteStorage.DiscoveryError("User adress doesn't contain an @."));return}this.remote.configure(userAddress);this._emit("connecting");var discoveryTimeout=setTimeout(function(){this._emit("error",new RemoteStorage.DiscoveryError("No storage information found at that user address."))}.bind(this),5e3);RemoteStorage.Discover(userAddress,function(href,storageApi,authURL){clearTimeout(discoveryTimeout);if(!href){this._emit("error",new RemoteStorage.DiscoveryError("Failed to contact storage server."));return}this._emit("authing");this.remote.configure(userAddress,href,storageApi);if(!this.remote.connected){this.authorize(authURL)}}.bind(this))},disconnect:function(){if(this.remote){this.remote.configure(null,null,null,null)}this._setGPD({get:this._pendingGPD("get"),put:this._pendingGPD("put"),delete:this._pendingGPD("delete")});var n=this._cleanups.length,i=0;var oneDone=function(){i++;if(i>=n){this._init();RemoteStorage.log("Done cleaning up, emitting disconnected and disconnect events");this._emit("disconnected")}}.bind(this);if(n>0){this._cleanups.forEach(function(cleanup){var cleanupResult=cleanup(this);if(typeof cleanup==="object"&&typeof cleanup.then==="function"){cleanupResult.then(oneDone)}else{oneDone()}}.bind(this))}else{oneDone()}},setBackend:function(what){this.backend=what;if(this.localStorageAvailable()){if(what){localStorage["remotestorage:backend"]=what}else{delete localStorage["remotestorage:backend"]}}},onChange:function(path,handler){if(!this._pathHandlers.change[path]){this._pathHandlers.change[path]=[]}this._pathHandlers.change[path].push(handler)},enableLog:function(){RemoteStorage._log=true},disableLog:function(){RemoteStorage._log=false},log:function(){RemoteStorage.log.apply(RemoteStorage,arguments)},setApiKeys:function(type,keys){if(keys){this.apiKeys[type]=keys}else{delete this.apiKeys[type]}if(this.localStorageAvailable()){localStorage["remotestorage:api-keys"]=JSON.stringify(this.apiKeys)}},_init:function(){var self=this,readyFired=false;function fireReady(){try{if(!readyFired){self._emit("ready");readyFired=true}}catch(e){console.error("'ready' failed: ",e,e.stack);self._emit("error",e)}}this._loadFeatures(function(features){this.log("[RemoteStorage] All features loaded");this.local=features.local&&new features.local;if(this.local&&this.remote){this._setGPD(SyncedGetPutDelete,this);this._bindChange(this.local)}else if(this.remote){this._setGPD(this.remote,this.remote)}if(this.remote){this.remote.on("connected",function(){fireReady();self._emit("connected")});this.remote.on("not-connected",function(){fireReady();self._emit("not-connected")});if(this.remote.connected){fireReady();self._emit("connected")}}this._collectCleanupFunctions();try{this._allLoaded=true;this._emit("features-loaded")}catch(exc){logError(exc);this._emit("error",exc)}this._processPending()}.bind(this))},_collectCleanupFunctions:function(){for(var i=0;i<this.features.length;i++){var cleanup=this.features[i].cleanup;if(typeof cleanup==="function"){this._cleanups.push(cleanup)}}},_loadFeatures:function(callback){var featureList=["WireClient","I18n","Dropbox","GoogleDrive","Access","Caching","Discover","Authorize","Widget","IndexedDB","LocalStorage","InMemoryStorage","Sync","BaseClient","Env"];var features=[];var featuresDone=0;var self=this;function featureDone(){featuresDone++;if(featuresDone===featureList.length){setTimeout(function(){features.caching=!!RemoteStorage.Caching;features.sync=!!RemoteStorage.Sync;["IndexedDB","LocalStorage","InMemoryStorage"].some(function(cachingLayer){if(features.some(function(feature){return feature.name===cachingLayer})){features.local=RemoteStorage[cachingLayer];return true}});self.features=features;callback(features)},0)}}function featureInitialized(name){self.log("[RemoteStorage] [FEATURE "+name+"] initialized.");features.push({name:name,init:RemoteStorage[name]._rs_init,supported:true,cleanup:RemoteStorage[name]._rs_cleanup});featureDone()}function featureFailed(name,err){self.log("[RemoteStorage] [FEATURE "+name+"] initialization failed ( "+err+")");featureDone()}function featureSupported(name,success){self.log("[RemoteStorage] [FEATURE "+name+"]"+success?"":" not"+" supported");if(!success){featureDone()}}function initFeature(name){var initResult;try{initResult=RemoteStorage[name]._rs_init(self)}catch(e){featureFailed(name,e);return}if(typeof initResult==="object"&&typeof initResult.then==="function"){initResult.then(function(){featureInitialized(name)},function(err){featureFailed(name,err)})}else{featureInitialized(name)}}featureList.forEach(function(featureName){self.log("[RemoteStorage] [FEATURE "+featureName+"] initializing...");var impl=RemoteStorage[featureName];var supported;if(impl){supported=!impl._rs_supported||impl._rs_supported();if(typeof supported==="object"){supported.then(function(){featureSupported(featureName,true);initFeature(featureName)},function(){featureSupported(featureName,false)})}else if(typeof supported==="boolean"){featureSupported(featureName,supported);if(supported){initFeature(featureName)}}}else{featureSupported(featureName,false)}})},localStorageAvailable:function(){try{return!!global.localStorage}catch(error){return false}},_setGPD:function(impl,context){function wrap(f){return function(){return f.apply(context,arguments).then(emitUnauthorized.bind(this))}}this.get=wrap(impl.get);this.put=wrap(impl.put);this.delete=wrap(impl.delete)},_pendingGPD:function(methodName){return function(){var promise=promising();this._pending.push({method:methodName,args:Array.prototype.slice.call(arguments),promise:promise});return promise}.bind(this)},_processPending:function(){this._pending.forEach(function(pending){try{this[pending.method].apply(this,pending.args).then(pending.promise.fulfill,pending.promise.reject)}catch(e){pending.promise.reject(e)}}.bind(this));this._pending=[]},_bindChange:function(object){object.on("change",this._dispatchEvent.bind(this,"change"))},_dispatchEvent:function(eventName,event){for(var path in this._pathHandlers[eventName]){var pl=path.length;var self=this;this._pathHandlers[eventName][path].forEach(function(handler){if(event.path.substr(0,pl)===path){var ev={};for(var key in event){ev[key]=event[key]}ev.relativePath=event.path.replace(new RegExp("^"+path),"");try{handler(ev)}catch(e){console.error("'change' handler failed: ",e,e.stack);self._emit("error",e)}}})}}};Object.defineProperty(RemoteStorage.prototype,"connected",{get:function(){return this.remote.connected}});global.RemoteStorage=RemoteStorage})(typeof window!=="undefined"?window:global);(function(global){var methods={addEventListener:function(eventName,handler){if(typeof eventName!=="string"){throw new Error("Argument eventName should be a string")}if(typeof handler!=="function"){throw new Error("Argument handler should be a function")}RemoteStorage.log("[Eventhandling] Adding event listener",eventName,handler);this._validateEvent(eventName);this._handlers[eventName].push(handler)},removeEventListener:function(eventName,handler){this._validateEvent(eventName);var hl=this._handlers[eventName].length;for(var i=0;i<hl;i++){if(this._handlers[eventName][i]===handler){this._handlers[eventName].splice(i,1);return}}},_emit:function(eventName){this._validateEvent(eventName);var args=Array.prototype.slice.call(arguments,1);this._handlers[eventName].forEach(function(handler){handler.apply(this,args)})},_validateEvent:function(eventName){if(!(eventName in this._handlers)){throw new Error("Unknown event: "+eventName)}},_delegateEvent:function(eventName,target){target.on(eventName,function(event){this._emit(eventName,event)}.bind(this))},_addEvent:function(eventName){this._handlers[eventName]=[]}};methods.on=methods.addEventListener;RemoteStorage.eventHandling=function(object){var eventNames=Array.prototype.slice.call(arguments,1);for(var key in methods){object[key]=methods[key]}object._handlers={};eventNames.forEach(function(eventName){object._addEvent(eventName)})}})(typeof window!=="undefined"?window:global);(function(global){var RS=RemoteStorage;var hasLocalStorage;var SETTINGS_KEY="remotestorage:wireclient";var API_2012=1,API_00=2,API_01=3,API_02=4,API_HEAD=5;var STORAGE_APIS={"draft-dejong-remotestorage-00":API_00,"draft-dejong-remotestorage-01":API_01,"draft-dejong-remotestorage-02":API_02,"https://www.w3.org/community/rww/wiki/read-write-web-00#simple":API_2012};var isArrayBufferView;if(typeof ArrayBufferView==="function"){isArrayBufferView=function(object){return object&&object instanceof ArrayBufferView}}else{var arrayBufferViews=[Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];isArrayBufferView=function(object){for(var i=0;i<8;i++){if(object instanceof arrayBufferViews[i]){return true}}return false}}function addQuotes(str){if(typeof str!=="string"){return str}if(str==="*"){return"*"}return'"'+str+'"'}function stripQuotes(str){if(typeof str!=="string"){return str}return str.replace(/^["']|["']$/g,"")}function readBinaryData(content,mimeType,callback){var blob=new Blob([content],{type:mimeType});var reader=new FileReader;reader.addEventListener("loadend",function(){callback(reader.result)});reader.readAsArrayBuffer(blob)}function cleanPath(path){return path.replace(/\/+/g,"/").split("/").map(encodeURIComponent).join("/")}function isFolder(path){return path.substr(-1)==="/"}function isFolderDescription(body){return body["@context"]==="http://remotestorage.io/spec/folder-description"&&typeof body["items"]==="object"}function isSuccessStatus(status){return[201,204,304].indexOf(status)>=0}function isErrorStatus(status){return[401,403,404,412].indexOf(status)>=0}var onErrorCb;RS.WireClient=function(rs){this.connected=false;RS.eventHandling(this,"change","connected","wire-busy","wire-done","not-connected");onErrorCb=function(error){if(error instanceof RemoteStorage.Unauthorized){this.configure(undefined,undefined,undefined,null)}}.bind(this);rs.on("error",onErrorCb);if(hasLocalStorage){var settings;try{settings=JSON.parse(localStorage[SETTINGS_KEY])}catch(e){}if(settings){setTimeout(function(){this.configure(settings.userAddress,settings.href,settings.storageApi,settings.token)}.bind(this),0)}}this._revisionCache={};if(this.connected){setTimeout(this._emit.bind(this),0,"connected")}};RS.WireClient.REQUEST_TIMEOUT=3e4;RS.WireClient.prototype={_request:function(method,uri,token,headers,body,getEtag,fakeRevision){if((method==="PUT"||method==="DELETE")&&uri[uri.length-1]==="/"){throw"Don't "+method+" on directories!"}var promise=promising();var revision;var reqType;var self=this;headers["Authorization"]="Bearer "+token;this._emit("wire-busy",{method:method,isFolder:isFolder(uri)});RS.WireClient.request(method,uri,{body:body,headers:headers},function(error,response){if(error){self._emit("wire-done",{method:method,isFolder:isFolder(uri),success:false});self.online=false;promise.reject(error)}else{self._emit("wire-done",{method:method,isFolder:isFolder(uri),success:true});self.online=true;if(isErrorStatus(response.status)){RemoteStorage.log("[WireClient] Error response status",response.status);if(getEtag){revision=stripQuotes(response.getResponseHeader("ETag"))}else{revision=undefined}promise.fulfill(response.status,undefined,undefined,revision)}else if(isSuccessStatus(response.status)||response.status===200&&method!=="GET"){revision=stripQuotes(response.getResponseHeader("ETag"));RemoteStorage.log("[WireClient] Successful request",revision);promise.fulfill(response.status,undefined,undefined,revision)}else{var mimeType=response.getResponseHeader("Content-Type");var body;if(getEtag){revision=stripQuotes(response.getResponseHeader("ETag"))}else{revision=response.status===200?fakeRevision:undefined}if(!mimeType||mimeType.match(/charset=binary/)){RS.WireClient.readBinaryData(response.response,mimeType,function(result){RemoteStorage.log("[WireClient] Successful request with unknown or binary mime-type",revision);promise.fulfill(response.status,result,mimeType,revision)})}else{if(mimeType&&mimeType.match(/^application\/json/)){body=JSON.parse(response.responseText)}else{body=response.responseText}RemoteStorage.log("[WireClient] Successful request",revision);promise.fulfill(response.status,body,mimeType,revision)}}}});return promise},configure:function(userAddress,href,storageApi,token){if(typeof userAddress!=="undefined"){this.userAddress=userAddress}if(typeof href!=="undefined"){this.href=href}if(typeof storageApi!=="undefined"){this.storageApi=storageApi}if(typeof token!=="undefined"){this.token=token}if(typeof this.storageApi!=="undefined"){this._storageApi=STORAGE_APIS[this.storageApi]||API_HEAD;this.supportsRevs=this._storageApi>=API_00}if(this.href&&this.token){this.connected=true;this.online=true;this._emit("connected")}else{this.connected=false}if(hasLocalStorage){localStorage[SETTINGS_KEY]=JSON.stringify({userAddress:this.userAddress,href:this.href,token:this.token,storageApi:this.storageApi})}RS.WireClient.configureHooks.forEach(function(hook){hook.call(this)}.bind(this))},stopWaitingForToken:function(){if(!this.connected){this._emit("not-connected")}},get:function(path,options){if(!this.connected){throw new Error("not connected (path: "+path+")")}if(!options){options={}}var headers={};if(this.supportsRevs){if(options.ifNoneMatch){headers["If-None-Match"]=addQuotes(options.ifNoneMatch)}}else if(options.ifNoneMatch){var oldRev=this._revisionCache[path]}var promise=this._request("GET",this.href+cleanPath(path),this.token,headers,undefined,this.supportsRevs,this._revisionCache[path]);if(isFolder(path)){return promise.then(function(status,body,contentType,revision){var itemsMap={};if(status===200&&typeof body==="object"){if(Object.keys(body).length===0){status=404}else if(isFolderDescription(body)){for(var item in body.items){this._revisionCache[path+item]=body.items[item].ETag}itemsMap=body.items}else{Object.keys(body).forEach(function(key){this._revisionCache[path+key]=body[key];itemsMap[key]={ETag:body[key]}}.bind(this))}return promising().fulfill(status,itemsMap,contentType,revision)}else{return promising().fulfill(status,body,contentType,revision)}}.bind(this))}else{return promise}},put:function(path,body,contentType,options){if(!this.connected){throw new Error("not connected (path: "+path+")")}if(!options){options={}}if(!contentType.match(/charset=/)){contentType+="; charset="+(body instanceof ArrayBuffer||isArrayBufferView(body)?"binary":"utf-8")}var headers={"Content-Type":contentType};if(this.supportsRevs){if(options.ifMatch){headers["If-Match"]=addQuotes(options.ifMatch)}if(options.ifNoneMatch){headers["If-None-Match"]=addQuotes(options.ifNoneMatch)}}return this._request("PUT",this.href+cleanPath(path),this.token,headers,body,this.supportsRevs)},delete:function(path,options){if(!this.connected){throw new Error("not connected (path: "+path+")")}if(!options){options={}}var headers={};if(this.supportsRevs){if(options.ifMatch){headers["If-Match"]=addQuotes(options.ifMatch)}}return this._request("DELETE",this.href+cleanPath(path),this.token,headers,undefined,this.supportsRevs)}};RS.WireClient.cleanPath=cleanPath;RS.WireClient.isArrayBufferView=isArrayBufferView;RS.WireClient.readBinaryData=readBinaryData;RS.WireClient.request=function(method,url,options,callback){RemoteStorage.log("[WireClient]",method,url);callback=callback.bind(this);var timedOut=false;var timer=setTimeout(function(){timedOut=true;callback("timeout")},RS.WireClient.REQUEST_TIMEOUT);var xhr=new XMLHttpRequest;xhr.open(method,url,true);if(options.responseType){xhr.responseType=options.responseType}if(options.headers){for(var key in options.headers){xhr.setRequestHeader(key,options.headers[key])}}xhr.onload=function(){if(timedOut){return}clearTimeout(timer);callback(null,xhr)};xhr.onerror=function(error){if(timedOut){return}clearTimeout(timer);callback(error)};var body=options.body;if(typeof body==="object"){if(isArrayBufferView(body)){}else if(body instanceof ArrayBuffer){body=new Uint8Array(body)}else{body=JSON.stringify(body)}}xhr.send(body)};Object.defineProperty(RemoteStorage.WireClient.prototype,"storageType",{get:function(){if(this.storageApi){var spec=this.storageApi.match(/draft-dejong-(remotestorage-\d\d)/);return spec?spec[1]:"2012.04"}}});RS.WireClient.configureHooks=[];RS.WireClient._rs_init=function(remoteStorage){hasLocalStorage=remoteStorage.localStorageAvailable();remoteStorage.remote=new RS.WireClient(remoteStorage);this.online=true};RS.WireClient._rs_supported=function(){return!!global.XMLHttpRequest};RS.WireClient._rs_cleanup=function(remoteStorage){if(hasLocalStorage){delete localStorage[SETTINGS_KEY]}remoteStorage.removeEventListener("error",onErrorCb)}})(typeof window!=="undefined"?window:global);(function(global){var haveXMLHttpRequest,hasLocalStorage;var SETTINGS_KEY="remotestorage:discover";var cachedInfo={};RemoteStorage.Discover=function(userAddress,callback){if(userAddress in cachedInfo){var info=cachedInfo[userAddress];callback(info.href,info.type,info.authURL);return}var hostname=userAddress.split("@")[1];var params="?resource="+encodeURIComponent("acct:"+userAddress);var urls=["https://"+hostname+"/.well-known/webfinger"+params,"https://"+hostname+"/.well-known/host-meta.json"+params,"http://"+hostname+"/.well-known/webfinger"+params,"http://"+hostname+"/.well-known/host-meta.json"+params];function tryOne(){var xhr=new XMLHttpRequest;var url=urls.shift();if(!url){return callback()}RemoteStorage.log("[Discover] Trying URL",url);xhr.open("GET",url,true);xhr.onabort=xhr.onerror=function(){console.error("webfinger error",arguments,"(",url,")");tryOne()};xhr.onload=function(){if(xhr.status!==200){return tryOne()}var profile;try{profile=JSON.parse(xhr.responseText)}catch(e){RemoteStorage.log("[Discover] Failed to parse profile ",xhr.responseText,e);tryOne();return}if(!profile.links){RemoteStorage.log("[Discover] Profile has no links section ",JSON.stringify(profile));tryOne();return}var link;profile.links.forEach(function(l){if(l.rel==="remotestorage"){link=l}else if(l.rel==="remoteStorage"&&!link){link=l}});RemoteStorage.log("[Discover] Got profile",profile,"and link",link);if(link){var authURL=link.properties["http://tools.ietf.org/html/rfc6749#section-4.2"]||link.properties["auth-endpoint"],storageType=link.properties["http://remotestorage.io/spec/version"]||link.type;cachedInfo[userAddress]={href:link.href,type:storageType,authURL:authURL};if(hasLocalStorage){localStorage[SETTINGS_KEY]=JSON.stringify({cache:cachedInfo})}callback(link.href,storageType,authURL)}else{tryOne()}};xhr.send()}tryOne()};RemoteStorage.Discover._rs_init=function(remoteStorage){hasLocalStorage=remoteStorage.localStorageAvailable();if(hasLocalStorage){var settings;try{settings=JSON.parse(localStorage[SETTINGS_KEY])}catch(e){}if(settings){cachedInfo=settings.cache}}};RemoteStorage.Discover._rs_supported=function(){haveXMLHttpRequest=!!global.XMLHttpRequest;return haveXMLHttpRequest};RemoteStorage.Discover._rs_cleanup=function(){if(hasLocalStorage){delete localStorage[SETTINGS_KEY]}}})(typeof window!=="undefined"?window:global);(function(global){function extractParams(){var location=RemoteStorage.Authorize.getLocation(),hashPos=location.href.indexOf("#"),hash;if(hashPos===-1){return}hash=location.href.substring(hashPos+1);if(hash.indexOf("=")===-1){return}return hash.split("&").reduce(function(m,kvs){var kv=kvs.split("=");m[decodeURIComponent(kv[0])]=decodeURIComponent(kv[1]);return m},{})}RemoteStorage.Authorize=function(authURL,scope,redirectUri,clientId){RemoteStorage.log("[Authorize] authURL = ",authURL);var url=authURL;url+=authURL.indexOf("?")>0?"&":"?";url+="redirect_uri="+encodeURIComponent(redirectUri.replace(/#.*$/,""));url+="&scope="+encodeURIComponent(scope);url+="&client_id="+encodeURIComponent(clientId);url+="&response_type=token";RemoteStorage.Authorize.setLocation(url)};RemoteStorage.prototype.authorize=function(authURL){this.access.setStorageType(this.remote.storageType);var scope=this.access.scopeParameter;var redirectUri=String(RemoteStorage.Authorize.getLocation());var clientId=redirectUri.match(/^(https?:\/\/[^\/]+)/)[0];RemoteStorage.Authorize(authURL,scope,redirectUri,clientId)};RemoteStorage.Authorize.getLocation=function(){return global.document.location};RemoteStorage.Authorize.setLocation=function(location){if(typeof location==="string"){global.document.location.href=location}else if(typeof location==="object"){global.document.location=location}else{throw"Invalid location "+location}};RemoteStorage.Authorize._rs_supported=function(remoteStorage){return typeof document!=="undefined"};var onFeaturesLoaded;RemoteStorage.Authorize._rs_init=function(remoteStorage){onFeaturesLoaded=function(){var authParamsUsed=false;if(params){if(params.error){throw"Authorization server errored: "+params.error}if(params.access_token){remoteStorage.remote.configure(undefined,undefined,undefined,params.access_token);authParamsUsed=true}if(params.remotestorage){remoteStorage.connect(params.remotestorage);authParamsUsed=true}}if(!authParamsUsed){remoteStorage.remote.stopWaitingForToken()}};var params=extractParams(),location;if(params){location=RemoteStorage.Authorize.getLocation();location.hash=""}remoteStorage.on("features-loaded",onFeaturesLoaded)};RemoteStorage.Authorize._rs_cleanup=function(remoteStorage){remoteStorage.removeEventListener("features-loaded",onFeaturesLoaded)}})(typeof window!=="undefined"?window:global);(function(global){var SETTINGS_KEY="remotestorage:access";RemoteStorage.Access=function(){this.reset()};RemoteStorage.Access.prototype={claim:function(scope,mode){if(typeof scope!=="string"||scope.indexOf("/")!==-1||scope.length===0){throw new Error("Scope should be a non-empty string without forward slashes")}if(!mode.match(/^rw?$/)){throw new Error("Mode should be either 'r' or 'rw'")}this._adjustRootPaths(scope);this.scopeModeMap[scope]=mode},get:function(scope){return this.scopeModeMap[scope]},remove:function(scope){var savedMap={};var name;for(name in this.scopeModeMap){savedMap[name]=this.scopeModeMap[name]}this.reset();delete savedMap[scope];for(name in savedMap){this.set(name,savedMap[name])}},checkPermission:function(scope,mode){var actualMode=this.get(scope);return actualMode&&(mode==="r"||actualMode==="rw")},checkPathPermission:function(path,mode){if(this.checkPermission("*",mode)){return true}return!!this.checkPermission(this._getModuleName(path),mode)},reset:function(){this.rootPaths=[];this.scopeModeMap={}},_getModuleName:function(path){if(path[0]!=="/"){throw new Error("Path should start with a slash")}var moduleMatch=path.replace(/^\/public/,"").match(/^\/([^\/]*)\//);return moduleMatch?moduleMatch[1]:"*"},_adjustRootPaths:function(newScope){if("*"in this.scopeModeMap||newScope==="*"){this.rootPaths=["/"]}else if(!(newScope in this.scopeModeMap)){this.rootPaths.push("/"+newScope+"/");this.rootPaths.push("/public/"+newScope+"/")}},_scopeNameForParameter:function(scope){if(scope.name==="*"&&this.storageType){if(this.storageType==="2012.04"){return""}else if(this.storageType.match(/remotestorage-0[01]/)){return"root"}}return scope.name},setStorageType:function(type){this.storageType=type}};Object.defineProperty(RemoteStorage.Access.prototype,"scopes",{get:function(){return Object.keys(this.scopeModeMap).map(function(key){return{name:key,mode:this.scopeModeMap[key]}}.bind(this))}});Object.defineProperty(RemoteStorage.Access.prototype,"scopeParameter",{get:function(){return this.scopes.map(function(scope){return this._scopeNameForParameter(scope)+":"+scope.mode}.bind(this)).join(" ")}});Object.defineProperty(RemoteStorage.prototype,"access",{get:function(){var access=new RemoteStorage.Access;Object.defineProperty(this,"access",{value:access});return access},configurable:true});RemoteStorage.Access._rs_init=function(){}})(typeof window!=="undefined"?window:global);(function(pMode){var mode=pMode,env={},isBackground=false;RemoteStorage.Env=function(){return env};RemoteStorage.Env.isBrowser=function(){return mode==="browser"};RemoteStorage.Env.isNode=function(){return mode==="node"};RemoteStorage.Env.goBackground=function(){isBackground=true;RemoteStorage.Env._emit("background")};RemoteStorage.Env.goForeground=function(){isBackground=false;RemoteStorage.Env._emit("foreground")};RemoteStorage.Env._rs_init=function(remoteStorage){RemoteStorage.eventHandling(RemoteStorage.Env,"background","foreground");if(mode==="browser"){if(typeof document.hidden!=="undefined"){env.hiddenProperty="hidden";env.visibilityChangeEvent="visibilitychange"}else if(typeof document.mozHidden!=="undefined"){env.hiddenProperty="mozHidden";env.visibilityChangeEvent="mozvisibilitychange"}else if(typeof document.msHidden!=="undefined"){env.hiddenProperty="msHidden";env.visibilityChangeEvent="msvisibilitychange"}else if(typeof document.webkitHidden!=="undefined"){env.hiddenProperty="webkitHidden";env.visibilityChangeEvent="webkitvisibilitychange"}document.addEventListener(env.visibilityChangeEvent,function(){if(document[env.hiddenProperty]){RemoteStorage.Env.goBackground()}else{RemoteStorage.Env.goForeground()}},false)}};RemoteStorage.Env._rs_cleanup=function(remoteStorage){}})(typeof window!=="undefined"?"browser":"node");(function(){"use strict";var dictionary={view_info:'This app allows you to use your own storage. <a href="http://remotestorage.io/" target="_blank">Learn more!</a>',view_connect:"<strong>Connect</strong> remote storage",view_connecting:"Connecting <strong>%s</strong>",view_offline:"Offline",view_error_occured:"Sorry! An error occured.",view_confirm_reset:"Are you sure you want to reset everything? This will clear your local data and reload the page.",view_get_me_out:"Get me out of here!",view_error_plz_report:'If this problem persists, please <a href="http://remotestorage.io/community/" target="_blank">let us know</a>!',view_unauthorized:"Unauthorized! Click here to reconnect."};RemoteStorage.I18n={translate:function(){var str=arguments[0],params=Array.prototype.splice.call(arguments,1);if(typeof dictionary[str]!=="string"){throw"Unknown translation string: "+str}else{str=dictionary[str]}return str.replace(/%s/g,function(){return params.shift()
})},getDictionary:function(){return dictionary},setDictionary:function(newDictionary){dictionary=newDictionary}}})();RemoteStorage.Assets={connectIcon:"data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjxzdmcgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIGhlaWdodD0iMTYiIHdpZHRoPSIxNiIgdmVyc2lvbj0iMS4xIiB4bWxuczpjYz0iaHR0cDovL2NyZWF0aXZlY29tbW9ucy5vcmcvbnMjIiB4bWxuczpkYz0iaHR0cDovL3B1cmwub3JnL2RjL2VsZW1lbnRzLzEuMS8iPgogPGcgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoMCAtMTAzNi40KSI+CiAgPHBhdGggZD0ibTEgMTA0Ny40di02aDd2LTRsNyA3LTcgN3YtNHoiIGZpbGw9IiNmZmYiLz4KIDwvZz4KPC9zdmc+Cg==",disconnectIcon:"data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjxzdmcgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIGhlaWdodD0iMTYiIHdpZHRoPSIxNiIgdmVyc2lvbj0iMS4wIiB4bWxuczpjYz0iaHR0cDovL2NyZWF0aXZlY29tbW9ucy5vcmcvbnMjIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIj4KIDxwYXRoIHN0eWxlPSJibG9jay1wcm9ncmVzc2lvbjp0Yjt0ZXh0LWluZGVudDowO2NvbG9yOiMwMDAwMDA7dGV4dC10cmFuc2Zvcm06bm9uZSIgZD0ibTguMDAwMSAwYy0wLjQ3MTQgMC0wLjk2MTAzIDAuNTQxOS0wLjk1IDF2NmMtMC4wMDc0NyAwLjUyODMxIDAuNDIxNjMgMSAwLjk1IDFzMC45NTc0Ny0wLjQ3MTY5IDAuOTUtMXYtNmMwLjAxNDYyMi0wLjYwNTEtMC40Nzg2LTEtMC45NS0xem0tMy4zNDM4IDIuNWMtMC4wODcxODYgMC4wMTkyOTQtMC4xNzE2MyAwLjA1MDk1OS0wLjI1IDAuMDkzNzUtMi45OTk1IDEuNTcxNS0zLjkxODQgNC43OTc5LTMuMTI1IDcuNDY4OCAwLjc5MzQgMi42NyAzLjI3OTkgNC45MzcgNi42ODc1IDQuOTM3IDMuMzU5MiAwIDUuODc3Mi0yLjE0OSA2LjcxOTItNC43ODEgMC44NDEtMi42MzIxLTAuMDU4LTUuODIzNC0zLjEyNS03LjU5NC0wLjQzNC0wLjI1MzYtMS4wNTktMC4wODk5LTEuMzEzIDAuMzQzNy0wLjI1MzYgMC40MzM2LTAuMDkgMS4wNTg5IDAuMzQ0IDEuMzEyNSAyLjM5MDggMS4zNzk4IDIuODgyNSAzLjQ5NDQgMi4yODEyIDUuMzc1LTAuNjAxMiAxLjg4MDYtMi4zNDQgMy40Mzc1LTQuOTA2MiAzLjQzNzUtMi41NzU5IDAtNC4yOTc2LTEuNjUwMi00Ljg3NS0zLjU5MzgtMC41Nzc2LTEuOTQzNS0wLjA0Ny00LjA0OCAyLjE4NzMtNS4yMTg3IDAuMzc4Ny0wLjIwNjMgMC41NzkxLTAuNjkyNSAwLjQ1NTgtMS4xMDU3LTAuMTIzMi0wLjQxMzMtMC41NTcyLTAuNzEwMy0wLjk4Ny0wLjY3NTUtMC4wMzEzLTAuMDAxNS0wLjA2MjYtMC4wMDE1LTAuMDkzOCAweiIgZmlsbD0iI2ZmZiIvPgo8L3N2Zz4K",dropbox:"data:image/png;base64,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",googledrive:"data:image/png;base64,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",remoteStorageIcon:"data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjxzdmcgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIGhlaWdodD0iMzIiIHdpZHRoPSIzMiIgdmVyc2lvbj0iMS4xIiB4bWxuczpjYz0iaHR0cDovL2NyZWF0aXZlY29tbW9ucy5vcmcvbnMjIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIj4KIDxkZWZzPgogIDxyYWRpYWxHcmFkaWVudCBpZD0iYSIgZ3JhZGllbnRVbml0cz0idXNlclNwYWNlT25Vc2UiIGN5PSI1NzEuNDIiIGN4PSIxMDQ2LjUiIGdyYWRpZW50VHJhbnNmb3JtPSJtYXRyaXgoLjE0NDMzIDAgMCAuMTY2NjcgMTIwMS41IDg3Ny4xMSkiIHI9Ijk2Ij4KICAgPHN0b3Agc3RvcC1jb2xvcj0iI2ZmNGEwNCIgc3RvcC1vcGFjaXR5PSIuNzYxNTQiIG9mZnNldD0iMCIvPgogICA8c3RvcCBzdG9wLWNvbG9yPSIjZmY0YTA0IiBvZmZzZXQ9IjEiLz4KICA8L3JhZGlhbEdyYWRpZW50PgogPC9kZWZzPgogPGcgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoLTEzMzYuNiAtOTU2LjM1KSI+CiAgPHBhdGggc3R5bGU9ImNvbG9yOiMwMDAwMDAiIGQ9Im0xMzUyLjYgOTU2LjM1IDAuMjg4NiAxNS4xMzYgMTMuNTY3LTcuMTM1Mi0xMy44NTUtOC4wMDExemwtMTMuODU1IDguMDAxMSAxMy41NjcgNy4xMzUyIDAuMjg4Ny0xNS4xMzZ6bS0xMy44NTUgOC4wMDExdjE1Ljk5OGwxMi45NTgtNy44MTYyLTEyLjk1OC04LjE4MTV6bTAgMTUuOTk4IDEzLjg1NSA4LjAwMTEtMC42MDg5LTE1LjMxNy0xMy4yNDYgNy4zMTU2em0xMy44NTUgOC4wMDExIDEzLjg1NS04LjAwMTEtMTMuMjUxLTcuMzE1Ni0wLjYwNDQgMTUuMzE3em0xMy44NTUtOC4wMDExdi0xNS45OThsLTEyLjk2MiA4LjE4MTUgMTIuOTYyIDcuODE2MnoiIGZpbGw9InVybCgjYSkiLz4KIDwvZz4KPC9zdmc+Cg==",remoteStorageIconError:"data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjxzdmcgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIGhlaWdodD0iMzIiIHdpZHRoPSIzMiIgdmVyc2lvbj0iMS4xIiB4bWxuczpjYz0iaHR0cDovL2NyZWF0aXZlY29tbW9ucy5vcmcvbnMjIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIj4KIDxkZWZzPgogIDxyYWRpYWxHcmFkaWVudCBpZD0iYSIgZ3JhZGllbnRVbml0cz0idXNlclNwYWNlT25Vc2UiIGN5PSI1NzEuNDIiIGN4PSIxMDQ2LjUiIGdyYWRpZW50VHJhbnNmb3JtPSJtYXRyaXgoLjE0NDMzIDAgMCAuMTY2NjcgMTIwMS41IDg3Ny4xMSkiIHI9Ijk2Ij4KICAgPHN0b3Agc3RvcC1jb2xvcj0iI2U5MDAwMCIgc3RvcC1vcGFjaXR5PSIuNzYwNzgiIG9mZnNldD0iMCIvPgogICA8c3RvcCBzdG9wLWNvbG9yPSIjZTkwMDAwIiBvZmZzZXQ9IjEiLz4KICA8L3JhZGlhbEdyYWRpZW50PgogPC9kZWZzPgogPGcgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoLTEzMzYuNiAtOTU2LjM1KSI+CiAgPHBhdGggc3R5bGU9ImNvbG9yOiMwMDAwMDAiIGQ9Im0xMzUyLjYgOTU2LjM1IDAuMjg4NiAxNS4xMzYgMTMuNTY3LTcuMTM1Mi0xMy44NTUtOC4wMDExemwtMTMuODU1IDguMDAxMSAxMy41NjcgNy4xMzUyIDAuMjg4Ny0xNS4xMzZ6bS0xMy44NTUgOC4wMDExdjE1Ljk5OGwxMi45NTgtNy44MTYyLTEyLjk1OC04LjE4MTV6bTAgMTUuOTk4IDEzLjg1NSA4LjAwMTEtMC42MDg5LTE1LjMxNy0xMy4yNDYgNy4zMTU2em0xMy44NTUgOC4wMDExIDEzLjg1NS04LjAwMTEtMTMuMjUxLTcuMzE1Ni0wLjYwNDQgMTUuMzE3em0xMy44NTUtOC4wMDExdi0xNS45OThsLTEyLjk2MiA4LjE4MTUgMTIuOTYyIDcuODE2MnoiIGZpbGw9InVybCgjYSkiLz4KIDwvZz4KPC9zdmc+Cg==",remoteStorageIconOffline:"data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjxzdmcgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIGhlaWdodD0iMzIiIHdpZHRoPSIzMiIgdmVyc2lvbj0iMS4xIiB4bWxuczpjYz0iaHR0cDovL2NyZWF0aXZlY29tbW9ucy5vcmcvbnMjIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIj4KIDxkZWZzPgogIDxyYWRpYWxHcmFkaWVudCBpZD0iYSIgZ3JhZGllbnRVbml0cz0idXNlclNwYWNlT25Vc2UiIGN5PSI1NzEuNDIiIGN4PSIxMDQ2LjUiIGdyYWRpZW50VHJhbnNmb3JtPSJtYXRyaXgoLjE0NDMzIDAgMCAuMTY2NjcgMTIwMS41IDg3Ny4xMSkiIHI9Ijk2Ij4KICAgPHN0b3Agc3RvcC1jb2xvcj0iIzY5Njk2OSIgc3RvcC1vcGFjaXR5PSIuNzYxNTQiIG9mZnNldD0iMCIvPgogICA8c3RvcCBzdG9wLWNvbG9yPSIjNjc2NzY3IiBvZmZzZXQ9IjEiLz4KICA8L3JhZGlhbEdyYWRpZW50PgogPC9kZWZzPgogPGcgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoLTEzMzYuNiAtOTU2LjM1KSI+CiAgPHBhdGggc3R5bGU9ImNvbG9yOiMwMDAwMDAiIGQ9Im0xMzUyLjYgOTU2LjM1IDAuMjg4NiAxNS4xMzYgMTMuNTY3LTcuMTM1Mi0xMy44NTUtOC4wMDExemwtMTMuODU1IDguMDAxMSAxMy41NjcgNy4xMzUyIDAuMjg4Ny0xNS4xMzZ6bS0xMy44NTUgOC4wMDExdjE1Ljk5OGwxMi45NTgtNy44MTYyLTEyLjk1OC04LjE4MTV6bTAgMTUuOTk4IDEzLjg1NSA4LjAwMTEtMC42MDg5LTE1LjMxNy0xMy4yNDYgNy4zMTU2em0xMy44NTUgOC4wMDExIDEzLjg1NS04LjAwMTEtMTMuMjUxLTcuMzE1Ni0wLjYwNDQgMTUuMzE3em0xMy44NTUtOC4wMDExdi0xNS45OThsLTEyLjk2MiA4LjE4MTUgMTIuOTYyIDcuODE2MnoiIGZpbGw9InVybCgjYSkiLz4KIDwvZz4KPC9zdmc+Cg==",syncIcon:"data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjxzdmcgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIGVuYWJsZS1iYWNrZ3JvdW5kPSJuZXcgMCAwIDg3LjUgMTAwIiB4bWw6c3BhY2U9InByZXNlcnZlIiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTUuOTk5OTk5IDE2IiB3aWR0aD0iMTYiIHZlcnNpb249IjEuMSIgeT0iMHB4IiB4PSIwcHgiIHhtbG5zOmNjPSJodHRwOi8vY3JlYXRpdmVjb21tb25zLm9yZy9ucyMiIHhtbG5zOmRjPSJodHRwOi8vcHVybC5vcmcvZGMvZWxlbWVudHMvMS4xLyI+CjxnIHRyYW5zZm9ybT0idHJhbnNsYXRlKC01LjUxMTIgLTc2LjUyNSkiIGRpc3BsYXk9Im5vbmUiPgoJPHBhdGggZGlzcGxheT0iaW5saW5lIiBkPSJtNTEuNDczIDQyLjI1NS0yLjIwNSAyLjIxMmMxLjQ3OCAxLjQ3NyAyLjI5NSAzLjQ0MiAyLjI5NSA1LjUzMyAwIDQuMzA5LTMuNTA0IDcuODEyLTcuODEyIDcuODEydi0xLjU2MmwtMy4xMjUgMy4xMjUgMy4xMjQgMy4xMjV2LTEuNTYyYzYuMDI5IDAgMTAuOTM4LTQuOTA2IDEwLjkzOC0xMC45MzggMC0yLjkyNy0xLjE0MS01LjY3Ni0zLjIxNS03Ljc0NXoiLz4KCTxwYXRoIGRpc3BsYXk9ImlubGluZSIgZD0ibTQ2Ljg3NSA0MC42MjUtMy4xMjUtMy4xMjV2MS41NjJjLTYuMDMgMC0xMC45MzggNC45MDctMTAuOTM4IDEwLjkzOCAwIDIuOTI3IDEuMTQxIDUuNjc2IDMuMjE3IDcuNzQ1bDIuMjAzLTIuMjEyYy0xLjQ3Ny0xLjQ3OS0yLjI5NC0zLjQ0Mi0yLjI5NC01LjUzMyAwLTQuMzA5IDMuNTA0LTcuODEyIDcuODEyLTcuODEydjEuNTYybDMuMTI1LTMuMTI1eiIvPgo8L2c+CjxwYXRoIGZpbGw9IiNmZmYiIGQ9Im0xMCAwbC0wLjc1IDEuOTA2MmMtMS4wMDc4LTAuMjk0Mi0zLjQ1ODYtMC43NzA4LTUuNjU2MiAwLjkzNzYgMC0wLjAwMDItMy45MzAyIDIuNTk0MS0yLjA5MzggNy41OTQybDEuNjU2Mi0wLjcxOTJzLTEuNTM5OS0zLjExMjIgMS42ODc2LTUuNTMxM2MwIDAgMS42OTU3LTEuMTMzOSAzLjY4NzQtMC41OTM3bC0wLjcxODcgMS44MTI0IDMuODEyNS0xLjYyNS0xLjYyNS0zLjc4MTJ6Ii8+PHBhdGggZmlsbD0iI2ZmZiIgZD0ibTE0IDUuNTYyNWwtMS42NTYgMC43MTg3czEuNTQxIDMuMTEzNS0xLjY4OCA1LjUzMDhjMCAwLTEuNzI3MiAxLjEzNS0zLjcxODUgMC41OTRsMC43NS0xLjgxMi0zLjgxMjUgMS41OTQgMS41OTM4IDMuODEyIDAuNzgxMi0xLjkwNmMxLjAxMTMgMC4yOTUgMy40NjE1IDAuNzY2IDUuNjU2LTAuOTM4IDAgMCAzLjkyOC0yLjU5NCAyLjA5NC03LjU5MzV6Ii8+Cjwvc3ZnPgo=",widget:'<div class="rs-bubble rs-hidden">   <div class="rs-bubble-text remotestorage-initial remotestorage-error remotestorage-authing remotestorage-offline">     <span class="rs-status-text">{{view_connect}}</span>   </div>   <div class="rs-bubble-expandable">     <!-- error -->     <div class="remotestorage-error">       <pre class="rs-status-text rs-error-msg">{{ERROR_MSG}}</pre>       <button class="remotestorage-reset">{{view_get_me_out}}</button>       <p class="rs-centered-text rs-error-plz-report">{{view_error_plz_report}}</p>     </div>     <!-- connected -->     <div class="rs-bubble-text remotestorage-connected">       <strong class="userAddress">{{USER_ADDRESS}}</strong>       <p class="remotestorage-unauthorized">{{view_unauthorized}}</p>     </div>     <div class="rs-content remotestorage-connected">       <button class="rs-sync" title="sync"><img></button>       <button class="rs-disconnect" title="disconnect"><img></button>     </div>     <!-- initial -->     <form novalidate class="remotestorage-initial">       <input type="email" placeholder="user@host" name="userAddress" novalidate>       <button class="connect" name="connect" title="connect" disabled="disabled">         <img>       </button>     </form>     <div class="rs-info-msg remotestorage-initial">{{view_info}}</div>   </div> </div> <img class="rs-dropbox rs-backends rs-action" alt="Connect to Dropbox"> <img class="rs-googledrive rs-backends rs-action" alt="Connect to Google Drive"> <img class="rs-cube rs-action"> ',widgetCss:'/** encoding:utf-8 **/ /* RESET */ #remotestorage-widget{text-align:left;}#remotestorage-widget input, #remotestorage-widget button{font-size:11px;}#remotestorage-widget form input[type=email]{margin-bottom:0;/* HTML5 Boilerplate */}#remotestorage-widget form input[type=submit]{margin-top:0;/* HTML5 Boilerplate */}/* /RESET */ #remotestorage-widget, #remotestorage-widget *{-moz-box-sizing:border-box;box-sizing:border-box;}#remotestorage-widget{position:absolute;right:10px;top:10px;font:normal 16px/100% sans-serif !important;user-select:none;-webkit-user-select:none;-moz-user-select:-moz-none;cursor:default;z-index:10000;}#remotestorage-widget .rs-bubble{background:rgba(80, 80, 80, .7);border-radius:5px 15px 5px 5px;color:white;font-size:0.8em;padding:5px;position:absolute;right:3px;top:9px;min-height:24px;white-space:nowrap;text-decoration:none;}.rs-bubble .rs-bubble-text{padding-right:32px;/* make sure the bubble doesn\'t "jump" when initially opening. */ min-width:182px;}#remotestorage-widget .rs-action{cursor:pointer;}/* less obtrusive cube when connected */ #remotestorage-widget.remotestorage-state-connected .rs-cube, #remotestorage-widget.remotestorage-state-busy .rs-cube{opacity:.3;-webkit-transition:opacity .3s ease;-moz-transition:opacity .3s ease;-ms-transition:opacity .3s ease;-o-transition:opacity .3s ease;transition:opacity .3s ease;}#remotestorage-widget.remotestorage-state-connected:hover .rs-cube, #remotestorage-widget.remotestorage-state-busy:hover .rs-cube, #remotestorage-widget.remotestorage-state-connected .rs-bubble:not(.rs-hidden) + .rs-cube{opacity:1 !important;}#remotestorage-widget .rs-backends{position:relative;top:5px;right:0;}#remotestorage-widget .rs-cube{position:relative;top:5px;right:0;}/* pulsing animation for cube when loading */ #remotestorage-widget .rs-cube.remotestorage-loading{-webkit-animation:remotestorage-loading .5s ease-in-out infinite alternate;-moz-animation:remotestorage-loading .5s ease-in-out infinite alternate;-o-animation:remotestorage-loading .5s ease-in-out infinite alternate;-ms-animation:remotestorage-loading .5s ease-in-out infinite alternate;animation:remotestorage-loading .5s ease-in-out infinite alternate;}@-webkit-keyframes remotestorage-loading{to{opacity:.7}}@-moz-keyframes remotestorage-loading{to{opacity:.7}}@-o-keyframes remotestorage-loading{to{opacity:.7}}@-ms-keyframes remotestorage-loading{to{opacity:.7}}@keyframes remotestorage-loading{to{opacity:.7}}#remotestorage-widget a{text-decoration:underline;color:inherit;}#remotestorage-widget form{margin-top:.7em;position:relative;}#remotestorage-widget form input{display:table-cell;vertical-align:top;border:none;border-radius:6px;font-weight:bold;color:white;outline:none;line-height:1.5em;height:2em;}#remotestorage-widget form input:disabled{color:#999;background:#444 !important;cursor:default !important;}#remotestorage-widget form input[type=email]:focus{background:#223;}#remotestorage-widget form input[type=email]{background:#000;width:100%;height:26px;padding:0 30px 0 5px;border-top:1px solid #111;border-bottom:1px solid #999;}#remotestorage-widget form input[type=email]:focus{background:#223;}#remotestorage-widget button:focus, #remotestorage-widget input:focus{box-shadow:0 0 4px #ccc;}#remotestorage-widget form input[type=email]::-webkit-input-placeholder{color:#999;}#remotestorage-widget form input[type=email]:-moz-placeholder{color:#999;}#remotestorage-widget form input[type=email]::-moz-placeholder{color:#999;}#remotestorage-widget form input[type=email]:-ms-input-placeholder{color:#999;}#remotestorage-widget form input[type=submit]{background:#000;cursor:pointer;padding:0 5px;}#remotestorage-widget form input[type=submit]:hover{background:#333;}#remotestorage-widget .rs-info-msg{font-size:10px;color:#eee;margin-top:0.7em;white-space:normal;}#remotestorage-widget .rs-info-msg.last-synced-message{display:inline;white-space:nowrap;margin-bottom:.7em}#remotestorage-widget .rs-info-msg a:hover, #remotestorage-widget .rs-info-msg a:active{color:#fff;}#remotestorage-widget button img{vertical-align:baseline;}#remotestorage-widget button{border:none;border-radius:6px;font-weight:bold;color:white;outline:none;line-height:1.5em;height:26px;width:26px;background:#000;cursor:pointer;margin:0;padding:5px;}#remotestorage-widget button:hover{background:#333;}#remotestorage-widget .rs-bubble button.connect{display:block;background:none;position:absolute;right:0;top:0;opacity:1;/* increase clickable area of connect button */ margin:-5px;padding:10px;width:36px;height:36px;}#remotestorage-widget .rs-bubble button.connect:not([disabled]):hover{background:rgba(150,150,150,.5);}#remotestorage-widget .rs-bubble button.connect[disabled]{opacity:.5;cursor:default !important;}#remotestorage-widget .rs-bubble button.rs-sync{position:relative;left:-5px;bottom:-5px;padding:4px 4px 0 4px;background:#555;}#remotestorage-widget .rs-bubble button.rs-sync:hover{background:#444;}#remotestorage-widget .rs-bubble button.rs-disconnect{background:#721;position:absolute;right:0;bottom:0;padding:4px 4px 0 4px;}#remotestorage-widget .rs-bubble button.rs-disconnect:hover{background:#921;}#remotestorage-widget .remotestorage-error-info{color:#f92;}#remotestorage-widget .remotestorage-reset{width:100%;background:#721;}#remotestorage-widget .remotestorage-reset:hover{background:#921;}#remotestorage-widget .rs-bubble .rs-content{margin-top:7px;}#remotestorage-widget pre{user-select:initial;-webkit-user-select:initial;-moz-user-select:text;max-width:27em;margin-top:1em;overflow:auto;}#remotestorage-widget .rs-centered-text{text-align:center;}#remotestorage-widget .rs-bubble.rs-hidden{padding-bottom:2px;border-radius:5px 15px 15px 5px;}#remotestorage-widget .rs-error-msg{min-height:5em;}.rs-bubble.rs-hidden .rs-bubble-expandable{display:none;}.remotestorage-state-connected .rs-bubble.rs-hidden{display:none;}.remotestorage-connected{display:none;}.remotestorage-state-connected .remotestorage-connected{display:block;}.remotestorage-initial{display:none;}.remotestorage-state-initial .remotestorage-initial{display:block;}.remotestorage-error{display:none;}.remotestorage-state-error .remotestorage-error{display:block;}.remotestorage-state-authing .remotestorage-authing{display:block;}.remotestorage-state-offline .remotestorage-connected, .remotestorage-state-offline .remotestorage-offline{display:block;}.remotestorage-unauthorized{display:none;}.remotestorage-state-unauthorized .rs-bubble.rs-hidden{display:none;}.remotestorage-state-unauthorized .remotestorage-connected, .remotestorage-state-unauthorized .remotestorage-unauthorized{display:block;}.remotestorage-state-unauthorized .rs-sync{display:none;}.remotestorage-state-busy .rs-bubble.rs-hidden{display:none;}.remotestorage-state-busy .rs-bubble{display:block;}.remotestorage-state-busy .remotestorage-connected{display:block;}.remotestorage-state-authing .rs-bubble-expandable{display:none;}'};(function(window){var hasLocalStorage;var LS_STATE_KEY="remotestorage:widget:state";var VALID_ENTRY_STATES={initial:true,connected:true,offline:true};function stateSetter(widget,state){RemoteStorage.log("[Widget] Producing stateSetter for",state);return function(){RemoteStorage.log("[Widget] Setting state",state,arguments);if(hasLocalStorage){localStorage[LS_STATE_KEY]=state}if(widget.view){if(widget.rs.remote){widget.view.setUserAddress(widget.rs.remote.userAddress)}widget.view.setState(state,arguments)}else{widget._rememberedState=state}}}function errorsHandler(widget){return function(error){if(error instanceof RemoteStorage.DiscoveryError){console.error("Discovery failed",error,'"'+error.message+'"');widget.view.setState("initial",[error.message])}else if(error instanceof RemoteStorage.SyncError){widget.view.setState("offline",[])}else if(error instanceof RemoteStorage.Unauthorized){widget.view.setState("unauthorized")}else{RemoteStorage.log("[Widget] Unknown error");widget.view.setState("error",[error])}}}function flashFor(evt){if(evt.method==="GET"&&evt.isFolder){return false}return true}RemoteStorage.Widget=function(remoteStorage){var self=this;var requestsToFlashFor=0;this.rs=remoteStorage;this.rs.remote.on("connected",stateSetter(this,"connected"));this.rs.on("disconnected",stateSetter(this,"initial"));this.rs.on("connecting",stateSetter(this,"authing"));this.rs.on("authing",stateSetter(this,"authing"));this.rs.on("error",errorsHandler(this));if(this.rs.remote){this.rs.remote.on("wire-busy",function(evt){if(flashFor(evt)){requestsToFlashFor++;stateSetter(self,"busy")()}});this.rs.remote.on("wire-done",function(evt){if(flashFor(evt)){requestsToFlashFor--;if(requestsToFlashFor<=0){stateSetter(self,"connected")()}}})}if(hasLocalStorage){var state=localStorage[LS_STATE_KEY];if(state&&VALID_ENTRY_STATES[state]){this._rememberedState=state}}};RemoteStorage.Widget.prototype={display:function(domID){if(!this.view){this.setView(new RemoteStorage.Widget.View(this.rs))}this.view.display.apply(this.view,arguments);return this},linkWidgetToSync:function(){if(typeof this.rs.sync==="object"&&typeof this.rs.sync.sync==="function"){this.view.on("sync",this.rs.sync.sync.bind(this.rs.sync))}else{RemoteStorage.log("[Widget] typeof this.rs.sync check fail",this.rs.sync);setTimeout(this.linkWidgetToSync.bind(this),1e3)}},setView:function(view){this.view=view;this.view.on("connect",function(options){if(typeof options==="string"){this.rs.connect(options)}else if(options.special){this.rs[options.special].connect(options)}}.bind(this));this.view.on("disconnect",this.rs.disconnect.bind(this.rs));this.linkWidgetToSync();try{this.view.on("reset",function(){var location=RemoteStorage.Authorize.getLocation();this.rs.on("disconnected",location.reload.bind(location));this.rs.disconnect()}.bind(this))}catch(e){if(e.message&&e.message.match(/Unknown event/)){}else{throw e}}if(this._rememberedState){setTimeout(stateSetter(this,this._rememberedState),0);delete this._rememberedState}}};RemoteStorage.prototype.displayWidget=function(domID){return this.widget.display(domID)};RemoteStorage.Widget._rs_init=function(remoteStorage){hasLocalStorage=remoteStorage.localStorageAvailable();if(!remoteStorage.widget){remoteStorage.widget=new RemoteStorage.Widget(remoteStorage)}};RemoteStorage.Widget._rs_supported=function(remoteStorage){return typeof document!=="undefined"}})(typeof window!=="undefined"?window:global);(function(window){var t=RemoteStorage.I18n.translate;var cEl=function(){return document.createElement.apply(document,arguments)};function gCl(parent,className){return parent.getElementsByClassName(className)[0]}function gTl(parent,tagName){return parent.getElementsByTagName(tagName)[0]}function removeClass(el,className){return el.classList.remove(className)}function addClass(el,className){return el.classList.add(className)}function stopPropagation(event){if(typeof event.stopPropagation==="function"){event.stopPropagation()}else{event.cancelBubble=true}}function setupButton(parent,className,iconName,eventListener){var element=gCl(parent,className);if(typeof iconName!=="undefined"){var img=gTl(element,"img");(img||element).src=RemoteStorage.Assets[iconName]}element.addEventListener("click",eventListener);return element}RemoteStorage.Widget.View=function(remoteStorage){this.rs=remoteStorage;if(typeof document==="undefined"){throw"Widget not supported"}RemoteStorage.eventHandling(this,"connect","disconnect","sync","display","reset");for(var event in this.events){this.events[event]=this.events[event].bind(this)}this.hideBubbleOnBodyClick=function(event){for(var p=event.target;p!==document.body;p=p.parentElement){if(p.id==="remotestorage-widget"){return}}this.hideBubble()}.bind(this)};RemoteStorage.Widget.View.prototype={connectGdrive:function(){this._emit("connect",{special:"googledrive"})},connectDropbox:function(){this._emit("connect",{special:"dropbox"})},setState:function(state,args){RemoteStorage.log("[View] widget.view.setState(",state,",",args,");");var s=this.states[state];if(typeof s==="undefined"){throw new Error("Bad State assigned to view: "+state)}s.apply(this,args)},setUserAddress:function(addr){this.userAddress=addr||"";var el;if(this.div&&(el=gTl(this.div,"form").userAddress)){el.value=this.userAddress}},toggleBubble:function(event){if(this.bubble.className.search("rs-hidden")<0){this.hideBubble(event)}else{this.showBubble(event)}},hideBubble:function(){addClass(this.bubble,"rs-hidden");document.body.removeEventListener("click",this.hideBubbleOnBodyClick)},showBubble:function(event){removeClass(this.bubble,"rs-hidden");if(typeof event!=="undefined"){stopPropagation(event)}document.body.addEventListener("click",this.hideBubbleOnBodyClick);gTl(this.bubble,"form").userAddress.focus()},display:function(domID){if(typeof this.div!=="undefined"){return this.div}var element=cEl("div");var style=cEl("style");style.innerHTML=RemoteStorage.Assets.widgetCss;element.id="remotestorage-widget";element.innerHTML=RemoteStorage.Assets.widget;element.appendChild(style);if(domID){var parent=document.getElementById(domID);if(!parent){throw'Failed to find target DOM element with id="'+domID+'"'}parent.appendChild(element)}else{document.body.appendChild(element)}setupButton(element,"rs-sync","syncIcon",this.events.sync);setupButton(element,"rs-disconnect","disconnectIcon",this.events.disconnect);setupButton(element,"remotestorage-reset",undefined,this.events.reset);var cb=setupButton(element,"connect","connectIcon",this.events.connect);this.form=gTl(element,"form");var el=this.form.userAddress;el.addEventListener("keyup",function(event){if(event.target.value){cb.removeAttribute("disabled")}else{cb.setAttribute("disabled","disabled")}});if(this.userAddress){el.value=this.userAddress}this.cube=setupButton(element,"rs-cube","remoteStorageIcon",this.toggleBubble.bind(this));setupButton(element,"rs-dropbox","dropbox",this.connectDropbox.bind(this));setupButton(element,"rs-googledrive","googledrive",this.connectGdrive.bind(this));var bubbleDontCatch={INPUT:true,BUTTON:true,IMG:true};var eventListener=function(event){if(!bubbleDontCatch[event.target.tagName]&&!this.div.classList.contains("remotestorage-state-unauthorized")){this.showBubble(event)}}.bind(this);this.bubble=setupButton(element,"rs-bubble",undefined,eventListener);this.hideBubble();this.div=element;this.states.initial.call(this);this.events.display.call(this);return this.div},_renderTranslatedInitialContent:function(){gCl(this.div,"rs-status-text").innerHTML=t("view_connect");gCl(this.div,"remotestorage-reset").innerHTML=t("view_get_me_out");gCl(this.div,"rs-error-plz-report").innerHTML=t("view_error_plz_report");gCl(this.div,"remotestorage-unauthorized").innerHTML=t("view_unauthorized")},states:{initial:function(message){var cube=this.cube;var info=message||t("view_info");this._renderTranslatedInitialContent();if(message){cube.src=RemoteStorage.Assets.remoteStorageIconError;removeClass(this.cube,"remotestorage-loading");this.showBubble();setTimeout(function(){cube.src=RemoteStorage.Assets.remoteStorageIcon},5e3)}else{this.hideBubble()}this.div.className="remotestorage-state-initial";var backends=1;if(this._activateBackend("dropbox")){backends+=1}if(this._activateBackend("googledrive")){backends+=1}gCl(this.div,"rs-bubble-text").style.paddingRight=backends*32+8+"px";var cb=gCl(this.div,"connect");if(this.form.userAddress.value){cb.removeAttribute("disabled")}var infoEl=gCl(this.div,"rs-info-msg");infoEl.innerHTML=info;if(message){infoEl.classList.add("remotestorage-error-info")}else{infoEl.classList.remove("remotestorage-error-info")}},authing:function(){this.div.removeEventListener("click",this.events.connect);this.div.className="remotestorage-state-authing";gCl(this.div,"rs-status-text").innerHTML=t("view_connecting",this.userAddress);addClass(this.cube,"remotestorage-loading")},connected:function(){this.div.className="remotestorage-state-connected";gCl(this.div,"userAddress").innerHTML=this.userAddress;this.cube.src=RemoteStorage.Assets.remoteStorageIcon;removeClass(this.cube,"remotestorage-loading");var icons={googledrive:gCl(this.div,"rs-googledrive"),dropbox:gCl(this.div,"rs-dropbox")};icons.googledrive.style.display=icons.dropbox.style.display="none";if(icons[this.rs.backend]){icons[this.rs.backend].style.display="inline-block";gCl(this.div,"rs-bubble-text").style.paddingRight=2*32+8+"px"}else{gCl(this.div,"rs-bubble-text").style.paddingRight=32+8+"px"}},busy:function(){this.div.className="remotestorage-state-busy";addClass(this.cube,"remotestorage-loading");this.hideBubble()},offline:function(){this.div.className="remotestorage-state-offline";this.cube.src=RemoteStorage.Assets.remoteStorageIconOffline;gCl(this.div,"rs-status-text").innerHTML=t("view_offline")},error:function(err){var errorMsg=err;this.div.className="remotestorage-state-error";gCl(this.div,"rs-bubble-text").innerHTML="<strong>"+t("view_error_occured")+"</strong>";if(err instanceof Error){errorMsg=err.message+"\n\n"+err.stack}gCl(this.div,"rs-error-msg").textContent=errorMsg;this.cube.src=RemoteStorage.Assets.remoteStorageIconError;this.showBubble()},unauthorized:function(){this.div.className="remotestorage-state-unauthorized";this.cube.src=RemoteStorage.Assets.remoteStorageIconError;this.showBubble();this.div.addEventListener("click",this.events.connect)}},events:{connect:function(event){stopPropagation(event);event.preventDefault();this._emit("connect",gTl(this.div,"form").userAddress.value)},sync:function(event){stopPropagation(event);event.preventDefault();this._emit("sync")},disconnect:function(event){stopPropagation(event);event.preventDefault();this._emit("disconnect")},reset:function(event){event.preventDefault();var result=window.confirm(t("view_confirm_reset"));if(result){this._emit("reset")}},display:function(event){if(event){event.preventDefault()
}this._emit("display")}},_activateBackend:function activateBackend(backendName){var className="rs-"+backendName;if(this.rs.apiKeys[backendName]){gCl(this.div,className).style.display="inline-block";return true}else{gCl(this.div,className).style.display="none";return false}}}})(typeof window!=="undefined"?window:global);(function(global){var ValidatorContext=function(parent,collectMultiple){this.missing=[];this.schemas=parent?Object.create(parent.schemas):{};this.collectMultiple=collectMultiple;this.errors=[];this.handleError=collectMultiple?this.collectError:this.returnError};ValidatorContext.prototype.returnError=function(error){return error};ValidatorContext.prototype.collectError=function(error){if(error){this.errors.push(error)}return null};ValidatorContext.prototype.prefixErrors=function(startIndex,dataPath,schemaPath){for(var i=startIndex;i<this.errors.length;i++){this.errors[i]=this.errors[i].prefixWith(dataPath,schemaPath)}return this};ValidatorContext.prototype.getSchema=function(url){if(this.schemas[url]!=undefined){var schema=this.schemas[url];return schema}var baseUrl=url;var fragment="";if(url.indexOf("#")!=-1){fragment=url.substring(url.indexOf("#")+1);baseUrl=url.substring(0,url.indexOf("#"))}if(this.schemas[baseUrl]!=undefined){var schema=this.schemas[baseUrl];var pointerPath=decodeURIComponent(fragment);if(pointerPath==""){return schema}else if(pointerPath.charAt(0)!="/"){return undefined}var parts=pointerPath.split("/").slice(1);for(var i=0;i<parts.length;i++){var component=parts[i].replace("~1","/").replace("~0","~");if(schema[component]==undefined){schema=undefined;break}schema=schema[component]}if(schema!=undefined){return schema}}if(this.missing[baseUrl]==undefined){this.missing.push(baseUrl);this.missing[baseUrl]=baseUrl}};ValidatorContext.prototype.addSchema=function(url,schema){var map={};map[url]=schema;normSchema(schema,url);searchForTrustedSchemas(map,schema,url);for(var key in map){this.schemas[key]=map[key]}return map};ValidatorContext.prototype.validateAll=function validateAll(data,schema,dataPathParts,schemaPathParts){if(schema["$ref"]!=undefined){schema=this.getSchema(schema["$ref"]);if(!schema){return null}}var errorCount=this.errors.length;var error=this.validateBasic(data,schema)||this.validateNumeric(data,schema)||this.validateString(data,schema)||this.validateArray(data,schema)||this.validateObject(data,schema)||this.validateCombinations(data,schema)||null;if(error||errorCount!=this.errors.length){while(dataPathParts&&dataPathParts.length||schemaPathParts&&schemaPathParts.length){var dataPart=dataPathParts&&dataPathParts.length?""+dataPathParts.pop():null;var schemaPart=schemaPathParts&&schemaPathParts.length?""+schemaPathParts.pop():null;if(error){error=error.prefixWith(dataPart,schemaPart)}this.prefixErrors(errorCount,dataPart,schemaPart)}}return this.handleError(error)};function recursiveCompare(A,B){if(A===B){return true}if(typeof A=="object"&&typeof B=="object"){if(Array.isArray(A)!=Array.isArray(B)){return false}else if(Array.isArray(A)){if(A.length!=B.length){return false}for(var i=0;i<A.length;i++){if(!recursiveCompare(A[i],B[i])){return false}}}else{for(var key in A){if(B[key]===undefined&&A[key]!==undefined){return false}}for(var key in B){if(A[key]===undefined&&B[key]!==undefined){return false}}for(var key in A){if(!recursiveCompare(A[key],B[key])){return false}}}return true}return false}ValidatorContext.prototype.validateBasic=function validateBasic(data,schema){var error;if(error=this.validateType(data,schema)){return error.prefixWith(null,"type")}if(error=this.validateEnum(data,schema)){return error.prefixWith(null,"type")}return null};ValidatorContext.prototype.validateType=function validateType(data,schema){if(schema.type==undefined){return null}var dataType=typeof data;if(data==null){dataType="null"}else if(Array.isArray(data)){dataType="array"}var allowedTypes=schema.type;if(typeof allowedTypes!="object"){allowedTypes=[allowedTypes]}for(var i=0;i<allowedTypes.length;i++){var type=allowedTypes[i];if(type==dataType||type=="integer"&&dataType=="number"&&data%1==0){return null}}return new ValidationError(ErrorCodes.INVALID_TYPE,"invalid data type: "+dataType)};ValidatorContext.prototype.validateEnum=function validateEnum(data,schema){if(schema["enum"]==undefined){return null}for(var i=0;i<schema["enum"].length;i++){var enumVal=schema["enum"][i];if(recursiveCompare(data,enumVal)){return null}}return new ValidationError(ErrorCodes.ENUM_MISMATCH,"No enum match for: "+JSON.stringify(data))};ValidatorContext.prototype.validateNumeric=function validateNumeric(data,schema){return this.validateMultipleOf(data,schema)||this.validateMinMax(data,schema)||null};ValidatorContext.prototype.validateMultipleOf=function validateMultipleOf(data,schema){var multipleOf=schema.multipleOf||schema.divisibleBy;if(multipleOf==undefined){return null}if(typeof data=="number"){if(data%multipleOf!=0){return new ValidationError(ErrorCodes.NUMBER_MULTIPLE_OF,"Value "+data+" is not a multiple of "+multipleOf)}}return null};ValidatorContext.prototype.validateMinMax=function validateMinMax(data,schema){if(typeof data!="number"){return null}if(schema.minimum!=undefined){if(data<schema.minimum){return new ValidationError(ErrorCodes.NUMBER_MINIMUM,"Value "+data+" is less than minimum "+schema.minimum).prefixWith(null,"minimum")}if(schema.exclusiveMinimum&&data==schema.minimum){return new ValidationError(ErrorCodes.NUMBER_MINIMUM_EXCLUSIVE,"Value "+data+" is equal to exclusive minimum "+schema.minimum).prefixWith(null,"exclusiveMinimum")}}if(schema.maximum!=undefined){if(data>schema.maximum){return new ValidationError(ErrorCodes.NUMBER_MAXIMUM,"Value "+data+" is greater than maximum "+schema.maximum).prefixWith(null,"maximum")}if(schema.exclusiveMaximum&&data==schema.maximum){return new ValidationError(ErrorCodes.NUMBER_MAXIMUM_EXCLUSIVE,"Value "+data+" is equal to exclusive maximum "+schema.maximum).prefixWith(null,"exclusiveMaximum")}}return null};ValidatorContext.prototype.validateString=function validateString(data,schema){return this.validateStringLength(data,schema)||this.validateStringPattern(data,schema)||null};ValidatorContext.prototype.validateStringLength=function validateStringLength(data,schema){if(typeof data!="string"){return null}if(schema.minLength!=undefined){if(data.length<schema.minLength){return new ValidationError(ErrorCodes.STRING_LENGTH_SHORT,"String is too short ("+data.length+" chars), minimum "+schema.minLength).prefixWith(null,"minLength")}}if(schema.maxLength!=undefined){if(data.length>schema.maxLength){return new ValidationError(ErrorCodes.STRING_LENGTH_LONG,"String is too long ("+data.length+" chars), maximum "+schema.maxLength).prefixWith(null,"maxLength")}}return null};ValidatorContext.prototype.validateStringPattern=function validateStringPattern(data,schema){if(typeof data!="string"||schema.pattern==undefined){return null}var regexp=new RegExp(schema.pattern);if(!regexp.test(data)){return new ValidationError(ErrorCodes.STRING_PATTERN,"String does not match pattern").prefixWith(null,"pattern")}return null};ValidatorContext.prototype.validateArray=function validateArray(data,schema){if(!Array.isArray(data)){return null}return this.validateArrayLength(data,schema)||this.validateArrayUniqueItems(data,schema)||this.validateArrayItems(data,schema)||null};ValidatorContext.prototype.validateArrayLength=function validateArrayLength(data,schema){if(schema.minItems!=undefined){if(data.length<schema.minItems){var error=new ValidationError(ErrorCodes.ARRAY_LENGTH_SHORT,"Array is too short ("+data.length+"), minimum "+schema.minItems).prefixWith(null,"minItems");if(this.handleError(error)){return error}}}if(schema.maxItems!=undefined){if(data.length>schema.maxItems){var error=new ValidationError(ErrorCodes.ARRAY_LENGTH_LONG,"Array is too long ("+data.length+" chars), maximum "+schema.maxItems).prefixWith(null,"maxItems");if(this.handleError(error)){return error}}}return null};ValidatorContext.prototype.validateArrayUniqueItems=function validateArrayUniqueItems(data,schema){if(schema.uniqueItems){for(var i=0;i<data.length;i++){for(var j=i+1;j<data.length;j++){if(recursiveCompare(data[i],data[j])){var error=new ValidationError(ErrorCodes.ARRAY_UNIQUE,"Array items are not unique (indices "+i+" and "+j+")").prefixWith(null,"uniqueItems");if(this.handleError(error)){return error}}}}}return null};ValidatorContext.prototype.validateArrayItems=function validateArrayItems(data,schema){if(schema.items==undefined){return null}var error;if(Array.isArray(schema.items)){for(var i=0;i<data.length;i++){if(i<schema.items.length){if(error=this.validateAll(data[i],schema.items[i],[i],["items",i])){return error}}else if(schema.additionalItems!=undefined){if(typeof schema.additionalItems=="boolean"){if(!schema.additionalItems){error=new ValidationError(ErrorCodes.ARRAY_ADDITIONAL_ITEMS,"Additional items not allowed").prefixWith(""+i,"additionalItems");if(this.handleError(error)){return error}}}else if(error=this.validateAll(data[i],schema.additionalItems,[i],["additionalItems"])){return error}}}}else{for(var i=0;i<data.length;i++){if(error=this.validateAll(data[i],schema.items,[i],["items"])){return error}}}return null};ValidatorContext.prototype.validateObject=function validateObject(data,schema){if(typeof data!="object"||data==null||Array.isArray(data)){return null}return this.validateObjectMinMaxProperties(data,schema)||this.validateObjectRequiredProperties(data,schema)||this.validateObjectProperties(data,schema)||this.validateObjectDependencies(data,schema)||null};ValidatorContext.prototype.validateObjectMinMaxProperties=function validateObjectMinMaxProperties(data,schema){var keys=Object.keys(data);if(schema.minProperties!=undefined){if(keys.length<schema.minProperties){var error=new ValidationError(ErrorCodes.OBJECT_PROPERTIES_MINIMUM,"Too few properties defined ("+keys.length+"), minimum "+schema.minProperties).prefixWith(null,"minProperties");if(this.handleError(error)){return error}}}if(schema.maxProperties!=undefined){if(keys.length>schema.maxProperties){var error=new ValidationError(ErrorCodes.OBJECT_PROPERTIES_MAXIMUM,"Too many properties defined ("+keys.length+"), maximum "+schema.maxProperties).prefixWith(null,"maxProperties");if(this.handleError(error)){return error}}}return null};ValidatorContext.prototype.validateObjectRequiredProperties=function validateObjectRequiredProperties(data,schema){if(schema.required!=undefined){for(var i=0;i<schema.required.length;i++){var key=schema.required[i];if(data[key]===undefined){var error=new ValidationError(ErrorCodes.OBJECT_REQUIRED,"Missing required property: "+key).prefixWith(null,""+i).prefixWith(null,"required");if(this.handleError(error)){return error}}}}return null};ValidatorContext.prototype.validateObjectProperties=function validateObjectProperties(data,schema){var error;for(var key in data){var foundMatch=false;if(schema.properties!=undefined&&schema.properties[key]!=undefined){foundMatch=true;if(error=this.validateAll(data[key],schema.properties[key],[key],["properties",key])){return error}}if(schema.patternProperties!=undefined){for(var patternKey in schema.patternProperties){var regexp=new RegExp(patternKey);if(regexp.test(key)){foundMatch=true;if(error=this.validateAll(data[key],schema.patternProperties[patternKey],[key],["patternProperties",patternKey])){return error}}}}if(!foundMatch&&schema.additionalProperties!=undefined){if(typeof schema.additionalProperties=="boolean"){if(!schema.additionalProperties){error=new ValidationError(ErrorCodes.OBJECT_ADDITIONAL_PROPERTIES,"Additional properties not allowed").prefixWith(key,"additionalProperties");if(this.handleError(error)){return error}}}else{if(error=this.validateAll(data[key],schema.additionalProperties,[key],["additionalProperties"])){return error}}}}return null};ValidatorContext.prototype.validateObjectDependencies=function validateObjectDependencies(data,schema){var error;if(schema.dependencies!=undefined){for(var depKey in schema.dependencies){if(data[depKey]!==undefined){var dep=schema.dependencies[depKey];if(typeof dep=="string"){if(data[dep]===undefined){error=new ValidationError(ErrorCodes.OBJECT_DEPENDENCY_KEY,"Dependency failed - key must exist: "+dep).prefixWith(null,depKey).prefixWith(null,"dependencies");if(this.handleError(error)){return error}}}else if(Array.isArray(dep)){for(var i=0;i<dep.length;i++){var requiredKey=dep[i];if(data[requiredKey]===undefined){error=new ValidationError(ErrorCodes.OBJECT_DEPENDENCY_KEY,"Dependency failed - key must exist: "+requiredKey).prefixWith(null,""+i).prefixWith(null,depKey).prefixWith(null,"dependencies");if(this.handleError(error)){return error}}}}else{if(error=this.validateAll(data,dep,[],["dependencies",depKey])){return error}}}}}return null};ValidatorContext.prototype.validateCombinations=function validateCombinations(data,schema){var error;return this.validateAllOf(data,schema)||this.validateAnyOf(data,schema)||this.validateOneOf(data,schema)||this.validateNot(data,schema)||null};ValidatorContext.prototype.validateAllOf=function validateAllOf(data,schema){if(schema.allOf==undefined){return null}var error;for(var i=0;i<schema.allOf.length;i++){var subSchema=schema.allOf[i];if(error=this.validateAll(data,subSchema,[],["allOf",i])){return error}}return null};ValidatorContext.prototype.validateAnyOf=function validateAnyOf(data,schema){if(schema.anyOf==undefined){return null}var errors=[];var startErrorCount=this.errors.length;for(var i=0;i<schema.anyOf.length;i++){var subSchema=schema.anyOf[i];var errorCount=this.errors.length;var error=this.validateAll(data,subSchema,[],["anyOf",i]);if(error==null&&errorCount==this.errors.length){this.errors=this.errors.slice(0,startErrorCount);return null}if(error){errors.push(error.prefixWith(null,""+i).prefixWith(null,"anyOf"))}}errors=errors.concat(this.errors.slice(startErrorCount));this.errors=this.errors.slice(0,startErrorCount);return new ValidationError(ErrorCodes.ANY_OF_MISSING,'Data does not match any schemas from "anyOf"',"","/anyOf",errors)};ValidatorContext.prototype.validateOneOf=function validateOneOf(data,schema){if(schema.oneOf==undefined){return null}var validIndex=null;var errors=[];var startErrorCount=this.errors.length;for(var i=0;i<schema.oneOf.length;i++){var subSchema=schema.oneOf[i];var errorCount=this.errors.length;var error=this.validateAll(data,subSchema,[],["oneOf",i]);if(error==null&&errorCount==this.errors.length){if(validIndex==null){validIndex=i}else{this.errors=this.errors.slice(0,startErrorCount);return new ValidationError(ErrorCodes.ONE_OF_MULTIPLE,'Data is valid against more than one schema from "oneOf": indices '+validIndex+" and "+i,"","/oneOf")}}else if(error){errors.push(error.prefixWith(null,""+i).prefixWith(null,"oneOf"))}}if(validIndex==null){errors=errors.concat(this.errors.slice(startErrorCount));this.errors=this.errors.slice(0,startErrorCount);return new ValidationError(ErrorCodes.ONE_OF_MISSING,'Data does not match any schemas from "oneOf"',"","/oneOf",errors)}else{this.errors=this.errors.slice(0,startErrorCount)}return null};ValidatorContext.prototype.validateNot=function validateNot(data,schema){if(schema.not==undefined){return null}var oldErrorCount=this.errors.length;var error=this.validateAll(data,schema.not);var notErrors=this.errors.slice(oldErrorCount);this.errors=this.errors.slice(0,oldErrorCount);if(error==null&&notErrors.length==0){return new ValidationError(ErrorCodes.NOT_PASSED,'Data matches schema from "not"',"","/not")}return null};function parseURI(url){var m=String(url).replace(/^\s+|\s+$/g,"").match(/^([^:\/?#]+:)?(\/\/(?:[^:@]*(?::[^:@]*)?@)?(([^:\/?#]*)(?::(\d*))?))?([^?#]*)(\?[^#]*)?(#[\s\S]*)?/);return m?{href:m[0]||"",protocol:m[1]||"",authority:m[2]||"",host:m[3]||"",hostname:m[4]||"",port:m[5]||"",pathname:m[6]||"",search:m[7]||"",hash:m[8]||""}:null}function resolveUrl(base,href){function removeDotSegments(input){var output=[];input.replace(/^(\.\.?(\/|$))+/,"").replace(/\/(\.(\/|$))+/g,"/").replace(/\/\.\.$/,"/../").replace(/\/?[^\/]*/g,function(p){if(p==="/.."){output.pop()}else{output.push(p)}});return output.join("").replace(/^\//,input.charAt(0)==="/"?"/":"")}href=parseURI(href||"");base=parseURI(base||"");return!href||!base?null:(href.protocol||base.protocol)+(href.protocol||href.authority?href.authority:base.authority)+removeDotSegments(href.protocol||href.authority||href.pathname.charAt(0)==="/"?href.pathname:href.pathname?(base.authority&&!base.pathname?"/":"")+base.pathname.slice(0,base.pathname.lastIndexOf("/")+1)+href.pathname:base.pathname)+(href.protocol||href.authority||href.pathname?href.search:href.search||base.search)+href.hash}function normSchema(schema,baseUri){if(baseUri==undefined){baseUri=schema.id}else if(typeof schema.id=="string"){baseUri=resolveUrl(baseUri,schema.id);schema.id=baseUri}if(typeof schema=="object"){if(Array.isArray(schema)){for(var i=0;i<schema.length;i++){normSchema(schema[i],baseUri)}}else if(typeof schema["$ref"]=="string"){schema["$ref"]=resolveUrl(baseUri,schema["$ref"])}else{for(var key in schema){if(key!="enum"){normSchema(schema[key],baseUri)}}}}}var ErrorCodes={INVALID_TYPE:0,ENUM_MISMATCH:1,ANY_OF_MISSING:10,ONE_OF_MISSING:11,ONE_OF_MULTIPLE:12,NOT_PASSED:13,NUMBER_MULTIPLE_OF:100,NUMBER_MINIMUM:101,NUMBER_MINIMUM_EXCLUSIVE:102,NUMBER_MAXIMUM:103,NUMBER_MAXIMUM_EXCLUSIVE:104,STRING_LENGTH_SHORT:200,STRING_LENGTH_LONG:201,STRING_PATTERN:202,OBJECT_PROPERTIES_MINIMUM:300,OBJECT_PROPERTIES_MAXIMUM:301,OBJECT_REQUIRED:302,OBJECT_ADDITIONAL_PROPERTIES:303,OBJECT_DEPENDENCY_KEY:304,ARRAY_LENGTH_SHORT:400,ARRAY_LENGTH_LONG:401,ARRAY_UNIQUE:402,ARRAY_ADDITIONAL_ITEMS:403};function ValidationError(code,message,dataPath,schemaPath,subErrors){if(code==undefined){throw new Error("No code supplied for error: "+message)}this.code=code;this.message=message;this.dataPath=dataPath?dataPath:"";this.schemaPath=schemaPath?schemaPath:"";this.subErrors=subErrors?subErrors:null}ValidationError.prototype={prefixWith:function(dataPrefix,schemaPrefix){if(dataPrefix!=null){dataPrefix=dataPrefix.replace("~","~0").replace("/","~1");this.dataPath="/"+dataPrefix+this.dataPath}if(schemaPrefix!=null){schemaPrefix=schemaPrefix.replace("~","~0").replace("/","~1");this.schemaPath="/"+schemaPrefix+this.schemaPath}if(this.subErrors!=null){for(var i=0;i<this.subErrors.length;i++){this.subErrors[i].prefixWith(dataPrefix,schemaPrefix)}}return this}};function searchForTrustedSchemas(map,schema,url){if(typeof schema.id=="string"){if(schema.id.substring(0,url.length)==url){var remainder=schema.id.substring(url.length);if(url.length>0&&url.charAt(url.length-1)=="/"||remainder.charAt(0)=="#"||remainder.charAt(0)=="?"){if(map[schema.id]==undefined){map[schema.id]=schema}}}}if(typeof schema=="object"){for(var key in schema){if(key!="enum"&&typeof schema[key]=="object"){searchForTrustedSchemas(map,schema[key],url)}}}return map}var globalContext=new ValidatorContext;var publicApi={validate:function(data,schema){var context=new ValidatorContext(globalContext);if(typeof schema=="string"){schema={$ref:schema}}var added=context.addSchema("",schema);var error=context.validateAll(data,schema);this.error=error;this.missing=context.missing;this.valid=error==null;return this.valid},validateResult:function(){var result={};this.validate.apply(result,arguments);return result},validateMultiple:function(data,schema){var context=new ValidatorContext(globalContext,true);if(typeof schema=="string"){schema={$ref:schema}}context.addSchema("",schema);context.validateAll(data,schema);var result={};result.errors=context.errors;result.missing=context.missing;result.valid=result.errors.length==0;return result},addSchema:function(url,schema){return globalContext.addSchema(url,schema)},getSchema:function(url){return globalContext.getSchema(url)},missing:[],error:null,normSchema:normSchema,resolveUrl:resolveUrl,errorCodes:ErrorCodes};global.tv4=publicApi})(typeof window!="undefined"?window:global);var CHARS="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split("");Math.uuid=function(len,radix){var chars=CHARS,uuid=[],i;radix=radix||chars.length;if(len){for(i=0;i<len;i++)uuid[i]=chars[0|Math.random()*radix]}else{var r;uuid[8]=uuid[13]=uuid[18]=uuid[23]="-";uuid[14]="4";for(i=0;i<36;i++){if(!uuid[i]){r=0|Math.random()*16;uuid[i]=chars[i==19?r&3|8:r]}}}return uuid.join("")};(function(global){function deprecate(thing,replacement){console.log("WARNING: "+thing+" is deprecated. Use "+replacement+" instead.")}var RS=RemoteStorage;RS.BaseClient=function(storage,base){if(base[base.length-1]!=="/"){throw"Not a folder: "+base}if(base==="/"){this.makePath=function(path){return(path[0]==="/"?"":"/")+path}}this.storage=storage;this.base=base;var parts=this.base.split("/");if(parts.length>2){this.moduleName=parts[1]}else{this.moduleName="root"}RS.eventHandling(this,"change");this.on=this.on.bind(this);storage.onChange(this.base,this._fireChange.bind(this))};RS.BaseClient.prototype={extend:function(object){for(var key in object){this[key]=object[key]}return this},scope:function(path){return new RS.BaseClient(this.storage,this.makePath(path))},getListing:function(path,maxAge){if(typeof path!=="string"){path=""}else if(path.length>0&&path[path.length-1]!=="/"){throw"Not a folder: "+path}if(maxAgeInvalid(maxAge)){return promising().reject("Argument 'maxAge' of baseClient.getListing must be undefined or a number")}return this.storage.get(this.makePath(path),maxAge).then(function(status,body){return status===404?undefined:body})},getAll:function(path,maxAge){if(typeof path!=="string"){path=""}else if(path.length>0&&path[path.length-1]!=="/"){throw"Not a folder: "+path}if(maxAgeInvalid(maxAge)){return promising().reject("Argument 'maxAge' of baseClient.getAll must be undefined or a number")}return this.storage.get(this.makePath(path),maxAge).then(function(status,body){if(status===404){return}if(typeof body==="object"){var promise=promising();var count=Object.keys(body).length,i=0;if(count===0){return}for(var key in body){this.storage.get(this.makePath(path+key),maxAge).then(function(status,b){body[this.key]=b;i++;if(i===count){promise.fulfill(body)}}.bind({key:key}))}return promise}}.bind(this))},getFile:function(path,maxAge){if(typeof path!=="string"){return promising().reject("Argument 'path' of baseClient.getFile must be a string")}if(maxAgeInvalid(maxAge)){return promising().reject("Argument 'maxAge' of baseClient.getFile must be undefined or a number")}return this.storage.get(this.makePath(path),maxAge).then(function(status,body,mimeType,revision){return{data:body,mimeType:mimeType,revision:revision}})},storeFile:function(mimeType,path,body){if(typeof mimeType!=="string"){return promising().reject("Argument 'mimeType' of baseClient.storeFile must be a string")}if(typeof path!=="string"){return promising().reject("Argument 'path' of baseClient.storeFile must be a string")}if(typeof body!=="string"&&typeof body!=="object"){return promising().reject("Argument 'body' of baseClient.storeFile must be a string, ArrayBuffer, or ArrayBufferView")}var self=this;return this.storage.put(this.makePath(path),body,mimeType).then(function(status,_body,_mimeType,revision){if(status===200||status===201){return revision}else{throw"Request (PUT "+self.makePath(path)+") failed with status: "+status}})},getObject:function(path,maxAge){if(typeof path!=="string"){return promising().reject("Argument 'path' of baseClient.getObject must be a string")}if(maxAgeInvalid(maxAge)){return promising().reject("Argument 'maxAge' of baseClient.getObject must be undefined or a number")}return this.storage.get(this.makePath(path),maxAge).then(function(status,body,mimeType,revision){if(typeof body==="object"){return body}else if(typeof body!=="undefined"&&status===200){throw"Not an object: "+this.makePath(path)}})},storeObject:function(typeAlias,path,object){if(typeof typeAlias!=="string"){return promising().reject("Argument 'typeAlias' of baseClient.storeObject must be a string")}if(typeof path!=="string"){return promising().reject("Argument 'path' of baseClient.storeObject must be a string")}if(typeof object!=="object"){return promising().reject("Argument 'object' of baseClient.storeObject must be an object")}this._attachType(object,typeAlias);try{var validationResult=this.validate(object);if(!validationResult.valid){return promising(function(p){p.reject(validationResult)})}}catch(exc){if(!(exc instanceof RS.BaseClient.Types.SchemaNotFound)){return promising().reject(exc)}}return this.storage.put(this.makePath(path),object,"application/json; charset=UTF-8").then(function(status,_body,_mimeType,revision){if(status===200||status===201){return revision}else{throw"Request (PUT "+this.makePath(path)+") failed with status: "+status}}.bind(this))},remove:function(path){if(typeof path!=="string"){return promising().reject("Argument 'path' of baseClient.remove must be a string")}return this.storage.delete(this.makePath(path))},cache:function(path,strategy){if(typeof path!=="string"){throw"Argument 'path' of baseClient.cache must be a string"}if(strategy===false){deprecate("caching strategy <false>",'<"FLUSH">');strategy="FLUSH"}else if(strategy===undefined){strategy="ALL"}else if(typeof strategy!=="string"){deprecate("that caching strategy",'<"ALL">');strategy="ALL"}if(strategy!=="FLUSH"&&strategy!=="SEEN"&&strategy!=="ALL"){throw"Argument 'strategy' of baseclient.cache must be one of "+'["FLUSH", "SEEN", "ALL"]'}this.storage.caching.set(this.makePath(path),strategy);return this},flush:function(path){return this.storage.local.flush(path)},makePath:function(path){return this.base+(path||"")},_fireChange:function(event){this._emit("change",event)},_cleanPath:RS.WireClient.cleanPath,getItemURL:function(path){if(typeof path!=="string"){throw"Argument 'path' of baseClient.getItemURL must be a string"}if(this.storage.connected){path=this._cleanPath(this.makePath(path));return this.storage.remote.href+path}else{return undefined}},uuid:function(){return Math.uuid()}};RS.BaseClient._rs_init=function(){RS.prototype.scope=function(path){if(typeof path!=="string"){throw"Argument 'path' of baseClient.scope must be a string"}return new RS.BaseClient(this,path)}};maxAgeInvalid=function(maxAge){return typeof maxAge!=="undefined"&&typeof maxAge!=="number"}})(typeof window!=="undefined"?window:global);(function(global){RemoteStorage.BaseClient.Types={uris:{},schemas:{},aliases:{},declare:function(moduleName,alias,uri,schema){var fullAlias=moduleName+"/"+alias;if(schema.extends){var extendedAlias;var parts=schema.extends.split("/");if(parts.length===1){extendedAlias=moduleName+"/"+parts.shift()}else{extendedAlias=parts.join("/")}var extendedUri=this.uris[extendedAlias];if(!extendedUri){throw"Type '"+fullAlias+"' tries to extend unknown schema '"+extendedAlias+"'"}schema.extends=this.schemas[extendedUri]}this.uris[fullAlias]=uri;this.aliases[uri]=fullAlias;this.schemas[uri]=schema},resolveAlias:function(alias){return this.uris[alias]},getSchema:function(uri){return this.schemas[uri]},inScope:function(moduleName){var ml=moduleName.length;var schemas={};for(var alias in this.uris){if(alias.substr(0,ml+1)===moduleName+"/"){var uri=this.uris[alias];schemas[uri]=this.schemas[uri]}}return schemas}};var SchemaNotFound=function(uri){var error=new Error("Schema not found: "+uri);error.name="SchemaNotFound";return error};SchemaNotFound.prototype=Error.prototype;RemoteStorage.BaseClient.Types.SchemaNotFound=SchemaNotFound;RemoteStorage.BaseClient.prototype.extend({validate:function(object){var schema=RemoteStorage.BaseClient.Types.getSchema(object["@context"]);if(schema){return tv4.validateResult(object,schema)}else{throw new SchemaNotFound(object["@context"])}},declareType:function(alias,uri,schema){if(!schema){schema=uri;uri=this._defaultTypeURI(alias)}RemoteStorage.BaseClient.Types.declare(this.moduleName,alias,uri,schema)},_defaultTypeURI:function(alias){return"http://remotestoragejs.com/spec/modules/"+this.moduleName+"/"+alias},_attachType:function(object,alias){object["@context"]=RemoteStorage.BaseClient.Types.resolveAlias(alias)||this._defaultTypeURI(alias)}});Object.defineProperty(RemoteStorage.BaseClient.prototype,"schemas",{configurable:true,get:function(){return RemoteStorage.BaseClient.Types.inScope(this.moduleName)}})})(typeof window!=="undefined"?window:global);(function(global){var SETTINGS_KEY="remotestorage:caching";function containingFolder(path){if(path===""){return"/"}if(!path){throw"Path not given!"}return path.replace(/\/+/g,"/").replace(/[^\/]+\/?$/,"")}RemoteStorage.Caching=function(){this.reset()};RemoteStorage.Caching.prototype={pendingActivations:[],set:function(path,value){if(typeof path!=="string"){throw new Error("path should be a string")}if(typeof value==="undefined"){throw new Error("value should be 'FLUSH', 'SEEN', or 'ALL'")}this._rootPaths[path]=value;if(value==="ALL"){if(this.activateHandler){this.activateHandler(path)}else{this.pendingActivations.push(path)}}},enable:function(path){this.set(path,"ALL")},disable:function(path){this.set(path,"FLUSH")},onActivate:function(cb){var i;RemoteStorage.log("[Caching] Setting activate handler",cb,this.pendingActivations);this.activateHandler=cb;for(i=0;i<this.pendingActivations.length;i++){cb(this.pendingActivations[i])}delete this.pendingActivations},checkPath:function(path){if(this._rootPaths[path]!==undefined){return this._rootPaths[path]}else if(path==="/"){return"SEEN"}else{return this.checkPath(containingFolder(path))}},reset:function(){this._rootPaths={}}};Object.defineProperty(RemoteStorage.prototype,"caching",{configurable:true,get:function(){var caching=new RemoteStorage.Caching;Object.defineProperty(this,"caching",{value:caching});return caching}});RemoteStorage.Caching._rs_init=function(){}})(typeof window!=="undefined"?window:global);(function(global){var syncInterval=1e4;function taskFor(action,path,promise){return{action:action,path:path,promise:promise}}function isStaleChild(node){return node.remote&&node.remote.revision&&!node.remote.itemsMap&&!node.remote.body}function hasCommonRevision(node){return node.common&&node.common.revision}function equal(obj1,obj2){return JSON.stringify(obj1)===JSON.stringify(obj2)}function equalObj(x,y){var p;for(p in y){if(typeof x[p]==="undefined"){return false}}for(p in y){if(y[p]){switch(typeof y[p]){case"object":if(!y[p].equals(x[p])){return false}break;case"function":if(typeof x[p]==="undefined"||p!=="equals"&&y[p].toString()!==x[p].toString()){return false}break;default:if(y[p]!==x[p]){return false}}}else{if(x[p]){return false}}}for(p in x){if(typeof y[p]==="undefined"){return false}}return true}function isFolder(path){return path.substr(-1)==="/"}RemoteStorage.Sync=function(setLocal,setRemote,setAccess,setCaching){this.local=setLocal;this.local.onDiff(function(path){this.addTask(path);this.doTasks()}.bind(this));this.remote=setRemote;this.access=setAccess;this.caching=setCaching;this._tasks={};this._running={};this._timeStarted={};RemoteStorage.eventHandling(this,"done","req-done");this.caching.onActivate(function(path){this.addTask(path);this.doTasks()}.bind(this))};RemoteStorage.Sync.prototype={now:function(){return(new Date).getTime()},queueGetRequest:function(path,promise){if(!this.remote.connected){promise.reject("cannot fulfill maxAge requirement - remote is not connected")}else if(!this.remote.online){promise.reject("cannot fulfill maxAge requirement - remote is not online")}else{this.addTask(path,function(){this.local.get(path).then(function(status,bodyOrItemsMap,contentType){promise.fulfill(status,bodyOrItemsMap,contentType)})}.bind(this));this.doTasks()}},corruptServerItemsMap:function(itemsMap,force02){if(typeof itemsMap!=="object"||Array.isArray(itemsMap)){return true}for(var itemName in itemsMap){var item=itemsMap[itemName];if(typeof item!=="object"){return true}if(typeof item.ETag!=="string"){return true}if(isFolder(itemName)){if(itemName.substring(0,itemName.length-1).indexOf("/")!==-1){return true}}else{if(itemName.indexOf("/")!==-1){return true
}if(force02){if(typeof item["Content-Type"]!=="string"){return true}if(typeof item["Content-Length"]!=="number"){return true}}}}return false},corruptItemsMap:function(itemsMap){if(typeof itemsMap!=="object"||Array.isArray(itemsMap)){return true}for(var itemName in itemsMap){if(typeof itemsMap[itemName]!=="boolean"){return true}}return false},corruptRevision:function(rev){return typeof rev!=="object"||Array.isArray(rev)||rev.revision&&typeof rev.revision!=="string"||rev.body&&typeof rev.body!=="string"&&typeof rev.body!=="object"||rev.contentType&&typeof rev.contentType!=="string"||rev.contentLength&&typeof rev.contentLength!=="number"||rev.timestamp&&typeof rev.timestamp!=="number"||rev.itemsMap&&this.corruptItemsMap(rev.itemsMap)},isCorrupt:function(node){return typeof node!=="object"||Array.isArray(node)||typeof node.path!=="string"||this.corruptRevision(node.common)||node.local&&this.corruptRevision(node.local)||node.remote&&this.corruptRevision(node.remote)||node.push&&this.corruptRevision(node.push)},isFolderNode:function(node){return node.path.substr(-1)==="/"},isDocumentNode:function(node){return!this.isFolderNode(node)},hasTasks:function(){return Object.getOwnPropertyNames(this._tasks).length>0},collectDiffTasks:function(){var num=0;return this.local.forAllNodes(function(node){if(num>100){return}if(this.isCorrupt(node)){RemoteStorage.log("[Sync] WARNING: corrupt node in local cache",node);if(typeof node==="object"&&node.path){this.addTask(node.path);num++}}else if(this.needsFetch(node)&&this.access.checkPathPermission(node.path,"r")){this.addTask(node.path);num++}else if(this.isDocumentNode(node)&&this.needsPush(node)&&this.access.checkPathPermission(node.path,"rw")){this.addTask(node.path);num++}}.bind(this)).then(function(){return num},function(err){throw err})},inConflict:function(node){return node.local&&node.remote&&(node.remote.body!==undefined||node.remote.itemsMap)},needsRefresh:function(node){if(node.common){if(!node.common.timestamp){return true}return this.now()-node.common.timestamp>syncInterval}return false},needsFetch:function(node){if(this.inConflict(node)){return true}if(node.common&&node.common.itemsMap===undefined&&node.common.body===undefined){return true}if(node.remote&&node.remote.itemsMap===undefined&&node.remote.body===undefined){return true}return false},needsPush:function(node){if(this.inConflict(node)){return false}if(node.local&&!node.push){return true}},needsRemotePut:function(node){return node.local&&node.local.body},needsRemoteDelete:function(node){return node.local&&node.local.body===false},getParentPath:function(path){var parts=path.match(/^(.*\/)([^\/]+\/?)$/);if(parts){return parts[1]}else{throw new Error('Not a valid path: "'+path+'"')}},deleteChildPathsFromTasks:function(){for(var path in this._tasks){paths=this.local._getInternals().pathsFromRoot(path);for(var i=1;i<paths.length;i++){if(this._tasks[paths[i]]){delete this._tasks[path]}}}},collectRefreshTasks:function(){return this.local.forAllNodes(function(node){var parentPath;if(this.needsRefresh(node)){try{parentPath=this.getParentPath(node.path)}catch(e){}if(parentPath&&this.access.checkPathPermission(parentPath,"r")){this.addTask(parentPath)}else if(this.access.checkPathPermission(node.path,"r")){this.addTask(node.path)}}}.bind(this)).then(function(){this.deleteChildPathsFromTasks()}.bind(this),function(err){throw err})},flush:function(nodes){for(var path in nodes){if(this.caching.checkPath(path)==="FLUSH"&&!nodes[path].local){RemoteStorage.log("[Sync] Flushing",path);nodes[path]=undefined}}return nodes},doTask:function(path){var promise=this.local.getNodes([path]).then(function(nodes){var node=nodes[path];if(typeof node==="undefined"){return taskFor("get",path,this.remote.get(path))}else if(isStaleChild(node)){return taskFor("get",path,this.remote.get(path))}else if(this.needsRemotePut(node)){node.push=this.local._getInternals().deepClone(node.local);node.push.timestamp=this.now();return this.local.setNodes(this.flush(nodes)).then(function(){var options;if(hasCommonRevision(node)){options={ifMatch:node.common.revision}}else{options={ifNoneMatch:"*"}}return taskFor("put",path,this.remote.put(path,node.push.body,node.push.contentType,options))}.bind(this))}else if(this.needsRemoteDelete(node)){node.push={body:false,timestamp:this.now()};return this.local.setNodes(this.flush(nodes)).then(function(){if(hasCommonRevision(node)){return taskFor("delete",path,this.remote.delete(path,{ifMatch:node.common.revision}))}else{return taskFor("get",path,this.remote.get(path))}}.bind(this))}else if(hasCommonRevision(node)){return taskFor("get",path,this.remote.get(path,{ifNoneMatch:node.common.revision}))}else{return taskFor("get",path,this.remote.get(path))}}.bind(this));return promise},autoMergeFolder:function(node){if(node.remote.itemsMap){node.common=node.remote;delete node.remote;if(node.common.itemsMap){for(var itemName in node.common.itemsMap){if(!node.local.itemsMap[itemName]){node.local.itemsMap[itemName]=false}}if(equalObj(node.local.itemsMap,node.common.itemsMap)){delete node.local}}}return node},autoMergeDocument:function(node){if(node.remote.body!==undefined){RemoteStorage.log("[Sync] Emitting keep/revert");this.local._emit("change",{origin:"conflict",path:node.path,oldValue:node.local.body,newValue:node.remote.body,oldContentType:node.local.contentType,newContentType:node.remote.contentType});node.common=node.remote;delete node.remote;delete node.local}delete node.push;return node},autoMerge:function(node){if(node.remote){if(node.local){if(isFolder(node.path)){return this.autoMergeFolder(node)}else{return this.autoMergeDocument(node)}}else{if(isFolder(node.path)){if(node.remote.itemsMap!==undefined){node.common=node.remote;delete node.remote}}else{if(node.remote.body!==undefined){this.local._emit("change",{origin:"remote",path:node.path,oldValue:node.common.body===false?undefined:node.common.body,newValue:node.remote.body===false?undefined:node.remote.body});node.common=node.remote;delete node.remote}}}}else{this.local._emit("change",{origin:"remote",path:node.path,oldValue:node.common.body===false?undefined:node.common.body,newValue:undefined});return undefined}return node},markChildren:function(path,itemsMap,changedNodes,missingChildren){var paths=[];var meta={};var recurse={};for(var item in itemsMap){paths.push(path+item);meta[path+item]=itemsMap[item]}for(var childName in missingChildren){paths.push(path+childName)}return this.local.getNodes(paths).then(function(nodes){var cachingStrategy;var node;nodeChanged=function(node,etag){return node.common.revision!==etag&&(!node.remote||node.remote.revision!==etag)};for(var nodePath in nodes){node=nodes[nodePath];if(meta[nodePath]){if(node&&node.common){if(nodeChanged(node,meta[nodePath].ETag)){changedNodes[nodePath]=this.local._getInternals().deepClone(node);changedNodes[nodePath].remote={revision:meta[nodePath].ETag,timestamp:this.now()};changedNodes[nodePath]=this.autoMerge(changedNodes[nodePath])}}else{cachingStrategy=this.caching.checkPath(nodePath);if(cachingStrategy==="ALL"){changedNodes[nodePath]={path:nodePath,common:{timestamp:this.now()},remote:{revision:meta[nodePath].ETag,timestamp:this.now()}}}}if(changedNodes[nodePath]&&meta[nodePath]["Content-Type"]){changedNodes[nodePath].remote.contentType=meta[nodePath]["Content-Type"]}if(changedNodes[nodePath]&&meta[nodePath]["Content-Length"]){changedNodes[nodePath].remote.contentLength=meta[nodePath]["Content-Length"]}}else if(missingChildren[nodePath.substring(path.length)]&&node&&node.common){if(node.common.itemsMap){for(var commonItem in node.common.itemsMap){recurse[nodePath+commonItem]=true}}if(node.local&&node.local.itemsMap){for(var localItem in node.local.itemsMap){recurse[nodePath+localItem]=true}}if(node.remote||isFolder(nodePath)){changedNodes[nodePath]=undefined}else{changedNodes[nodePath]=this.autoMerge(node);if(typeof changedNodes[nodePath]==="undefined"){var parentPath=this.getParentPath(nodePath);var parentNode=changedNodes[parentPath];var itemName=nodePath.substring(path.length);if(parentNode&&parentNode.local){delete parentNode.local.itemsMap[itemName];if(equalObj(parentNode.local.itemsMap,parentNode.common.itemsMap)){delete parentNode.local}}}}}}return this.deleteRemoteTrees(Object.keys(recurse),changedNodes).then(function(changedObjs2){return this.local.setNodes(this.flush(changedObjs2))}.bind(this))}.bind(this))},deleteRemoteTrees:function(paths,changedNodes){if(paths.length===0){return promising().fulfill(changedNodes)}this.local.getNodes(paths).then(function(nodes){var subPaths={};collectSubPaths=function(folder,path){if(folder&&folder.itemsMap){for(var itemName in folder.itemsMap){subPaths[path+itemName]=true}}};for(var path in nodes){var node=nodes[path];if(!node){continue}if(isFolder(path)){collectSubPaths(node.common,path);collectSubPaths(node.local,path)}else{if(node.common&&typeof node.common.body!==undefined){changedNodes[path]=this.local._getInternals().deepClone(node);changedNodes[path].remote={body:false,timestamp:this.now()};changedNodes[path]=this.autoMerge(changedNodes[path])}}}return this.deleteRemoteTrees(Object.keys(subPaths),changedNodes).then(function(changedNodes2){return this.local.setNodes(this.flush(changedNodes2))}.bind(this))}.bind(this))},completeFetch:function(path,bodyOrItemsMap,contentType,revision){var paths;var parentPath;var pathsFromRoot=this.local._getInternals().pathsFromRoot(path);if(!isFolder(path)){parentPath=pathsFromRoot[1];paths=[path,parentPath]}else{paths=[path]}var promise=this.local.getNodes(paths).then(function(nodes){var itemName;var missingChildren={};var node=nodes[path];var parentNode;collectMissingChildren=function(folder){if(folder&&folder.itemsMap){for(var itemName in folder.itemsMap){if(!bodyOrItemsMap[itemName]){missingChildren[itemName]=true}}}};if(typeof node!=="object"||node.path!==path||typeof node.common!=="object"){node={path:path,common:{}};nodes[path]=node}node.remote={revision:revision,timestamp:this.now()};if(isFolder(path)){collectMissingChildren(node.common);collectMissingChildren(node.remote);node.remote.itemsMap={};for(itemName in bodyOrItemsMap){node.remote.itemsMap[itemName]=true}}else{node.remote.body=bodyOrItemsMap;node.remote.contentType=contentType;parentNode=nodes[parentPath];if(parentNode&&parentNode.local&&parentNode.local.itemsMap){itemName=path.substring(parentPath.length);parentNode.local.itemsMap[itemName]=true;if(equalObj(parentNode.local.itemsMap,parentNode.common.itemsMap)){delete parentNode.local}}}nodes[path]=this.autoMerge(node);return{toBeSaved:nodes,missingChildren:missingChildren}}.bind(this));return promise},completePush:function(path,action,conflict,revision){var promise=this.local.getNodes([path]).then(function(nodes){var node=nodes[path];if(!node.push){this.stopped=true;throw new Error("completePush called but no push version!")}if(conflict){RemoteStorage.log("[Sync] We have a conflict");if(!node.remote||node.remote.revision!==revision){node.remote={revision:revision,timestamp:this.now()}}nodes[path]=this.autoMerge(node)}else{node.common={revision:revision,timestamp:this.now()};if(action==="put"){node.common.body=node.push.body;node.common.contentType=node.push.contentType;if(equal(node.local.body,node.push.body)&&node.local.contentType===node.push.contentType){delete node.local}delete node.push}else if(action==="delete"){if(node.local.body===false){nodes[path]=undefined}else{delete node.push}}}return this.local.setNodes(this.flush(nodes))}.bind(this));return promise},dealWithFailure:function(path,action,statusMeaning){return this.local.getNodes([path]).then(function(nodes){if(nodes[path]){delete nodes[path].push;return this.local.setNodes(this.flush(nodes))}}.bind(this))},interpretStatus:function(statusCode){if(statusCode==="offline"||statusCode==="timeout"){return{successful:false,networkProblems:true}}var series=Math.floor(statusCode/100);return{successful:series===2||statusCode===304||statusCode===412||statusCode===404,conflict:statusCode===412,unAuth:statusCode===401||statusCode===402||statusCode===403,notFound:statusCode===404,changed:statusCode!==304}},handleGetResponse:function(path,status,bodyOrItemsMap,contentType,revision){if(status.notFound){if(isFolder(path)){bodyOrItemsMap={}}else{bodyOrItemsMap=false}}if(status.changed){return this.completeFetch(path,bodyOrItemsMap,contentType,revision).then(function(dataFromFetch){if(isFolder(path)){if(this.corruptServerItemsMap(bodyOrItemsMap)){RemoteStorage.log("[Sync] WARNING: Discarding corrupt folder description from server for "+path);return false}else{return this.markChildren(path,bodyOrItemsMap,dataFromFetch.toBeSaved,dataFromFetch.missingChildren).then(function(){return true})}}else{return this.local.setNodes(this.flush(dataFromFetch.toBeSaved)).then(function(){return true})}}.bind(this))}else{return promising().fulfill(true)}},handleResponse:function(path,action,statusCode,bodyOrItemsMap,contentType,revision){var status=this.interpretStatus(statusCode);if(status.successful){if(action==="get"){return this.handleGetResponse(path,status,bodyOrItemsMap,contentType,revision)}else if(action==="put"||action==="delete"){return this.completePush(path,action,status.conflict,revision).then(function(){return true})}else{throw new Error("cannot handle response for unknown action",action)}}else{if(status.unAuth){remoteStorage._emit("error",new RemoteStorage.Unauthorized)}if(status.networkProblems){remoteStorage._emit("error",new RemoteStorage.SyncError("Sync error"))}return this.dealWithFailure(path,action,status).then(function(){return false})}},numThreads:10,finishTask:function(task){if(task.action===undefined){delete this._running[task.path];return}task.promise.then(function(status,bodyOrItemsMap,contentType,revision){return this.handleResponse(task.path,task.action,status,bodyOrItemsMap,contentType,revision)}.bind(this),function(err){RemoteStorage.log("[Sync] wireclient rejects its promise!",task.path,task.action,err);return this.handleResponse(task.path,task.action,"offline")}.bind(this)).then(function(completed){delete this._timeStarted[task.path];delete this._running[task.path];if(completed){if(this._tasks[task.path]){for(i=0;i<this._tasks[task.path].length;i++){this._tasks[task.path][i]()}delete this._tasks[task.path]}}this._emit("req-done");this.collectTasks(false).then(function(){if(!this.hasTasks()||this.stopped){RemoteStorage.log("[Sync] Sync is done! Reschedule?",Object.getOwnPropertyNames(this._tasks).length,this.stopped);if(!this.done){this.done=true;this._emit("done")}}else{setTimeout(function(){this.doTasks()}.bind(this),10)}}.bind(this))}.bind(this),function(err){RemoteStorage.log("[Sync] Error",err);this.remote.online=false;delete this._timeStarted[task.path];delete this._running[task.path];this._emit("req-done");if(!this.stopped){setTimeout(function(){this.doTasks()}.bind(this),0)}}.bind(this))},doTasks:function(){var numToHave,numAdded=0,numToAdd,path;if(this.remote.connected){if(this.remote.online){numToHave=this.numThreads}else{numToHave=1}}else{numToHave=0}numToAdd=numToHave-Object.getOwnPropertyNames(this._running).length;if(numToAdd<=0){return true}for(path in this._tasks){if(!this._running[path]){this._timeStarted=this.now();this._running[path]=this.doTask(path);this._running[path].then(this.finishTask.bind(this));numAdded++;if(numAdded>=numToAdd){return true}}}return numAdded>=numToAdd},collectTasks:function(alsoCheckRefresh){if(this.hasTasks()||this.stopped){promise=promising();promise.fulfill();return promise}return this.collectDiffTasks().then(function(numDiffs){if(numDiffs||alsoCheckRefresh===false){promise=promising();promise.fulfill();return promise}else{return this.collectRefreshTasks()}}.bind(this),function(err){throw err})},addTask:function(path,cb){if(!this._tasks[path]){this._tasks[path]=[]}if(typeof cb==="function"){this._tasks[path].push(cb)}},sync:function(){var promise=promising();this.done=false;if(!this.doTasks()){return this.collectTasks().then(function(){try{this.doTasks()}catch(e){RemoteStorage.log("[Sync] doTasks error",e)}}.bind(this),function(e){RemoteStorage.log("[Sync] Sync error",e);throw new Error("Local cache unavailable")})}else{return promising().fulfill()}}};RemoteStorage.prototype.getSyncInterval=function(){return syncInterval};RemoteStorage.prototype.setSyncInterval=function(interval){if(typeof interval!=="number"){throw interval+" is not a valid sync interval"}syncInterval=parseInt(interval,10);if(this._syncTimer){this.stopSync();this._syncTimer=setTimeout(this.syncCycle.bind(this),interval)}};var SyncError=function(originalError){var msg="Sync failed: ";if(typeof originalError==="object"&&"message"in originalError){msg+=originalError.message}else{msg+=originalError}this.originalError=originalError;Error.apply(this,[msg])};SyncError.prototype=Object.create(Error.prototype);RemoteStorage.SyncError=SyncError;RemoteStorage.prototype.syncCycle=function(){if(this.sync.stopped){return}this.sync.on("done",function(){RemoteStorage.log("[Sync] Sync done. Setting timer to",this.getSyncInterval());if(!this.sync.stopped){if(this._syncTimer){clearTimeout(this._syncTimer)}this._syncTimer=setTimeout(this.sync.sync.bind(this.sync),this.getSyncInterval())}}.bind(this));this.sync.sync()};RemoteStorage.prototype.stopSync=function(){if(this.sync){RemoteStorage.log("[Sync] Stopping sync");this.sync.stopped=true}else{RemoteStorage.log("[Sync] Will instantiate sync stopped");this.syncStopped=true}};RemoteStorage.prototype.startSync=function(){this.sync.stopped=false;this.syncStopped=false;this.sync.sync()};var syncCycleCb;RemoteStorage.Sync._rs_init=function(remoteStorage){syncCycleCb=function(){RemoteStorage.log("[Sync] syncCycleCb calling syncCycle");if(!remoteStorage.sync){remoteStorage.sync=new RemoteStorage.Sync(remoteStorage.local,remoteStorage.remote,remoteStorage.access,remoteStorage.caching);if(remoteStorage.syncStopped){RemoteStorage.log("[Sync] Instantiating sync stopped");remoteStorage.sync.stopped=true;delete remoteStorage.syncStopped}}RemoteStorage.log("[Sync] syncCycleCb calling syncCycle");remoteStorage.syncCycle()};remoteStorage.on("ready",syncCycleCb)};RemoteStorage.Sync._rs_cleanup=function(remoteStorage){remoteStorage.stopSync();remoteStorage.removeEventListener("ready",syncCycleCb)}})(typeof window!=="undefined"?window:global);(function(){function isFolder(path){return path.substr(-1)==="/"}function isDocument(path){return path.substr(-1)!=="/"}function deepClone(obj){if(obj===undefined){return undefined}else{return JSON.parse(JSON.stringify(obj))}}function equal(obj1,obj2){return JSON.stringify(obj1)===JSON.stringify(obj2)}function getLatest(node){if(typeof node!=="object"||typeof node.path!=="string"){return}if(isFolder(node.path)){if(node.local&&node.local.itemsMap){return node.local}if(node.common&&node.common.itemsMap){return node.common}}else{if(node.local&&node.local.body&&node.local.contentType){return node.local}if(node.common&&node.common.body&&node.common.contentType){return node.common}if(node.body&&node.contentType){return{body:node.body,contentType:node.contentType}}}}function isOutdated(node,maxAge){return!node||!node.timestamp||(new Date).getTime()-node.timestamp>maxAge}function pathsFromRoot(path){var paths=[path];var parts=path.replace(/\/$/,"").split("/");while(parts.length>1){parts.pop();paths.push(parts.join("/")+"/")}return paths}function makeNode(path,timestamp){var node={path:path,common:{timestamp:timestamp}};if(isFolder(path)){node.common.itemsMap={}}return node}function updateFolderNodeWithItemName(node,itemName,timestamp){if(!node.common){node.common={timestamp:timestamp,itemsMap:{}}}if(!node.common.itemsMap){node.common.itemsMap={}}if(!node.local){node.local=deepClone(node.common)}if(!node.local.itemsMap){node.local.itemsMap=node.common.itemsMap}node.local.itemsMap[itemName]=true;return node}var methods={get:function(path,maxAge){var promise=promising();this.getNodes([path]).then(function(objs){var node=getLatest(objs[path]);if(typeof maxAge==="number"&&isOutdated(node,maxAge)){remoteStorage.sync.queueGetRequest(path,promise)}if(node){promise.fulfill(200,node.body||node.itemsMap,node.contentType)}else{promise.fulfill(404)}}.bind(this),function(err){promise.reject(err)}.bind(this));return promise},put:function(path,body,contentType){var paths=pathsFromRoot(path);var now=(new Date).getTime();return this._updateNodes(paths,function(nodes){try{for(var i=0;i<paths.length;i++){var path=paths[i];var node=nodes[path];var previous;if(!node){nodes[path]=node=makeNode(path,now)}if(i===0){previous=getLatest(node);node.local={body:body,contentType:contentType,timestamp:now,previousBody:previous?previous.body:undefined,previousContentType:previous?previous.contentType:undefined}}else{var itemName=paths[i-1].substring(path.length);node=updateFolderNodeWithItemName(node,itemName,now)}}return nodes}catch(e){RemoteStorage.log("[Cachinglayer] Error during PUT",nodes,i,e);throw e}})},delete:function(path){var paths=pathsFromRoot(path);return this._updateNodes(paths,function(nodes){var now=(new Date).getTime();for(var i=0;i<paths.length;i++){var path=paths[i];var node=nodes[path];if(!node){throw new Error("Cannot delete non-existing node "+path)}if(i===0){previous=getLatest(node);node.local={body:false,timestamp:now,previousBody:previous?previous.body:undefined,previousContentType:previous?previous.contentType:undefined}}else{if(!node.local){node.local=deepClone(node.common)}var itemName=paths[i-1].substring(path.length);delete node.local.itemsMap[itemName];if(Object.getOwnPropertyNames(node.local.itemsMap).length>0){break}}}return nodes})},flush:function(path){return this._getAllDescendentPaths(path).then(function(paths){return this.getNodes(paths)}.bind(this)).then(function(nodes){for(var path in nodes){var node=nodes[path];if(node&&node.common&&node.local){this._emit("change",{path:node.path,origin:"local",oldValue:node.local.body===false?undefined:node.local.body,newValue:node.common.body===false?undefined:node.common.body})}nodes[path]=undefined}return this.setNodes(nodes)}.bind(this))},fireInitial:function(){this.forAllNodes(function(node){var latest;if(isDocument(node.path)){latest=getLatest(node);if(latest){this._emit("change",{path:node.path,origin:"local",oldValue:undefined,oldContentType:undefined,newValue:latest.body,newContentType:latest.contentType})}}}.bind(this))},onDiff:function(diffHandler){this.diffHandler=diffHandler},migrate:function(node){if(typeof node==="object"&&!node.common){node.common={};if(typeof node.path==="string"){if(node.path.substr(-1)==="/"&&typeof node.body==="object"){node.common.itemsMap=node.body}}else{if(!node.local){node.local={}}node.local.body=node.body;node.local.contentType=node.contentType}}return node},_updateNodes:function(paths,cb){var self=this;return this.getNodes(paths).then(function(nodes){var existingNodes=deepClone(nodes);var changeEvents=[];var node;nodes=cb(nodes);for(var path in nodes){node=nodes[path];if(equal(node,existingNodes[path])){delete nodes[path]}else if(isDocument(path)){changeEvents.push({path:path,origin:"window",oldValue:node.local.previousBody,newValue:node.local.body===false?undefined:node.local.body,oldContentType:node.local.previousContentType,newContentType:node.local.contentType});delete node.local.previousBody;delete node.local.previousContentType}}return self.setNodes(nodes).then(function(){self._emitChangeEvents(changeEvents);return 200})},function(err){throw err})},_emitChangeEvents:function(events){for(var i=0;i<events.length;i++){this._emit("change",events[i]);if(this.diffHandler){this.diffHandler(events[i].path)}}},_getAllDescendentPaths:function(path){if(isFolder(path)){return this.getNodes([path]).then(function(nodes){var pending=0;var allPaths=[path];var latest=getLatest(nodes[path]);var promise=promising();for(var itemName in latest.itemsMap){pending++;this._getAllDescendentPaths(path+itemName).then(function(paths){pending--;for(var i=0;i<paths.length;i++){allPaths.push(paths[i])}if(pending===0){promise.fulfill(allPaths)}})}return promise}.bind(this))}else{return promising().fulfill([path])}},_getInternals:function(){return{isFolder:isFolder,isDocument:isDocument,deepClone:deepClone,equal:equal,getLatest:getLatest,pathsFromRoot:pathsFromRoot,makeNode:makeNode}}};RemoteStorage.cachingLayer=function(object){for(var key in methods){object[key]=methods[key]}}})();(function(global){var RS=RemoteStorage;var DB_VERSION=2;var DEFAULT_DB_NAME="remotestorage";var DEFAULT_DB;RS.IndexedDB=function(database){this.db=database||DEFAULT_DB;if(!this.db){RemoteStorage.log("[IndexedDB] Failed to open DB");return undefined}RS.cachingLayer(this);RS.eventHandling(this,"change");this.getsRunning=0;this.putsRunning=0};RS.IndexedDB.prototype={getNodes:function(paths){var promise=promising();var transaction=this.db.transaction(["nodes"],"readonly");var nodes=transaction.objectStore("nodes");var retrievedNodes={};var startTime=(new Date).getTime();this.getsRunning++;for(var i=0;i<paths.length;i++){(function(index){var path=paths[index];nodes.get(path).onsuccess=function(evt){retrievedNodes[path]=evt.target.result}})(i)}transaction.oncomplete=function(){promise.fulfill(retrievedNodes);this.getsRunning--}.bind(this);transaction.onerror=transaction.onabort=function(){promise.reject("get transaction error/abort");this.getsRunning--}.bind(this);return promise},setNodes:function(nodes){var promise=promising();var transaction=this.db.transaction(["nodes"],"readwrite");var nodesStore=transaction.objectStore("nodes");var startTime=(new Date).getTime();this.putsRunning++;RemoteStorage.log("[IndexedDB] Starting put",nodes,this.putsRunning);for(var path in nodes){var node=nodes[path];if(typeof node==="object"){try{nodesStore.put(node)}catch(e){RemoteStorage.log("[IndexedDB] Error while putting",node,e);throw e}}else{try{nodesStore.delete(path)}catch(e){RemoteStorage.log("[IndexedDB] Error while removing",nodesStore,node,e);throw e}}}transaction.oncomplete=function(){promise.fulfill();this.putsRunning--;RemoteStorage.log("[IndexedDB] Finished put",nodes,this.putsRunning,(new Date).getTime()-startTime+"ms")}.bind(this);transaction.onerror=function(){promise.reject("transaction error");this.putsRunning--}.bind(this);transaction.onabort=function(){promise.reject("transaction abort");this.putsRunning--}.bind(this);return promise},reset:function(callback){var dbName=this.db.name;var self=this;this.db.close();RS.IndexedDB.clean(this.db.name,function(){RS.IndexedDB.open(dbName,function(err,other){if(err){RemoteStorage.log("[IndexedDB] Error while resetting local storage",err)}else{self.db=other}if(typeof callback==="function"){callback(self)}})})},forAllNodes:function(cb){var promise=promising();var transaction=this.db.transaction(["nodes"],"readonly");var cursorReq=transaction.objectStore("nodes").openCursor();cursorReq.onsuccess=function(evt){var cursor=evt.target.result;if(cursor){cb(this.migrate(cursor.value));cursor.continue()}else{promise.fulfill()}}.bind(this);return promise},closeDB:function(){this.db.close()}};RS.IndexedDB.open=function(name,callback){var timer=setTimeout(function(){callback("timeout trying to open db")},1e4);var req=indexedDB.open(name,DB_VERSION);req.onerror=function(){RemoteStorage.log("[IndexedDB] Opening DB failed",req);clearTimeout(timer);callback(req.error)};req.onupgradeneeded=function(event){var db=req.result;RemoteStorage.log("[IndexedDB] Upgrade: from ",event.oldVersion," to ",event.newVersion);if(event.oldVersion!==1){RemoteStorage.log("[IndexedDB] Creating object store: nodes");db.createObjectStore("nodes",{keyPath:"path"})}RemoteStorage.log("[IndexedDB] Creating object store: changes");db.createObjectStore("changes",{keyPath:"path"})};req.onsuccess=function(){clearTimeout(timer);callback(null,req.result)}};RS.IndexedDB.clean=function(databaseName,callback){var req=indexedDB.deleteDatabase(databaseName);req.onsuccess=function(){RemoteStorage.log("[IndexedDB] Done removing DB");callback()};req.onerror=req.onabort=function(evt){console.error('Failed to remove database "'+databaseName+'"',evt)}};RS.IndexedDB._rs_init=function(remoteStorage){var promise=promising();RS.IndexedDB.open(DEFAULT_DB_NAME,function(err,db){if(err){promise.reject(err)}else{DEFAULT_DB=db;db.onerror=function(){remoteStorage._emit("error",err)};promise.fulfill()}});return promise};RS.IndexedDB._rs_supported=function(){var promise=promising();if("indexedDB"in global){try{var check=indexedDB.open("rs-check");check.onerror=function(event){promise.reject()};check.onsuccess=function(event){indexedDB.deleteDatabase("rs-check");promise.fulfill()}}catch(e){promise.reject()}}else{promise.reject()}return promise};RS.IndexedDB._rs_cleanup=function(remoteStorage){var promise=promising();if(remoteStorage.local){remoteStorage.local.closeDB()}RS.IndexedDB.clean(DEFAULT_DB_NAME,function(){promise.fulfill()});return promise}})(typeof window!=="undefined"?window:global);(function(global){var NODES_PREFIX="remotestorage:cache:nodes:";var CHANGES_PREFIX="remotestorage:cache:changes:";RemoteStorage.LocalStorage=function(){RemoteStorage.cachingLayer(this);RemoteStorage.log("[LocalStorage] Registering events");RemoteStorage.eventHandling(this,"change")};function b64ToUint6(nChr){return nChr>64&&nChr<91?nChr-65:nChr>96&&nChr<123?nChr-71:nChr>47&&nChr<58?nChr+4:nChr===43?62:nChr===47?63:0}function base64DecToArr(sBase64,nBlocksSize){var sB64Enc=sBase64.replace(/[^A-Za-z0-9\+\/]/g,""),nInLen=sB64Enc.length,nOutLen=nBlocksSize?Math.ceil((nInLen*3+1>>2)/nBlocksSize)*nBlocksSize:nInLen*3+1>>2,taBytes=new Uint8Array(nOutLen);for(var nMod3,nMod4,nUint24=0,nOutIdx=0,nInIdx=0;nInIdx<nInLen;nInIdx++){nMod4=nInIdx&3;nUint24|=b64ToUint6(sB64Enc.charCodeAt(nInIdx))<<18-6*nMod4;if(nMod4===3||nInLen-nInIdx===1){for(nMod3=0;nMod3<3&&nOutIdx<nOutLen;nMod3++,nOutIdx++){taBytes[nOutIdx]=nUint24>>>(16>>>nMod3&24)&255}nUint24=0}}return taBytes}function isBinary(node){return node.match(/charset=binary/)}function isRemoteStorageKey(key){return key.substr(0,NODES_PREFIX.length)===NODES_PREFIX||key.substr(0,CHANGES_PREFIX.length)===CHANGES_PREFIX}function isNodeKey(key){return key.substr(0,NODES_PREFIX.length)===NODES_PREFIX}RemoteStorage.LocalStorage.prototype={getNodes:function(paths){var promise=promising();var nodes={};for(i=0;i<paths.length;i++){try{nodes[paths[i]]=JSON.parse(localStorage[NODES_PREFIX+paths[i]])}catch(e){nodes[paths[i]]=undefined}}promise.fulfill(nodes);return promise},setNodes:function(nodes){var promise=promising();for(var path in nodes){localStorage[NODES_PREFIX+path]=JSON.stringify(nodes[path])}promise.fulfill();return promise},forAllNodes:function(cb){var node;for(var i=0;i<localStorage.length;i++){if(isNodeKey(localStorage.key(i))){try{node=this.migrate(JSON.parse(localStorage[localStorage.key(i)]))}catch(e){node=undefined}if(node){cb(node)}}}return promising().fulfill()}};RemoteStorage.LocalStorage._rs_init=function(){};RemoteStorage.LocalStorage._rs_supported=function(){return"localStorage"in global};RemoteStorage.LocalStorage._rs_cleanup=function(){var keys=[];for(var i=0;i<localStorage.length;i++){var key=localStorage.key(i);if(isRemoteStorageKey(key)){keys.push(key)}}keys.forEach(function(key){RemoteStorage.log("[LocalStorage] Removing",key);delete localStorage[key]})}})(typeof window!=="undefined"?window:global);(function(global){RemoteStorage.InMemoryStorage=function(){RemoteStorage.cachingLayer(this);RemoteStorage.log("[InMemoryStorage] Registering events");RemoteStorage.eventHandling(this,"change");this._storage={}};RemoteStorage.InMemoryStorage.prototype={getNodes:function(paths){var promise=promising();var nodes={};for(i=0;i<paths.length;i++){nodes[paths[i]]=this._storage[paths[i]]}promise.fulfill(nodes);return promise},setNodes:function(nodes){var promise=promising();for(var path in nodes){if(nodes[path]===undefined){delete this._storage[path]}else{this._storage[path]=nodes[path]}}promise.fulfill();return promise},forAllNodes:function(cb){for(var path in this._storage){cb(this.migrate(this._storage[path]))}return promising().fulfill()
}};RemoteStorage.InMemoryStorage._rs_init=function(){};RemoteStorage.InMemoryStorage._rs_supported=function(){return true};RemoteStorage.InMemoryStorage._rs_cleanup=function(){}})(typeof window!=="undefined"?window:global);(function(){RemoteStorage.MODULES={};RemoteStorage.defineModule=function(moduleName,builder){RemoteStorage.MODULES[moduleName]=builder;Object.defineProperty(RemoteStorage.prototype,moduleName,{configurable:true,get:function(){var instance=this._loadModule(moduleName);Object.defineProperty(this,moduleName,{value:instance});return instance}});if(moduleName.indexOf("-")!==-1){var camelizedName=moduleName.replace(/\-[a-z]/g,function(s){return s[1].toUpperCase()});Object.defineProperty(RemoteStorage.prototype,camelizedName,{get:function(){return this[moduleName]}})}};RemoteStorage.prototype._loadModule=function(moduleName){var builder=RemoteStorage.MODULES[moduleName];if(builder){var module=builder(new RemoteStorage.BaseClient(this,"/"+moduleName+"/"),new RemoteStorage.BaseClient(this,"/public/"+moduleName+"/"));return module.exports}else{throw"Unknown module: "+moduleName}};RemoteStorage.prototype.defineModule=function(moduleName){console.log("remoteStorage.defineModule is deprecated, use RemoteStorage.defineModule instead!");RemoteStorage.defineModule.apply(RemoteStorage,arguments)}})();(function(){function loadTable(table,storage,paths){table.setAttribute("border","1");table.style.margin="8px";table.innerHTML="";var thead=document.createElement("thead");table.appendChild(thead);var titleRow=document.createElement("tr");thead.appendChild(titleRow);["Path","Content-Type","Revision"].forEach(function(label){var th=document.createElement("th");th.textContent=label;thead.appendChild(th)});var tbody=document.createElement("tbody");table.appendChild(tbody);function renderRow(tr,path,contentType,revision){[path,contentType,revision].forEach(function(value){var td=document.createElement("td");td.textContent=value||"";tr.appendChild(td)})}function loadRow(path){if(storage.connected===false){return}function processRow(status,body,contentType,revision){if(status===200){var tr=document.createElement("tr");tbody.appendChild(tr);renderRow(tr,path,contentType,revision);if(path[path.length-1]==="/"){for(var key in body){loadRow(path+key)}}}}storage.get(path).then(processRow)}paths.forEach(loadRow)}function renderWrapper(title,table,storage,paths){var wrapper=document.createElement("div");var heading=document.createElement("h2");heading.textContent=title;wrapper.appendChild(heading);var updateButton=document.createElement("button");updateButton.textContent="Refresh";updateButton.onclick=function(){loadTable(table,storage,paths)};wrapper.appendChild(updateButton);if(storage.reset){var resetButton=document.createElement("button");resetButton.textContent="Reset";resetButton.onclick=function(){storage.reset(function(newStorage){storage=newStorage;loadTable(table,storage,paths)})};wrapper.appendChild(resetButton)}wrapper.appendChild(table);loadTable(table,storage,paths);return wrapper}function renderLocalChanges(local){var wrapper=document.createElement("div");var heading=document.createElement("h2");heading.textContent="Outgoing changes";wrapper.appendChild(heading);var updateButton=document.createElement("button");updateButton.textContent="Refresh";wrapper.appendChild(updateButton);var list=document.createElement("ul");list.style.fontFamily="courier";wrapper.appendChild(list);function updateList(){local.changesBelow("/").then(function(changes){list.innerHTML="";changes.forEach(function(change){var el=document.createElement("li");el.textContent=JSON.stringify(change);list.appendChild(el)})})}updateButton.onclick=updateList;updateList();return wrapper}RemoteStorage.prototype.inspect=function(){var widget=document.createElement("div");widget.id="remotestorage-inspect";widget.style.position="absolute";widget.style.top=0;widget.style.left=0;widget.style.background="black";widget.style.color="white";widget.style.border="groove 5px #ccc";var controls=document.createElement("div");controls.style.position="absolute";controls.style.top=0;controls.style.left=0;var heading=document.createElement("strong");heading.textContent=" remotestorage.js inspector ";controls.appendChild(heading);var syncButton;if(this.local){syncButton=document.createElement("button");syncButton.textContent="Synchronize";controls.appendChild(syncButton)}var closeButton=document.createElement("button");closeButton.textContent="Close";closeButton.onclick=function(){document.body.removeChild(widget)};controls.appendChild(closeButton);widget.appendChild(controls);var remoteTable=document.createElement("table");var localTable=document.createElement("table");widget.appendChild(renderWrapper("Remote",remoteTable,this.remote,this.caching.rootPaths));if(this.local){widget.appendChild(renderWrapper("Local",localTable,this.local,["/"]));widget.appendChild(renderLocalChanges(this.local));syncButton.onclick=function(){this.log("sync clicked");this.sync().then(function(){this.log("SYNC FINISHED");loadTable(localTable,this.local,["/"])}.bind(this),function(err){console.error("SYNC FAILED",err,err.stack)})}.bind(this)}document.body.appendChild(widget)}})();(function(){var util={getEventEmitter:function(){var object={};var args=Array.prototype.slice.call(arguments);args.unshift(object);RemoteStorage.eventHandling.apply(RemoteStorage,args);object.emit=object._emit;return object},extend:function(target){var sources=Array.prototype.slice.call(arguments,1);sources.forEach(function(source){for(var key in source){target[key]=source[key]}});return target},asyncEach:function(array,callback){return this.asyncMap(array,callback).then(function(){return array})},asyncMap:function(array,callback){var promise=promising();var n=array.length,i=0;var results=[],errors=[];function oneDone(){i++;if(i===n){promise.fulfill(results,errors)}}array.forEach(function(item,index){var result;try{result=callback(item)}catch(exc){oneDone();errors[index]=exc}if(typeof result==="object"&&typeof result.then==="function"){result.then(function(res){results[index]=res;oneDone()},function(error){errors[index]=res;oneDone()})}else{oneDone();results[index]=result}});return promise},containingFolder:function(path){var folder=path.replace(/[^\/]+\/?$/,"");return folder===path?null:folder},isFolder:function(path){return path.substr(-1)==="/"},baseName:function(path){var parts=path.split("/");if(util.isFolder(path)){return parts[parts.length-2]+"/"}else{return parts[parts.length-1]}},bindAll:function(object){for(var key in this){if(typeof object[key]==="function"){object[key]=object[key].bind(object)}}}};Object.defineProperty(RemoteStorage.prototype,"util",{get:function(){console.log("DEPRECATION WARNING: remoteStorage.util is deprecated and will be removed with the next major release.");return util}})})();(function(global){var RS=RemoteStorage;var BASE_URL="https://www.googleapis.com";var AUTH_URL="https://accounts.google.com/o/oauth2/auth";var AUTH_SCOPE="https://www.googleapis.com/auth/drive";var GD_DIR_MIME_TYPE="application/vnd.google-apps.folder";var RS_DIR_MIME_TYPE="application/json; charset=UTF-8";function buildQueryString(params){return Object.keys(params).map(function(key){return encodeURIComponent(key)+"="+encodeURIComponent(params[key])}).join("&")}function fileNameFromMeta(meta){return encodeURIComponent(meta.title)+(meta.mimeType===GD_DIR_MIME_TYPE?"/":"")}function metaTitleFromFileName(filename){if(filename.substr(-1)==="/"){filename=filename.substr(0,filename.length-1)}return decodeURIComponent(filename)}function parentPath(path){return path.replace(/[^\/]+\/?$/,"")}function baseName(path){var parts=path.split("/");if(path.substr(-1)==="/"){return parts[parts.length-2]+"/"}else{return parts[parts.length-1]}}var Cache=function(maxAge){this.maxAge=maxAge;this._items={}};Cache.prototype={get:function(key){var item=this._items[key];var now=(new Date).getTime();return item&&item.t>=now-this.maxAge?item.v:undefined},set:function(key,value){this._items[key]={v:value,t:(new Date).getTime()}}};RS.GoogleDrive=function(remoteStorage,clientId){RS.eventHandling(this,"connected");this.rs=remoteStorage;this.clientId=clientId;this._fileIdCache=new Cache(60*5);setTimeout(function(){this.configure(undefined,undefined,undefined,localStorage["remotestorage:googledrive:token"])}.bind(this),0)};RS.GoogleDrive.prototype={configure:function(_x,_y,_z,token){if(token){localStorage["remotestorage:googledrive:token"]=token;this.token=token;this.connected=true;this._emit("connected")}else{this.connected=false;delete this.token;delete localStorage["remotestorage:googledrive:token"]}},connect:function(){this.rs.setBackend("googledrive");RS.Authorize(AUTH_URL,AUTH_SCOPE,String(RS.Authorize.getLocation()),this.clientId)},get:function(path,options){if(path.substr(-1)==="/"){return this._getFolder(path,options)}else{return this._getFile(path,options)}},put:function(path,body,contentType,options){var promise=promising();function putDone(error,response){if(error){promise.reject(error)}else if(response.status>=200&&response.status<300){var meta=JSON.parse(response.responseText);promise.fulfill(200,undefined,meta.mimeType,meta.etag)}else{promise.reject("PUT failed with status "+response.status+" ("+response.responseText+")")}}this._getFileId(path,function(idError,id){if(idError){promise.reject(idError);return}else if(id){this._updateFile(id,path,body,contentType,options,putDone)}else{this._createFile(path,body,contentType,options,putDone)}});return promise},delete:function(path,options){var promise=promising();this._getFileId(path,function(idError,id){if(idError){promise.reject(idError)}else if(id){this._request("DELETE",BASE_URL+"/drive/v2/files/"+id,{},function(deleteError,response){if(deleteError){promise.reject(deleteError)}else if(response.status===200||response.status===204){promise.fulfill(200)}else{promise.reject("Delete failed: "+response.status+" ("+response.responseText+")")}})}else{promise.fulfill(200)}});return promise},_updateFile:function(id,path,body,contentType,options,callback){callback=callback.bind(this);var metadata={mimeType:contentType};this._request("PUT",BASE_URL+"/upload/drive/v2/files/"+id+"?uploadType=resumable",{body:JSON.stringify(metadata),headers:{"Content-Type":"application/json; charset=UTF-8"}},function(metadataError,response){if(metadataError){callback(metadataError)}else{this._request("PUT",response.getResponseHeader("Location"),{body:contentType.match(/^application\/json/)?JSON.stringify(body):body},callback)}})},_createFile:function(path,body,contentType,options,callback){callback=callback.bind(this);this._getParentId(path,function(parentIdError,parentId){if(parentIdError){callback(parentIdError);return}var fileName=baseName(path);var metadata={title:metaTitleFromFileName(fileName),mimeType:contentType,parents:[{kind:"drive#fileLink",id:parentId}]};this._request("POST",BASE_URL+"/upload/drive/v2/files?uploadType=resumable",{body:JSON.stringify(metadata),headers:{"Content-Type":"application/json; charset=UTF-8"}},function(metadataError,response){if(metadataError){callback(metadataError)}else{this._request("POST",response.getResponseHeader("Location"),{body:contentType.match(/^application\/json/)?JSON.stringify(body):body},callback)}})})},_getFile:function(path,options){var promise=promising();this._getFileId(path,function(idError,id){if(idError){promise.reject(idError)}else{this._getMeta(id,function(metaError,meta){var etagWithoutQuotes;if(typeof meta==="object"&&typeof meta.etag==="string"){etagWithoutQuotes=meta.etag.substring(1,meta.etag.length-1)}if(metaError){promise.reject(metaError)}else if(meta.downloadUrl){var options={};if(meta.mimeType.match(/charset=binary/)){options.responseType="blob"}this._request("GET",meta.downloadUrl,options,function(downloadError,response){if(downloadError){promise.reject(downloadError)}else{var body=response.response;if(meta.mimeType.match(/^application\/json/)){try{body=JSON.parse(body)}catch(e){}}promise.fulfill(200,body,meta.mimeType,etagWithoutQuotes)}})}else{promise.fulfill(200,"",meta.mimeType,etagWithoutQuotes)}})}});return promise},_getFolder:function(path,options){var promise=promising();this._getFileId(path,function(idError,id){var query,fields,data,i,etagWithoutQuotes,itemsMap;if(idError){promise.reject(idError)}else if(!id){promise.fulfill(404)}else{query="'"+id+"' in parents";fields="items(downloadUrl,etag,fileSize,id,mimeType,title)";this._request("GET",BASE_URL+"/drive/v2/files?"+"q="+encodeURIComponent(query)+"&fields="+encodeURIComponent(fields)+"&maxResults=1000",{},function(childrenError,response){if(childrenError){promise.reject(childrenError)}else{if(response.status===200){try{data=JSON.parse(response.responseText)}catch(e){promise.reject("non-JSON response from GoogleDrive");return}itemsMap={};for(i=0;i<data.items.length;i++){etagWithoutQuotes=data.items[i].etag.substring(1,data.items[i].etag.length-1);if(data.items[i].mimeType===GD_DIR_MIME_TYPE){this._fileIdCache.set(path+data.items[i].title+"/",data.items[i].id);itemsMap[data.items[i].title+"/"]={ETag:etagWithoutQuotes}}else{this._fileIdCache.set(path+data.items[i].title,data.items[i].id);itemsMap[data.items[i].title]={ETag:etagWithoutQuotes,"Content-Type":data.items[i].mimeType,"Content-Length":data.items[i].fileSize}}}promise.fulfill(200,itemsMap,RS_DIR_MIME_TYPE,undefined)}else{promise.reject("request failed or something: "+response.status)}}})}});return promise},_getParentId:function(path,callback){callback=callback.bind(this);var foldername=parentPath(path);this._getFileId(foldername,function(idError,parentId){if(idError){callback(idError)}else if(parentId){callback(null,parentId)}else{this._createFolder(foldername,callback)}})},_createFolder:function(path,callback){callback=callback.bind(this);this._getParentId(path,function(idError,parentId){if(idError){callback(idError)}else{this._request("POST",BASE_URL+"/drive/v2/files",{body:JSON.stringify({title:metaTitleFromFileName(baseName(path)),mimeType:GD_DIR_MIME_TYPE,parents:[{id:parentId}]}),headers:{"Content-Type":"application/json; charset=UTF-8"}},function(createError,response){if(createError){callback(createError)}else{var meta=JSON.parse(response.responseText);callback(null,meta.id)}})}})},_getFileId:function(path,callback){callback=callback.bind(this);var id;if(path==="/"){callback(null,"root")}else if(id=this._fileIdCache.get(path)){callback(null,id)}else{this._getFolder(parentPath(path)).then(function(){var id=this._fileIdCache.get(path);if(!id){callback("no file or folder found at the path: "+path,null);return}callback(null,id)}.bind(this),callback)}},_getMeta:function(id,callback){callback=callback.bind(this);this._request("GET",BASE_URL+"/drive/v2/files/"+id,{},function(err,response){if(err){callback(err)}else{if(response.status===200){callback(null,JSON.parse(response.responseText))}else{callback("request (getting metadata for "+id+") failed with status: "+response.status)}}})},_request:function(method,url,options,callback){callback=callback.bind(this);if(!options.headers){options.headers={}}options.headers["Authorization"]="Bearer "+this.token;RS.WireClient.request.call(this,method,url,options,function(err,xhr){if(xhr&&xhr.status===401){this.connect();return}callback(err,xhr)})}};RS.GoogleDrive._rs_init=function(remoteStorage){var config=remoteStorage.apiKeys.googledrive;if(config){remoteStorage.googledrive=new RS.GoogleDrive(remoteStorage,config.client_id);if(remoteStorage.backend==="googledrive"){remoteStorage._origRemote=remoteStorage.remote;remoteStorage.remote=remoteStorage.googledrive}}};RS.GoogleDrive._rs_supported=function(rs){return true};RS.GoogleDrive._rs_cleanup=function(remoteStorage){remoteStorage.setBackend(undefined);if(remoteStorage._origRemote){remoteStorage.remote=remoteStorage._origRemote;delete remoteStorage._origRemote}}})(this);(function(global){var RS=RemoteStorage;var hasLocalStorage;var AUTH_URL="https://www.dropbox.com/1/oauth2/authorize";var SETTINGS_KEY="remotestorage:dropbox";var cleanPath=RS.WireClient.cleanPath;function LowerCaseCache(defaultValue){this.defaultValue=defaultValue;this._storage={};this.set=this.justSet;this.delete=this.justDelete}LowerCaseCache.prototype={get:function(key){key=key.toLowerCase();var stored=this._storage[key];if(typeof stored==="undefined"){stored=this.defaultValue;this._storage[key]=stored}return stored},propagateSet:function(key,value){key=key.toLowerCase();if(this._storage[key]===value){return value}this._propagate(key,value);return this._storage[key]=value},propagateDelete:function(key){key=key.toLowerCase();this._propagate(key,this._storage[key]);return delete this._storage[key]},_activatePropagation:function(){this.set=this.propagateSet;this.delete=this.propagateDelete;return true},justSet:function(key,value){key=key.toLowerCase();return this._storage[key]=value},justDelete:function(key,value){key=key.toLowerCase();return delete this._storage[key]},_propagate:function(key,rev){var folders=key.split("/").slice(0,-1);var len=folders.length;var path="";for(var i=0;i<len;i++){path+=folders[i]+"/";if(!rev){rev=this._storage[path]+1}this._storage[path]=rev}}};var onErrorCb;RS.Dropbox=function(rs){this.rs=rs;this.connected=false;this.rs=rs;var self=this;onErrorCb=function(error){if(error instanceof RemoteStorage.Unauthorized){self.configure(null,null,null,null)}};RS.eventHandling(this,"change","connected");rs.on("error",onErrorCb);this.clientId=rs.apiKeys.dropbox.api_key;this._revCache=new LowerCaseCache("rev");this._itemRefs={};if(hasLocalStorage){var settings;try{settings=JSON.parse(localStorage[SETTINGS_KEY])}catch(e){}if(settings){this.configure(settings.userAddress,undefined,undefined,settings.token)}try{this._itemRefs=JSON.parse(localStorage[SETTINGS_KEY+":shares"])}catch(e){}}if(this.connected){setTimeout(this._emit.bind(this),0,"connected")}};RS.Dropbox.prototype={connect:function(){this.rs.setBackend("dropbox");if(this.token){hookIt(this.rs)}else{RS.Authorize(AUTH_URL,"",String(RS.Authorize.getLocation()),this.clientId)}},configure:function(userAddress,href,storageApi,token){RemoteStorage.log("dropbox configure",arguments);if(typeof token!=="undefined"){this.token=token}if(typeof userAddress!=="undefined"){this.userAddress=userAddress}if(this.token){this.connected=true;if(!this.userAddress){this.info().then(function(info){this.userAddress=info.display_name}.bind(this))}this._emit("connected")}else{this.connected=false}if(hasLocalStorage){localStorage[SETTINGS_KEY]=JSON.stringify({token:this.token,userAddress:this.userAddress})}},_getFolder:function(path,options){var url="https://api.dropbox.com/1/metadata/auto"+path;var promise=promising();var revCache=this._revCache;this._request("GET",url,{},function(err,resp){if(err){promise.reject(err)}else{var status=resp.status;if(status===304){promise.fulfill(status);return}var listing,body,mime,rev;try{body=JSON.parse(resp.responseText)}catch(e){promise.reject(e);return}rev=this._revCache.get(path);mime="application/json; charset=UTF-8";if(body.contents){listing=body.contents.reduce(function(m,item){var itemName=item.path.split("/").slice(-1)[0]+(item.is_dir?"/":"");if(item.is_dir){m[itemName]=revCache.get(path+itemName)}else{m[itemName]=item.rev}return m},{})}promise.fulfill(status,listing,mime,rev)}});return promise},get:function(path,options){RemoteStorage.log("dropbox.get",arguments);if(!this.connected){throw new Error("not connected (path: "+path+")")}path=cleanPath(path);var url="https://api-content.dropbox.com/1/files/auto"+path;var promise=this._sharePromise(path);var savedRev=this._revCache.get(path);if(savedRev===null){RemoteStorage.log(path," deleted 404");promise.fulfill(404);return promise}if(options&&options.ifNoneMatch&&savedRev&&savedRev===options.ifNoneMatch){RemoteStorage.log("nothing changed for",path,savedRev,options.ifNoneMatch);promise.fulfill(304);return promise}if(path.substr(-1)==="/"){return this._getFolder(path,options)}this._request("GET",url,{},function(err,resp){if(err){promise.reject(err)}else{var status=resp.status;var meta,body,mime,rev;if(status===404){promise.fulfill(404)}else if(status===200){body=resp.responseText;try{meta=JSON.parse(resp.getResponseHeader("x-dropbox-metadata"))}catch(e){promise.reject(e);return}mime=meta.mime_type;rev=meta.rev;this._revCache.set(path,rev);if(!resp.getResponseHeader("Content-Type")||resp.getResponseHeader("Content-Type").match(/charset=binary/)){RS.WireClient.readBinaryData(resp.response,mime,function(result){promise.fulfill(status,result,mime,rev)})}else{if(mime&&mime.search("application/json")>=0||true){try{body=JSON.parse(body);mime="application/json; charset=UTF-8"}catch(e){RS.log("Failed parsing Json, assume it is something else then",mime,path)}}promise.fulfill(status,body,mime,rev)}}else{promise.fulfill(status)}}});return promise},put:function(path,body,contentType,options){RemoteStorage.log("dropbox.put",arguments);if(!this.connected){throw new Error("not connected (path: "+path+")")}path=cleanPath(path);var promise=this._sharePromise(path);var revCache=this._revCache;var savedRev=revCache.get(path);if(options&&options.ifMatch&&savedRev&&savedRev!==options.ifMatch){promise.fulfill(412);return promise}if(!contentType.match(/charset=/)){contentType+="; charset="+(body instanceof ArrayBuffer||RS.WireClient.isArrayBufferView(body)?"binary":"utf-8")}var url="https://api-content.dropbox.com/1/files_put/auto"+path+"?";if(options&&options.ifMatch){url+="parent_rev="+encodeURIComponent(options.ifMatch)}if(body.length>150*1024*1024){RemoteStorage.log("files larger than 150MB not supported yet")}else{this._request("PUT",url,{body:body,headers:{"Content-Type":contentType}},function(err,resp){if(err){promise.reject(err)}else{var response=JSON.parse(resp.responseText);if(response.path!==path){promise.fulfill(412);this.rs.log("Dropbox created conflicting File ",response.path)}else{revCache.set(path,response.rev);promise.fulfill(resp.status)}}})}return promise},delete:function(path,options){RemoteStorage.log("dropbox.delete ",arguments);if(!this.connected){throw new Error("not connected (path: "+path+")")}path=cleanPath(path);var promise=promising();var revCache=this._revCache;var savedRev=revCache.get(path);if(options.ifMatch&&savedRev&&options.ifMatch!==savedRev){promise.fulfill(412);return promise}var url="https://api.dropbox.com/1/fileops/delete?root=auto&path="+encodeURIComponent(path);this._request("POST",url,{},function(err,resp){if(err){promise.reject(error)}else{promise.fulfill(resp.status);revCache.delete(path)}});return promise.then(function(){var args=Array.prototype.slice.call(arguments);delete this._itemRefs[path];var p=promising();return p.fulfill.apply(p,args)}.bind(this))},_sharePromise:function(path){var promise=promising();var self=this;if(path.match(/^\/public\/.*[^\/]$/)&&typeof this._itemRefs[path]==="undefined"){RemoteStorage.log("shareing this one ",path);promise.then(function(){var args=Array.prototype.slice.call(arguments);var p=promising();RemoteStorage.log("calling share now");self.share(path).then(function(){RemoteStorage.log("shareing fullfilled promise",arguments);p.fulfill.apply(p,args)},function(err){RemoteStorage.log("shareing failed",err);p.fulfill.apply(p,args)});return p})}return promise},share:function(path){var url="https://api.dropbox.com/1/media/auto"+path;var promise=promising();var itemRefs=this._itemRefs;this._request("POST",url,{},function(err,resp){if(err){RemoteStorage.log(err);err.message='Shareing Dropbox Thingie("'+path+'") failed'+err.message;promise.reject(err)}else{try{var response=JSON.parse(resp.responseText);var url=response.url;itemRefs[path]=url;RemoteStorage.log("SHAREING URL :::: ",url," for ",path);if(hasLocalStorage){localStorage[SETTINGS_KEY+":shares"]=JSON.stringify(this._itemRefs)}promise.fulfill(url)}catch(err){err.message+="share error";promise.reject(err)}}});return promise},info:function(){var url="https://api.dropbox.com/1/account/info";var promise=promising();this._request("GET",url,{},function(err,resp){if(err){promise.reject(err)}else{try{var info=JSON.parse(resp.responseText);promise.fulfill(info)}catch(e){promise.reject(err)}}});return promise},_request:function(method,url,options,callback){callback=callback.bind(this);if(!options.headers){options.headers={}}options.headers["Authorization"]="Bearer "+this.token;RS.WireClient.request.call(this,method,url,options,function(err,xhr){if(xhr&&xhr.status===503){global.setTimeout(this._request(method,url,options,callback),3210)}else{callback(err,xhr)}})},fetchDelta:function(){var args=Array.prototype.slice.call(arguments);var promise=promising();var self=this;this._request("POST","https://api.dropbox.com/1/delta",{body:this._deltaCursor?"cursor="+encodeURIComponent(this._deltaCursor):"",headers:{"Content-Type":"application/x-www-form-urlencoded"}},function(error,response){if(error){this.rs.log("fetchDeltas",error);this.rs._emit("error",new RemoteStorage.SyncError("fetchDeltas failed"+error));promise.reject(error)}else{if(response.status!==200){if(response.status===400){this.rs._emit("error",new RemoteStorage.Unauthorized);promise.fulfill.apply(promise,args)}else{RemoteStorage.log("!!!!dropbox.fetchDelta returned "+response.status+response.responseText);promise.reject("dropbox.fetchDelta returned "+response.status+response.responseText)}return promise}var delta;try{delta=JSON.parse(response.responseText)}catch(error){RS.log("fetchDeltas can not parse response",error);return promise.reject("can not parse response of fetchDelta : "+error.message)}if(!delta.entries){RemoteStorage.log("!!!!!DropBox.fetchDeltas() NO ENTRIES FOUND!!",delta);return promise.reject("dropbox.fetchDeltas failed, no entries found")}if(delta.reset){this._revCache=new LowerCaseCache("rev");promise.then(function(){var args=Array.prototype.slice.call(arguments);self._revCache._activatePropagation();var p=promising();return p.fulfill.apply(p,args)})}if(delta.cursor){this._deltaCursor=delta.cursor}RemoteStorage.log("Delta : ",delta.entries);delta.entries.forEach(function(entry){var path=entry[0];var rev;if(!entry[1]){rev=null}else{if(entry[1].is_dir){return}rev=entry[1].rev}self._revCache.set(path,rev)});promise.fulfill.apply(promise,args)}});return promise}};function hookSync(rs){if(rs._dropboxOrigSync){return}rs._dropboxOrigSync=rs.sync.bind(rs);rs.sync=function(){return this.dropbox.fetchDelta.apply(this.dropbox,arguments).then(rs._dropboxOrigSync,function(err){rs._emit("error",new rs.SyncError(err))})}}function unHookSync(rs){if(!rs._dropboxOrigSync){return}rs.sync=rs._dropboxOrigSync;delete rs._dropboxOrigSync}function hookGetItemURL(rs){if(rs._origBaseClientGetItemURL){return}rs._origBaseClientGetItemURL=RS.BaseClient.prototype.getItemURL;RS.BaseClient.prototype.getItemURL=function(path){var ret=rs.dropbox._itemRefs[path];return ret?ret:""}}function unHookGetItemURL(rs){if(!rs._origBaseClieNtGetItemURL){return}RS.BaseClient.prototype.getItemURL=rs._origBaseClietGetItemURL;delete rs._origBaseClietGetItemURL}function hookRemote(rs){if(rs._origRemote){return}rs._origRemote=rs.remote;rs.remote=rs.dropbox}function unHookRemote(rs){if(rs._origRemote){rs.remote=rs._origRemote;delete rs._origRemote}}function hookIt(rs){hookRemote(rs);if(rs.sync){hookSync(rs)}hookGetItemURL(rs)}function unHookIt(rs){unHookRemote(rs);unHookSync(rs);unHookGetItemURL(rs)}RS.Dropbox._rs_init=function(rs){hasLocalStorage=rs.localStorageAvailable();if(rs.apiKeys.dropbox){rs.dropbox=new RS.Dropbox(rs)}if(rs.backend==="dropbox"){hookIt(rs)}};RS.Dropbox._rs_supported=function(){return true};RS.Dropbox._rs_cleanup=function(rs){unHookIt(rs);if(hasLocalStorage){delete localStorage[SETTINGS_KEY]}rs.removeEventListener("error",onErrorCb);rs.setBackend(undefined)}})(this);remoteStorage=new RemoteStorage;"use strict";document.webL10n=function(window,document,undefined){var gL10nData={};var gTextData="";var gTextProp="textContent";var gLanguage="";var gMacros={};var gReadyState="loading";var gAsyncResourceLoading=true;var gDEBUG=1;function consoleLog(message){if(gDEBUG>=2){console.log("[l10n] "+message)}}function consoleWarn(message){if(gDEBUG){console.warn("[l10n] "+message)}}function getL10nResourceLinks(){return document.querySelectorAll('link[type="application/l10n"]')}function getL10nDictionary(){var script=document.querySelector('script[type="application/l10n"]');return script?JSON.parse(script.innerHTML):null}function getTranslatableChildren(element){return element?element.querySelectorAll("*[data-l10n-id]"):[]}function getL10nAttributes(element){if(!element)return{};var l10nId=element.getAttribute("data-l10n-id");var l10nArgs=element.getAttribute("data-l10n-args");var args={};if(l10nArgs){try{args=JSON.parse(l10nArgs)}catch(e){consoleWarn("could not parse arguments for #"+l10nId)}}return{id:l10nId,args:args}}function fireL10nReadyEvent(lang){var evtObject=document.createEvent("Event");evtObject.initEvent("localized",true,false);evtObject.language=lang;document.dispatchEvent(evtObject)}function xhrLoadText(url,onSuccess,onFailure,asynchronous){onSuccess=onSuccess||function _onSuccess(data){};onFailure=onFailure||function _onFailure(){consoleWarn(url+" not found.")};var xhr=new XMLHttpRequest;xhr.open("GET",url,asynchronous);if(xhr.overrideMimeType){xhr.overrideMimeType("text/plain; charset=utf-8")}xhr.onreadystatechange=function(){if(xhr.readyState==4){if(xhr.status==200||xhr.status===0){onSuccess(xhr.responseText)}else{onFailure()}}};xhr.onerror=onFailure;xhr.ontimeout=onFailure;try{xhr.send(null)}catch(e){onFailure()}}function parseResource(href,lang,successCallback,failureCallback){var baseURL=href.replace(/[^\/]*$/,"")||"./";function evalString(text){if(text.lastIndexOf("\\")<0)return text;return text.replace(/\\\\/g,"\\").replace(/\\n/g,"\n").replace(/\\r/g,"\r").replace(/\\t/g,"	").replace(/\\b/g,"\b").replace(/\\f/g,"\f").replace(/\\{/g,"{").replace(/\\}/g,"}").replace(/\\"/g,'"').replace(/\\'/g,"'")}function parseProperties(text){var dictionary=[];var reBlank=/^\s*|\s*$/;var reComment=/^\s*#|^\s*$/;var reSection=/^\s*\[(.*)\]\s*$/;var reImport=/^\s*@import\s+url\((.*)\)\s*$/i;var reSplit=/^([^=\s]*)\s*=\s*(.+)$/;function parseRawLines(rawText,extendedSyntax){rawText=rawText.replace(/\\[\r\n]{1,2}\s*/gm,"\\n");var entries=rawText.replace(reBlank,"").split(/[\r\n]+/);var currentLang="*";var genericLang=lang.replace(/-[a-z]+$/i,"");var skipLang=false;var match="";for(var i=0;i<entries.length;i++){var line=entries[i];if(reComment.test(line))continue;if(extendedSyntax){if(reSection.test(line)){match=reSection.exec(line);currentLang=match[1];skipLang=currentLang!=="*"&&currentLang!==lang&&currentLang!==genericLang;continue}else if(skipLang){continue}if(reImport.test(line)){match=reImport.exec(line);loadImport(baseURL+match[1])}}var tmp=line.match(reSplit);if(tmp&&tmp.length==3){dictionary[tmp[1]]=evalString(tmp[2])}}}function loadImport(url){xhrLoadText(url,function(content){parseRawLines(content,false)},null,false)}parseRawLines(text,true);return dictionary}xhrLoadText(href,function(response){gTextData+=response;var data=parseProperties(response);for(var key in data){var id,prop,index=key.lastIndexOf(".");if(index>0){id=key.substring(0,index);prop=key.substr(index+1)}else{id=key;prop=gTextProp}if(!gL10nData[id]){gL10nData[id]={}}gL10nData[id][prop]=data[key]}if(successCallback){successCallback()}},failureCallback,gAsyncResourceLoading)}function loadLocale(lang,callback){callback=callback||function _callback(){};clear();gLanguage=lang;var langLinks=getL10nResourceLinks();var langCount=langLinks.length;if(langCount==0){var dict=getL10nDictionary();if(dict&&dict.locales&&dict.default_locale){consoleLog("using the embedded JSON directory, early way out");gL10nData=dict.locales[lang]||dict.locales[dict.default_locale];callback()}else{consoleLog("no resource to load, early way out")}fireL10nReadyEvent(lang);gReadyState="complete";return}var onResourceLoaded=null;var gResourceCount=0;onResourceLoaded=function(){gResourceCount++;if(gResourceCount>=langCount){callback();
fireL10nReadyEvent(lang);gReadyState="complete"}};function l10nResourceLink(link){var href=link.href;var type=link.type;this.load=function(lang,callback){var applied=lang;parseResource(href,lang,callback,function(){consoleWarn(href+" not found.");applied=""});return applied}}for(var i=0;i<langCount;i++){var resource=new l10nResourceLink(langLinks[i]);var rv=resource.load(lang,onResourceLoaded);if(rv!=lang){consoleWarn('"'+lang+'" resource not found');gLanguage=""}}}function clear(){gL10nData={};gTextData="";gLanguage=""}function getPluralRules(lang){var locales2rules={af:3,ak:4,am:4,ar:1,asa:3,az:0,be:11,bem:3,bez:3,bg:3,bh:4,bm:0,bn:3,bo:0,br:20,brx:3,bs:11,ca:3,cgg:3,chr:3,cs:12,cy:17,da:3,de:3,dv:3,dz:0,ee:3,el:3,en:3,eo:3,es:3,et:3,eu:3,fa:0,ff:5,fi:3,fil:4,fo:3,fr:5,fur:3,fy:3,ga:8,gd:24,gl:3,gsw:3,gu:3,guw:4,gv:23,ha:3,haw:3,he:2,hi:4,hr:11,hu:0,id:0,ig:0,ii:0,is:3,it:3,iu:7,ja:0,jmc:3,jv:0,ka:0,kab:5,kaj:3,kcg:3,kde:0,kea:0,kk:3,kl:3,km:0,kn:0,ko:0,ksb:3,ksh:21,ku:3,kw:7,lag:18,lb:3,lg:3,ln:4,lo:0,lt:10,lv:6,mas:3,mg:4,mk:16,ml:3,mn:3,mo:9,mr:3,ms:0,mt:15,my:0,nah:3,naq:7,nb:3,nd:3,ne:3,nl:3,nn:3,no:3,nr:3,nso:4,ny:3,nyn:3,om:3,or:3,pa:3,pap:3,pl:13,ps:3,pt:3,rm:3,ro:9,rof:3,ru:11,rwk:3,sah:0,saq:3,se:7,seh:3,ses:0,sg:0,sh:11,shi:19,sk:12,sl:14,sma:7,smi:7,smj:7,smn:7,sms:7,sn:3,so:3,sq:3,sr:11,ss:3,ssy:3,st:3,sv:3,sw:3,syr:3,ta:3,te:3,teo:3,th:0,ti:4,tig:3,tk:3,tl:4,tn:3,to:0,tr:0,ts:3,tzm:22,uk:11,ur:3,ve:3,vi:0,vun:3,wa:4,wae:3,wo:0,xh:3,xog:3,yo:0,zh:0,zu:3};function isIn(n,list){return list.indexOf(n)!==-1}function isBetween(n,start,end){return start<=n&&n<=end}var pluralRules={0:function(n){return"other"},1:function(n){if(isBetween(n%100,3,10))return"few";if(n===0)return"zero";if(isBetween(n%100,11,99))return"many";if(n==2)return"two";if(n==1)return"one";return"other"},2:function(n){if(n!==0&&n%10===0)return"many";if(n==2)return"two";if(n==1)return"one";return"other"},3:function(n){if(n==1)return"one";return"other"},4:function(n){if(isBetween(n,0,1))return"one";return"other"},5:function(n){if(isBetween(n,0,2)&&n!=2)return"one";return"other"},6:function(n){if(n===0)return"zero";if(n%10==1&&n%100!=11)return"one";return"other"},7:function(n){if(n==2)return"two";if(n==1)return"one";return"other"},8:function(n){if(isBetween(n,3,6))return"few";if(isBetween(n,7,10))return"many";if(n==2)return"two";if(n==1)return"one";return"other"},9:function(n){if(n===0||n!=1&&isBetween(n%100,1,19))return"few";if(n==1)return"one";return"other"},10:function(n){if(isBetween(n%10,2,9)&&!isBetween(n%100,11,19))return"few";if(n%10==1&&!isBetween(n%100,11,19))return"one";return"other"},11:function(n){if(isBetween(n%10,2,4)&&!isBetween(n%100,12,14))return"few";if(n%10===0||isBetween(n%10,5,9)||isBetween(n%100,11,14))return"many";if(n%10==1&&n%100!=11)return"one";return"other"},12:function(n){if(isBetween(n,2,4))return"few";if(n==1)return"one";return"other"},13:function(n){if(isBetween(n%10,2,4)&&!isBetween(n%100,12,14))return"few";if(n!=1&&isBetween(n%10,0,1)||isBetween(n%10,5,9)||isBetween(n%100,12,14))return"many";if(n==1)return"one";return"other"},14:function(n){if(isBetween(n%100,3,4))return"few";if(n%100==2)return"two";if(n%100==1)return"one";return"other"},15:function(n){if(n===0||isBetween(n%100,2,10))return"few";if(isBetween(n%100,11,19))return"many";if(n==1)return"one";return"other"},16:function(n){if(n%10==1&&n!=11)return"one";return"other"},17:function(n){if(n==3)return"few";if(n===0)return"zero";if(n==6)return"many";if(n==2)return"two";if(n==1)return"one";return"other"},18:function(n){if(n===0)return"zero";if(isBetween(n,0,2)&&n!==0&&n!=2)return"one";return"other"},19:function(n){if(isBetween(n,2,10))return"few";if(isBetween(n,0,1))return"one";return"other"},20:function(n){if((isBetween(n%10,3,4)||n%10==9)&&!(isBetween(n%100,10,19)||isBetween(n%100,70,79)||isBetween(n%100,90,99)))return"few";if(n%1e6===0&&n!==0)return"many";if(n%10==2&&!isIn(n%100,[12,72,92]))return"two";if(n%10==1&&!isIn(n%100,[11,71,91]))return"one";return"other"},21:function(n){if(n===0)return"zero";if(n==1)return"one";return"other"},22:function(n){if(isBetween(n,0,1)||isBetween(n,11,99))return"one";return"other"},23:function(n){if(isBetween(n%10,1,2)||n%20===0)return"one";return"other"},24:function(n){if(isBetween(n,3,10)||isBetween(n,13,19))return"few";if(isIn(n,[2,12]))return"two";if(isIn(n,[1,11]))return"one";return"other"}};var index=locales2rules[lang.replace(/-.*$/,"")];if(!(index in pluralRules)){consoleWarn("plural form unknown for ["+lang+"]");return function(){return"other"}}return pluralRules[index]}gMacros.plural=function(str,param,key,prop){var n=parseFloat(param);if(isNaN(n))return str;if(prop!=gTextProp)return str;if(!gMacros._pluralRules){gMacros._pluralRules=getPluralRules(gLanguage)}var index="["+gMacros._pluralRules(n)+"]";if(n===0&&key+"[zero]"in gL10nData){str=gL10nData[key+"[zero]"][prop]}else if(n==1&&key+"[one]"in gL10nData){str=gL10nData[key+"[one]"][prop]}else if(n==2&&key+"[two]"in gL10nData){str=gL10nData[key+"[two]"][prop]}else if(key+index in gL10nData){str=gL10nData[key+index][prop]}else if(key+"[other]"in gL10nData){str=gL10nData[key+"[other]"][prop]}return str};function getL10nData(key,args){var data=gL10nData[key];if(!data){consoleWarn("#"+key+" is undefined.")}var rv={};for(var prop in data){var str=data[prop];str=substIndexes(str,args,key,prop);str=substArguments(str,args,key);rv[prop]=str}return rv}function substIndexes(str,args,key,prop){var reIndex=/\{\[\s*([a-zA-Z]+)\(([a-zA-Z]+)\)\s*\]\}/;var reMatch=reIndex.exec(str);if(!reMatch||!reMatch.length)return str;var macroName=reMatch[1];var paramName=reMatch[2];var param;if(args&&paramName in args){param=args[paramName]}else if(paramName in gL10nData){param=gL10nData[paramName]}if(macroName in gMacros){var macro=gMacros[macroName];str=macro(str,param,key,prop)}return str}function substArguments(str,args,key){var reArgs=/\{\{\s*(.+?)\s*\}\}/;var match=reArgs.exec(str);while(match){if(!match||match.length<2)return str;var arg=match[1];var sub="";if(args&&arg in args){sub=args[arg]}else if(arg in gL10nData){sub=gL10nData[arg][gTextProp]}else{consoleLog("argument {{"+arg+"}} for #"+key+" is undefined.");return str}str=str.substring(0,match.index)+sub+str.substr(match.index+match[0].length);match=reArgs.exec(str)}return str}function translateElement(element){var l10n=getL10nAttributes(element);if(!l10n.id)return;var data=getL10nData(l10n.id,l10n.args);if(!data){consoleWarn("#"+l10n.id+" is undefined.");return}if(data[gTextProp]){if(getChildElementCount(element)===0){element[gTextProp]=data[gTextProp]}else{var children=element.childNodes;var found=false;for(var i=0,l=children.length;i<l;i++){if(children[i].nodeType===3&&/\S/.test(children[i].nodeValue)){if(found){children[i].nodeValue=""}else{children[i].nodeValue=data[gTextProp];found=true}}}if(!found){var textNode=document.createTextNode(data[gTextProp]);element.insertBefore(textNode,element.firstChild)}}delete data[gTextProp]}for(var k in data){element[k]=data[k]}}function getChildElementCount(element){if(element.children){return element.children.length}if(typeof element.childElementCount!=="undefined"){return element.childElementCount}var count=0;for(var i=0;i<element.childNodes.length;i++){count+=element.nodeType===1?1:0}return count}function translateFragment(element){element=element||document.documentElement;var children=getTranslatableChildren(element);var elementCount=children.length;for(var i=0;i<elementCount;i++){translateElement(children[i])}translateElement(element)}function l10nStartup(){gReadyState="interactive";var userLocale=navigator.language||navigator.userLanguage;consoleLog("loading ["+userLocale+"] resources, "+(gAsyncResourceLoading?"asynchronously.":"synchronously."));if(document.documentElement.lang===userLocale){loadLocale(userLocale)}else{loadLocale(userLocale,translateFragment)}}if(document.addEventListener){if(document.readyState==="loading"){document.addEventListener("DOMContentLoaded",l10nStartup)}else{window.setTimeout(l10nStartup)}}else if(window.attachEvent){if(!window.console){consoleLog=function(message){};consoleWarn=function(message){if(gDEBUG){alert("[l10n] "+message)}}}if(!window.XMLHttpRequest){xhrLoadText=function(url,onSuccess,onFailure,asynchronous){onSuccess=onSuccess||function _onSuccess(data){};onFailure=onFailure||function _onFailure(){consoleWarn(url+" not found.")};var xhr=new ActiveXObject("Microsoft.XMLHTTP");xhr.open("GET",url,asynchronous);xhr.onreadystatechange=function(){if(xhr.readyState==4){if(xhr.status==200){onSuccess(xhr.responseText)}else{onFailure()}}};xhr.send(null)}}if(!window.JSON){getL10nAttributes=function(element){if(!element)return{};var l10nId=element.getAttribute("data-l10n-id"),l10nArgs=element.getAttribute("data-l10n-args"),args={};if(l10nArgs)try{args=eval(l10nArgs)}catch(e){consoleWarn("could not parse arguments for #"+l10nId)}return{id:l10nId,args:args}}}if(!document.querySelectorAll){getTranslatableChildren=function(element){if(!element)return[];var nodes=element.getElementsByTagName("*"),l10nElements=[],n=nodes.length;for(var i=0;i<n;i++){if(nodes[i].getAttribute("data-l10n-id"))l10nElements.push(nodes[i])}return l10nElements};getL10nResourceLinks=function(){var links=document.getElementsByTagName("link"),l10nLinks=[],n=links.length;for(var i=0;i<n;i++){if(links[i].type=="application/l10n")l10nLinks.push(links[i])}return l10nLinks}}if(!window.JSON||!document.querySelectorAll){getL10nDictionary=function(){var scripts=document.getElementsByName("script");for(var i=0;i<scripts.length;i++){if(scripts[i].type=="application/l10n"){return eval(scripts[i].innerHTML)}}return null}}if(document.createEventObject&&!document.createEvent){fireL10nReadyEvent=function(lang){document.documentElement.localized=1}}window.attachEvent("onload",function(){gTextProp=document.body.textContent?"textContent":"innerText";l10nStartup()})}return{get:function(key,args,fallback){var data=getL10nData(key,args)||fallback;if(data){return gTextProp in data?data[gTextProp]:""}return"{{"+key+"}}"},getData:function(){return gL10nData},getText:function(){return gTextData},getLanguage:function(){return gLanguage},setLanguage:function(lang){loadLocale(lang,translateFragment)},getDirection:function(){var rtlList=["ar","he","fa","ps","ur"];return rtlList.indexOf(gLanguage)>=0?"rtl":"ltr"},translate:translateFragment,getReadyState:function(){return gReadyState},ready:function(callback){if(!callback){return}else if(gReadyState=="complete"||gReadyState=="interactive"){window.setTimeout(callback)}else if(document.addEventListener){document.addEventListener("localized",callback)}else if(document.attachEvent){document.documentElement.attachEvent("onpropertychange",function(e){if(e.propertyName==="localized"){callback()}})}}}}(window,document);if(window._===undefined){var _=document.webL10n.get}(function(){"use strict";var startTag=/^<([-A-Za-z0-9_]+)((?:\s+[-A-Za-z0-9_]+(?:\s*=\s*(?:(?:"[^"]*")|(?:'[^']*')|[^>\s]+))?)*)\s*(\/?)>/,endTag=/^<\/([-A-Za-z0-9_]+)[^>]*>/,attr=/([-A-Za-z0-9_]+)(?:\s*=\s*(?:(?:"((?:\\.|[^"])*)")|(?:'((?:\\.|[^'])*)')|([^>\s]+)))?/g;var empty=makeMap("area,base,basefont,br,col,frame,hr,img,input,isindex,link,meta,param,embed");var block=makeMap("address,applet,blockquote,button,center,dd,del,dir,div,dl,dt,fieldset,form,frameset,hr,iframe,ins,isindex,li,map,menu,noframes,noscript,object,ol,p,pre,script,table,tbody,td,tfoot,th,thead,tr,ul");var inline=makeMap("a,abbr,acronym,applet,b,basefont,bdo,big,br,button,cite,code,del,dfn,em,font,i,iframe,img,input,ins,kbd,label,map,object,q,s,samp,script,select,small,span,strike,strong,sub,sup,textarea,tt,u,var");var closeSelf=makeMap("colgroup,dd,dt,li,options,p,td,tfoot,th,thead,tr");var fillAttrs=makeMap("checked,compact,declare,defer,disabled,ismap,multiple,nohref,noresize,noshade,nowrap,readonly,selected");var special=makeMap("script,style");var blacklist={tags:["script","style"],attr:["onclick","onerror","onload","id","style","class"]};var htmlParser=function(html,handler){var index,chars,match,stack=[],last=html;stack.last=function(){return this[this.length-1]};function replaceFct(all,text){text=text.replace(/<!--(.*?)-->/g,"$1").replace(/<!\[CDATA\[(.*?)]]>/g,"$1");if(handler.chars)handler.chars(text);return""}while(html){chars=true;if(!stack.last()||!special[stack.last()]){if(html.indexOf("<!--")===0){index=html.indexOf("-->");if(index>=0){if(handler.comment)handler.comment(html.substring(4,index));html=html.substring(index+3);chars=false}}else if(html.indexOf("</")===0){match=html.match(endTag);if(match){html=html.substring(match[0].length);match[0].replace(endTag,parseEndTag);chars=false}}else if(html.indexOf("<")===0){match=html.match(startTag);if(match){html=html.substring(match[0].length);match[0].replace(startTag,parseStartTag);chars=false}else{var altStartTag=/<(\w)+?[^>]*>/;match=html.match(altStartTag);if(match){html=html.substring(match[0].length);match[0].replace(altStartTag,parseStartTag);chars=false}}}if(chars){index=html.indexOf("<");var text=index<0?html:html.substring(0,index);html=index<0?"":html.substring(index);if(handler.chars)handler.chars(text)}}else{html=html.replace(new RegExp("(.*)</"+stack.last()+"[^>]*>"),replaceFct);parseEndTag("",stack.last())}if(html===last)throw"Parse Error: "+html;last=html}parseEndTag();function parseStartTag(tag,tagName,rest,unary){tagName=tagName.toLowerCase();if(typeof rest!=="string"){rest=""}if(block[tagName]){while(stack.last()&&inline[stack.last()]){parseEndTag("",stack.last())}}if(closeSelf[tagName]&&stack.last()===tagName){parseEndTag("",tagName)}unary=empty[tagName]||!!unary;if(!unary)stack.push(tagName);if(handler.start){var attrs=[];rest.replace(attr,function(match,name){var value=arguments[2]?arguments[2]:arguments[3]?arguments[3]:arguments[4]?arguments[4]:fillAttrs[name]?name:"";attrs.push({name:name,value:value,escaped:value.replace(/(^|[^\\])"/g,'$1\\"')})});if(handler.start)handler.start(tagName,attrs,unary)}}function parseEndTag(tag,tagName){var pos;if(!tagName)pos=0;else for(pos=stack.length-1;pos>=0;pos--)if(stack[pos]===tagName)break;if(pos>=0){for(var i=stack.length-1;i>=pos;i--)if(handler.end)handler.end(stack[i]);stack.length=pos}}};window.HTMLtoXML=function(html){var results="";htmlParser(html,{start:function(tag,attrs,unary){tag=tag.toLowerCase();if(blacklist.tags.indexOf(tag)===-1){results+="<"+tag;for(var i=0;i<attrs.length;i++){attrs[i].name=attrs[i].name.toLowerCase();if(blacklist.attr.indexOf(attrs[i].name)===-1){results+=" "+attrs[i].name+'="'+attrs[i].escaped+'"'}}results+=(unary?"/":"")+">"}},end:function(tag){if(blacklist.tags.indexOf(tag)===-1){results+="</"+tag+">"}},chars:function(text){results+=text},comment:function(text){}});return results};function makeMap(str){var obj={},items=str.split(",");for(var i=0;i<items.length;i++)obj[items[i]]=true;return obj}})();var Showdown={extensions:{}},forEach=Showdown.forEach=function(a,b){if(typeof a.forEach=="function")a.forEach(b);else{var c,d=a.length;for(c=0;c<d;c++)b(a[c],c,a)}},stdExtName=function(a){return a.replace(/[_-]||\s/g,"").toLowerCase()};Showdown.converter=function(a){var b,c,d,e=0,f=[],g=[];if(typeof module!="undefind"&&typeof exports!="undefined"&&typeof require!="undefind"){var h=require("fs");if(h){var i=h.readdirSync((__dirname||".")+"/extensions").filter(function(a){return~a.indexOf(".js")}).map(function(a){return a.replace(/\.js$/,"")});Showdown.forEach(i,function(a){var b=stdExtName(a);Showdown.extensions[b]=require("./extensions/"+a)})}}this.makeHtml=function(a){return b={},c={},d=[],a=a.replace(/~/g,"~T"),a=a.replace(/\$/g,"~D"),a=a.replace(/\r\n/g,"\n"),a=a.replace(/\r/g,"\n"),a="\n\n"+a+"\n\n",a=M(a),a=a.replace(/^[ \t]+$/gm,""),Showdown.forEach(f,function(b){a=k(b,a)}),a=z(a),a=m(a),a=l(a),a=o(a),a=K(a),a=a.replace(/~D/g,"$$"),a=a.replace(/~T/g,"~"),Showdown.forEach(g,function(b){a=k(b,a)}),a};if(a&&a.extensions){var j=this;Showdown.forEach(a.extensions,function(a){typeof a=="string"&&(a=Showdown.extensions[stdExtName(a)]);if(typeof a!="function")throw"Extension '"+a+"' could not be loaded.  It was either not found or is not a valid extension.";Showdown.forEach(a(j),function(a){a.type?a.type==="language"||a.type==="lang"?f.push(a):(a.type==="output"||a.type==="html")&&g.push(a):g.push(a)})})}var k=function(a,b){if(a.regex){var c=new RegExp(a.regex,"g");return b.replace(c,a.replace)}if(a.filter)return a.filter(b)},l=function(a){return a+="~0",a=a.replace(/^[ ]{0,3}\[(.+)\]:[ \t]*\n?[ \t]*<?(\S+?)>?[ \t]*\n?[ \t]*(?:(\n*)["(](.+?)[")][ \t]*)?(?:\n+|(?=~0))/gm,function(a,d,e,f,g){return d=d.toLowerCase(),b[d]=G(e),f?f+g:(g&&(c[d]=g.replace(/"/g,"&quot;")),"")}),a=a.replace(/~0/,""),a},m=function(a){a=a.replace(/\n/g,"\n\n");var b="p|div|h[1-6]|blockquote|pre|table|dl|ol|ul|script|noscript|form|fieldset|iframe|math|ins|del|style|section|header|footer|nav|article|aside",c="p|div|h[1-6]|blockquote|pre|table|dl|ol|ul|script|noscript|form|fieldset|iframe|math|style|section|header|footer|nav|article|aside";return a=a.replace(/^(<(p|div|h[1-6]|blockquote|pre|table|dl|ol|ul|script|noscript|form|fieldset|iframe|math|ins|del)\b[^\r]*?\n<\/\2>[ \t]*(?=\n+))/gm,n),a=a.replace(/^(<(p|div|h[1-6]|blockquote|pre|table|dl|ol|ul|script|noscript|form|fieldset|iframe|math|style|section|header|footer|nav|article|aside)\b[^\r]*?<\/\2>[ \t]*(?=\n+)\n)/gm,n),a=a.replace(/(\n[ ]{0,3}(<(hr)\b([^<>])*?\/?>)[ \t]*(?=\n{2,}))/g,n),a=a.replace(/(\n\n[ ]{0,3}<!(--[^\r]*?--\s*)+>[ \t]*(?=\n{2,}))/g,n),a=a.replace(/(?:\n\n)([ ]{0,3}(?:<([?%])[^\r]*?\2>)[ \t]*(?=\n{2,}))/g,n),a=a.replace(/\n\n/g,"\n"),a},n=function(a,b){var c=b;return c=c.replace(/\n\n/g,"\n"),c=c.replace(/^\n/,""),c=c.replace(/\n+$/g,""),c="\n\n~K"+(d.push(c)-1)+"K\n\n",c},o=function(a){a=v(a);var b=A("<hr />");return a=a.replace(/^[ ]{0,2}([ ]?\*[ ]?){3,}[ \t]*$/gm,b),a=a.replace(/^[ ]{0,2}([ ]?\-[ ]?){3,}[ \t]*$/gm,b),a=a.replace(/^[ ]{0,2}([ ]?\_[ ]?){3,}[ \t]*$/gm,b),a=x(a),a=y(a),a=E(a),a=m(a),a=F(a),a},p=function(a){return a=B(a),a=q(a),a=H(a),a=t(a),a=r(a),a=I(a),a=G(a),a=D(a),a=a.replace(/  +\n/g," <br />\n"),a},q=function(a){var b=/(<[a-z\/!$]("[^"]*"|'[^']*'|[^'">])*>|<!(--.*?--\s*)+>)/gi;return a=a.replace(b,function(a){var b=a.replace(/(.)<\/?code>(?=.)/g,"$1`");return b=N(b,"\\`*_"),b}),a},r=function(a){return a=a.replace(/(\[((?:\[[^\]]*\]|[^\[\]])*)\][ ]?(?:\n[ ]*)?\[(.*?)\])()()()()/g,s),a=a.replace(/(\[((?:\[[^\]]*\]|[^\[\]])*)\]\([ \t]*()<?(.*?(?:\(.*?\).*?)?)>?[ \t]*((['"])(.*?)\6[ \t]*)?\))/g,s),a=a.replace(/(\[([^\[\]]+)\])()()()()()/g,s),a},s=function(a,d,e,f,g,h,i,j){j==undefined&&(j="");var k=d,l=e,m=f.toLowerCase(),n=g,o=j;if(n==""){m==""&&(m=l.toLowerCase().replace(/ ?\n/g," ")),n="#"+m;if(b[m]!=undefined)n=b[m],c[m]!=undefined&&(o=c[m]);else{if(!(k.search(/\(\s*\)$/m)>-1))return k;n=""}}n=N(n,"*_");var p='<a href="'+n+'"';return o!=""&&(o=o.replace(/"/g,"&quot;"),o=N(o,"*_"),p+=' title="'+o+'"'),p+=">"+l+"</a>",p},t=function(a){return a=a.replace(/(!\[(.*?)\][ ]?(?:\n[ ]*)?\[(.*?)\])()()()()/g,u),a=a.replace(/(!\[(.*?)\]\s?\([ \t]*()<?(\S+?)>?[ \t]*((['"])(.*?)\6[ \t]*)?\))/g,u),a},u=function(a,d,e,f,g,h,i,j){var k=d,l=e,m=f.toLowerCase(),n=g,o=j;o||(o="");if(n==""){m==""&&(m=l.toLowerCase().replace(/ ?\n/g," ")),n="#"+m;if(b[m]==undefined)return k;n=b[m],c[m]!=undefined&&(o=c[m])}l=l.replace(/"/g,"&quot;"),n=N(n,"*_");var p='<img src="'+n+'" alt="'+l+'"';return o=o.replace(/"/g,"&quot;"),o=N(o,"*_"),p+=' title="'+o+'"',p+=" />",p},v=function(a){function b(a){return a.replace(/[^\w]/g,"").toLowerCase()}return a=a.replace(/^(.+)[ \t]*\n=+[ \t]*\n+/gm,function(a,c){return A('<h1 id="'+b(c)+'">'+p(c)+"</h1>")}),a=a.replace(/^(.+)[ \t]*\n-+[ \t]*\n+/gm,function(a,c){return A('<h2 id="'+b(c)+'">'+p(c)+"</h2>")}),a=a.replace(/^(\#{1,6})[ \t]*(.+?)[ \t]*\#*\n+/gm,function(a,c,d){var e=c.length;return A("<h"+e+' id="'+b(d)+'">'+p(d)+"</h"+e+">")}),a},w,x=function(a){a+="~0";var b=/^(([ ]{0,3}([*+-]|\d+[.])[ \t]+)[^\r]+?(~0|\n{2,}(?=\S)(?![ \t]*(?:[*+-]|\d+[.])[ \t]+)))/gm;return e?a=a.replace(b,function(a,b,c){var d=b,e=c.search(/[*+-]/g)>-1?"ul":"ol";d=d.replace(/\n{2,}/g,"\n\n\n");var f=w(d);return f=f.replace(/\s+$/,""),f="<"+e+">"+f+"</"+e+">\n",f}):(b=/(\n\n|^\n?)(([ ]{0,3}([*+-]|\d+[.])[ \t]+)[^\r]+?(~0|\n{2,}(?=\S)(?![ \t]*(?:[*+-]|\d+[.])[ \t]+)))/g,a=a.replace(b,function(a,b,c,d){var e=b,f=c,g=d.search(/[*+-]/g)>-1?"ul":"ol",f=f.replace(/\n{2,}/g,"\n\n\n"),h=w(f);return h=e+"<"+g+">\n"+h+"</"+g+">\n",h})),a=a.replace(/~0/,""),a};w=function(a){return e++,a=a.replace(/\n{2,}$/,"\n"),a+="~0",a=a.replace(/(\n)?(^[ \t]*)([*+-]|\d+[.])[ \t]+([^\r]+?(\n{1,2}))(?=\n*(~0|\2([*+-]|\d+[.])[ \t]+))/gm,function(a,b,c,d,e){var f=e,g=b,h=c;return g||f.search(/\n{2,}/)>-1?f=o(L(f)):(f=x(L(f)),f=f.replace(/\n$/,""),f=p(f)),"<li>"+f+"</li>\n"}),a=a.replace(/~0/g,""),e--,a};var y=function(a){return a+="~0",a=a.replace(/(?:\n\n|^)((?:(?:[ ]{4}|\t).*\n+)+)(\n*[ ]{0,3}[^ \t\n]|(?=~0))/g,function(a,b,c){var d=b,e=c;return d=C(L(d)),d=M(d),d=d.replace(/^\n+/g,""),d=d.replace(/\n+$/g,""),d="<pre><code>"+d+"\n</code></pre>",A(d)+e}),a=a.replace(/~0/,""),a},z=function(a){return a+="~0",a=a.replace(/(?:^|\n)```(.*)\n([\s\S]*?)\n```/g,function(a,b,c){var d=b,e=c;return e=C(e),e=M(e),e=e.replace(/^\n+/g,""),e=e.replace(/\n+$/g,""),e="<pre><code"+(d?' class="'+d+'"':"")+">"+e+"\n</code></pre>",A(e)}),a=a.replace(/~0/,""),a},A=function(a){return a=a.replace(/(^\n+|\n+$)/g,""),"\n\n~K"+(d.push(a)-1)+"K\n\n"},B=function(a){return a=a.replace(/(^|[^\\])(`+)([^\r]*?[^`])\2(?!`)/gm,function(a,b,c,d,e){var f=d;return f=f.replace(/^([ \t]*)/g,""),f=f.replace(/[ \t]*$/g,""),f=C(f),b+"<code>"+f+"</code>"}),a},C=function(a){return a=a.replace(/&/g,"&amp;"),a=a.replace(/</g,"&lt;"),a=a.replace(/>/g,"&gt;"),a=N(a,"*_{}[]\\",!1),a},D=function(a){return a=a.replace(/(\*\*|__)(?=\S)([^\r]*?\S[*_]*)\1/g,"<strong>$2</strong>"),a=a.replace(/(\*|_)(?=\S)([^\r]*?\S)\1/g,"<em>$2</em>"),a},E=function(a){return a=a.replace(/((^[ \t]*>[ \t]?.+\n(.+\n)*\n*)+)/gm,function(a,b){var c=b;return c=c.replace(/^[ \t]*>[ \t]?/gm,"~0"),c=c.replace(/~0/g,""),c=c.replace(/^[ \t]+$/gm,""),c=o(c),c=c.replace(/(^|\n)/g,"$1  "),c=c.replace(/(\s*<pre>[^\r]+?<\/pre>)/gm,function(a,b){var c=b;return c=c.replace(/^  /gm,"~0"),c=c.replace(/~0/g,""),c}),A("<blockquote>\n"+c+"\n</blockquote>")}),a},F=function(a){a=a.replace(/^\n+/g,""),a=a.replace(/\n+$/g,"");var b=a.split(/\n{2,}/g),c=[],e=b.length;for(var f=0;f<e;f++){var g=b[f];g.search(/~K(\d+)K/g)>=0?c.push(g):g.search(/\S/)>=0&&(g=p(g),g=g.replace(/^([ \t]*)/g,"<p>"),g+="</p>",c.push(g))}e=c.length;for(var f=0;f<e;f++)while(c[f].search(/~K(\d+)K/)>=0){var h=d[RegExp.$1];h=h.replace(/\$/g,"$$$$"),c[f]=c[f].replace(/~K\d+K/,h)}return c.join("\n\n")},G=function(a){return a=a.replace(/&(?!#?[xX]?(?:[0-9a-fA-F]+|\w+);)/g,"&amp;"),a=a.replace(/<(?![a-z\/?\$!])/gi,"&lt;"),a},H=function(a){return a=a.replace(/\\(\\)/g,O),a=a.replace(/\\([`*_{}\[\]()>#+-.!])/g,O),a},I=function(a){return a=a.replace(/<((https?|ftp|dict):[^'">\s]+)>/gi,'<a href="$1">$1</a>'),a=a.replace(/<(?:mailto:)?([-.\w]+\@[-a-z0-9]+(\.[-a-z0-9]+)*\.[a-z]+)>/gi,function(a,b){return J(K(b))}),a},J=function(a){var b=[function(a){return"&#"+a.charCodeAt(0)+";"},function(a){return"&#x"+a.charCodeAt(0).toString(16)+";"},function(a){return a}];return a="mailto:"+a,a=a.replace(/./g,function(a){if(a=="@")a=b[Math.floor(Math.random()*2)](a);else if(a!=":"){var c=Math.random();a=c>.9?b[2](a):c>.45?b[1](a):b[0](a)}return a}),a='<a href="'+a+'">'+a+"</a>",a=a.replace(/">.+:/g,'">'),a},K=function(a){return a=a.replace(/~E(\d+)E/g,function(a,b){var c=parseInt(b);return String.fromCharCode(c)}),a},L=function(a){return a=a.replace(/^(\t|[ ]{1,4})/gm,"~0"),a=a.replace(/~0/g,""),a},M=function(a){return a=a.replace(/\t(?=\t)/g,"    "),a=a.replace(/\t/g,"~A~B"),a=a.replace(/~B(.+?)~A/g,function(a,b,c){var d=b,e=4-d.length%4;for(var f=0;f<e;f++)d+=" ";return d}),a=a.replace(/~A/g,"    "),a=a.replace(/~B/g,""),a},N=function(a,b,c){var d="(["+b.replace(/([\[\]\\])/g,"\\$1")+"])";c&&(d="\\\\"+d);var e=new RegExp(d,"g");return a=a.replace(e,O),a},O=function(a,b){var c=b.charCodeAt(0);return"~E"+c+"E"}},typeof module!="undefined"&&(module.exports=Showdown),typeof define=="function"&&define.amd&&define("showdown",function(){return Showdown});var Gesture=function(){"use strict";var cursor,allowedEvent=["gestureStart","gestureMove","gestureEnd","gesture"],listeners=[],startTarget,endTarget;cursor={startX:0,startY:0};function getEvent(event){if(event.touches){if(event.type==="touchend"){return event.changedTouches[0]}else{return event.touches[0]}}else{return event}}function onTouchStart(event){var ev=getEvent(event);cursor.startX=ev.pageX;cursor.startY=ev.pageY;startTarget=ev.target;listeners.forEach(function(elmt){if(elmt.contains(ev.target)){elmt.dispatchEvent(new CustomEvent("gestureStart",{detail:ev}))}})}function onTouchMove(event){var ev=getEvent(event);listeners.forEach(function(elmt){if(elmt.contains(ev.target)){elmt.dispatchEvent(new CustomEvent("gestureMove",{detail:ev}))}})}function onTouchEnd(event){var ev=getEvent(event),delta=10,dirs=["N","NW","W","SW","S","SE","E","NE","N"],dir=false;endTarget=ev.target;if(Math.abs(ev.pageX-cursor.startX)>delta||Math.abs(ev.pageY-cursor.startY)>delta){dir=dirs[Math.round(Math.atan2(ev.pageX-cursor.startX,ev.pageY-cursor.startY)*4/Math.PI)+4]}listeners.forEach(function(elmt){if(elmt.contains(ev.target)){elmt.dispatchEvent(new window.CustomEvent("gestureEnd",{detail:ev}));if(dir){elmt.dispatchEvent(new window.CustomEvent("gesture",{detail:{dir:dir,startTarget:startTarget,endTarget:endTarget}}))}}})}function attach(element,events){var names=Object.keys(events),remaining=names.filter(function(e){return allowedEvent.indexOf(e)===-1});if(remaining.length>0){throw"Wrong event names: "+remaining.join(", ")}names.forEach(function(ev){element.addEventListener(ev,events[ev])});listeners.push(element)}function detach(element,events){var names=Object.keys(events),remaining=names.filter(function(e){return allowedEvent.indexOf(e)===-1});if(remaining.length>0){throw"Wrong event names: "+remaining.join(", ")}names.forEach(function(ev){element.removeEventListener(ev,events[ev])})}window.addEventListener("mousedown",onTouchStart);window.addEventListener("touchstart",onTouchStart);window.addEventListener("mouseup",onTouchEnd);window.addEventListener("touchend",onTouchEnd);window.addEventListener("mousemove",onTouchMove);window.addEventListener("touchmove",onTouchMove);return{attach:attach,detach:detach}}();var matchesSelector=document.documentElement.matches||document.documentElement.matchesSelector||document.documentElement.webkitMatchesSelector||document.documentElement.mozMatchesSelector||document.documentElement.oMatchesSelector||document.documentElement.msMatchesSelector;var realLog=console.log;var utils={device:{type:"",orientation:""},logLevel:"debug",logLevels:["debug","info","warning","error"],uuid:function uuid(){"use strict";var id="",i,random;for(i=0;i<32;i++){random=Math.random()*16|0;if(i===8||i===12||i===16||i===20){id+="-"}id+=(i===12?4:i===16?random&3|8:random).toString(16)}return id},format:function format(str){"use strict";var params=Array.prototype.splice.call(arguments,1);return str.replace(/%s/g,function(){return params.shift()})},trim:function trim(str){"use strict";return str.replace(/^\s+/,"").replace(/\s+$/,"")},getDate:function(d){"use strict";var date=typeof d==="undefined"?new Date:new Date(d);date.setMinutes(date.getMinutes()-date.getTimezoneOffset());return date.toISOString()},log:function log(){"use strict";var args=Array.prototype.slice.call(arguments),level,levelNum,message,ui,curDate=utils.getDate().substr(11,8),ts;if(args.length>1){level=args.pop()}else{level="info"}levelNum=utils.logLevels.indexOf(level);if(levelNum===-1){realLog("Unknown log level "+level)}if(levelNum>=utils.logLevels.indexOf(utils.logLevel)){if(args.length===1){message=args[0];if(typeof message==="object"){message=JSON.stringify(message,null,"  ")}}else{message=utils.format.apply(null,args)}ts=Math.round(Date.now()/1e3);if(message!==utils.log.lastMessage||ts>utils.log.lastMessageDate+60){ui=document.getElementById("debugLog");if(ui){ui.innerHTML=utils.format('<p><span class="%s">[%s][%s]</span> %s<p>',level,curDate,level+new Array(10-level.length).join(" "),message)+ui.innerHTML;if(level==="error"){document.body.classList.add("error")}}}utils.log.lastMessage=message;utils.log.lastMessageDate=ts;try{realLog(utils.format("=====> [%s][%s] %s\n",curDate,level+new Array(10-level.length).join(" "),message))}catch(e){}}},notify:function(title,body,cb){"use strict";var notif;title="[Àlir] "+title;if("Notification"in window){if(window.Notification.permission==="granted"){notif=new window.Notification(title,{body:body});if(cb){notif.addEventListener("click",cb)}}else if(window.Notification.permission!=="denied"){window.Notification.requestPermission(function(permission){if(!("permission"in window.Notification)){window.Notification.permission=permission}if(permission==="granted"){notif=new window.Notification(title,{body:body});if(cb){notif.addEventListener("click",cb)}}})}}else if("mozNotification"in navigator){notif=navigator.mozNotification.createNotification(title,body);notif.show();if(cb){notif.addEventListener("click",function(){cb();notif.close()},false)}}else{window.alir.ui.message(title+"\n"+body,"info")}},merge:function(a,b){"use strict";Object.keys(a).forEach(function(keyA){if(typeof b[keyA]==="undefined"){b[keyA]=a[keyA]}else{if(typeof a[keyA]==="object"){b[keyA]=utils.merge(a[keyA],b[keyA])}}});return b},match:function(elmt,sel){"use strict";sel=sel+", "+sel+" *";return matchesSelector.call(elmt,sel)},parent:function(elmt,match){"use strict";var res=null,found=false;while(!found){if(elmt.nodeType!==1){found=true}else{if(match(elmt)){res=elmt;found=true}else{elmt=elmt.parentNode}}}return res},toArray:function(obj,key){"use strict";key=key||"_id";var res=[];Object.keys(obj).forEach(function(k){var item=obj[k];item[key]=k;res.push(item)});return res},createXPathFromElement:function(elm){"use strict";var allNodes=document.getElementsByTagName("*"),uniqueIdCount,i,n,sib,segs;for(segs=[];elm&&elm.nodeType===1;elm=elm.parentNode){if(elm.hasAttribute("id")){uniqueIdCount=0;for(n=0;n<allNodes.length;n++){if(allNodes[n].hasAttribute("id")&&allNodes[n].id===elm.id){uniqueIdCount++}if(uniqueIdCount>1){break}}if(uniqueIdCount===1){segs.unshift('//*[@id="'+elm.getAttribute("id")+'"]');return segs.join("/")}else{segs.unshift(elm.localName.toLowerCase()+'[@id="'+elm.getAttribute("id")+'"]')}}else if(elm.hasAttribute("class")){segs.unshift(elm.localName.toLowerCase()+'[@class="'+elm.getAttribute("class")+'"]')}else{for(i=1,sib=elm.previousSibling;sib;sib=sib.previousSibling){if(sib.localName===elm.localName){i++}}segs.unshift(elm.localName.toLowerCase()+"["+i+"]")}}return segs.length?"/"+segs.join("/"):null},cleanupUrl:function(url){"use strict";if(url.substr(0,4)!=="http"){url="http://"+url}var s=url.match(/\//g);if(s!==null&&s.length<3){url+="/"}return url},getAbsoluteUri:function(base,relative){"use strict";if(relative.substr(0,4)==="http"){return relative}base=utils.cleanupUrl(base);var abs=relative.substr(0,1)==="/",domain,domainUrl="",baseUrl="";domain=new RegExp("((http.?://[^/]+).*/)([^?]*).?(.*$)").exec(base);if(domain!==null){domainUrl=domain[2];baseUrl=domain[1]}if(abs){return domainUrl+relative}else{return baseUrl+relative}}};console.log=function(){"use strict";[].slice.call(arguments).forEach(function(a){utils.log(a,"debug")})};window.onerror=function(errorMsg,url,lineNumber){"use strict";utils.log("%s on %s:%s",errorMsg,url,lineNumber,"error")};var Tiles=function(global){"use strict";RemoteStorage.eventHandling(this,"leaving","shown","help","helpClosed");var self=this,current,currentParams,tiles=[],popup=window.matchMedia("(min-width: 78rem) and (min-height: 3rem)").matches;this.show=function(fullname){var name=fullname.split("|")[0],params=fullname.split("|").slice(1);this._emit("leaving",current);Array.prototype.forEach.call(document.querySelectorAll("[data-tile]"),function(e){if(e.dataset.tile===name){e.classList.add("shown");
window.scrollTo(0,0);current=name;currentParams=params}else{e.classList.remove("shown")}});window.alir.ui.toggleMenu(false);window.location.hash=fullname;this._emit("shown",name,params)};this.go=function(fullname,cb){var name=fullname.split("|")[0],params=fullname.split("|").slice(1),i=tiles.findIndex(function(e){return e.name===name}),next,popupElmt;if(i!==-1&&tiles[i].params.join("|")===params.join("|")){next=tiles[i];next.params.unshift(next.name);this.show(next.params.join("|"));if(typeof next.cb==="function"){next.cb()}window.scrollTo(0,0);tiles.splice(i)}else{if(name!==current&&typeof current!=="undefined"||name===current&&params.length>0){tiles.push({name:current,y:window.scrollY,cb:cb,params:currentParams})}if(popup){popupElmt=document.querySelector(".popup[data-tile]");if(popupElmt){popupElmt.classList.remove("popup")}popupElmt=document.querySelector("[data-tile='"+name+"']");this._emit("leaving",current);if(popupElmt){popupElmt.classList.add("popup");setTimeout(function(){popupElmt.style.left=popupElmt.getBoundingClientRect().width-2+"px";popupElmt.style.opacity="1"});window.scrollTo(0,0);window.location.hash=fullname;this._emit("shown",name,params);current=name;currentParams=params}}else{this.show(fullname)}}window.alir.ui.toggleMenu(false)};this.back=function(res){var popupOldElmt,popupNewElmt,next;next=tiles.pop();if(typeof next==="undefined"){next={name:"articleList",y:0,params:[]}}if(popup){popupOldElmt=document.querySelector(".popup[data-tile]");if(popupOldElmt){popupOldElmt.style.left="0";popupOldElmt.style.opacity="0";setTimeout(function(){popupOldElmt.style.left="0";popupOldElmt.style.opacity="1";popupOldElmt.classList.remove("popup");if(tiles.length===0){document.body.classList.remove("popup")}},500)}this._emit("leaving",current);next.params.unshift(next.name);window.location.hash=next.params.join("|");if(tiles.length!==0){popupNewElmt=document.querySelector("[data-tile='"+next.name+"']");if(popupNewElmt){popupNewElmt.classList.add("popup")}}else{self.show(next.params.join("|"))}if(typeof next.cb==="function"){next.cb(res)}current=next.name;currentParams=next.params;this._emit("shown",current,next.params)}else{if(typeof next==="object"){next.params.unshift(next.name);this.show(next.params.join("|"));if(typeof next.cb==="function"){next.cb(res)}window.scrollTo(0,next.y)}}window.alir.ui.toggleMenu(false)};this.$=function(name){var root=document.querySelector('[data-tile="'+name+'"]');return function(sel){return root.querySelector(sel)}};this.pop=function(){var tile=tiles.pop();current=tile.name;currentParams=tile.params;return tile};this.tiles=function(){return tiles};this.getCurrent=function(){return current};this.getCurrentTile=function(){return document.querySelector("[data-tile='"+current+"']")};this.exists=function(name){return document.querySelectorAll("[data-tile='"+name+"']").length===1};window.addEventListener("resize",function(){var newState=window.matchMedia("(min-width: 78rem) and (min-height: 3rem)").matches,curr;if(newState!==popup){if(tiles.length>0){curr=current;self.back();popup=newState;self.go(curr)}else{popup=newState}}},false)};window.tiles=new Tiles;window.$=function(sel,root){"use strict";root=root||document;return root.querySelector(sel)};window.$$=function(sel,root){"use strict";root=root||document;return[].slice.call(root.querySelectorAll(sel))};var View={};View.toDom=function(str,fullUrl){"use strict";var sandbox=document.createElement("div"),domain=new RegExp("((http.?://[^/]+).*/)([^?]*).?(.*$)").exec(fullUrl),domainUrl,baseUrl,parser;parser=new DOMParser;try{if(domain!==null){domainUrl=domain[2];baseUrl=domain[1]}else{domainUrl="";baseUrl=""}try{sandbox=parser.parseFromString(HTMLtoXML(str),"text/html")}catch(e){utils.log("Error sanityzing: "+e.toString(),"error");sandbox=parser.parseFromString(str,"text/html")}Array.prototype.forEach.call(sandbox.querySelectorAll("script, style","frame","iframe"),function(e){e.parentNode.removeChild(e)});["class","id","style","onclick","onload"].forEach(function(attr){Array.prototype.forEach.call(sandbox.querySelectorAll("* ["+attr+"]"),function(e){e.removeAttribute(attr)})});Array.prototype.forEach.call(sandbox.querySelectorAll("* a[href]"),function(e){e.setAttribute("target","_blank")});Array.prototype.forEach.call(sandbox.querySelectorAll("* img:not([src^=http])"),function(e){var src=e.getAttribute("src"),cachedImg;function srcError(){utils.log("[view] Unable to load %s from %s",src,fullUrl)}if(src){if(src.substr(0,1)==="/"){src=domainUrl+src}else{src=baseUrl+src}e.setAttribute("src",src);cachedImg=new Image;cachedImg.onerror=srcError;cachedImg.onabort=srcError;cachedImg.src=src}});Array.prototype.forEach.call(sandbox.querySelectorAll("* a[href]:not([href^=http])"),function(e){var src=e.getAttribute("href");if(src){if(src.substr(0,1)==="/"){e.setAttribute("href",domainUrl+src)}else{e.setAttribute("href",baseUrl+src)}}})}catch(e){utils.log("Error displaying content: "+e.toString(),"error")}return sandbox.querySelector("html").innerHTML};View.insertInList=function(list,selector,item,comp){"use strict";var nextNode;Array.prototype.slice.call(list.querySelectorAll(selector)).some(function(e){if(comp(e)){nextNode=e;return true}});if(typeof nextNode==="undefined"){list.appendChild(item)}else{list.insertBefore(item,nextNode)}};View.template=function(sel,data){"use strict";var re=new RegExp("{{([=#].*?)}}","g"),frag,xpathResult,i,elmt,attr;function getData(path,val){var res=val,expr;if(path.substr(0,3)==="../"){return val[".."][path.substr(3)]}if(path!=="."){expr=path.split(".");while(res&&expr.length>0){res=res[expr.shift()]}}if(typeof res==="undefined"){console.log("UNDEFINED",path,val)}return res}function repl(match){var res,tmp,fct,type,value;try{type=match[2];match=match.substr(3,match.length-5);switch(type){case"=":tmp=match.split("|");res=getData(utils.trim(tmp.shift()),data);if(tmp.length>0){while((fct=tmp.shift())!==undefined){switch(utils.trim(fct).toLowerCase()){case"join":res=res.join(",");break;case"tolocal":res=new Date(res).toLocaleString(undefined,{day:"2-digit",month:"2-digit",year:"numeric",hour:"2-digit",minute:"2-digit"});break;case"tolowercase":res=res.toLowerCase();break;default:utils.log("Unknown template function "+fct,"error")}}}break;case"#":tmp=match.split(" ");value=getData(tmp[1],data);if(Array.isArray(value)){res=value.reduce(function(p,c){var val={"..":data};val[tmp[1]]=c;return p+View.template(tmp[0],val).outerHTML},"")}else{res=View.template(tmp[0],data).outerHTML}break}}catch(e){utils.log("Exception in View/Template/repl: "+e.toString(),"error")}return res}frag=document.getElementById(sel);if(typeof frag==="undefined"){throw"No template with id "+sel}frag=frag.cloneNode(true);xpathResult=document.evaluate('//@*[contains(., "{{=")]',frag,null,XPathResult.UNORDERED_NODE_SNAPSHOT_TYPE,null);for(i=0;i<xpathResult.snapshotLength;i++){attr=xpathResult.snapshotItem(i);attr.nodeValue=attr.nodeValue.replace(re,repl)}xpathResult=document.evaluate('//*[contains(text(),"{{")]',frag,null,XPathResult.UNORDERED_NODE_SNAPSHOT_TYPE,null);for(i=0;i<xpathResult.snapshotLength;i++){elmt=xpathResult.snapshotItem(i);elmt.innerHTML=elmt.innerHTML.replace(re,repl)}return frag.children[0]};function Article(){"use strict";var self=this,_currentId,_currentUrl,_tags=[],_alternates=[],_cache={},dynamicSheet=document.getElementById("dynamicCss").sheet;function doNote(event){var res=utils.parent(event.target,function(el){return typeof el.dataset.key!=="undefined"});if(res!==null){window.comment.create(res.dataset.key,utils.createXPathFromElement(event.target))}}if("ontouchstart"in window){document.getElementById("articleShowTile").addEventListener("contextmenu",doNote,false)}document.getElementById("articleShowTile").addEventListener("dblclick",doNote,false);document.getElementById("articleShowTile").addEventListener("click",function(e){if(e.target.tagName==="IMG"){var $=tiles.$("imgShow");$("img").src=e.target.src;$(".title").textContent=e.target.alt+" "+e.target.title;tiles.go("imgShow")}},false);function prepare(obj){var title=obj.title||obj.id,data;if(typeof obj.notes!=="object"){obj.notes={}}if(typeof obj.date==="undefined"){obj.date=utils.getDate()}else{try{obj.date=utils.getDate(obj.date)}catch(e){utils.log("Wrong date in article.display: "+obj.date,"error")}}data={key:obj.id,context:"private",hasNotes:Object.keys(obj.notes).length>0?"hasNotes":"",title:title.replace(/</g,"&lt;").replace(/>/g,"&gt;"),url:obj.url||"",date:obj.date,tags:Array.isArray(obj.tags)?obj.tags:[],alternates:Array.isArray(obj.alternates)?obj.alternates:[],notes:Object.keys(obj.notes).map(function(e,i){return{id:e,url:obj.id+"/"+e,content:obj.notes[e].content}}),flags:typeof obj.flags==="object"?Object.keys(obj.flags).filter(function(e){return obj.flags[e]===true}).join(","):""};data.cleanTags=data.tags.filter(function(e){return["feed","star"].indexOf(e)===-1});if(data.title==="???"&&data.url!==""){data.title=data.url.replace(/\/$/,"").split("/").pop().replace(/[\W]/g," ")}if(utils.trim(data.title)===""){data.title=_("noTitle")}if(Array.isArray(obj.tags)&&obj.tags.length>0){obj.tags.forEach(function(tag){if(_tags.indexOf(tag)===-1){_tags.push(tag);(function(tag){var elmt=document.createElement("li");elmt.dataset.tag=tag;elmt.textContent=tag;View.insertInList(document.getElementById("tagList"),"li",elmt,function(e){return e.dataset.tag.toLowerCase()>tag.toLowerCase()})})(tag)}})}return data}window.tiles.on("leaving",function(name){if(name==="articleShow"&&typeof _currentId!=="undefined"){_cache[_currentId]={url:_currentUrl,tags:_tags,alternates:_alternates};self.hide()}});window.tiles.on("shown",function(name,params){if(name==="articleShow"&&params[0]!=="undefined"){_currentId=params[0];if(typeof _cache[_currentId]!=="undefined"){_currentUrl=_cache[_currentId].url;_tags=_cache[_currentId].tags;_alternates=_cache[_currentId].alternates}}if(name==="articleShow"&&typeof _currentId!=="undefined"){self.onShown(_currentId)}});window.tiles.on("help",function(name){if(name==="articleShow"&&typeof _currentId!=="undefined"){self.ui.menu(true)}});window.tiles.on("helpClosed",function(name){if(name==="articleShow"&&typeof _currentId!=="undefined"){self.ui.menu(false)}});this.setCurrent=function setCurrent(current){if(typeof current==="undefined"){_currentId=undefined;_currentUrl=undefined;_alternates=[]}else{_currentId=current.id;_currentUrl=current.url||""}};this.getCurrentId=function getCurrentId(){return _currentId};this.addToList=function(obj){var data,item,classes=[];item=$('#list > [data-key="'+obj.id+'"]');if(item){classes=[].slice.call(item.classList);item.parentNode.removeChild(item)}data=prepare(obj);data.type="none";data.content="";item=View.template("tmpl-article",data);View.insertInList(document.getElementById("list"),"[data-key]",item,function(e){return e.dataset.date<obj.date});if(classes.length!==0){classes.forEach(function(cl){item.classList.add(cl)})}};this.display=function(obj,update){var data,item,topNote,tile;data=prepare(obj);if(obj.html){data.type="html";data.content=View.toDom(obj.html,obj.url)}else{data.type="text";data.content=obj.text}item=View.template("tmpl-article-detail",data);if(typeof obj.notes==="object"){topNote=item.querySelector(".content > .notes");Object.keys(obj.notes).forEach(function(noteId,i){var note=obj.notes[noteId],target,container,a;container=document.createElement("div");container.appendChild(item);try{target=document.evaluate(note.xpath,container,null,XPathResult.FIRST_ORDERED_NODE_TYPE,null).singleNodeValue;if(target===null){target=item.querySelector(".html").firstElementChild}}catch(e){utils.log("Unable to evaluate XPath "+note.xpath+" : "+e,"error")}if(target){a=document.createElement("a");a.setAttribute("class","note icon-comment");a.dataset.object="comment";a.dataset.method="read";a.dataset.params=obj.id+","+noteId;a.setAttribute("href","#"+obj.id+"/"+noteId);a.setAttribute("name",noteId);target.insertBefore(a,target.firstChild)}else{utils.log("Unable to evaluate XPath "+note.xpath,"error")}})}if(Array.isArray(obj.alternates)&&obj.alternates.length>0){item.classList.add("hasAlternates");_alternates=obj.alternates}else{_alternates=[]}tile=document.getElementById("articleShowTile");tile.innerHTML="";tile.appendChild(item);self.setCurrent(obj);if(update!==true){tiles.go("articleShow|"+obj.id)}self.ui.showTab("content");return item};this.create=function(){var choices=[];$('#articleEditTile [name="id"]').value="";$('#articleEditTile [name="url"]').value="http://";$('#articleEditTile [name="title"]').value="";$('#articleEditTile [name="text"]').value="";choices.push({object:"articles",method:"createArticle",l10nId:"articleCreateArticle"});choices.push({object:"articles",method:"createUrl",l10nId:"articleCreateUrl"});window.alir.ui.choice(choices,_("articleCreateChoice"))};this.createArticle=function(){var tile=document.querySelector("[data-tile=articleEdit]");tiles.back();tile.classList.remove("url");tile.classList.add("article");tiles.go("articleEdit")};this.createUrl=function(){var tile=document.querySelector("[data-tile=articleEdit]");tiles.back();tile.classList.add("url");tile.classList.remove("article");tiles.go("articleEdit")};this.read=function(key,cb){remoteStorage.alir.getArticle(key,cb)};this.edit=function(key){var tile=document.querySelector("[data-tile=articleEdit]");tile.classList.remove("url");tile.classList.add("article");self.read(key,function(article){if(typeof article!=="undefined"){$('#articleEditTile [name="id"]').value=key;$('#articleEditTile [name="title"]').value=article.title;$('#articleEditTile [name="url"]').value=article.url;$('#articleEditTile [name="text"]').value=article.text;tiles.go("articleEdit")}})};this.delete=function(key,title){var elmt;if(window.confirm(_("confirmDelete",{title:title}))){remoteStorage.alir.private.remove("article/"+key);delete config.bookmarks[key];elmt=$('#list > [data-key="'+key+'"]');if(elmt){elmt.parentNode.removeChild(elmt)}window.alir.ui.message(_("articleDeleted"),"info");if(tiles.getCurrent()==="articleShow"){tiles.back();self.hide()}}};this.save=function(){var tile=document.querySelector("[data-tile=articleEdit]"),id=$('#articleEditTile [name="id"]').value,article;function doSave(article){if(article.url==="http://"){article.url=""}remoteStorage.alir.saveArticle(article);tiles.back();self.display(article)}if(id){self.read(id,function(article){if(article){article.url=$('#articleEditTile [name="url"]').value;article.title=$('#articleEditTile [name="title"]').value;article.text=$('#articleEditTile [name="text"]').value;article.html=(new Showdown.converter).makeHtml(article.text);article.date=Date.now();doSave(article)}else{utils.log("Unable to load article "+id,"error")}})}else{if(tile.classList.contains("article")){article={id:utils.uuid(),url:$('#articleEditTile [name="url"]').value,title:$('#articleEditTile [name="title"]').value,text:$('#articleEditTile [name="text"]').value,html:(new Showdown.converter).makeHtml($('#articleEditTile [name="text"]').value),date:Date.now(),flags:{editable:true},tags:["note"]};doSave(article)}else{tiles.back();window.link.scrap($('#articleEditTile [name="url"]').value)}}};this.reload=function(key){window.alir.ui.message(_("articleReloading"),"info");self.read(key,function(article){if(typeof article!=="undefined"){window.scrap(article.url,function(err,res){if(err){utils.log(err.toString(),"error")}else{res.id=key;window.saveScraped(res)}})}})};this.show=function show(key){if(key===_currentId){return}function doShow(){$('[data-key="'+key+'"]').classList.add("read");_currentId=key;self.onShown()}self.read(key,function(article){if(article){self.display(article);doShow()}else{window.alir.ui.message(_("articleNotFound"),"error")}})};this.onShown=function onShown(){var scroll;self.ui.menu(false);$("#menu .content .top").href="#"+_currentId;if(config.bookmarks[_currentId]){scroll=config.bookmarks[_currentId]*$("#articleShowTile").clientHeight}else{scroll=0}window.setTimeout(function(){window.scrollTo(0,scroll)},100)};this.hide=function hide(){var current=$('#list > [data-key="'+_currentId+'"]');if(current){config.bookmarks[_currentId]=window.scrollY/$("#articleShowTile").clientHeight;current.classList.remove("current");current.scrollIntoView()}window.alir.ui.toggleMenu(false);self.setCurrent()};this.addTag=function(key){tiles.go("tagTile",function(tag){if(typeof tag!=="undefined"){if(tag!==null){self.switchTag(key,tag)}}})};this.switchTag=function(key,tag){var node=$('#list > [data-key="'+key+'"]'),_tags=node.dataset.tags.split(",").filter(function(e){return e!==""}),i=_tags.indexOf(tag);if(i!==-1){_tags.splice(i,1);node.dataset.tags=","+_tags.join(",")+",";switch(tag){case"archive":window.alir.ui.message(_("articleNotArchived"),"info");break;case"star":window.alir.ui.message(_("articleNotStar"),"info");break;default:window.alir.ui.message(_("articleNotTag",{tag:tag}),"info");break}}else{_tags.splice(1,0,tag);node.dataset.tags=","+_tags.join(",").replace(",,,",",,")+",";switch(tag){case"archive":window.alir.ui.message(_("articleDoArchived"),"info");break;case"star":window.alir.ui.message(_("articleDoStar"),"info");break;default:window.alir.ui.message(_("articleDoTag",{tag:tag}),"info");break}}self.read(key,function(article){if(article){article.tags=_tags.filter(function(t){return t!==""});remoteStorage.alir.saveArticle(article);self.display(article,true)}})};this.share=function(key){if(typeof window.MozActivity!=="undefined"){var node=$('#list > [data-key="'+key+'"]'),request=new window.MozActivity({name:"share",data:{type:"url",url:node.dataset.url}});request.onerror=function(){if(request.error.name!=="USER_ABORT"){utils.log("Error sharing : "+request.error.name,"error");window.alir.ui.message(_("sharingError"),"error")}}}else{utils.log("Share is not available","error")}};this.ui={menu:function(folded){var cl=$("#articleShowTile .articleMenu").classList,actions=$("#articleShowTile .articleMenu .articleActions");function style(){if(cl.contains("folded")){if(document.body.classList.contains("bottom")){actions.style.marginBottom=-(actions.clientHeight+16)+"px"}else{actions.style.marginTop=-(actions.clientHeight+16)+"px"}}else{if(document.body.classList.contains("bottom")){actions.style.marginBottom=""}else{actions.style.marginTop=""}}}if(typeof folded==="undefined"){cl.toggle("folded");style()}else if(folded){cl.remove("folded");style()}else{cl.add("folded");style()}},filterArchive:function(){$("#main").classList.toggle("archives")},filterFeed:function(){$("#main").classList.toggle("feeds")},filterStar:function(){$("#main").classList.toggle("stars")},editArticles:function(){$("#main").classList.toggle("edit")},deleteArticles:function(){var toDel=window.$$("#list h2 .delitem input:checked");if(toDel.length>0){if(window.confirm(_("articlesDelete",{nb:toDel.length}))){toDel.forEach(function(elmt){var parent=utils.parent(elmt,function(e){return typeof e.dataset.key!=="undefined"}),key;if(parent){key=parent.dataset.key;remoteStorage.alir.private.remove("article/"+key);delete config.bookmarks[key];parent.parentNode.removeChild(parent)}})}}$("#main").classList.remove("edit")},updateFilter:function(){var filterVal=document.getElementById("listFilter").value.toLowerCase();while(dynamicSheet.cssRules[0]){dynamicSheet.deleteRule(0)}if(utils.trim(filterVal)!==""){dynamicSheet.insertRule("#main.list #list > li[data-tags] { display: none !important; }",0);dynamicSheet.insertRule('#main.list #list > li[data-tags*="'+filterVal+'"], #main.list #list > li[data-title*="'+filterVal+'"] { display: block !important; }',1)}},addFilterTag:function(){tiles.go("tagTile",function(tag){if(typeof tag!=="undefined"){if(tag!==null){document.getElementById("listFilter").value=tag;self.ui.updateFilter()}}})},scrollToNote:function(noteId){var note=document.querySelector('[name="'+noteId+'"]');if(note){window.articles.ui.showTab("content");note.scrollIntoView(true)}else{utils.log("No note with id "+noteId,"warning")}},toggleAlternates:function(){var choices=[];if(Array.isArray(_alternates)){_alternates.forEach(function(e){var href=utils.getAbsoluteUri(_currentUrl,e.href);choices.push({object:"feeds",method:"create",params:e.href+","+e.title,content:e.title||href})})}window.alir.ui.choice(choices,_("feedUrlChoice"))},showTab:function(name){var tile=document.getElementById("articleShowTile");["content","notes","meta"].forEach(function(tab){if(tab===name){tile.classList.add("tab-"+tab)}else{tile.classList.remove("tab-"+tab)}})}};this.mock=function(n){var article,ipsum,aIpsum,i,j,l,text;if(typeof n==="undefined"){n=1}ipsum="Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum";aIpsum=ipsum.split(" ");l=aIpsum.length;function title(){var res=[],j;for(j=0;j<Math.floor(Math.random()*5)+1;j++){res.push(aIpsum[Math.floor(Math.random()*(l-1))])}res=res.join(" ");return res.charAt(0).toUpperCase()+res.slice(1)}for(i=0;i<n;i++){text="";for(j=0;j<Math.floor(Math.random()*10)+1;j++){text+="###"+title()+"\n\n"+ipsum+"\n\n"}article={id:utils.uuid(),title:title(),html:(new Showdown.converter).makeHtml(text),date:Date.now(),flags:{editable:true}};article.tags=article.title.toLowerCase().split(" ");remoteStorage.alir.saveArticle(article)}}}window.articles=new Article;window.Comment=function(){"use strict";var UI,self=this;UI={article:$('#noteEditTile [name="articleId"]'),path:$('#noteEditTile [name="xpath"]'),content:$('#noteEditTile [name="text"]')};this.create=function(article,path){UI.article.value=article;UI.path.value=path;UI.content.value="";window.tiles.go("noteEdit");$('#noteEditTile [name="text"]').focus()};this.read=function(articleId,noteId,cb){window.articles.read(articleId,function(article){if(article){if(typeof cb==="undefined"){var tile=document.getElementById("noteViewTile");tile.dataset.noteId=noteId;$(".content",tile).textContent=article.notes[noteId].content;$('[name="text"]',tile).value=article.notes[noteId].content;$('[name="articleId"]',tile).value=articleId;$('[name="noteId"]',tile).value=noteId;$('[name="xpath"]',tile).value=article.notes[noteId].xpath;$('[name="url"]',tile).value=article.url;tiles.go("noteView")}else{article.notes[noteId].articleUrl=article.url;cb(article.notes[noteId])}}})};this.save=function(){var noteId=$('#noteEditTile [name="noteId"]').value,articleId=$('#noteEditTile [name="articleId"]').value;if(!noteId){noteId=utils.uuid()}window.articles.read(articleId,function(article){if(article){if(typeof article.notes!=="object"){article.notes={}}article.notes[noteId]={xpath:$('#noteEditTile [name="xpath"]').value,content:$('#noteEditTile [name="text"]').value};remoteStorage.alir.saveArticle(article);if(document.getElementById("noteViewTile").dataset.noteId===noteId){$("#noteViewTile .content").textContent=article.notes[noteId].content;$('#noteViewTile [name="text"]').value=article.notes[noteId].content}tiles.back();window.articles.display(article,true)}})};this.edit=function(){["articleId","noteId","xpath","text"].forEach(function(field){$('#noteEditTile [name="'+field+'"]').value=$('#noteViewTile [name="'+field+'"]').value});window.tiles.go("noteEdit")};this.delete=function(){var noteId=$('#noteViewTile [name="noteId"]').value,articleId=$('#noteViewTile [name="articleId"]').value;if(window.confirm(_("noteConfirmDelete"))){window.articles.read(articleId,function(article){if(article){delete article.notes[noteId];remoteStorage.alir.saveArticle(article);tiles.back();window.articles.display(article,true)}else{tiles.back()}})}else{tiles.back()}};this.share=function(articleId,noteId){function doShare(url,value){document.getElementById("linkRef").textContent=url;document.getElementById("linkRefFull").textContent=url;document.getElementById("linkText").value=value;tiles.go("link")}if(typeof articleId!=="undefined"){self.read(articleId,noteId,function(note){if(typeof note!=="undefined"){doShare(note.articleUrl,note.content)}})}else{doShare($('#noteViewTile [name="url"]').value,$("#noteViewTile .content").textContent)}}};window.comment=new window.Comment;function Feeds(){"use strict";var _cache={},self=this;this.cache=function(obj){_cache[obj.url]=obj};this.display=function(obj){var title=obj.title||obj.id,data={},item,classes=[];item=document.getElementById(obj.id);if(item){classes=[].slice.call(item.classList);item.parentNode.removeChild(item)}data={key:obj.id,context:"private",title:title,url:obj.url};item=View.template("tmpl-feed",data);View.insertInList(document.getElementById("feedsList"),"[data-key]",item,function(e){return e.dataset.title.toLowerCase()>title.toLowerCase()});window.feeds.cache(obj);if(classes.length!==0){classes.forEach(function(cl){item.classList.add(cl)})}return item};this.save=function(){var $=tiles.$("feedEdit"),id=$('[name="id"]').value,obj;function doSave(feed){remoteStorage.alir.saveFeed(feed);window.feeds.display(feed);window.feeds.cache(feed);tiles.show("feeds");$('[name="url"]').value="http://";$('[name="title"]').value="";$('[name="feedShort"]').checked=false}if(id){remoteStorage.alir.getFeed(id,function(obj){if(obj){obj.url=$('[name="url"]').value;obj.title=$('[name="title"]').value;obj.short=$('[name="feedShort"]').checked;obj.date=Date.now();doSave(obj)}})}else{obj={id:utils.uuid(),url:$('[name="url"]').value,title:$('[name="title"]').value,date:Date.now(),short:$('[name="feedShort"]').checked,articles:{}};doSave(obj)}};this.fetch=function(url,test,cb){url=utils.cleanupUrl(url);if(typeof _cache[url]==="undefined"){if(test){_cache[url]={articles:{},short:false,title:"???"}}else{utils.log("No cache for url "+url,"error");window.alir.ui.message(_("feedNoCache"),"error");if(cb){cb({})}return}}function getAlternates(doc){var alternates,choices=[];alternates=doc.querySelectorAll("link[rel='alternate'][type*=xml][href]");if(alternates.length>0){[].slice.apply(alternates).forEach(function(e){var href=utils.getAbsoluteUri(url,e.getAttribute("href"));choices.push({object:"feeds.ui",method:"setFeedUrl",params:href,content:e.title||href})});window.alir.ui.choice(choices,_("feedUrlChoice"))}return alternates.length}function onFeedGot(err,doc){var feedUpdated,root,format="atom",cache,parser,back=true;cache=_cache[url];utils.log("Updating feed "+cache.title,"debug");if(err){utils.log(err,"warning")}else{if(!doc.responseXML||doc.responseXML&&doc.responseXML.getElementsByTagName("rss").length===0&&doc.responseXML.getElementsByTagName("feed").length===0){try{parser=new DOMParser;doc=parser.parseFromString(doc.response,"text/html")}catch(e){utils.log("Error parsing feed : "+e.toString(),"error")}if(doc.getElementsByTagName("rss").length===0&&doc.getElementsByTagName("feed").length===0){utils.log("Unable to get feed type for "+url,"error");if(test){back=getAlternates(doc)===0}if(back&&cb){cb(cache.articles)}return}}else{doc=doc.responseXML}if(!doc){utils.log("Unable to parse feed "+url,"error");if(cb){cb(cache.articles)}return}doc.url=url;root=doc.getElementsByTagName("rss");if(root.length>0){format="rss";root="rss > channel "}else{format="atom";root="feed "}utils.log("Feed format : "+format,"debug");feedUpdated=doc.querySelector(root+" > updated");if(feedUpdated){feedUpdated=new Date(feedUpdated.textContent)}root=format==="atom"?root+" entry":root+" item";[].slice.call(doc.querySelectorAll(root)).forEach(function(entry){var itemContent,itemId,itemTitle,itemUpdated,itemUrl;function getVal(key,prop){var val=entry.querySelector(key);if(val){if(prop){return val.getAttribute(prop)}else{if(val.textContent!==""){return utils.trim(val.textContent)}else if(val.nextSibling&&val.nextSibling.nodeType===3){return utils.trim(val.nextSibling.textContent)}}}else{return null}}itemId=format==="atom"?getVal("id"):getVal("guid");itemUrl=format==="atom"?getVal("link","href"):getVal("link");itemTitle=getVal("title");itemContent=getVal("encoded")||getVal("content")||getVal("summary")||getVal("description");itemUpdated=entry.querySelector("updated")||entry.querySelector("published")||entry.querySelector("pubDate")||entry.getElementsByTagNameNS("http://purl.org/dc/elements/1.1/","date");if(itemUpdated&&typeof itemUpdated.length!=="undefined"){itemUpdated=itemUpdated[0]}if(!!!itemId||!!!itemUpdated){return}itemUpdated=utils.getDate(itemUpdated.textContent);if(typeof cache.articles[itemId]!=="undefined"&&cache.articles[itemId].updated>=itemUpdated){return}if(test!==true){if(typeof cache.articles[itemId]==="undefined"){utils.log('New article "%s" in "%s"',itemTitle,cache.title,"info");utils.notify(_("articleNew",{title:cache.title}),itemTitle,function(){if(window.alir.getStatus().installed){navigator.mozApps.getSelf().onsuccess=function gotSelf(evt){var app=evt.target.result;if(app!==null){app.launch()}self.showArticle(itemUrl)}}else{self.showArticle(itemUrl)}})}else{utils.log('Article Updated : "%s" "%s" < "%s"',itemTitle,cache.articles[itemId].updated,itemUpdated,"info")}}if(itemUpdated>feedUpdated){feedUpdated=itemUpdated}function doSave(content){var article={id:utils.uuid(),url:itemUrl,title:itemTitle,html:content,date:itemUpdated,flags:{editable:false},tags:["feed",cache.title]};if(typeof content==="undefined"){article.loaded=false}else{View.toDom(content,itemUrl)}if(test!==true){remoteStorage.alir.saveArticle(article);window.articles.addToList(article)}return article.id}if(cache!==true){cache.articles[itemId]={url:itemUrl,updated:itemUpdated,title:itemTitle}}if(test!==true&&(cache.short||!!!itemContent)){window.scrap(itemUrl,function(err,res){if(err){utils.log(err.toString(),"error");doSave()}else{doSave(res.html)}})}else{doSave(itemContent)}});if(test!==true){remoteStorage.alir.getFeed(_cache[url].id,function(obj){if(obj){obj.articles=cache.articles;obj.date=Date.now();remoteStorage.alir.saveFeed(obj);window.feeds.display(obj);try{if(tiles.getCurrent()==="feedShow"&&document.querySelector("#feedDetail [data-url]").dataset.url===obj.url){window.feeds.show(obj.url)}}catch(e){}}})}}if(cb){cb(cache.articles)}}window.network.fetch(url,onFeedGot)};this.test=function(url){var $=tiles.$("feedEdit");url=url||$('[name="url"]').value;window.feeds.fetch(url,true,function(items){items=items||{};var nb=Object.keys(items).length;if(nb===0){window.alir.ui.message(_("feedTestNoResult"),"info")}else{window.alir.ui.message(_("feedTestResult",{nb:nb}),"info")}items={}})};this.create=function(url,title){if(typeof title==="undefined"){title=""}if(typeof url==="undefined"){url="http://"}var $=tiles.$("feedEdit");$('[name="id"]').value="";$('[name="url"]').value=url;$('[name="title"]').value=title;$('[name="feedShort"]').checked=false;tiles.go("feedEdit")};this.edit=function(url){var $=tiles.$("feedEdit"),feed=_cache[url];$('[name="id"]').value=feed.id;$('[name="url"]').value=feed.url;$('[name="title"]').value=feed.title;$('[name="feedShort"]').checked=feed.short;tiles.go("feedEdit")};this.show=function(url){var feed=_cache[url],parent=$("#feedDetail");if(feed){feed.items=utils.toArray(feed.articles);feed.items.forEach(function(v,k){if(!v.title){feed.items[k].title=v.url.split("/").pop()}});feed.items.sort(function(a,b){return a.updated>b.updated?-1:1});parent.innerHTML="";parent.appendChild(View.template("tmpl-feed-detail",feed));tiles.go("feedShow")}else{window.alir.ui.message(_("feedNotFound"),"error")}};this.delete=function(url){var feed=_cache[url],elmt;if(window.confirm(_("feedConfirmDelete",{title:feed.title}))){remoteStorage.alir.private.remove("feed/"+feed.id);elmt=$('#feedsList [data-key="'+feed.id+'"]');if(elmt){elmt.parentNode.removeChild(elmt)}delete _cache[url];tiles.show("feeds")}};this.update=function(){remoteStorage.alir.private.getAll("feed/").then(function(feeds){var keys,toFetch;if(feeds){keys=Object.keys(feeds);toFetch=keys.length;keys.forEach(function(key){window.feeds.fetch(feeds[key].url,false,function(){self.cache(feeds[key]);
toFetch--;if(toFetch===0){utils.log("Feeds updated","debug")}})})}else{keys=Object.keys(_cache);toFetch=keys.length;utils.log("No feeds yet","warning");keys.forEach(function(key){window.feeds.fetch(_cache[key].url,false,function(){toFetch--;if(toFetch===0){utils.log("Feeds updated","debug")}})})}})};this.showArticle=function(url){var elmt=$('[data-url="'+url+'"]');if(elmt){tiles.go("list");window.articles.show(elmt.dataset.key)}else{if(window.confirm(_("feedShowReload"))){window.scrap(url,function(err,article){var obj;obj={id:utils.uuid(),url:article.url,title:article.title,html:article.html,date:Date.now(),flags:{editable:false},tags:["feed"]};if(err){utils.log(err.toString(),"error");obj.loaded=false}else{View.toDom(article.html,article.url)}remoteStorage.alir.saveArticle(obj).then(function(){utils.log("Created : "+obj.title,"info");window.articles.display(obj)})})}}};this.handleNotificationMessage=function(message){if(!message.clicked){return}navigator.mozApps.getSelf().onsuccess=function gotSelf(evt){var app=evt.target.result;if(app!==null){app.launch()}}};this.handleAlarmMessage=function(mozAlarm){try{utils.log("alarm fired: "+JSON.stringify(mozAlarm.data),"debug")}catch(e){utils.log(e,"warning")}switch(mozAlarm.data.action){case"feedUpdate":try{self.update()}catch(e){utils.notify(_("feedUpdateError"),e.toString());utils.log(e,"warning")}try{window.alarms.plan()}catch(e){utils.notify(_("alarmPlanError"),e.toString());utils.log(e,"warning")}}};this.reset=function(url){_cache[url].article={};tiles.back();this.show(url);tiles.go("feedShow")};this.ui={setFeedUrl:function(url){document.getElementById("feedUrl").value=url;tiles.back()}};document.getElementById("feedUrl").addEventListener("change",function(){if(window.alir.getStatus().online===true){self.test()}},false)}window.feeds=new Feeds;if(navigator.mozAlarms){window.alarms={display:function(){"use strict";var request=navigator.mozAlarms.getAll();request.onsuccess=function(){var alarms=this.result;if(alarms.length===0){utils.log(_("alarmsNoAlarms"),"warning")}else{alarms.forEach(function(alarm){utils.log(alarm.data.action+" at "+alarm.date,"info")})}};request.onerror=function(){utils.log("Error getting alarms: "+this.error)}},plan:function(){"use strict";var request=navigator.mozAlarms.getAll();if(typeof window.utils!=="object"){window.utils=window.console}request.onsuccess=function(){var alarms=this.result,current=new Date,nb=alarms.length,interval=window.config.alarmInterval||60;utils.log(alarms.length+" alarms planned","debug");if(alarms.length===0){current.setMinutes(current.getMinutes()+1);window.alarms.set(current)}alarms.forEach(function(alarm){if(alarm.date>current){current=alarm.date}});utils.log("Last alarm planned at "+utils.getDate(current),"debug");while(nb<10){current.setMinutes(current.getMinutes()+parseInt(interval,10));window.alarms.set(current);nb++}};request.onerror=function(){utils.log("Error getting alarms: "+this.error)}},set:function(date){"use strict";var alarm,request;alarm={date:date,respectTimezone:"honorTimezone",data:{action:"feedUpdate"}};utils.log("Planning alarm at "+date,"debug");request=navigator.mozAlarms.add(alarm.date,alarm.respectTimezone,alarm.data);request.onsuccess=function(){utils.log("Alarm planned at "+date,"debug")};request.onerror=function(){utils.log("Error planning alarm at "+date,"error")}},reset:function(cb){"use strict";var request=navigator.mozAlarms.getAll();request.onsuccess=function(){this.result.forEach(function(alarm){navigator.mozAlarms.remove(alarm.id)});if(cb){cb()}};request.onerror=function(){utils.log("Error getting alarms: "+this.error)}}};if(navigator.mozSetMessageHandler){navigator.mozSetMessageHandler("alarm",window.feeds.handleAlarmMessage)}}else{window.alarms={all:[],display:function(){"use strict";if(this.all.length===0){utils.log(_("alarmsNoAlarms"),"warning")}else{this.all.forEach(function(alarm){utils.log(alarm.data.action+" at "+alarm.date,"debug")})}},plan:function(){"use strict";if(typeof window.utils!=="object"){window.utils=window.console}var current=new Date,nb=this.all.length,interval=window.config.alarmInterval||60;utils.log(this.all.length+" alarms planned","debug");if(nb===0){current.setMinutes(current.getMinutes()+1);window.alarms.set(current)}this.all.forEach(function(alarm){if(alarm.date>current){current=alarm.date}});utils.log("Last alarm planned at "+utils.getDate(current),"debug");while(nb<10){current.setMinutes(current.getMinutes()+parseInt(interval,10));window.alarms.set(current);nb++}},set:function(date){"use strict";var alarm,interval;interval=date-new Date;if(interval>0){alarm={date:date,data:{action:"feedUpdate"}};utils.log("Planning alarm at "+date,"debug");alarm.id=window.setTimeout(function(){delete window.config.alarms[date.toISOString()];window.feeds.handleAlarmMessage(alarm)},interval);this.all.push(alarm);window.config.alarms[date.toISOString()]=alarm}else{utils.log("Unable to plan action in the past "+date,"debug")}},reset:function(cb){"use strict";this.all.forEach(function(alarm){window.clearTimeout(alarm.id)});this.all=[];if(cb){cb()}}}}(function(global){global.saxParser=function saxParser(elem,callbacks){if(typeof callbacks!=="object")throw"please provide callbacks!";function parse(node){var name=node.tagName.toLowerCase(),attributeNodes=node.attributes;callbacks.onopentagname(name);for(var i=0,j=attributeNodes.length;i<j;i++){callbacks.onattribute(attributeNodes[i].name+"",attributeNodes[i].value)}var childs=node.childNodes,num=childs.length,nodeType;for(var i=0;i<num;i++){nodeType=childs[i].nodeType;if(nodeType===3)callbacks.ontext(childs[i].textContent);else if(nodeType===1)parse(childs[i])}callbacks.onclosetag(name)}parse(elem)}})(typeof unsafeWindow==="object"?unsafeWindow:this);(function(global){var Element=function(tagName,parent){this.name=tagName;this.parent=parent;this.attributes={};this.children=[];this.tagScore=0;this.attributeScore=0;this.totalScore=0;this.elementData="";this.info={textLength:0,linkLength:0,commas:0,density:0,tagCount:{}};this.isCandidate=false};Element.prototype={addInfo:function(){var info=this.info,childs=this.children,childNum=childs.length,elem;for(var i=0;i<childNum;i++){elem=childs[i];if(typeof elem==="string"){info.textLength+=elem.trim().length;if(re_commas.test(elem))info.commas+=elem.split(re_commas).length-1}else{if(elem.name==="a"){info.linkLength+=elem.info.textLength+elem.info.linkLength}else{info.textLength+=elem.info.textLength;info.linkLength+=elem.info.linkLength}info.commas+=elem.info.commas;for(var j in elem.info.tagCount){if(j in info.tagCount)info.tagCount[j]+=elem.info.tagCount[j];else info.tagCount[j]=elem.info.tagCount[j]}if(elem.name in info.tagCount)info.tagCount[elem.name]+=1;else info.tagCount[elem.name]=1}}if(info.linkLength!==0){info.density=info.linkLength/(info.textLength+info.linkLength)}},getOuterHTML:function(){var ret="<"+this.name;for(var i in this.attributes){ret+=" "+i+'="'+this.attributes[i]+'"'}if(this.children.length===0){if(this.name in formatTags)return ret+"/>";else return ret+"></"+this.name+">"}return ret+">"+this.getInnerHTML()+"</"+this.name+">"},getInnerHTML:function(){var nodes=this.children,ret="";for(var i=0,j=nodes.length;i<j;i++){if(typeof nodes[i]==="string")ret+=nodes[i];else ret+=nodes[i].getOuterHTML()}return ret},getFormattedText:function(){var nodes=this.children,ret="";for(var i=0,j=nodes.length;i<j;i++){if(typeof nodes[i]==="string")ret+=nodes[i].replace(re_whitespace," ");else{if(nodes[i].name==="p"||nodes[i].name in headerTags)ret+="\n";ret+=nodes[i].getFormattedText();if(nodes[i].name in newLinesAfter)ret+="\n"}}return ret},toString:function(){return this.children.join("")},getTopCandidate:function(){var childs=this.children,topScore=-Infinity,score=0,topCandidate,elem;for(var i=0,j=childs.length;i<j;i++){if(typeof childs[i]==="string")continue;if(childs[i].isCandidate){elem=childs[i];if(elem.name in tagCounts)elem.tagScore+=tagCounts[elem.name];score=Math.floor((elem.tagScore+elem.attributeScore)*(1-elem.info.density));if(topScore<score){elem.totalScore=topScore=score;topCandidate=elem}}if((elem=childs[i].getTopCandidate())&&topScore<elem.totalScore){topScore=elem.totalScore;topCandidate=elem}}return topCandidate}};var tagsToSkip={__proto__:null,aside:true,footer:true,head:true,label:true,nav:true,noscript:true,script:true,select:true,style:true,textarea:true},tagCounts={__proto__:null,address:-3,article:30,blockquote:3,body:-5,dd:-3,div:5,dl:-3,dt:-3,form:-3,h2:-5,h3:-5,h4:-5,h5:-5,h6:-5,li:-3,ol:-3,pre:3,section:15,td:3,th:-5,ul:-3},removeIfEmpty={__proto__:null,blockquote:true,li:true,p:true,pre:true,tbody:true,td:true,th:true,thead:true,tr:true},embeds={__proto__:null,embed:true,object:true,iframe:true},goodAttributes={__proto__:null,alt:true,href:true,src:true,title:true},cleanConditionally={__proto__:null,div:true,form:true,ol:true,table:true,ul:true},unpackDivs={__proto__:embeds,div:true,img:true},noContent={__proto__:formatTags,font:false,input:false,link:false,meta:false,span:false},formatTags={__proto__:null,br:new Element("br"),hr:new Element("hr")},headerTags={__proto__:null,h1:true,h2:true,h3:true,h4:true,h5:true,h6:true},newLinesAfter={__proto__:headerTags,br:true,li:true,p:true},divToPElements=["a","blockquote","dl","img","ol","p","pre","table","ul"],okayIfEmpty=["audio","embed","iframe","img","object","video"],re_videos=/http:\/\/(?:www\.)?(?:youtube|vimeo)\.com/,re_nextLink=/[>»]|continue|next|weiter(?:[^\|]|$)/i,re_prevLink=/[<«]|earl|new|old|prev/i,re_extraneous=/all|archive|comment|discuss|e-?mail|login|print|reply|share|sign|single/i,re_pages=/pag(?:e|ing|inat)/i,re_pagenum=/p[ag]{0,2}(?:e|ing|ination)?[=\/]\d{1,2}/i,re_safe=/article-body|hentry|instapaper_body/,re_final=/first|last/i,re_positive=/article|blog|body|content|entry|main|news|pag(?:e|ination)|post|story|text/,re_negative=/com(?:bx|ment|-)|contact|foot(?:er|note)?|masthead|media|meta|outbrain|promo|related|scroll|shoutbox|sidebar|sponsor|shopping|tags|tool|widget/,re_unlikelyCandidates=/ad-break|agegate|auth?or|bookmark|cat|com(?:bx|ment|munity)|date|disqus|extra|foot|header|ignore|links|menu|nav|pag(?:er|ination)|popup|related|remark|rss|share|shoutbox|sidebar|similar|social|sponsor|teaserlist|time|tweet|twitter/,re_okMaybeItsACandidate=/and|article|body|column|main|shadow/,re_sentence=/\. |\.$/,re_whitespace=/\s+/g,re_pageInURL=/[_\-]?p[a-zA-Z]*[_\-]?\d{1,2}$/,re_badFirst=/^(?:[^a-z]{0,3}|index|\d+)$/i,re_noLetters=/[^a-zA-Z]/,re_params=/\?.*/,re_extension=/00,|\.[a-zA-Z]+$/g,re_digits=/\d/,re_justDigits=/^\d{1,2}$/,re_slashes=/\/+/,re_domain=/\/([^\/]+)/,re_protocol=/^\w+\:/,re_cleanPaths=/\/\.(?!\.)|\/[^\/]*\/\.\./,re_closing=/\/?(?:#.*)?$/,re_imgUrl=/\.(gif|jpe?g|png|webp)$/i,re_commas=/,[\s\,]*/g;var Readability=function(settings){this._currentElement=new Element("document");this._topCandidate=null;this._origTitle=this._headerTitle="";this._scannedLinks={};if(settings)this._processSettings(settings)};Readability.prototype._settings={stripUnlikelyCandidates:true,weightClasses:true,cleanConditionally:true,cleanAttributes:true,replaceImgs:true,searchFurtherPages:true,linksToSkip:{},resolvePaths:false};Readability.prototype._convertLinks=function(path){if(!this._url)return path;if(!path)return this._url.full;var path_split=path.split("/");if(path_split[1]===""){if(path_split[0]===""){return this._url.protocol+path}if(path_split[0].substr(-1)===":"){return path}}if(path_split[0]==="")path_split.shift();else Array.prototype.unshift.apply(path_split,this._url.path);path=path_split.join("/");if(this._settings.resolvePaths){while(path!==(path=path.replace(re_cleanPaths,"")));}return this._url.protocol+"//"+this._url.domain+"/"+path};Readability.prototype._getBaseURL=function(){if(this._url.path.length===0){return this._url.full.replace(re_params,"")}var cleaned="",elementNum=this._url.path.length-1;for(var i=0;i<elementNum;i++){cleaned+="/"+this._url.path[i].replace(re_extension,"")}var first=this._url.full.replace(re_params,"").replace(/.*\//,""),second=this._url.path[elementNum];if(!(second.length<3&&re_noLetters.test(first))&&!re_justDigits.test(second)){if(re_pageInURL.test(second)){second=second.replace(re_pageInURL,"")}cleaned+="/"+second}if(!re_badFirst.test(first)){if(re_pageInURL.test(first)){first=first.replace(re_pageInURL,"")}cleaned+="/"+first}return this._url.protocol+"//"+this._url.domain+cleaned};Readability.prototype._processSettings=function(settings){var Settings=this._settings;this._settings={};for(var i in Settings){if(typeof settings[i]!=="undefined"){this._settings[i]=settings[i]}else this._settings[i]=Settings[i]}var path;if(settings.pageURL){path=settings.pageURL.split(re_slashes);this._url={protocol:path[0],domain:path[1],path:path.slice(2,-1),full:settings.pageURL.replace(re_closing,"")};this._baseURL=this._getBaseURL()}if(settings.type)this._settings.type=settings.type};Readability.prototype._scanLink=function(elem){var href=elem.attributes.href;if(!href)return;href=href.replace(re_closing,"");if(href in this._settings.linksToSkip)return;if(href===this._baseURL||this._url&&href===this._url.full)return;var match=href.match(re_domain);if(!match)return;if(this._url&&match[1]!==this._url.domain)return;var text=elem.toString();if(text.length>25||re_extraneous.test(text))return;if(!re_digits.test(href.replace(this._baseURL,"")))return;var score=0,linkData=text+elem.elementData;if(re_nextLink.test(linkData))score+=50;if(re_pages.test(linkData))score+=25;if(re_final.test(linkData)){if(!re_nextLink.test(text))if(!(this._scannedLinks[href]&&re_nextLink.test(this._scannedLinks[href].text)))score-=65}if(re_negative.test(linkData)||re_extraneous.test(linkData))score-=50;if(re_prevLink.test(linkData))score-=200;if(re_pagenum.test(href)||re_pages.test(href))score+=25;if(re_extraneous.test(href))score-=15;var current=elem,posMatch=true,negMatch=true;while(current=current.parent){if(current.elementData==="")continue;if(posMatch&&re_pages.test(current.elementData)){score+=25;if(!negMatch)break;else posMatch=false}if(negMatch&&re_negative.test(current.elementData)&&!re_positive.test(current.elementData)){score-=25;if(!posMatch)break;else negMatch=false}}var parsedNum=parseInt(text,10);if(parsedNum<10){if(parsedNum===1)score-=10;else score+=10-parsedNum}if(href in this._scannedLinks){this._scannedLinks[href].score+=score;this._scannedLinks[href].text+=" "+text}else this._scannedLinks[href]={score:score,text:text}};Readability.prototype.onopentagname=function(name){if(name in noContent){if(name in formatTags)this._currentElement.children.push(formatTags[name])}else this._currentElement=new Element(name,this._currentElement)};Readability.prototype.onattribute=function(name,value){if(!value)return;name=name.toLowerCase();var elem=this._currentElement;if(name==="href"||name==="src"){if(re_protocol.test(value))elem.attributes[name]=value;else elem.attributes[name]=this._convertLinks(value)}else if(name==="id"||name==="class"){value=value.toLowerCase();if(!this._settings.weightClasses);else if(re_safe.test(value)){elem.attributeScore+=300;elem.isCandidate=true}else if(re_negative.test(value))elem.attributeScore-=25;else if(re_positive.test(value))elem.attributeScore+=25;elem.elementData+=" "+value}else if(elem.name==="img"&&(name==="width"||name==="height")){value=parseInt(value,10);if(value!==value);else if(value<=32){elem.name="script"}else if(name==="width"?value>=390:value>=290){elem.parent.attributeScore+=20}else if(name==="width"?value>=200:value>=150){elem.parent.attributeScore+=5}}else if(this._settings.cleanAttributes){if(name in goodAttributes)elem.attributes[name]=value}else elem.attributes[name]=value};Readability.prototype.ontext=function(text){this._currentElement.children.push(text)};Readability.prototype.onclosetag=function(tagName){if(tagName in noContent)return;var elem=this._currentElement,title,i,j;this._currentElement=elem.parent;if(this._settings.searchFurtherPages&&tagName==="a"){this._scanLink(elem)}else if(tagName==="title"){this._origTitle=elem.toString().trim().replace(re_whitespace," ");return}else if(tagName in headerTags){title=elem.toString().trim().replace(re_whitespace," ");if(this._origTitle){if(this._origTitle.indexOf(title)!==-1){if(title.split(" ",4).length===4){this._headerTitle=title}return}if(tagName==="h1")return}else if(tagName==="h1"){this._headerTitle=title;return}}if(tagName in tagsToSkip)return;if(this._settings.stripUnlikelyCandidates&&re_unlikelyCandidates.test(elem.elementData)&&!re_okMaybeItsACandidate.test(elem.elementData)){return}if(tagName==="div"&&elem.children.length===1&&typeof elem.children[0]==="object"&&elem.children[0].name in unpackDivs){elem.parent.children.push(elem.children[0]);return}elem.addInfo();if(tagName in embeds){if(!("src"in elem.attributes&&re_videos.test(elem.attributes.src)))return}else if(tagName==="h2"||tagName==="h3"){if(elem.attributeScore<0||elem.info.density>.33)return}else if(this._settings.cleanConditionally&&tagName in cleanConditionally){var p=elem.info.tagCount.p||0,contentLength=elem.info.textLength+elem.info.linkLength;if(contentLength===0){if(elem.children.length===0)return;if(elem.children.length===1&&typeof elem.children[0]==="string")return}if(elem.info.tagCount.li-100>p&&tagName!=="ul"&&tagName!=="ol")return;if(contentLength<25&&(!("img"in elem.info.tagCount)||elem.info.tagCount.img>2))return;if(elem.info.density>.5)return;if(elem.attributeScore<25&&elem.info.density>.2)return;if(elem.info.tagCount.embed===1&&contentLength<75||elem.info.tagCount.embed>1)return}filterEmpty:if((tagName in removeIfEmpty||!this._settings.cleanConditionally&&tagName in cleanConditionally)&&elem.info.linkLength+elem.info.textLength===0&&elem.children.length!==0){for(i=0,j=okayIfEmpty.length;i<j;i++){if(okayIfEmpty[i]in elem.info.tagCount)break filterEmpty}return}if(this._settings.replaceImgs&&tagName==="a"&&elem.children.length===1&&elem.children[0].name==="img"&&re_imgUrl.test(elem.attributes.href)){elem=elem.children[0];elem.attributes.src=elem.parent.attributes.href}elem.parent.children.push(elem);if(tagName==="p"||tagName==="pre"||tagName==="td");else if(tagName==="div"){for(i=0,j=divToPElements.length;i<j;i++){if(divToPElements[i]in elem.info.tagCount)return}elem.name="p"}else return;if(elem.info.textLength+elem.info.linkLength>24&&elem.parent&&elem.parent.parent){elem.parent.isCandidate=elem.parent.parent.isCandidate=true;var addScore=1+elem.info.commas+Math.min(Math.floor((elem.info.textLength+elem.info.linkLength)/100),3);elem.parent.tagScore+=addScore;elem.parent.parent.tagScore+=addScore/2}};Readability.prototype.onreset=Readability;var getCandidateSiblings=function(candidate){var ret=[],childs=candidate.parent.children,childNum=childs.length,siblingScoreThreshold=Math.max(10,candidate.totalScore*.2);for(var i=0;i<childNum;i++){if(typeof childs[i]==="string")continue;if(childs[i]===candidate);else if(candidate.elementData===childs[i].elementData){if(childs[i].totalScore+candidate.totalScore*.2>=siblingScoreThreshold){if(childs[i].name!=="p")childs[i].name="div"}else continue}else if(childs[i].name==="p"){if(childs[i].info.textLength>=80&&childs[i].info.density<.25);else if(childs[i].info.textLength<80&&childs[i].info.density===0&&re_sentence.test(childs[i].toString()));else continue}else continue;ret.push(childs[i])}return ret};Readability.prototype._getCandidateNode=function(){var elem=this._topCandidate,elems;if(!elem)elem=this._topCandidate=this._currentElement.getTopCandidate();if(!elem){elem=this._currentElement}else if(elem.parent.children.length>1){elems=getCandidateSiblings(elem);elem=new Element("div");elem.children=elems;elem.addInfo()}while(elem.children.length===1){if(typeof elem.children[0]==="object"){elem=elem.children[0]}else break}return elem};Readability.prototype.setSkipLevel=function(skipLevel){if(skipLevel===0)return;if(this._settings===Readability.prototype._settings){this._processSettings({})}if(skipLevel>0)this._settings.stripUnlikelyCandidates=false;if(skipLevel>1)this._settings.weightClasses=false;if(skipLevel>2)this._settings.cleanConditionally=false};Readability.prototype.getTitle=function(){if(this._headerTitle)return this._headerTitle;if(!this._origTitle)return"";var curTitle=this._origTitle;if(/ [\|\-] /.test(curTitle)){curTitle=curTitle.replace(/(.*) [\|\-] .*/g,"$1");if(curTitle.split(" ",3).length!==3)curTitle=this._origTitle.replace(/.*?[\|\-] /,"")}else if(curTitle.indexOf(": ")!==-1){curTitle=curTitle.substr(curTitle.lastIndexOf(": ")+2);if(curTitle.split(" ",3).length!==3)curTitle=this._origTitle.substr(this._origTitle.indexOf(": "))}curTitle=curTitle.trim();if(curTitle.split(" ",5).length!==5)return this._origTitle;return curTitle};Readability.prototype.getNextPage=function(){var topScore=49,topLink="";for(var link in this._scannedLinks){if(this._scannedLinks[link].score>topScore){topLink=link;topScore=this._scannedLinks[link].score}}return topLink};Readability.prototype.getHTML=function(node){if(!node)node=this._getCandidateNode();return node.getInnerHTML().replace(/(?:<br\/>(?:\s|&nbsp;?)*)+(?=<\/?p)/g,"").replace(/(?:\s|&nbsp;?)+(?=<br\/>)/g,"").replace(/(?:<br\/>){2,}/g,"</p><p>").trim()};Readability.prototype.getText=function(node){if(!node)node=this._getCandidateNode();return node.getFormattedText().trim().replace(/\n+(?=\n{2})/g,"")};Readability.prototype.getEvents=function(cbs){(function process(node){cbs.onopentag(node.name,node.attributes);for(var i=0,j=node.children.length;i<j;i++){if(typeof node.children[i]==="string"){cbs.ontext(node.children[i])}else process(node.children[i])}cbs.onclosetag(node.name)})(this._getCandidateNode())};Readability.prototype.getArticle=function(type){var elem=this._getCandidateNode();var ret={title:this._headerTitle||this.getTitle(),nextPage:this.getNextPage(),textLength:elem.info.textLength,score:this._topCandidate?this._topCandidate.totalScore:0};if(!type&&this._settings.type)type=this._settings.type;if(type==="text")ret.text=this.getText(elem);else ret.html=this.getHTML(elem);return ret};if(typeof module!=="undefined"&&"exports"in module){module.exports=Readability}else{if(typeof define==="function"&&define.amd){define("Readability",function(){return Readability})}global.Readability=Readability}})(typeof unsafeWindow==="object"?unsafeWindow:this);function scrap(url,cb){"use strict";var article;article={url:url,title:"???",html:"???"};function onComplete(err,doc){if(err){cb(err,article)}else{try{var parser,readable=new window.Readability,root,parsed;readable.setSkipLevel(3);if(doc.responseXML){doc=doc.response}else{try{parser=new DOMParser;doc=parser.parseFromString(doc.response,"text/html")}catch(e){cb("Unable to parse document response",article)}}if(!doc){cb("Unable to parse document response",article)}root=doc.getElementsByTagName("html");if(root.length===1){root=root[0]}else{root=doc.getElementsByTagName("0");if(root.length>1){root=root[0]}else{root=false}}if(root!==false){window.saxParser(root,readable);parsed=readable.getArticle();article.title=parsed.title;article.html=parsed.html;article.alternates=[];[].slice.apply(root.querySelectorAll("link[rel='alternate'][type*=xml][href]")).forEach(function(e){var href=e.getAttribute("href"),alt;alt={href:href,title:e.title||href,type:e.getAttribute(href)};article.alternates.push(alt)})}cb(null,article)}catch(e){cb(e,article)}}}window.network.fetch(url,onComplete)}window.Network=function(){"use strict";var self=this,timeout=2e4,cache=[],retryInterval=6e4;this.maxRetry=5;function store(reason,url,cb){var found,item;found=cache.find(function(e){return e.url===url});if(typeof found!=="undefined"){found.calls++}else{item={url:url,cb:cb,calls:0};cache.push(item)}}function retry(status){cache=cache.filter(function(item){if(item.calls>self.maxRetry){item.cb("Error fetching "+item.url+", max retry");return false}else{return true}});if(typeof status==="undefined"){status=window.alir.getStatus()}if(status.online===true){cache.forEach(function(item){utils.log("Retrying to fetch "+item.url,"debug");self.fetch(item.url,item.cb)})}}window.alir.on("statusUpdated",retry);window.setInterval(retry,retryInterval);this.fetch=function(url,cb){var status,xhr,options,proxy,timer,computedUrl;status=window.alir.getStatus();if(url.substr(0,4)!=="http"){url="http://"+url}computedUrl=url;if(status.online!==true){store("offline",url,cb);return}try{options={mozAnon:true,mozSystem:true};xhr=new XMLHttpRequest(options);if(typeof xhr.mozSystem!=="boolean"||xhr.mozSystem!==true){if(window.config.proxy!==""&&window.config.proxy!=="http://"){proxy=url.split("://");if(proxy!==null){computedUrl=window.config.proxy+proxy[1]}else{cb(_("scrapNotInstalled"));return}}else{cb(_("scrapNotInstalled"));return}}else{computedUrl+=(/\?/.test(url)?"&":"?")+"ts="+(new Date).getTime()}computedUrl+=(/\?/.test(url)?"&":"?")+"ts="+(new Date).getTime();xhr.open("GET",computedUrl,true);xhr.timeout=this.timeout;xhr.onload=function(e){clearTimeout(timer);var i=cache.findIndex(function(e){return e.url===url});if(i!==-1){cache.splice(i,1)}cb(null,xhr)};xhr.onerror=function(e){clearTimeout(timer);store("error",url,cb);utils.log("Request for %s failed: %s",url,e.target.status,"error");cb(utils.format("Request for %s failed: %s",url,e.target.status),xhr);return};timer=setTimeout(function(){xhr.abort();store("timeout",url,cb)},timeout);xhr.send(null)}catch(e){store("error",url,cb);utils.log("Error getting %s : %s",url,e,"error");cb(utils.format("Error getting %s : %s",url,e),xhr);return}};this.clear=function(){cache=[]}};function saveScraped(article){"use strict";try{var obj;if(typeof article.id==="undefined"){article.id=utils.uuid()}obj={id:article.id,url:article.url,title:article.title,html:article.html,date:Date.now(),flags:{},tags:[],alternates:article.alternates};if(article.title==="???"){article.loaded=false}window.View.toDom(article.html,article.url);remoteStorage.alir.saveArticle(obj);window.displayItem(obj);if(article.loaded!==false){utils.notify(_("scrapingOk",{title:article.title}),"",function(){if(window.alir.getStatus().installed){navigator.mozApps.getSelf().onsuccess=function gotSelf(evt){var app=evt.target.result;if(app!==null){app.launch()}window.articles.show(article.id)}}else{window.articles.show(article.id)}});if(document.getElementById(obj.id)){window.articles.display(obj,true)}}utils.log("Scraped : "+article.title,"info")}catch(e){utils.log(utils.format("Error saving %s : %s",article.title,e),"error");window.alir.ui.message(_("scrapSaveError"),"error")}}function activityHandler(activity){"use strict";utils.log("Handling activity","debug");try{var data;switch(activity.source.name){case"save-bookmark":case"share":data=activity.source.data;if(data.type==="url"){try{utils.log("Scraping "+data.url);scrap(data.url,function(err,res){saveScraped(res);if(err){utils.log(err.toString(),"error");activity.postError(err)}else{activity.postResult("saved")}})}catch(e){activity.postError("cancelled");utils.log(e.toString(),"error")}}else{activity.postError("type not supported");utils.log("Activity type not supported: "+activity.source.data.type,"error")}break;default:activity.postError("name not supported");utils.log("Activity name not supported: "+activity.source.name,"error")}}catch(e){utils.log("Error handling activity: "+e,"error")}}if(navigator.mozSetMessageHandler){navigator.mozSetMessageHandler("activity",activityHandler)}