// Hide and Seek Configuration File


// Datatypes
// ------------------------------------------------------------------
//
// Boolean
// Booleans have two possible values true or false.
//     Example:
//         value: true
// Number
// Numbers can be represented as whole numbers or decimals.
//     Example:
//         x: -20
//         alpha: 0.4
//
// String
// String are described with quotes surrounding zero or more characters.
//     Example:
//         filename: "image1.png"
//
// Object 
// Objects are described with curly brackets surrounding 'name: value' pairs delimited by commas.
//     Example:
//         {
//             name1: value1,
//             name2: value2
//         }
//
// Array
// Arrays are described with square brackets surrounding values delimited by commas.
//     Example:
//         [
//             value1,
//             value2
//         ]

// Framework Properties
// ------------------------------------------------------------------
//
// View Properties
//     type (String)
//     filename (String): The url of image of the view is defined by the resourcePath and the filename.
//     x (Number): Location of view relative to the left of the viewport.
//     y (Number): Location of view relative to the top of the viewport.
//     offsetX (Number): Distance in pixels the image is shifted right.
//     offsetY (Number): Distance in pixels the image is shifted down.
//     numFrames (Number): Number of frames of animation. If this property is set and greater than one, the view will be a sprite.
//     frameRate (Number): Delay between frames of animation (in 1 / 60 second increments).
//         Example:
//              frameRate: 60 // The delay between frames is one second
//              frameRate: 10 // The delay between frames is on 10 / 60 or 0.6 seconds
//     loop (Boolean): If true the animation will continue to play indefinitely after started until stopped.
//     draggable (Boolean): If true the view will follow the cursor position between the touch start and touch end.
//     alpha (Number): Amount of transparency amount ranging from 0 (completely transparent) to 0.5 to 1 (completely opaque). 
//         Example:
//              alpha: 0.5 // View will be rendered at half transparency
//     ignoreTransparentPixels (Boolean): If true the hotspot will register only if the pixel's alpha component under touch position is greater than 0.
//     hotspots (Array):  Array of bounding rectangles that will act as the hotspot for the view if specified.
//         Example:
//              hotspots: [
//					{x: 38, y: 0, width: 161, height: 45},
//					{x: 9, y: 45, width: 201, height: 51}
//              ]
//     hotspotsVisible (Boolean): If true the hotspot rectangles of the view will be outlined. This is used for debug purposes only. 
//     states (Array): Array of views that describe specific states of the view.
//         Example:
//             states: [
//					{
//						type: "ON",
//						filename: "light-switch-on.png"
//					},{
//						type: "OFF",
//						filename: "light-switch-off.png"
//					}
//				]
//
// Audio Properties
//     states (Array): Array of audio sprites.
//         State Properties:
//             name (String): Type of audio state. 
//             startTime (Number): Start time of the state in seconds.
//             duration (Number): The duration of the state in seconds.
//             loop (Boolean): If true the state will loop.
//         Example:
//             states: [
//                 {
//                     type: "intro", 
//                     startTime: 0,
//                     duration: 3
//                 },
//  
// Game Properties
//     element (HTML Element): The HTML element in which the game will be populated. Usually a div element.
//         Example:
//              element: window.document.getElementById("game"),
//     device (String): What device the game is launched in (e.g. "IPHONE", "IPAD").
//     resourcePath (String): The url where all resources are relative to. Note the "/" is required.
//         Example:
//             resourcePath: "resources/"
//.    deviceOffset (Object):
//         Example:
//             deviceOffset: {
//.                iPhone: {x: -32, y: -64}
//.            }
//     rounds (Array): An array of objects containing each round's properties.
//	   startImageFilename (String): The url of image title card show at the beginning of the game.
//     audioEnabled (Boolean): If false audio will not be loaded or played.
//     audioFilename (String): The url of the audio file.

// Hide and Seek Specific Properties
// ------------------------------------------------------------------
//
// Game Properties
//
//     hud
//         Properties:
//             sidebar: Displays the number of targets found for the current round.
//                 Available States:
//                     DEFAULT: Only currently supported state.
//     audio
//         Available States:
//             INTRO: Played at the beginning of each round.
//             PAYOFF: Played after all the hidden items are found.
//             MUSIC: Loops in the background.
//			   CORRECT_HIT: Plays when a target item is touched.
//         
// Round Properties
//
//     background
//         Properties:
//            filename: Filename of the background image.
//     items: A random item is selected at the start of each round to be the correct item.
//         Available States:
//             HIDDEN: Initial state of the label.
//             DRAG: Displayed when the item is being dragged.
//             FOUND: Displayed after the item is found.
//         Properties:
//             mask: Optional view coupled with an item.
//                 Properties:
//                     wiggleOnTouch (Boolean): A touch will cause the mask's item to vibrate.
//                     foundOnTouch (Boolean): A touch will cause the mask' item to be found.
//                     touchDisabled (Boolean): Touch events on the mask will be ignored.

WM.config = {
	resourcePath: "resources/",
	deviceOffset: { //chopping of the BG image to iPhone size specs. Image BG must be 1024x768
		iPhone: {
			x: -32,
			y: -89
		}
	},
	gameIcon: "mozilla_thumb_256x256_AlphabetHunt.png",
	loadingImageWhiteFilename: "loading-white.png",
	loadingImageColorFilename: "loading-color.png",
	landscapeOnlyFilename: "landscape-only.png",
	exitButtonFilename: "exit-button.png",
	startImageFilename: "HTML_startscreen_alphabethunt.jpg",
	audioEnabled: true,
	audioFilename: "audio-hideSeek-letters.mp3",
	audio: { //all audio including intro, payoff, and music
		states: [
			{
				name: "intro",
				startTime: 0,
				duration: 2.6
			}, {
				name: "payoff",
				startTime: 4,
				duration: 3.4
			},
			{
				name: "music", 
				startTime: 9,
				duration: 21.4,
				loop: true
			}
		]
	},
	rounds: [
		{ //Round 1
			background: {
				filename: "Background-Laundromat.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden", //the item appearing in its hidden state, can be partial image
									filename: "A-hidden.png", //make a rectangle marquee in Photoshop to get the bounding rectangle of the object and export as transparent png
									x: 822, //x,y coordinates of objects can be found by opening the object in Photoshop, add on a layer mask to show the bounding rectangle, take the ruler tool and measure from top to bottom. Take this number and subtract 100 px. The x,y coordinates will then be placed here.
									y: 318
								},{
									type: "Drag", //item appearing in draggable state, should be full image even if hidden was partial
									filename: "A-hidden.png",
									x: 822,
									y: 318,
									draggable: true
								},{
									type: "Found", //found animation
									filename: "A_found.png",
									x: 802,
									y: 283,
									numFrames: 10
								}
							]
						}, {
							states: [
								{
									type: "Hidden",
									filename: "B-and-Elmo.png",
									x: -39,
									y: 519
								},{
									type: "Drag",
									filename: "B-and-Elmo.png",
									x: -39,
									y: 519,
									draggable: true
								},{
									type: "Found",
									filename: "Elmo1_B_found.png",
									x: -52,
									y: 358,
									numFrames: 16
								}
							]
						}, {
							states: [
								{
									type: "Hidden",
									filename: "C-hidden.png",
									x: 287,
									y: 343
								},{
									type: "Drag",
									filename: "C-hidden.png",
									x: 287,
									y: 343,
									draggable: true
								},{
									type: "Found",
									filename: "C_found.png",
									x: 265,
									y: 311,
									numFrames: 10
								}
							]
						}, {
							states: [
								{
									type: "Hidden",
									filename: "D-hidden.png",
									x: 73,
									y: 349
								},{
									type: "Drag",
									filename: "D-hidden.png",
									x: 73,
									y: 349,
									draggable: true
								},{
									type: "Found",
									filename: "D_found.png",
									x: 53,
									y: 311,
									numFrames: 10
								}
							]
						}, {
							states: [
								{
									type: "Hidden",
									filename: "E-hidden.png",
									x: 353,
									y: 132
								},{
									type: "Drag",
									filename: "E-hidden.png",
									x: 353,
									y: 132,
									draggable: true
								},{
									type: "Found",
									filename: "E_found.png",
									x: 320,
									y: 95,
									numFrames: 14
								}
							]
						}
					]
				}
			]
		}, { //Round 2
			background: {
				filename: "Background-123-Sesame.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "F-hidden.png",
									x: 82,
									y: 343
								},{
									type: "Drag",
									filename: "F-hidden.png",
									x: 82,
									y: 343,
									draggable: true
								},{
									type: "Found",
									filename: "F_found.png",
									x: 45,
									y: 293,
									numFrames: 12
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "G-hidden.png",
									x: 233,
									y: 342
								},{
									type: "Drag",
									filename: "G-hidden.png",
									x: 233,
									y: 342,
									draggable: true
								},{
									type: "Found",
									filename: "G_found.png",
									x: 215,
									y: 307,
									numFrames: 10
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "G-mask.png",
										x: 223,
										y: 332
									}
								]
							}
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "H-hidden.png",
									x: 729,
									y: 481
								},{
									type: "Drag",
									filename: "H-hidden.png",
									x: 729,
									y: 481,
									draggable: true
								},{
									type: "Found",
									filename: "H_found.png",
									x: 708,
									y: 441,
									numFrames: 12
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "I-and-Elmo-hidden.png",
									x: 433,
									y: 312
								},{
									type: "Drag",
									filename: "I-and-Elmo-hidden.png",
									x: 433,
									y: 312,
									draggable: true
								},{
									type: "Found",
									filename: "Elmo2_I_found.png",
									x: 413,
									y: 312,
									numFrames: 12
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "door-123.png",
										x: 423,
										y: 284
									}, {
										type: "Found",
										filename: "door-123-open.png",
										x: 376,
										y: 281
									}, {
										type: "SWIPE_LEFT",
										filename: "door-123-open.png",
										foundOnState: true,
										x: 376,
										y: 281
									}
								]
							}
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "J-hidden.png",
									x: 781,
									y: 185,
									hotspots: [
										{ x: -30, y: -20, width: 124, height: 141 }
									]
								},{
									type: "Drag",
									filename: "J-hidden.png",
									x: 781,
									y: 185,
									draggable: true
								},{
									type: "Found",
									filename: "J_found.png",
									x: 745,
									y: 146,
									numFrames: 10
								}
							]
						}	
					]
				}
			]
		}, { //Round 3
			background: {
				filename: "Background-hoopers-store.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "K-hidden.png",
									x: 583,
									y: 523
								},{
									type: "Drag",
									filename: "K-hidden.png",
									x: 583,
									y: 523,
									draggable: true
								},{
									type: "Found",
									filename: "K_found.png",
									x: 568,
									y: 488,
									numFrames: 10
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "L-and-Elmo-hidden.png",
									x: 74,
									y: 304
								},{
									type: "Drag",
									filename: "L-and-Elmo-hidden.png",
									x: 74,
									y: 304,
									draggable: true
								},{
									type: "Found",
									filename: "Elmo3_L_found.png",
									x: 59,
									y: 250,
									numFrames: 10
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "L-and-Elmo-mask.png",
										x: 40,
										y: 230
									}, {
										type: "Found",
										filename: "door-open-2.png",
										x: 0,
										y: 225
									}, {
										type: "SWIPE_LEFT",
										filename: "door-open-2.png",
										foundOnState: true,
										x: 0,
										y: 225
									}
								]
							}
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "M-hidden.png",
									x: 382,
									y: 342
								},{
									type: "Drag",
									filename: "M-hidden.png",
									x: 382,
									y: 342,
									draggable: true
								},{
									type: "Found",
									filename: "M_found.png",
									x: 363,
									y: 307,
									numFrames: 11
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "N-hidden.png",
									x: 681,
									y: 168
								},{
									type: "Drag",
									filename: "N-hidden.png",
									x: 681,
									y: 168,
									draggable: true
								},{
									type: "Found",
									filename: "N_found.png",
									x: 668,
									y: 133,
									numFrames: 11
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "O-hidden.png",
									x: 881,
									y: 459
								},{
									type: "Drag",
									filename: "O-hidden.png",
									x: 881,
									y: 459,
									draggable: true
								},{
									type: "Found",
									filename: "O_found.png",
									x: 867,
									y: 424,
									numFrames: 10
								}
							]
						},
					]
				}
			]
		}, { //Round 4
			background: {
				filename: "Background-bbnest.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "P-hidden.png",
									x: 865,
									y: 474
								},{
									type: "Drag",
									filename: "P-hidden.png",
									x: 865,
									y: 474,
									draggable: true
								},{
									type: "Found",
									filename: "P_found.png",
									x: 837,
									y: 434,
									numFrames: 10
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Q-hidden.png",
									x: 47,
									y: 382
								},{
									type: "Drag",
									filename: "Q-hidden.png",
									x: 47,
									y: 382,
									draggable: true
								},{
									type: "Found",
									filename: "Q_found.png",
									x: 31,
									y: 350,
									numFrames: 15
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "R-hidden.png",
									x: 774,
									y: 156
								},{
									type: "Drag",
									filename: "R-hidden.png",
									x: 774,
									y: 156,
									draggable: true
								},{
									type: "Found",
									filename: "R_found.png",
									x: 747,
									y: 116,
									numFrames: 12
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "S-hidden.png",
									x: 305,
									y: 531
								},{
									type: "Drag",
									filename: "S-hidden.png",
									x: 305,
									y: 531,
									draggable: true
								},{
									type: "Found",
									filename: "S_found.png",
									x: 275,
									y: 495,
									numFrames: 13
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "T-and-Elmo-hidden.png",
									x: 516,
									y: 289
								},{
									type: "Drag",
									filename: "T-and-Elmo-hidden.png",
									x: 516,
									y: 289,
									draggable: true
								},{
									type: "Found",
									filename: "Elmo4_T_found.png",
									x: 492,
									y: 248,
									numFrames: 12
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "T-and-elmo-mask.png",
										x: 506,
										y: 279
									}
								]
							}
						}	
					]
				}
			]
		}, { //Round 5
			background: {
				filename: "Background-garden.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "U-hidden.png",
									x: 50,
									y: 161
								},{
									type: "Drag",
									filename: "U-hidden.png",
									x: 50,
									y: 161,
									draggable: true
								},{
									type: "Found",
									filename: "U_found.png",
									x: 18,
									y: 125,
									numFrames: 12
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "V-hidden.png",
									x: 595,
									y: 160
								},{
									type: "Drag",
									filename: "V-hidden.png",
									x: 595,
									y: 160,
									draggable: true
								},{
									type: "Found",
									filename: "V_found.png",
									x: 577,
									y: 123,
									numFrames: 10
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "W-hidden.png",
									x: 154,
									y: 495
								},{
									type: "Drag",
									filename: "W-hidden.png",
									x: 154,
									y: 495,
									draggable: true
								},{
									type: "Found",
									filename: "W_found.png",
									x: 130,
									y: 470,
									numFrames: 12
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "X-hidden.png",
									x: 548,
									y: 532
								},{
									type: "Drag",
									filename: "X-hidden.png",
									x: 548,
									y: 532,
									draggable: true
								},{
									type: "Found",
									filename: "X_found.png",
									x: 527,
									y: 495,
									numFrames: 10
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Y-hidden.png",
									x: 311,
									y: 345
								},{
									type: "Drag",
									filename: "Y-hidden.png",
									x: 311,
									y: 345,
									draggable: true
								},{
									type: "Found",
									filename: "Y_found.png",
									x: 285,
									y: 305,
									numFrames: 10
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Z-and-Elmo-hidden.png",
									x: 810,
									y: 400
								},{
									type: "Drag",
									filename: "Z-and-Elmo-hidden.png",
									x: 810,
									y: 400,
									draggable: true
								},{
									type: "Found",
									filename: "Elmo5_Z_found.png",
									x: 798,
									y: 375,
									numFrames: 22
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Z-and-Elmo-mask.png",
										x: 800,
										y: 390
									}
								]
							}
						}	
					]
				}
			]
		}
	]
};