function drawAngleMeter( canvas, vangle, hangle ) {
	console.log( "begin drawAngleMeter" );
	console.log( "[vangle]" + vangle + " [hangle]" + hangle );

	var cw = canvas.width;
	var ch = canvas.height;
	console.log( "[cw]" + cw + " [ch]" + ch );

	var w = 10;
	var h = 10;
	var x = ( hangle + 180.0 ) * ( cw - w ) / 360.0;
	var y = ( vangle + 180.0 ) * ( ch - h ) / 360.0;
	console.log( "[w]" + w + " [h]" + h + " [x]" + x + " [y]" + y );

	var ctx = canvas.getContext( "2d" );
	ctx.beginPath();
	ctx.fillStyle = "#000000";
	ctx.fillRect( 0, 0, cw, ch );
	ctx.stroke();

	ctx.beginPath();
	ctx.strokeStyle = "#ff0000";
	ctx.lineWidth = 1;
	ctx.rect( ( cw - w ) / 2, ( ch - h ) / 2, w, h );
	ctx.stroke();

	ctx.beginPath();
	ctx.strokeStyle = "#ffffff";
	ctx.lineWidth = 2;
	ctx.rect( x, y, w, h );
	ctx.stroke();

	console.log( "end drawAngleMeter" );
}

function init() {
	console.log( "begin init" );

	var canvas = document.getElementById( "drawArea" );
	canvas.width = 360;
	canvas.height = 360;

	window.addEventListener("deviceorientation", function (e) {
		if (e) {
			//document.getElementById("orientation-alpha").innerHTML = e.alpha;
			//document.getElementById("orientation-beta").innerHTML = e.beta;
			//document.getElementById("orientation-gamma").innerHTML = e.gamma;
			drawAngleMeter( canvas, e.beta, e.gamma );
		}
	}, false);

	drawAngleMeter( canvas, 0, 0 );

	console.log( "end init" );
}

onload = function() {
	init();
};
