var installBtn = document.getElementById('install-btn');
var snd = new Audio("sounds/bip.ogg"); // buffers automatically when created

$(document).ready(function(){
    handleOrientationEvent(0, 0, 0);
})

if (window.DeviceOrientationEvent) {
    window.addEventListener("deviceorientation", function( event ) {
    //alpha: rotation around z-axis
    var rotateDegrees = event.alpha;
    //gamma: left to right
    var leftToRight = event.gamma;
    //beta: front back motion
    var frontToBack = event.beta;
                 
    handleOrientationEvent( frontToBack, leftToRight, rotateDegrees );
    }, false);
}

var handleOrientationEvent = function( frontToBack, leftToRight, rotateDegrees ){
    console.log(frontToBack);
    var height = $(window).height()/2.0;
    var delta = height * ((frontToBack)/180.0);
    $("#value").html(frontToBack+" °");
    $("#level").height(height*1.8);
    $("#bubul").height($("#level").height()*0.165);
    $("#bubul").css("top", (height+delta-$("#bubul").height()/2.0-1)+"px" ) ;
    $("#bubul").css("left", (-$("#bubul").width()/2.0+2)+"px" ) ;

    $("#level").css("top", (height-$("#level").height()/2.0)+"px" ) ;
    $("#level").css("left", (-$("#level").width()/2.0)+"px" ) ;

    $("#deg").html(frontToBack.toFixed(3)+"°");
    $("#rad").html((frontToBack*(1.0/Math.PI)).toFixed(3)+" rad");

    if(Math.round(Math.abs(frontToBack)) == 0 && $('#bipswitch').is(":checked")){
        snd.play();
    }
};

if(installBtn) { 
    installBtn.style.display = 'none';
    if(navigator.mozApps) {

        installBtn.addEventListener('click', function() {
            navigator.mozApps.install(location.href + 'manifest.webapp');
        }, false);

        var req = navigator.mozApps.getSelf();
        req.onsuccess = function() {
            if(!req.result) {
                installBtn.style.display = 'block';
            }
        };
    }
}
