'use strict';
var utils = this.utils || {};
utils.ActionMenu = (function() {
    var FILE_NAME = 'action_menu'
    function getPath() {
        var path = document.querySelector('[src*="' + FILE_NAME + '.js"]').src;
        return path.substring(0, path.lastIndexOf('/') + 1)
    }
    ;
    var actionMenus = Object.create(null), counter = 0, Action = function(container) {
        this.container = container;
        container.dataset.id = ++counter;
        this.callbacks = Object.create(null);
        container.addEventListener('click', this);
        container.addEventListener('animationend', this)
    };
    Action.prototype = {get id() {
            return this.container.id
        }}
    function addStyleSheet() {
        var link = document.createElement('link');
        link.type = 'text/css';
        link.rel = 'stylesheet';
        link.href = getPath() + 'action_menu_behavior.css';
        document.head.appendChild(link)
    }
    function initialize() {
        addStyleSheet();
        var elements = document.querySelectorAll('[role="dialog"][data-type="action"]');
        Array.prototype.forEach.call(elements, function(element) {
            utils.ActionMenu.bind(element)
        })
    }
    ;
    if (document.readyState === 'complete') {
        initialize()
    } else
        document.addEventListener('DOMContentLoaded', function loaded() {
            document.removeEventListener('DOMContentLoaded', loaded);
            initialize()
        })
    function destroy() {
        Object.keys(actionMenus).forEach(function destroying(id) {
            actionMenus[id].destroy()
        });
        actionMenus = Object.create(null);
        counter = 0
    }
    function build(descriptor) {
        var form = document.createElement('form');
        form.setAttribute('role', 'dialog');
        form.dataset.type = 'action';
        form.classList.add('hidden');
        if (descriptor.id)
            form.id = descriptor.id;
        var section = document.createElement('section'), h1 = document.createElement('h1');
        h1.textContent = descriptor.title || '';
        section.appendChild(h1);
        form.appendChild(section);
        var actions = descriptor.actions;
        if (actions) {
            var menu = document.createElement('menu');
            menu.classList.add('actions');
            actions.forEach(function(action) {
                var button = document.createElement('button');
                button.id = action.id;
                button.textContent = action.title;
                menu.appendChild(button);
                var classes = action.classList;
                if (classes)
                    classes.trim().split(/\s+/g).forEach(function(clazz) {
                        button.classList.add(clazz)
                    })
            });
            form.appendChild(menu)
        }
        ;
        return form
    }
    ;
    return{get: function get(id) {
            var elem = document.getElementById(id);
            if (!elem)
                return;
            return actionMenus[elem.dataset.id]
        }, bind: function bind(elem) {
            elem = typeof elem === 'object' ? elem : document.querySelector(elem);
            var out = actionMenus[elem.dataset.id];
            if (out)
                return out;
            out = new Action(elem);
            actionMenus[elem.dataset.id] = out;
            return out
        }, create: function create(descriptor) {
            return build(descriptor || {})
        }, destroy: destroy}
})()