
// This uses require.js to structure javascript:
// http://requirejs.org/docs/api.html#define

define(function(require) {
    // Receipt verification (https://github.com/mozilla/receiptverifier)
    require('receiptverifier');

    // Installation button
    require('./install-button');

    // Install the layouts
    require('layouts/layouts');
    var Backbone = require('backbone');
    var _ = require('underscore');
    require('carousel');
    
    var listItemTpl = require('text!tpl/listItem.tpl');
    var detailTpl = require('text!tpl/detail.tpl');
    var searchTpl = require('text!tpl/search.tpl');
    var listHeaderTpl = require('text!tpl/listHeader.tpl');

    // Write your app here.
    var annonces = {};
    annonces.uuid = '1c1bdb6dd061670d';
    annonces.token = null;
    annonces.isFetchError = false;
    annonces.isLoading = false;
    annonces.baseUrl = 'http://www.annoncespro.ma/rest/';

    annonces.searchPreferences = {
        'categories': {
            'label': 'Cat&eacute;gorie',
            'ckey': 'cat',
            'id': 0,
            'name': null
        },
        'cities': {
            'label': 'Ville',
            'ckey': 'city',
            'id': 0,
            'name': null
        },
        'types': {
            'label': 'Type',
            'ckey': 'type',
            'id': 0,
            'name': null
        }
    };
    
    annonces.lockTypeValues = function() {
        var selected = $('#categories').val();
        if (_.indexOf(annonces.lockTypeValues, selected) != -1) {
            $('#types').val('0');
            $('#types').attr('disabled', true);
        } else {
            $('#types').removeAttr('disabled');
        }
    };

    annonces.fetchCollection = function(collection, options) {
        if (annonces.token === null) {
            getToken();
        }
        if (options.data === undefined) {
            options.data = {};
        }
        options.data.token = annonces.token;
        options.data.uuid = annonces.uuid;

        options.success = function(collection, response, opts) {
            if (response.error !== undefined) {
                if (response.error === 501) {
                    collection.getToken();
                    collection.fetch(options);
                } else {
                    annonces.isFetchError = true;
                }
            }
        };
        var data = Backbone.Collection.prototype.fetch.call(collection, options);
        if (!annonces.isFetchError) {
            return data;
        } else {
            alert('Erreur dans la requete!');
        }
    }

    annonces.lockTypeValues = ['40', 'candidacy', 'jobs'];

    annonces.Auth = Backbone.Model.extend({
        urlRoot: annonces.baseUrl + 'auth',
        defaults: {
            'id': null,
            'token': null
        }
    });
    annonces.Category = Backbone.Model.extend({
        urlRoot: annonces.baseUrl + 'categories',
        defaults: {
            'id': null,
            'label': '',
            'elements': null
        }
    });

    annonces.City = Backbone.Model.extend({
        urlRoot: annonces.baseUrl + 'cities',
        idAttribute: 'idcities',
        defaults: {
            'idcities': null,
            'name': '',
            'slug': ''
        }
    });

    annonces.CategoriesCollection = Backbone.Collection.extend({
        model: annonces.Category,
        initialize: function() {
        },
        url: annonces.baseUrl + 'categories',
        fetch: function(options) {
            return annonces.fetchCollection(this, options);

        }
    });

    annonces.CitiesCollection = Backbone.Collection.extend({
        model: annonces.City,
        initialize: function() {
        },
        url: annonces.baseUrl + 'cities',
        fetch: function(options) {
            return annonces.fetchCollection(this, options);

        }
    });
    annonces.Model = Backbone.Model.extend({
        fetch: function(options) {
            if (annonces.token === null) {
                this.getToken();
            }
            if (options.data === undefined) {
                options.data = {};
            }
            options.data.token = annonces.token;
            options.data.uuid = annonces.uuid;

            options.success = function(model, response, opts) {
                if (response.error !== undefined) {
                    if (response.error === 501) {
                        model.getToken();
                        model.fetch(options);
                    } else {
                        annonces.isFetchError = true;
                    }
                }
            };
            var data = Backbone.Model.prototype.fetch.call(this, options);
            if (!annonces.isFetchError) {
                return data;
            } else {
                alert('Erreur dans la requete!');
            }
        },
        getToken: function() {
            this.authModel = new annonces.Auth({'id': annonces.uuid});
            this.authModel.fetch({async: false});
            annonces.token = this.authModel.get('token');
        }
    });
    annonces.Ad = annonces.Model.extend({
        urlRoot: annonces.baseUrl + 'ads',
        defaults: {
            'id': null,
            'title': '',
            'tel': ''
        }
    });

    function getToken() {
        authModel = new annonces.Auth({'id': annonces.uuid});
        authModel.fetch({async: false});
        annonces.token = authModel.get('token');
    }
    
    
    function updateHeader(){
        var searchActive = false;
        _.each(annonces.searchPreferences, function(p) {
            if (p.id != 0) {
                searchActive = true;
            }
        });
        this.template = _.template(listHeaderTpl);
        var headerData = {
            preferences: annonces.searchPreferences,
            searchActive: searchActive
        };
        //console.log(this.template(headerData));
        //$('#headerList').html(this.template(headerData));
    };

    // List view

    var list = $('.list').get(0);
    list.collection.model = annonces.Ad;
    list.collection.on('request', function() {
        annonces.isLoading = true;
    });
    list.collection.on('sync', function() {
        annonces.isLoading = false;
    });
    list.collection.parse = function(response) {
        annonces.currentCount = response.count;
        return response.list;
    };
    list.renderRow = function(model) {
        this.template = _.template(listItemTpl);
        this.innerHTML = this.template(model.toJSON());
    };
    list.collection.page = 1;
    list.collection.fetch = function(options) {
        return annonces.fetchCollection(this, options);
    };
    list.collection.url = annonces.baseUrl + 'ads';

   function searchAds(){
        var queryData = {
            p: list.collection.page,
            pp: 10
        };
        _.each(annonces.searchPreferences, function(criteria) {
            if (criteria.id != 0) {
                queryData[criteria.ckey] = criteria.id;
            }
        });
        list.collection.fetch({async : false, add : true, data: queryData});
    }
    updateHeader();
    searchAds();
    annonces.catCollection = new annonces.CategoriesCollection();
    annonces.catCollection.fetch({});
    annonces.cityCollection = new annonces.CitiesCollection();
    annonces.cityCollection.fetch({});


     function lockTypeValues() {
        var selected = $('#categories').val();
        if (_.indexOf(annonces.lockTypeValues, selected) != -1) {
            $('#types').val('0');
            $('#types').attr('disabled', true);
        } else {
            $('#types').removeAttr('disabled');
        }
    }
    function bindSearchEvents(){
        $('#validate-search').click(function() {
            lockTypeValues();
            console.log(annonces.searchPreferences);
            $('#recherche .select-filters').each(function(i, e) {
            if (annonces.searchPreferences[$(this).attr('id')].id !== $(this).val()) {
                annonces.searchPreferences[$(this).attr('id')].id = $(this).val();
                var selected = document.getElementById($(this).attr('id'));
                annonces.searchPreferences[$(this).attr('id')].name = selected.options[selected.selectedIndex].innerHTML;
            }
            console.log(annonces.searchPreferences);
            list.collection.reset();
            list.collection.page = 1;
            searchAds();
            updateHeader();
            $('.searchView').get(0).close();
        });
        });
        $('#reset-search').click(function() {
            $('#recherche .select-filters').val(0);
        });
        $('#categories').change(function() {
            lockTypeValues();
        });
    }
    $(function() {
        /**
         * Load more results
         */
        $("._contents").scroll(function() {
            var $this = $(this);
            var $results = $("ul");
            if (!annonces.isLoading) {
                if ($this.height() + $this[0].scrollTop + 20 >= $results.height()) {console.log('MORE!!');
                    list.collection.page++;
                    searchAds();
                }
            }
        });
        /**
         * Load Search View
         */
        $('#searchButton').click(function() {
            var serachView = $('.searchView').get(0);
            serachView.render = function(item) {
                this.template = _.template(searchTpl);
                var searchData = {
                    categories: annonces.catCollection.toJSON(),
                    cities: annonces.cityCollection.toJSON(),
                    preferences: annonces.searchPreferences
                };
                $('.searchContent', this).html(this.template(searchData));
            };
            serachView.open();
            bindSearchEvents();
        });
        /**
         * Back Buttons
         */
        $('.backButton').click(function(){
            $(this).parents('x-view').get(0).close();
        });
        
    });
    // Detail view

    var detail = $('.detail').get(0);
    detail.render = function(item) {

        this.ad = new annonces.Ad({
            'id': item.get('id')
        });
        this.ad.fetch({
            async: false
        });
        this.template = _.template(detailTpl);
        var adData = this.ad.toJSON();
        $('.detailContent', this).html(this.template(adData));
        if (_.size(adData.pictures) > 1) {
            $('.m-carousel').carousel();
        }
    };

});