function loadFeed(url) {
	$('#feed').html('');
	//document.querySelector('#progres-dialog').className = 'current';
	var key = 'antsettings';
	var storeval = localStorage.getItem(key);
	if (storeval == null || storeval == 'undefined') {
		storeval = '10:2';
	}
	var feed = new google.feeds.Feed(url);
	feed.setNumEntries(storeval.split(':')[0]);
	feed.load(function(result) {
		if (!result.error) {
			$('#feed').html('');
			for (var i = 0; i < result.feed.entries.length; i++) {
				var entry = result.feed.entries[i];
				var feedtxt = "";

				feedtxt += "<div class='divpreview'><p class='title'><a href='" + entry.link + "' >" + entry.title + "</a></p>";
				feedtxt += "<p id='feddelm'>" + entry.content + "</p>";
				feedtxt += "<p class='preview'><a href='" + entry.link + "' target='_blank'>View in Browser</a></p>";
				feedtxt += "<p class='sharetoolbar'><a href='" + entry.link + "' id='tlb-sms' class='sms-ico'>SMS</a>";
				feedtxt += "<a href='" + entry.link + "' id='tlb-email' class='email-ico'>Email</a>";
				feedtxt += "</p></div>";

				$('#feed').html($('#feed').html() + feedtxt);
				$('#feed div p a').attr('target', '_blank');

			}

			$('#feed div .title a').click(function(e) {
				e.preventDefault();
				window.open($(this).attr('href'));

			});

			$('#feed div .sms-ico').click(function(e) {
				e.preventDefault();
				var activity = new MozActivity({
					name : "new",

					data : {
						type : "websms/sms",
						number : '',
						body : "Check this " + $(this).attr('href')
					}
				});
			});

			$('#feed div .email-ico').click(function(e) {
				e.preventDefault();
				var alink = $(this).attr('href');
				window.open("mailto:?subject=Check%20this:&body=" + encodeURIComponent(alink));
			});

			$('#feed div img').bind('contextmenu', function(e) {
				e.preventDefault();

				var activity = new MozActivity({
					name : "view",
					data : {
						type : "url",
						url : this.src
					}
				});
			});

			$('#btn-refresh').attr('data', url);
			if (storeval.split(':')[1] == 1) {
				$('#subview [role="toolbar"]').hide();
			} else {
				$('#feed div').hide();
				$('#subview [role="toolbar"]').show();
				$('#feed div:nth-child(1)').show();
				$('#tlb-next').attr('data', '1');
				$('#tlb-prev').attr('data', '1');
			}

		} else {
			feedtxt += "<div><p>Load Error! Please, try again later.</p></div>";
		}
	});
}

function searchSubs(sstr) {
	google.feeds.findFeeds(sstr, function(result) {
		if (!result.error) {
			var resp = "";
			for (var i = 0; i < result.entries.length; i++) {
				var entry = result.entries[i];
				resp += '<li><a href="#" data="' + entry.url + '"><p>' + entry.title + '</p><p>' + entry.contentSnippet.replace(/(<([^>]+)>)/ig, "") + '</p></a></li>';
			}
			$("#slist-list").html(resp);
			$('#slist-list li a').click(function() {
				saveSubs($(this).attr('data'));
			});
		} else {
			alert("Error!");
		}
	});
}

function deleteSub(num) {
	// Punimo listu iz localStorage
	var key = 'antsubs';
	var storeval = localStorage.getItem(key);
	while (storeval.indexOf(";;") >= 0) {
		storeval = storeval.replace(";;", "");
	}
	if (storeval == ';') {
		storeval = '';
	}
	var subsarr = storeval.split(';');
	var resp = "";
	for (var i = 0, len = subsarr.length; i < len; i++) {
		var title = subsarr[i].split(":")[0];
		if (title != num) {
			resp += subsarr[i] + ";";
		}
	}
	localStorage.setItem(key, resp);
}

function deleteSelected() {
	var key = 'antsubs';
	var storeval = localStorage.getItem(key);
	// :istimo duple ;;;;
	while (storeval.indexOf(";;") >= 0) {
		storeval = storeval.replace(";;", ";");
	}
	if (storeval == ';') {
		storeval = '';
	}
	var subsarr = storeval.split(';');
	var resp = "";
	for (var i = 0, len = subsarr.length; i < len; i++) {
		var title = subsarr[i].split(":")[0];
		var preskoci = false;
		$('#flist-list input:checked').each(function() {
			if (title == $(this).parent().parent().children('a').html()) {
				preskoci = true;
			}
		})
		if (!preskoci) {
			resp += subsarr[i] + ";";
		}
	}
	localStorage.setItem(key, resp);

}

function prevSub() {
	var prev = parseInt($('#tlb-prev').attr('data')) - 1;
	if (prev < 1) {
		prev = 1;
		utils.status.show('On the first article!');
	} else {
		$('#feed div').hide();
		$('#feed div:nth-child(' + prev + ')').show();
		$('#tlb-prev').attr('data', prev);
		$('#tlb-next').attr('data', prev);
	}
	$('#afeed').scrollTop(0);
}

function nextSub() {
	var next = parseInt($('#tlb-next').attr('data')) + 1;
	if ($('#feed div:nth-child(' + next + ')').html() === undefined) {
		utils.status.show('On the last article!');
	} else {
		$('#feed div').hide();
		$('#feed div:nth-child(' + next + ')').show();
		$('#tlb-prev').attr('data', next);
		$('#tlb-next').attr('data', next);
	}
	$('#afeed').scrollTop(0);
}
