define(function(require) {
	require('app/status');
	require('app/util');
	require('app/appcache_updates');
	require('app/about');
	require('app/list');
	require('app/add');

	// Load List
	loadList();
	loadSettings();
	var tstart = 0;

	document.getElementById('afeed').addEventListener('touchstart', function(ev) {
		if ($('input[name=radio-view]:radio:checked').val() == 2) {
			if (tstart == 0)
				tstart = ev.touches.item(0).pageX;
		}
	}, false);

	document.getElementById('afeed').addEventListener('touchend', function(ev) {
		if ($('input[name=radio-view]:radio:checked').val() == 2) {
			if (ev.changedTouches.item(0).pageX < tstart && (tstart - ev.changedTouches.item(0).pageX) > 200) {
				nextSub();
			}
			if (ev.changedTouches.item(0).pageX > tstart && (ev.changedTouches.item(0).pageX - tstart) > 200) {
				prevSub();
			}
			tstart = 0;
		}
	}, false);

	if (!window.navigator.onLine) {
		alert('Please check your network connection!');
	}
	//action menu
	$('#btn-settings').click(function() {
		document.querySelector('#settings').className = 'current';
	});
	$('#btn-settings-back').click(function() {
		document.querySelector('#settings').className = 'right';
	});
	$('#btn-settings-save').click(function() {
		document.querySelector('#settings').className = 'right';
	});
	$('input[name=radio-num]:radio').click(function() {
		var skey = 'antsettings';
		localStorage.setItem(skey, $('input[name=radio-num]:radio:checked').val() + ":" + $('input[name=radio-view]:radio:checked').val());
	});
	$('input[name=radio-view]:radio').click(function() {
		var skey = 'antsettings';
		localStorage.setItem(skey, $('input[name=radio-num]:radio:checked').val() + ":" + $('input[name=radio-view]:radio:checked').val());
	});
	$('#btn-addform-back').click(function() {
		document.querySelector('#addform').className = 'right';
	});
	$('#btn-addform-save').click(function() {
		saveSubs($('#itm-url').val());
	});

	$('#itm-search').change(function() {
		searchSubs($(this).val());
		return false;
	});

	$('#btn-subview-back').click(function() {
		document.querySelector('#subview').className = 'right';
	});

	$('#btn-unsubscribe').click(function() {
		if (confirm("Delete " + $("#title-subvew").html() + "?")) {
			deleteSub($("#title-subvew").html());
			loadList();
			document.querySelector('#subview').className = 'right';
		}

	});

	$('#btn-refresh').click(function() {
		loadFeed($(this).attr('data'));
	});

	//Toolbar add
	$('#tlb-addsub').click(function() {
		document.querySelector('#addform').className = 'current';
		$('#addcont').scrollTop(0);
	});

	$('#tlb-refresh').click(function() {
		location.reload();
	});

	$('#tlb-deleteall').click(function() {
		$("#item-delete-dialog").css("display", "block");
		$("#flist-list").removeClass("item-list-scrollouter").addClass("item-list-scrollouter-edit");
	});

	$('#tlb-next').click(function() {
		nextSub();
	});
	$('#tlb-prev').click(function() {
		prevSub();
	});

	$('#tlb-open').click(function() {
		var dspla = parseInt($('#tlb-next').attr('data'));
		window.open($('#feed div:nth-child(' + dspla + ') .title a').attr('href'));

	});

	//edit mode
	$('#btn-edit').click(function() {
		$("#item-delete-dialog").css("display", "block");
		$("#flist-list").removeClass("item-list-scrollouter").addClass("item-list-scrollouter-edit");
	});
	$('#editbtn-close').click(function() {
		$("#item-delete-dialog").css("display", "none");
		$("#flist-list").removeClass("item-list-scrollouter-edit").addClass("item-list-scrollouter");
		$('#flist-list input:checked').prop('checked', false);
	});
	$('#editbtn-done').click(function() {
		$("#item-delete-dialog").css("display", "none");
		$("#flist-list").removeClass("item-list-scrollouter-edit").addClass("item-list-scrollouter");
		$('#flist-list input:checked').prop('checked', false);
	});
	$('#editbtn-delete').click(function() {
		var selectedcount = $('#flist-list input:checked').length;
		var s = '';
		if (selectedcount > 0) {
			if (selectedcount > 1) {
				s = 's';
			}
			if (confirm("Delete " + selectedcount + " item" + s + "?")) {
				deleteSelected();
				//location.reload();
				loadList();
				$("#item-delete-dialog").css("display", "none");
				$("#flist-list").removeClass("item-list-scrollouter-edit").addClass("item-list-scrollouter");
				$('#flist-list input:checked').prop('checked', false);
			}
		} else {
			alert("Please, check at least one item.");
		}
	});
	$('#editbtn-deleteall').click(function() {
		if (confirm("Delete all subsriptins?")) {
			var key = 'antsubs';
			localStorage.setItem(key, '');
			//location.reload();

			$("#item-delete-dialog").css("display", "none");
			$("#flist-list").removeClass("item-list-scrollouter-edit").addClass("item-list-scrollouter");
			$('#flist-list input:checked').prop('checked', false);
			loadList();
		}

	});

}); 