/*
  JavaScript que se carga al iniciar la aplicacion.
  Contiene:
   *Carga informacion de los partidos de: Ayer, hoy y manana
   *Metodos que actualizan la informacion dependiendo de la "pestana" en la que se encuentre
   
*/

/**
  Por alguna razon no se pueden colocar los onClick dentro del index.html
  Por esta razon toca hacer estas funciones aqui
*/

window.onload = function()
{
  console.log("Begin!");
  
  document.getElementById("posiciones").addEventListener("click", function(){ 
    console.log("Posiciones!");
    window.location = "posiciones.html";
  },false);  
  
  document.getElementById("estadisticas").addEventListener("click", function(){ 
    console.log("Estadisticas!");
    window.location = "estadisticas.html";
  },false);  
  
  document.getElementById("calendario").addEventListener("click", function(){ 
    console.log("Calendario!");
    window.location = "calendario.html";    
  },false);  

  document.getElementById("menu").addEventListener("click", function(){ 
    menu();
  },false);
  
  document.getElementById("pestanaAyer").addEventListener("click", function()  { actualizarDia('Ayer');},    false);
  document.getElementById("pestanaHoy").addEventListener("click", function()   { actualizarDia('Hoy');},    false);
  document.getElementById("pestanaManana").addEventListener("click", function(){ actualizarDia('Manana');},    false);
  document.getElementById("contadorPopUpPublicidad").addEventListener   ("click", function(){ cerrarPublicidad();}, false);
  document.getElementById("ayuda").addEventListener("click", function()
  { 
    mostrarPublicidad("http://dualvisio-estatico.azurewebsites.net/ayuda/");
  }, false);
  
  actualizarDia('Hoy');

  console.log("End!");
};

  function cerrarPublicidad()
  {
    document.getElementById("popUpPublicidad").classList.add('escondido');
  }

  function mostrarPublicidad(URL)
  {
    document.getElementById("popUpPublicidad").classList.remove('escondido');
    document.getElementById("resultadoPublicidad").src=URL;    
  } 

  /*
   Esta establecido por defecto que la aplicacion cargue el dia de HOY al abrir
  */

  /**
   Funcion que actualiza la informacion en la pantalla principal dependiendo del dia que se le pase
  */
  

  function menu()
  {
    var pagina = document.getElementById("pagina");
    var menu   = document.getElementById("menu_lateral");
    
    
    if(pagina.className.indexOf("moved")>-1)
    {
      pagina.classList.remove("moved");
      menu.classList.add("menu_escondido");
    }
    else
    {
      menu.classList.remove("menu_escondido");
      pagina.classList.add("moved");
    }
  }

  function actualizarDia(dia) 
  {
    
    var menuAyer = document.getElementById("pestanaAyer");
    var menuHoy = document.getElementById("pestanaHoy");
    var menuManana = document.getElementById("pestanaManana");
    
    menuAyer.className = "";
    menuHoy.className = "";
    menuManana.className = "";

    
    var url = "http://lvbp.meridiano.com.ve/ws/stats_json.aspx?metodo=Games&gameDate=";
    var d = new Date();
    
    if(dia=="Hoy")
    {
        menuHoy.className = "pure-menu-selected";
        url += d.getDate()+"-"+(d.getMonth()+1)+"-"+d.getFullYear();                  
    }

    if(dia=="Ayer")
    {
        menuAyer.className = "pure-menu-selected";
        url += (d.getDate()-1)+"-"+(d.getMonth()+1)+"-"+d.getFullYear();
    }

    if(dia=="Manana")
    {
        menuManana.className = "pure-menu-selected";
        url += (d.getDate()+1)+"-"+(d.getMonth()+1)+"-"+d.getFullYear();
    }    
   
    //url="http://lvbp.meridiano.com.ve/ws/stats_json.aspx?metodo=Games&gameDate=09-10-2014";
    console.log("url: "+url);
   
    request = new XMLHttpRequest({ mozSystem: true });

    request.open('get', url, true);
    request.responseType = 'json';

    request.addEventListener('error', onRequestError);
    request.addEventListener('load', onRequestLoad);

    request.send();
  }

/**
   Manejador que se encarga de procesar los errores en el Request
  */
  function onRequestError() {
    console.log("request.error: "+request.error);
  }
  
  /**
   Manejador que se encarga de procesar los datos recibidos por el Request, en el caso
   de que este no de errores.
  */
  function onRequestLoad() 
  {
    var partidos = request.response;
    
    if(partidos.length==0)
    {
      /*
       Aqui se debe mostrar una pantalla que diga: No se pudo cargar los partidos del servidor
       Por favor intenta mas tarde.
      */
      alert("Lastimosamente no hay partidos disponibles!");
    }
    else
    {
      var resultados = document.getElementById("resultados");
      var acum ="";
      var fecha;
      
      partidos.forEach(
        function(partido)
        {
          var id = partido.GameId;
          var t1 = partido.NameTeam1;
          var t2 = partido.NameTeam2;
          var s1 = partido.runsTeam1;
          var s2 = partido.runsTeam2;
          var escudo1 = "";
          var escudo2 = "";
          if(partido.IdTeam1<10)
          {
            escudo1 = "http://wap.meridiano.com.ve/escudos/"+partido.IdTeam1+".gif";            
          }
          else
          {
            if(partido.IdTeam1==20){escudo1="../img/Cuba.png";}
            if(partido.IdTeam1==21){escudo1="../img/RepublicaDominicana.png";}
            if(partido.IdTeam1==26){escudo1="../img/Mexico.png";}
            if(partido.IdTeam1==27){escudo1="../img/PuertoRico.png";}
            if(partido.IdTeam1==30){escudo1="../img/Venezuela.png";} 
          }

          if(partido.IdTeam2<10)
          {
            escudo2 = "http://wap.meridiano.com.ve/escudos/"+partido.IdTeam2+".gif";            
          }
          else
          {
            if(partido.IdTeam2==20){escudo2="../img/Cuba.png";}
            if(partido.IdTeam2==21){escudo2="../img/RepublicaDominicana.png";}
            if(partido.IdTeam2==26){escudo2="../img/Mexico.png";}
            if(partido.IdTeam2==27){escudo2="../img/PuertoRico.png";}
            if(partido.IdTeam2==30){escudo2="../img/Venezuela.png";}            
          }          

          var h1 = partido.hitsTeam1;
          var h2 = partido.hitsTeam2;
          var e1 = partido.ErrorsTeam1;
          var e2 = partido.ErrorsTeam2;
          var hora = partido.StartDate.substring(11,16);
          var estado =  partido.Status; 
          fecha = partido.StartDate;
          
          fecha=fecha.substr(0,fecha.indexOf(' '));
          
            
            
          var partidoTest = '<a href="infoPartido.html?idPartido='+id+'" class="ui-block-a" data-role="button" type="submit" style="text-align: -moz-center;">'+
              '<table style="width: 100%">'+
                               '<tbody>'+
                                 '<tr>'+
                                   '<td rowspan="2" style="width: 35%">'+
                                      '<img src="'+escudo1+'">'+
                                   '</td>'+
                                    '<td rowspan="2" style="width: 10%" class="score"> '+s1+' </td>'+
                                    '<td class="estado"  style="width: 10%"> '+hora+' </td>'+
                                    '<td rowspan="2" style="width: 10%" class="score">'+s2+'</td>'+
                                    '<td rowspan="2" style="width: 35%">'+
                                       '<img src="'+escudo2+'">'+
                                    '</td>'+
                                 '</tr>'+
                                 '<tr>'+
                                    '<td class="vs">VS</td>'+
                                  '</tr>'  +
                                  '<tr>'+
                                    '<td style="width: 30%">'+t1+'</td>'+
                                    '<td></td>'+
                                    '<td></td>'+
                                    '<td></td>'+
                                    '<td style="width: 30%">'+t2+'</td>'+
                                  '</tr>'+
                                '</tbody>'+
                              '</table>'+
                            '</a>';
          
          var partido = 
          '<a href="infoPartido.html?idPartido='+id+'">'+
            '<table style="width: 100%">'+
              '<tr>'+
                '<th></th>'+
                '<th></th>'+
                '<th></th>'+
                '<th>'+hora+'</th>'+
                '<th></th>'+
                '<th></th>'+
                '<th></th>'+
              '</tr>'+
              '<tr>'+
              '<td style="width: 30%; "><img src="'+escudo1+'"></td>'+
              '<td colspan="2" style="width: 10%" rowspan="2"><h2>'+s1+'</h2></td>'+
                '<td rowspan="2">VS</td>'+
                '<td colspan="2"  style="width: 10%" rowspan="2"><h2>'+s2+'</h2></td>'+
              '<td style="width: 30%; "><img src="'+escudo2+'"></td>'+
              '</tr>'+
              '<tr>'+
              '<td style="width: 30%">'+t1+'</td>'+
              '<td style="width: 30%">'+t2+'</td>'+
              '</tr>'+
            '</table>'+
           '</a>';
          
          acum+=partido;
        });
        resultados.innerHTML = "<p>"+fecha+"</p>"+acum;    
    }
  }