  var datosPitcher;
  var idPitcher;

  var datosBateador;
  var idBateador;

  var pestanaActual; //Puede ser EnVivo, Relato, Box

  var idQuestion=0;
  var respuestaCorrecta=0;

  window.onload = function()
  {
    
    log("onLoad");
    
    document.getElementById("menuEnVivo").addEventListener("click", function(){ cargarPestanaEnVivo();},   false);
    document.getElementById("menuRelato").addEventListener("click", function(){ cargarPestanaNarracion();},false);
    document.getElementById("menuBox").addEventListener   ("click", function(){ cargarPestanaBox();},      false);
    document.getElementById("contadorPopUp").addEventListener   ("click", function(){ cerrarPopUp();},      false);
    
    document.getElementById("resultado").classList.add('escondido');
    
    document.getElementById("contadorPopUpPublicidad").addEventListener   ("click", function(){ cerrarPublicidad();},      false);
    document.getElementById("publicidad").addEventListener   ("click", function(){ mostrarPublicidad("http://dualvisio-estatico.azurewebsites.net/publicidad/skin-tlf");},      false);
    cargarPestanaEnVivo();
    
    //setInterval(function () {actualizar()}, 30000);
    
    var mensaje="";
      var pubnub = PUBNUB.init({
         publish_key: 'pub-c-13d721c5-d62a-4c84-8083-c43863b8f045',
         subscribe_key: 'sub-c-0ac19742-0b60-11e3-80a5-02ee2ddab7fe'
     });
    
    var str = window.location.search.replace("?", "");
    strVector= str.split("=");

    var id  = strVector[1];    
    var canal = 'BEI'+id;
    console.log("Canal: "+canal);
    pubnub.subscribe({
        channel: canal,
        message: function(m)
        {
          console.log(m);
          pn = JSON.parse(m);
                    
          console.log("Evento: "+pn['event']+". ID: "+pn['id']);
          
          document.getElementById("popUp").classList.remove('escondido');
          document.getElementById("resultado").classList.add('escondido');
           
          if(pn['event']=="Nueva Trivia")
          {
            document.getElementById("textoHeadPopUp").innerHTML="Trivia";
          }
          else if(pn['event']=="Nueva Encuesta")
          {
            document.getElementById("textoHeadPopUp").innerHTML="Encuesta";
          }
          else
          {
            document.getElementById("textoHeadPopUp").innerHTML="Curiosidad";
          }
          
          //Las curiosidades no tienen opciones.
          if(pn['event']=="Curiosidad")
          {
            document.getElementById("textoPopUp").innerHTML=pn['curiosity'];
            document.getElementById("opt1").classList.add('escondido');
            document.getElementById("opt2").classList.add('escondido');
            document.getElementById("opt3").classList.add('escondido');
            document.getElementById("opt4").classList.add('escondido');
            document.getElementById("imagenPopUp").classList.remove('escondido');
          }
          else //La trivia tiene respuesta, la encuesta no.
          {
           
            if(pn['event']=="Nueva Trivia")
            {
              respuestaCorrecta=pn['answer']; 
            }
            
            document.getElementById("imagenPopUp").classList.add('escondido');
            document.getElementById("textoPopUp").innerHTML=pn['question'];
            
            document.getElementById("opt1").classList.remove('escondido');
            document.getElementById("opt1").innerHTML=pn['options'][0];          
            asignarFuncionBoton("opt1",pn['id'],pn['event']);
            
            document.getElementById("opt2").classList.remove('escondido');
            document.getElementById("opt2").innerHTML=pn['options'][1];
            asignarFuncionBoton("opt2",pn['id'],pn['event']);
            //Se tienen al menos 2 opciones, siempre.          
            
            if (typeof pn['options'][2] != 'undefined') 
            {
              document.getElementById("opt3").classList.remove('escondido');
              document.getElementById("opt3").innerHTML=pn['options'][2];
              asignarFuncionBoton("opt3",pn['id'],pn['event']);
            }
            
            if (typeof pn['options'][3] != 'undefined') 
            {
              document.getElementById("opt4").classList.remove('escondido');
              document.getElementById("opt4").innerHTML=pn['options'][3];
              asignarFuncionBoton("opt4",pn['id'],pn['event']);
            }
            
          }
          
        }
     });
  };

  function mostrarPublicidad(URL)
  {
    document.getElementById("popUpPublicidad").classList.remove('escondido');
    document.getElementById("resultadoPublicidad").src=URL;
  }

  function cerrarPublicidad()
  {
    document.getElementById("popUpPublicidad").classList.add('escondido');
  }

  function asignarFuncionBoton(idBoton, id, tipoEvento)
  {
    console.log("Boton id: "+idBoton+". ID: "+id+". Tipo Evento: "+tipoEvento);
    if(tipoEvento=="Nueva Encuesta")
    {
      document.getElementById(idBoton).addEventListener("click", function(){ respuestaEncuesta(idBoton,id);},   false);  
    }
    
    if(tipoEvento=="Nueva Trivia")
    {
      document.getElementById(idBoton).addEventListener("click", function(){ respuestaTrivia(idBoton,id);},   false);
    }
  }

  function respuestaTrivia(idBoton, id)
  {
    var respuesta=0;
    if(idBoton=="opt1"){respuesta=0;}
    if(idBoton=="opt2"){respuesta=1;}
    if(idBoton=="opt3"){respuesta=2;}
    if(idBoton=="opt4"){respuesta=3;}

      document.getElementById("imagenPopUp").classList.add('escondido');
      document.getElementById("opt1").classList.add('escondido');
      document.getElementById("opt2").classList.add('escondido');
      document.getElementById("opt3").classList.add('escondido');
      document.getElementById("opt4").classList.add('escondido');    
    
    if(respuesta==respuestaCorrecta)
    {
      document.getElementById("textoPopUp").innerHTML= "Respondiste correctamente! <br/> Seras redireccionado a las estadisticas";
    }
    else
    {
      document.getElementById("textoPopUp").innerHTML= "Respondiste incorrectamente! <br/> Seras redireccionado a las estadisticas";      
    }    
    
    var URL = "http://mer-extra.cloudapp.net/questions/show/"+id+"/"+respuesta;
    console.log("La URL que se va a mandar a la encuesta: "+URL);

    idQuestion=id;
    
    setTimeout(function() { redireccionEstadisticas(URL); }, 5000);

  }

  function redireccionEstadisticas(URL)
  {
    request = new XMLHttpRequest({ mozSystem: true });
    request.open('get', URL, true); 
    //request.responseType = 'json';
    request.addEventListener('error', errorEncuesta);
    request.addEventListener('load' , exitoEncuesta);
    request.send();        
  }

  function respuestaEncuesta(idBoton, id)
  {
    var respuesta=0;
    if(idBoton=="opt1"){respuesta=0;}
    if(idBoton=="opt2"){respuesta=1;}
    if(idBoton=="opt3"){respuesta=2;}
    if(idBoton=="opt4"){respuesta=3;}
    
      document.getElementById("imagenPopUp").classList.add('escondido');
      document.getElementById("opt1").classList.add('escondido');
      document.getElementById("opt2").classList.add('escondido');
      document.getElementById("opt3").classList.add('escondido');
      document.getElementById("opt4").classList.add('escondido');    
    
    document.getElementById("textoPopUp").innerHTML= "Gracias por particiar! <br/> Seras redireccionado a las estadisticas";
    
    var URL = "http://mer-extra.cloudapp.net/questions/show/"+id+"/"+respuesta;
    console.log("La URL que se va a mandar a la encuesta: "+URL);
    
    idQuestion=id;
    
    setTimeout(function() { redireccionEstadisticas(URL); }, 2000);
  }

  function errorEncuesta(){console.log("Error: "+request.error);}

  function exitoEncuesta(id)
  {
    var iFrame=document.getElementById("resultado");
    iFrame.classList.remove('escondido');
    iFrame.src = "http://mer-extra.cloudapp.net/questions/show/"+idQuestion;
  }

  function cerrarPopUp()
  {
    document.getElementById("popUp").classList.add('escondido');
    document.getElementById("imagenPopUp").classList.add('escondido');
    document.getElementById("opt1").classList.add('escondido');
    document.getElementById("opt2").classList.add('escondido');
    document.getElementById("opt3").classList.add('escondido');
    document.getElementById("opt4").classList.add('escondido');
    
    document.getElementById("textoPopUp").innerHTML= "------";
    document.getElementById("textoHeadPopUp").innerHTML= "Titulo";
    document.getElementById("resultado").classList.add('escondido');
    
  }

  function actualizar()
  {
    if(pestanaActual=="EnVivo")
    {
      cargarPestanaEnVivo();
    }
    if(pestanaActual=="Relato")
    {
      cargarPestanaNarracion();
    }
    if(pestanaActual=="Box")
    {
      cargarPestanaBox();
    }
    
  }

  function log(S)
  {
    console.log(S);
  }

  function cargarPestanaEnVivo()
  {
    //log("Entrando a cargarPestanaEnVivo.");
    pestanaActual="EnVivo";
    var menuEnVivo = document.getElementById("menuEnVivo");
    var menuRelato = document.getElementById("menuRelato");
    var menuBox = document.getElementById("menuBox");
    
    menuEnVivo.className = "pure-menu-selected";
    menuRelato.className = "";
    menuBox.className = "";
    
    var str = window.location.search.replace("?", "");
    strVector= str.split("=");

    var id  = strVector[1];
    
    var url = "http://lvbp.meridiano.com.ve/ws/stats_json.aspx?metodo=Innings&gameId="+id;   
    
    console.log("url: "+url);

    request = new XMLHttpRequest({ mozSystem: true });
    request.open('get', url, true);
    request.responseType = 'json';
    request.addEventListener('error', ErrorEstatusPartido);
    request.addEventListener('load', actualizarPartidoCargarEnVivo);
    request.send();

  }

  function actualizarPartidoCargarEnVivo()
  {
    //log("Entrando a actualizarPartidoCargarEnVivo");
    var partido = request.response;

    actualizarPartido(partido); 

    log("ID Pitcher: "+idPitcher);
    log("ID Bateador: "+idBateador);

    url = "http://lvbp.meridiano.com.ve/ws/stats_json.aspx?metodo=Jugador&playerId="+idPitcher;
    log("url: "+url);

    request = new XMLHttpRequest({ mozSystem: true });
    request.open('get', url, true);
    request.responseType = 'text/xml';
    request.addEventListener('error', ErrorEnVivo);
    request.addEventListener('load', exitoCargandoDatosPitcher);
    request.send();        
    
  }


  function actualizarPartido(partido)
  {
      //log("Entrando a actualizarPartido.");
      document.getElementById("estadio").innerHTML=partido[0].Stadium;
      document.getElementById("nombrePrimerEquipo").innerHTML=partido[0].ShortNameTeam1;
      document.getElementById("nombreSegundoEquipo").innerHTML=partido[0].ShortNameTeam2;
    
      var escudo2="";
    
      if(partido[0].Team1Id<10)
      {
        document.getElementById("escudoPrimerEquipo").innerHTML='<img src="http://wap.meridiano.com.ve/escudos/'+partido[0].Team1Id+'.gif">';  
      }
      else
      {
        var escudo1="";
        if(partido[0].Team1Id==20){escudo1="../img/Cuba.png";}
        if(partido[0].Team1Id==21){escudo1="../img/RepublicaDominicana.png";}
        if(partido[0].Team1Id==26){escudo1="../img/Mexico.png";}
        if(partido[0].Team1Id==27){escudo1="../img/PuertoRico.png";}
        if(partido[0].Team1Id==30){escudo1="../img/Venezuela.png";}         
        
        document.getElementById("escudoPrimerEquipo").innerHTML='<img src="'+escudo1+'">';
      }
    
      if(partido[0].Team2Id<10)
      {
        document.getElementById("escudoSegundoEquipo").innerHTML='<img src="http://wap.meridiano.com.ve/escudos/'+partido[0].Team2Id+'.gif"/>';  
      }
      else
      {
        var escudo2="";
        if(partido[0].Team2Id==20){escudo2="../img/Cuba.png";}
        if(partido[0].Team2Id==21){escudo2="../img/RepublicaDominicana.png";}
        if(partido[0].Team2Id==26){escudo2="../img/Mexico.png";}
        if(partido[0].Team2Id==27){escudo2="../img/PuertoRico.png";}
        if(partido[0].Team2Id==30){escudo2="../img/Venezuela.png";}         
        
        document.getElementById("escudoSegundoEquipo").innerHTML='<img src="'+escudo2+'">';
      }
    
    
      
      
      document.getElementById("carrerasPrimerEquipo").innerHTML=""+partido[0].RunsTeam1+"";
      document.getElementById("carrerasSegundoEquipo").innerHTML=""+partido[0].RunsTeam2+"";
      document.getElementById("bolas").innerHTML="B:"+partido[0].B;
      document.getElementById("strikes").innerHTML="S:"+partido[0].K;
      document.getElementById("outs").innerHTML="O:"+partido[0].O;
      document.getElementById("inning").innerHTML=partido[0].Inning;
      
      if (partido[0].Parte=="Baja"){
        document.getElementById("parte").innerHTML="&#9651;";
      }
      else{
        document.getElementById("parte").innerHTML="&#9661;";  
      }

      var nombreImagen = "";
      
      if(partido[0].FirstBasePlayerId==0){
        nombreImagen+="_";
      }
      else{
        nombreImagen+="-";
      }

      if(partido[0].SecondBasePlayerId==0){
        nombreImagen+="_";
      }
      else{
        nombreImagen+="-";
      }     
    
      if(partido[0].ThirdBasePlayerId==0){
        nombreImagen+="_";
      }
      else{
        nombreImagen+="-";
      }           
      
      document.getElementById("bases").innerHTML= '<img style="width: 45%" src="img/'+nombreImagen+'.png"/>';        
      
      /*
      Aqui van las cosas que ayudan a los otros metodos
      */
    
      idPitcher  = partido[0].CurrentPitcherId;
      idBateador = partido[0].CurrentBatterId;
        
  }


  function exitoCargandoDatosPitcher()
  {
    //log("Entrando a exitoCargandoDatosPitcher.");
    //log("Valor del datosPitcher antes: "+datosPitcher);    
    datosPitcher =request.response;
    //log("Valor del datosPitcher despues: "+datosPitcher);            

    url = "http://lvbp.meridiano.com.ve/ws/stats_json.aspx?metodo=Jugador&playerId="+idBateador;
    log("url: "+url);

    request = new XMLHttpRequest({ mozSystem: true });
    request.open('get', url, true);
    request.responseType = 'text/xml';
    request.addEventListener('error', ErrorEnVivo);
    request.addEventListener('load', exitoCargandoDatosBateador);
    request.send();            
  }

  function exitoCargandoDatosBateador()
  {
    //log("Entrando a exitoCargandoDatosBateador");
    //log("Valor del datosBateador antes: "+datosBateador);
    datosBateador =request.response;
    //log("Valor del datosBateador Despues: "+datosBateador);    
    
    //A estas alturas ya tengo los datos del Pitcher y del Bateador
    
    //log("Listos para parsear.");

    var pitcherNombre ="---";
    var pitcherImage  ="<img src='img/user.png' >"; //Aqui deberia de tener la imagen vacia
    var pitcherEFE    ="---";
    var pitcherHR     ="---";
    var pitcherK      ="---";
    var pitcherSV     ="---";
    
    if(datosPitcher!="{}"){
      pitcher = JSON.parse(datosPitcher);
      pitcherNombre=pitcher['Datos Personales'][0]['LastName']+" "+pitcher['Datos Personales'][0]['Name'];
      pitcherImage ='<img style="width: 70%;" src="http://lvbp.meridiano.com.ve/images/Players/'+pitcher['Datos Personales'][0]['Picture']+'">';
      
      pitcherEFE =pitcher['Estadisticas'][2]['Valor'];
      pitcherHR  =pitcher['Estadisticas'][7]['Valor'];
      pitcherK   =pitcher['Estadisticas'][9]['Valor'];
      pitcherSV  =pitcher['Estadisticas'][15]['Valor'];            
      
    }

    var bateadorNombre="---";
    var bateadorImagen="<img src='img/user.png' >";
    var bateadorAVG="---";
    var bateadorHR="---";
    var bateadorRBI="---";
    var bateadorOBP="---";
    
    if(datosBateador!="{}"){
      bateador= JSON.parse(datosBateador); 
      bateadorNombre=bateador['Datos Personales'][0]['LastName']+" "+bateador['Datos Personales'][0]['Name'];
      bateadorImagen='<img style="width: 70%;" src="http://lvbp.meridiano.com.ve/images/Players/'+bateador['Datos Personales'][0]['Picture']+'">';
      bateadorAVG =bateador['Estadisticas'][2]['Valor'];
      bateadorHR  =bateador['Estadisticas'][7]['Valor'];
      bateadorRBI =bateador['Estadisticas'][9]['Valor'];
      bateadorOBP =bateador['Estadisticas'][15]['Valor'];
    }
    
    var contenido=document.getElementById("contenido");
    
    var textoContenido = ''
+     '<table id="datosPitcher">'
+      '<tr>'
+        '<th colspan="5" style="text-align: left">Pitcher</th>'
+      '</tr>'
+      '<tr>'
+        '<td rowspan="3" id="imagenPitcher" >'+pitcherImage+'</td>'
+        '<td colspan="3" id="nombrePitcher" style="text-align: left">'+pitcherNombre+'<br></td>'
+        '<td> <img src="img/pelota.png"  style="width: 38%;"> </td>'
+      '</tr>'
+      '<tr>'
+        '<td>EFE</td>'
+        '<td>HR </td>'
+        '<td>K  </td>'
+        '<td>SV </td>'
+      '</tr>'
+      '<tr>'
+        '<td>'+pitcherEFE+'</td>'
+        '<td>'+pitcherHR+'</td>'
+        '<td>'+pitcherK+'</td>'
+        '<td>'+pitcherSV+'</td>'
+        '</tr>'
+      '</table>'                  
+      '<table id="datosBateador">'
+         '<tr>'
+           '<th colspan="5" style="text-align: left">Bateador</th>'
+         '</tr>'
+         '<tr>'
+        '<td rowspan="3" id="imagenBateador" >'+bateadorImagen+'</td>'
+        '<td colspan="3" id="nombreBateador" style="text-align: left">'+bateadorNombre+'<br></td>'
+           '<td><img src="img/bate.png" style="width: 38%;"></td>'
+         '</tr>'
+         '<tr>'
+           '<td>AVG<br></td>'
+           '<td>HR</td>'
+           '<td>RBI</td>'
+           '<td>OBP</td>'
+         '</tr>'
+         '<tr>'
+           '<td>'+bateadorAVG+'</td>'
+           '<td>'+bateadorHR+'</td>'
+           '<td>'+bateadorRBI+'</td>'
+           '<td>'+bateadorOBP+'</td>'
+         '</tr>'
+      '</table>';

      contenido.innerHTML= textoContenido;    
  }

  function cargarPestanaNarracion()
  {
    //log("Entrando a cargarPestanaNarracion.");
    pestanaActual="Narracion";
    var menuEnVivo = document.getElementById("menuEnVivo");
    var menuRelato = document.getElementById("menuRelato");
    var menuBox = document.getElementById("menuBox");
    
    menuEnVivo.className = "";
    menuRelato.className = "pure-menu-selected";
    menuBox.className = "";
    
    var str = window.location.search.replace("?", "");
    strVector= str.split("=");

    var id  = strVector[1];
    
    var url = "http://lvbp.meridiano.com.ve/ws/stats_json.aspx?metodo=Innings&gameId="+id;   
    
    console.log("url: "+url);

    request = new XMLHttpRequest({ mozSystem: true });
    request.open('get', url, true);
    request.responseType = 'text/xml';
    request.addEventListener('error', ErrorEstatusPartido);
    request.addEventListener('load', actualizarPartidoCargarNarracion);
    request.send();
    
  }

  function actualizarPartidoCargarNarracion()
  {
    
    var contenido=document.getElementById("contenido");
    
    var comentariosRaw12 = request.response;
    
    var comentariosRaw1 = comentariosRaw12.substr(1);
    
    var comentariosRaw = comentariosRaw1.substr(0, comentariosRaw1.length-1);

    var comentarios    = JSON.parse(comentariosRaw);
    contenido.innerHTML="";
    
    for(var i=0; i<comentarios["Comentarios"].length;i++)
    {
      agregarInning="<p class='tituloComentario' style='background: black;'>"+comentarios["Comentarios"][i]["Inning"]+"</p>";
      
      array_com = comentarios["Comentarios"][i]["Resume"].toString().split(',');
      
      for (var p = 0 ; p < array_com.length ; p++ )
      {
         agregarInning+="<p>"+array_com[p]+"</p>";
      }
      contenido.innerHTML+=agregarInning;
    }
    
  
  }

  function cargarPestanaBox(){
    
    pestanaActual="Box";
    
    var menuEnVivo = document.getElementById("menuEnVivo");
    var menuRelato = document.getElementById("menuRelato");
    var menuBox = document.getElementById("menuBox");
    
    menuEnVivo.className = "";
    menuRelato.className = "";
    menuBox.className = "pure-menu-selected";

    var str = window.location.search.replace("?", "");
    strVector= str.split("=");

    var id  = strVector[1];
    
    var url = "http://lvbp.meridiano.com.ve/ws/stats_json.aspx?metodo=Innings&gameId="+id;   
    
    
    console.log("url: "+url);

    request = new XMLHttpRequest({ mozSystem: true });
    request.open('get', url, true);
    request.responseType = 'text/xml';
    request.addEventListener('error', ErrorEstatusPartido);
    request.addEventListener('load', actualizarPartidoCargarBox);
    request.send();
    
  }

  function actualizarPartidoCargarBox(){
    //log("Entrando a actualizarPartidoCargarBox");
    var contenido=document.getElementById("contenido");
    
    var comentariosRaw12 = request.response;
    
    var comentariosRaw1 = comentariosRaw12.substr(1);
    
    var comentariosRaw = comentariosRaw1.substr(0, comentariosRaw1.length-1);

    var g    = JSON.parse(comentariosRaw);
    
    //log("comentarios['Comentarios: ']: "+g["I1Team1"]);
    contenido.innerHTML="";
    
    contenido.innerHTML=''

+'<table  style="width: 100%">'   
+'  <tr>'
+'    <th style="width: 28%"></th>'
+'    <th style="width: 6%">1</th>'
+'    <th style="width: 6%">2</th>'
+'    <th style="width: 6%">3</th>'
+'    <th style="width: 6%">4</th>'
+'    <th style="width: 6%">5</th>'
+'    <th style="width: 6%">6</th>'
+'    <th style="width: 6%">7</th>'
+'    <th style="width: 6%">8</th>'
+'    <th style="width: 6%">9</th>'
+'    <th style="width: 6%">C</th>'
+'    <th style="width: 6%">H</th>'
+'    <th style="width: 6%">E</th>'
    
+'  </tr>'
+'  <tr>'
+'    <td style="width: 28%">'+g["ShortNameTeam1"]+'</td>'
+'    <td style="width: 6%">'+g["I1Team1"]+'</td>'
+'    <td style="width: 6%">'+g["I2Team1"]+'</td>'
+'    <td style="width: 6%">'+g["I3Team1"]+'</td>'
+'    <td style="width: 6%">'+g["I4Team1"]+'</td>'
+'    <td style="width: 6%">'+g["I5Team1"]+'</td>'
+'    <td style="width: 6%">'+g["I6Team1"]+'</td>'
+'    <td style="width: 6%">'+g["I7Team1"]+'</td>'
+'    <td style="width: 6%">'+g["I8Team1"]+'</td>'
+'    <td style="width: 6%">'+g["I9Team1"]+'</td>'

+'    <td style="width: 6%">'+g["RunsTeam1"]+'</td>'
+'    <td style="width: 6%">'+g["HitsTeam1"]+'</td>'
+'    <td style="width: 6%">'+g["ErrorsTeam1"]+'</td>'
+'  </tr>'
+'  <tr>'
+'    <td style="width: 28%">'+g["ShortNameTeam2"]+'</td>'
+'    <td style="width: 6%">'+g["I1Team2"]+'</td>'
+'    <td style="width: 6%">'+g["I2Team2"]+'</td>'
+'    <td style="width: 6%">'+g["I3Team2"]+'</td>'
+'    <td style="width: 6%">'+g["I4Team2"]+'</td>'
+'    <td style="width: 6%">'+g["I5Team2"]+'</td>'
+'    <td style="width: 6%">'+g["I6Team2"]+'</td>'
+'    <td style="width: 6%">'+g["I7Team2"]+'</td>'
+'    <td style="width: 6%">'+g["I8Team2"]+'</td>'
+'    <td style="width: 6%">'+g["I9Team2"]+'</td>'
+'    <td style="width: 6%">'+g["RunsTeam2"]+'</td>'
+'    <td style="width: 6%">'+g["HitsTeam2"]+'</td>'
+'    <td style="width: 6%">'+g["ErrorsTeam2"]+'</td>'
   
+'  </tr>'
+'</table>';
}

  /*
  Todos los mensajes de error
  */

  function ErrorEstatusPartido()
  {
    log("ErrorEstatusPartido: "+request.error);
  }

  function ErrorEnVivo()
  {
    log("Error actualizado la pestana En Vivo. Request.error: "+request.error);
  }
  
  function ErrorPestanaEnVivo()
  {
    log("En el metodo cargaPestanaEnVivo tenemos el error "+ request.error);
  }

  function ErrorCargandoDatosPitcher()
  {
    log("En CargandoDatosPitcher tenemos el error: "+request.error);
  }

  function ErrorCargandoDatosBateador()
  {
    log("En ErrorCargandoDatosBateador tenemos el error: "+request.error);
  }

