/*
 
 @autor Maik Basso
 @email maik@maikbasso.com.br
 @telefone (55) 9952-9459
 
 @appNome Aprendendo Com O Zag
 */

function Principal(jogo) {

    //definir o status do audio a trilha sonora para iniciar tocando
    jogo.conteudo["statusTrilhaSonora"] = true;

    this.renderizar = function () {
        var interfaceInicial = new Menu(jogo);
        jogo.setInterface(interfaceInicial);
        jogo.renderizarInterface();
    };
    
}

function Menu(jogo) {

    //definição dos elementos da interface
    var background = new ElementosGraficos().imagem;
    background.setImagem(jogo.imagens["menu_background"]);

    var btnSobre = new ElementosGraficos().imagem;
    btnSobre.setImagem(jogo.imagens["menu_btn_sobre"]);

    var btnPlay = new ElementosGraficos().imagem;
    btnPlay.setImagem(jogo.imagens["menu_btn_play"]);

    var botoes = new Botoes(jogo);
    botoes.isMenu();
    
    //efeitos
    var efeitos = new EfeitosGraficos();

    //esse é o construtor da interface na engine
    this.renderizar = function () {

        background.renderizar(0, 0, 100, 100);

        btnSobre.renderizar(90, 15, 11, 10);

        btnSobre.canvas.onclick = function () {
            destruir();
            var sobre = new Sobre(jogo);
            jogo.setInterface(sobre);
            jogo.renderizarInterface();
        };

        btnPlay.renderizar(1.5, 70, 33, 25);

        btnPlay.canvas.onclick = function () {
            destruir();
            var intro = new Intro(jogo);
            jogo.setInterface(intro);
            jogo.renderizarInterface();
        };

        botoes.renderizar();
        
        efeitos.Especials.Dance(btnPlay.canvas);
        efeitos.Bounce.EnterRightBounce(btnSobre.canvas);
    };

    //método padrao de uma interface que remove a interface e seus elementos por completo
    function destruir() {
        efeitos.remover();
        background.remover();
        btnPlay.remover();
        btnSobre.remover();
        botoes.destruir();
    }

    this.destruir = function () {
        destruir();
    };
}

function Sobre(jogo) {

    //definição dos elementos da interface
    var background = new ElementosGraficos().imagem;
    background.setImagem(jogo.imagens["sobre_background"]);

    //importa os botoes na interface
    var botoes = new Botoes(jogo);
    botoes.isSobre();

    //esse é o construtor da interface na engine
    this.renderizar = function () {

        background.renderizar(0, 0, 100, 100);

        botoes.renderizar();
    };

    //remove a interface
    function destruir() {
        background.remover();
        botoes.destruir();
    }

    this.destruir = function () {
        destruir();
    };
}

function Intro(jogo) {

    //definição dos elementos da interface
    var background = new ElementosGraficos().imagem;
    background.setImagem(jogo.imagens["intro_background"]);

    var btnPular = new ElementosGraficos().imagem;
    btnPular.setImagem(jogo.imagens["intro_btn_pular"]);

    //importa os botoes na interface
    var botoes = new Botoes(jogo);
    botoes.isIntro();

    //criamos os efeitos graficos
    var efeito = new EfeitosGraficos();

    //esse é o construtor da interface na engine
    this.renderizar = function () {

        background.renderizar(0, 0, 100, 100);
        
        btnPular.renderizar(81, 85, 20, 13);

        if (jogo.sons["intro"].status === false) {
            jogo.sons["intro"].setTempoAtual(0);
            jogo.sons["intro"].play();

            window.setTimeout(function () {
                efeito.Agreccives.FlashBang(btnPular.canvas);
            }, 11 * 1000);
        }

        btnPular.canvas.onclick = function () {
            destruir();
            var fase = new Fase1(jogo);
            jogo.setInterface(fase);
            jogo.renderizarInterface();
        };

        botoes.renderizar();
        
        efeito.Bounce.EnterRightBounce(btnPular.canvas);
    };

    //remove a interface
    function destruir() {
        efeito.remover();
        jogo.sons["intro"].pause();
        background.remover();
        botoes.destruir();
        btnPular.remover();
    }

    this.destruir = function () {
        destruir();
    };

}

function Fase1(jogo) {

    //definição dos elementos da interface
    var background = new ElementosGraficos().imagem;
    background.setImagem(jogo.imagens["fase1_background"]);

    //importa os botoes na interface
    var botoes = new Botoes(jogo);
    botoes.isFase1();

    //tela apresentacao
    var telaApresentacao = new ElementosGraficos().retangulo;
    telaApresentacao.setPropriedades("#000000", "");
    telaApresentacao.canvas.style.opacity = 0.8;

    //miniaturas das letras
    var letraMinA = new ElementosGraficos().imagem;
    letraMinA.setImagem(jogo.imagens["fase1_letra_min_a"]);
    var letraMinE = new ElementosGraficos().imagem;
    letraMinE.setImagem(jogo.imagens["fase1_letra_min_e"]);
    var letraMinI = new ElementosGraficos().imagem;
    letraMinI.setImagem(jogo.imagens["fase1_letra_min_i"]);
    var letraMinO = new ElementosGraficos().imagem;
    letraMinO.setImagem(jogo.imagens["fase1_letra_min_o"]);
    var letraMinU = new ElementosGraficos().imagem;
    letraMinU.setImagem(jogo.imagens["fase1_letra_min_u"]);

    var opacidadeMiniaturas = 0.4;
    letraMinA.canvas.style.opacity = opacidadeMiniaturas;
    letraMinE.canvas.style.opacity = opacidadeMiniaturas;
    letraMinI.canvas.style.opacity = opacidadeMiniaturas;
    letraMinO.canvas.style.opacity = opacidadeMiniaturas;
    letraMinU.canvas.style.opacity = opacidadeMiniaturas;

    //letras escondidas
    var letraEscA = new ElementosGraficos().imagem;
    letraEscA.setImagem(jogo.imagens["fase1_letra_esc_a"]);
    var letraEscE = new ElementosGraficos().imagem;
    letraEscE.setImagem(jogo.imagens["fase1_letra_esc_e"]);
    var letraEscI = new ElementosGraficos().imagem;
    letraEscI.setImagem(jogo.imagens["fase1_letra_esc_i"]);
    var letraEscO = new ElementosGraficos().imagem;
    letraEscO.setImagem(jogo.imagens["fase1_letra_esc_o"]);
    var letraEscU = new ElementosGraficos().imagem;
    letraEscU.setImagem(jogo.imagens["fase1_letra_esc_u"]);

    //verifica se é vencedor ou não
    var venceuFase = false;

    //status apresentacao
    var statusApresentacao = false;

    //letras encontradas
    var letraEncontradaA = false;
    var letraEncontradaE = false;
    var letraEncontradaI = false;
    var letraEncontradaO = false;
    var letraEncontradaU = false;

    //verifica se venceu
    function verificaSeVenceu() {
        if ((letraEncontradaA === true) &&
                (letraEncontradaE === true) &&
                (letraEncontradaI === true) &&
                (letraEncontradaO === true) &&
                (letraEncontradaU === true)) {
            if (venceuFase === false) {
                destruir();
                var ganhou = new Fase1_ganhou(jogo);
                jogo.setInterface(ganhou);
                jogo.renderizarInterface();
            }
            venceuFase = true;
        }
    }
    
    //efeitos
    var efeitos = new EfeitosGraficos();

    //esse é o construtor da interface na engine
    this.renderizar = function () {

        background.renderizar(0, 0, 100, 100);

        letraMinA.renderizar(30, 93, 5, 5);
        letraMinE.renderizar(40, 93, 5, 5);
        letraMinI.renderizar(49, 93, 1.8, 5);
        letraMinO.renderizar(55, 93, 5, 5);
        letraMinU.renderizar(65, 93, 5, 5);

        if (letraEncontradaA === false)
            letraEscA.renderizar(34, 3, 7, 7);
        if (letraEncontradaE === false)
            letraEscE.renderizar(29.5, 79, 4, 4);
        if (letraEncontradaI === false)
            letraEscI.renderizar(87.8, 70.5, 2, 10);
        if (letraEncontradaO === false)
            letraEscO.renderizar(54.5, 45, 8, 8);
        if (letraEncontradaU === false)
            letraEscU.renderizar(18, 48, 8, 12);

        letraEscA.canvas.onclick = function () {
            jogo.sons["fase1_letra_a"].play();
            letraMinA.canvas.style.opacity = 1;
            efeitos.Agreccives.FlashBang(letraMinA.canvas);
            letraEscA.canvas.style.display = "none";
            window.setTimeout(function () {
                letraEncontradaA = true;
                verificaSeVenceu();
            }, 3 * 1000);
        };

        letraEscE.canvas.onclick = function () {
            jogo.sons["fase1_letra_e"].play();
            letraMinE.canvas.style.opacity = 1;
            efeitos.Agreccives.FlashBang(letraMinE.canvas);
            letraEscE.canvas.style.display = "none";
            window.setTimeout(function () {
                letraEncontradaE = true;
                verificaSeVenceu();
            }, 3 * 1000);
        };

        letraEscI.canvas.onclick = function () {
            jogo.sons["fase1_letra_i"].play();
            letraMinI.canvas.style.opacity = 1;
            efeitos.Agreccives.FlashBang(letraMinI.canvas);
            letraEscI.canvas.style.display = "none";
            window.setTimeout(function () {
                letraEncontradaI = true;
                verificaSeVenceu();
            }, 3 * 1000);
        };

        letraEscO.canvas.onclick = function () {
            jogo.sons["fase1_letra_o"].play();
            letraMinO.canvas.style.opacity = 1;
            efeitos.Agreccives.FlashBang(letraMinO.canvas);
            letraEscO.canvas.style.display = "none";
            window.setTimeout(function () {
                letraEncontradaO = true;
                verificaSeVenceu();
            }, 3 * 1000);
        };

        letraEscU.canvas.onclick = function () {
            jogo.sons["fase1_letra_u"].play();
            letraMinU.canvas.style.opacity = 1;
            efeitos.Agreccives.FlashBang(letraMinU.canvas);
            letraEscU.canvas.style.display = "none";
            window.setTimeout(function () {
                letraEncontradaU = true;
                verificaSeVenceu();
            }, 3 * 1000);
        };

        if (statusApresentacao === false) {
            telaApresentacao.renderizar(0, 0, 100, 100);
            //play na introdução
            if (jogo.sons["fase1_abertura"].status !== true) {
                jogo.sons["fase1_abertura"].setTempoAtual(0);
                jogo.sons["fase1_abertura"].play();
            }
            window.setTimeout(function () {
                statusApresentacao = true;
                telaApresentacao.canvas.style.display = "none";
            }, 9 * 1000);
        }

        botoes.renderizar();
    };

    //remove a interface
    function destruir() {
        efeitos.remover();
        jogo.sons["fase1_abertura"].pause();
        background.remover();
        telaApresentacao.remover();
        botoes.destruir();

        letraMinA.remover();
        letraMinE.remover();
        letraMinI.remover();
        letraMinO.remover();
        letraMinU.remover();

        letraEscA.remover();
        letraEscE.remover();
        letraEscI.remover();
        letraEscO.remover();
        letraEscU.remover();
    }

    this.destruir = function () {
        destruir();
    };

}

function Fase1_ganhou(jogo) {

    //definição dos elementos da interface
    var background = new ElementosGraficos().imagem;
    background.setImagem(jogo.imagens["fase1_ganhou_background"]);

    //importa os botoes na interface
    var botoes = new Botoes(jogo);
    botoes.isFase1_ganhou();

    var btnProximo = new ElementosGraficos().imagem;
    btnProximo.setImagem(jogo.imagens["fase1_btn_proxima"]);

    //reproduz o audio
    jogo.sons["fase1_final"].setTempoAtual(0);
    jogo.sons["fase1_final"].play();
    
    //efeitos
    var efeitos = new EfeitosGraficos();

    //esse é o construtor da interface na engine
    this.renderizar = function () {

        background.renderizar(0, 0, 100, 100);

        window.setTimeout(function () {
            btnProximo.renderizar(81, 85, 20, 13);
            
            efeitos.Bounce.EnterRightBounce(btnProximo.canvas);

            btnProximo.canvas.onclick = function () {
                destruir();
                var fase2 = new Fase2_apresentacao(jogo);
                jogo.setInterface(fase2);
                jogo.renderizarInterface();
            };
        }, 7 * 1000);

        botoes.renderizar();
    };

    //método padrao de uma interface que remove a interface e seus elementos por completo
    function destruir() {
        efeitos.remover();
        jogo.sons["fase1_final"].pause();
        background.remover();
        btnProximo.remover();
        botoes.destruir();
    }

    this.destruir = function () {
        destruir();
    };
}

function Fase2_apresentacao(jogo) {

    //definição dos elementos da interface
    var background = new ElementosGraficos().imagem;
    background.setImagem(jogo.imagens["fase2_apresentacao_background"]);

    var btnProximo = new ElementosGraficos().imagem;
    btnProximo.setImagem(jogo.imagens["fase2_btn_proxima"]);

    //importa os botoes na interface
    var botoes = new Botoes(jogo);
    botoes.isFase2_apresentacao();

    jogo.sons["fase2_abertura"].setTempoAtual(0);
    jogo.sons["fase2_abertura"].play();
    
    //efeitos
    var efeitos = new EfeitosGraficos();

    //esse é o construtor da interface na engine
    this.renderizar = function () {

        background.renderizar(0, 0, 100, 100);

        window.setTimeout(function () {
            btnProximo.renderizar(81, 85, 20, 13);
            
            efeitos.Bounce.EnterRightBounce(btnProximo.canvas);

            btnProximo.canvas.onclick = function () {
                destruir();
                var fase = new Fase2(jogo);
                jogo.setInterface(fase);
                jogo.renderizarInterface();
            };
        }, 9 * 1000);

        botoes.renderizar();
    };

    //remove a interface
    function destruir() {
        efeitos.remover();
        jogo.sons["fase2_abertura"].pause();
        botoes.destruir();
        background.remover();
    }

    this.destruir = function () {
        destruir();
    };
}

function Fase2(jogo) {

    //definição dos elementos da interface
    var background = new ElementosGraficos().imagem;
    background.setImagem(jogo.imagens["fase2_background"]);

    //importa os botoes na interface
    var botoes = new Botoes(jogo);
    botoes.isFase2();

    var btnReiniciar = new ElementosGraficos().imagem;
    btnReiniciar.setImagem(jogo.imagens["fase2_btn_reiniciar"]);

    var quadro = new ElementosGraficos().retangulo;
    
    var linha = new ElementosGraficos().retangulo;
    linha.setPropriedades("#0066ff", "");

    //classe logica
    var escrever = new EscreverNoPontilhado(quadro.canvas, jogo);

    //efeitos
    var efeitos = new EfeitosGraficos();
    
    //esse é o construtor da interface na engine
    this.renderizar = function () {

        background.renderizar(0, 0, 100, 100);

        btnReiniciar.renderizar(90, 15, 11, 10);

        btnReiniciar.canvas.onclick = function () {
            btnReiniciar.canvas.style.display = "none";
            quadro.renderizar(20, 10, 60, 80);
            escrever.executar();
            efeitos.Fade.In(btnReiniciar.canvas, 10);
        };

        quadro.renderizar(20, 10, 60, 80);
        linha.renderizar(20, 86, 60, 0.5);

        botoes.renderizar();
        escrever.executar();
        
        efeitos.Bounce.EnterRightBounce(btnReiniciar.canvas);
    };

    this.reiniciar = function () {
        quadro.renderizar(20, 10, 60, 80);
        escrever.executar();
    };

    //remove a interface
    function destruir() {
        linha.remover();
        efeitos.remover();
        botoes.destruir();
        background.remover();
        quadro.remover();
        btnReiniciar.remover();
    }

    this.destruir = function () {
        destruir();
    };

}

function Fase2_riscandoFora(jogo) {

    //definição dos elementos da interface
    var background = new ElementosGraficos().retangulo;
    background.setPropriedades("#000000", "");
    background.canvas.style.opacity = 0.8;

    var erroPontilhado = new ElementosGraficos().imagem;
    erroPontilhado.setImagem(jogo.imagens["fase2_riscandofora_imagem"]);

    //esse é o construtor da interface na engine
    this.renderizar = function () {

        background.renderizar(0, 0, 100, 100);

        erroPontilhado.renderizar(30, 30, 40, 40);

        if (jogo.sons["fase2_riscando_fora"].status !== true) {
            jogo.sons["fase2_riscando_fora"].setTempoAtual(0);
            jogo.sons["fase2_riscando_fora"].play();
        }

        window.setTimeout(function () {
            jogo.getInterface().reiniciar();
            destruir();
        }, 7 * 1000);
    };

    //método padrao de uma interface que remove a interface e seus elementos por completo
    function destruir() {
        jogo.sons["fase2_riscando_fora"].pause();
        background.remover();
        erroPontilhado.remover();
    }

    this.destruir = function () {
        destruir();
    };
}

function Fase2_acertou(jogo) {
    //definição dos elementos da interface
    var background = new ElementosGraficos().retangulo;
    background.setPropriedades("#000000", "");
    background.canvas.style.opacity = 0.8;

    var imagemAcerto = new ElementosGraficos().imagem;
    imagemAcerto.setImagem(jogo.imagens["fase2_acertou_imagem"]);

    //reproduzir o som da interface
    jogo.sons["fase2_proxima_letra"].setTempoAtual(0);
    jogo.sons["fase2_proxima_letra"].play();

    //esse é o construtor da interface na engine
    this.renderizar = function () {

        background.renderizar(0, 0, 100, 100);

        imagemAcerto.renderizar(30, 30, 40, 40);

        window.setTimeout(function () {
            destruir();
        }, 3 * 1000);
    };

    //método padrao de uma interface que remove a interface e seus elementos por completo
    function destruir() {
        jogo.sons["fase2_proxima_letra"].pause();
        background.remover();
        imagemAcerto.remover();
    }

    this.destruir = function () {
        destruir();
    };
}

function Fase2_ganhou(jogo) {
    //definição dos elementos da interface
    var background = new ElementosGraficos().imagem;
    background.setImagem(jogo.imagens["fase2_ganhou_background"]);

    //importa os botoes na interface
    var botoes = new Botoes(jogo);
    botoes.isFase2_ganhou();

    var btnProximo = new ElementosGraficos().imagem;
    btnProximo.setImagem(jogo.imagens["fase2_btn_proxima"]);

    //reproduz o audio
    jogo.sons["fase2_final"].setTempoAtual(0);
    jogo.sons["fase2_final"].play();
    
    //efeitos
    var efeitos = new EfeitosGraficos();

    //esse é o construtor da interface na engine
    this.renderizar = function () {

        background.renderizar(0, 0, 100, 100);

        window.setTimeout(function () {
            btnProximo.renderizar(81, 85, 20, 13);
            
            efeitos.Bounce.EnterRightBounce(btnProximo.canvas);

            btnProximo.canvas.onclick = function () {
                destruir();
                var fase = new Fase3_apresentacao(jogo);
                jogo.setInterface(fase);
                jogo.renderizarInterface();
            };
        }, 13 * 1000);

        botoes.renderizar();

    };

    //método padrao de uma interface que remove a interface e seus elementos por completo
    function destruir() {
        efeitos.remover();
        jogo.sons["fase2_final"].pause();
        background.remover();
        btnProximo.remover();
        botoes.destruir();
    }

    this.destruir = function () {
        destruir();
    };
}

function Fase3_apresentacao(jogo) {

    //definição dos elementos da interface
    var background = new ElementosGraficos().imagem;
    background.setImagem(jogo.imagens["fase3_apresentacao_background"]);

    var btnProximo = new ElementosGraficos().imagem;
    btnProximo.setImagem(jogo.imagens["fase3_btn_proxima"]);

    //importa os botoes na interface
    var botoes = new Botoes(jogo);
    botoes.isFase3_apresentacao();
    
    jogo.sons["fase3_abertura"].setTempoAtual(0);
    jogo.sons["fase3_abertura"].play();
    
    //efeitos
    var efeitos = new EfeitosGraficos();

    //esse é o construtor da interface na engine
    this.renderizar = function () {

        background.renderizar(0, 0, 100, 100);

        window.setTimeout(function () {
            btnProximo.renderizar(81, 85, 20, 13);
            
            efeitos.Bounce.EnterRightBounce(btnProximo.canvas);

            btnProximo.canvas.onclick = function () {
                destruir();
                var fase = new Fase3(jogo);
                jogo.setInterface(fase);
                jogo.renderizarInterface();
            };
        }, 13 * 1000);

        botoes.renderizar();

    };

    //remove a interface
    function destruir() {
        efeitos.remover();
        jogo.sons["fase3_abertura"].pause();
        botoes.destruir();
        background.remover();
    }

    this.destruir = function () {
        destruir();
    };

}

function Fase3(jogo) {

    //definição dos elementos da interface
    var background = new ElementosGraficos().imagem;
    background.setImagem(jogo.imagens["fase3_background"]);

    //importa os botoes na interface
    var botoes = new Botoes(jogo);
    botoes.isFase3();

    var btnReiniciar = new ElementosGraficos().imagem;
    btnReiniciar.setImagem(jogo.imagens["fase3_btn_reiniciar"]);

    var btnVerificarResposta = new ElementosGraficos().imagem;
    btnVerificarResposta.setImagem(jogo.imagens["fase3_btn_verificar"]);

    var quadro = new ElementosGraficos().retangulo;
    
    var linha = new ElementosGraficos().retangulo;
    linha.setPropriedades("#0066ff", "");
    
    var letraAtual = new ElementosGraficos().texto;
    letraAtual.setPropriedades("#2d2d2d", parseInt((letraAtual.canvas.width) / 60) + "em Helvetica", "center");
    letraAtual.canvas.style.borderRadius = "10%";
    letraAtual.canvas.style.background = "#cccccc";
    letraAtual.canvas.style.boxShadow = "#6d6d6d 0 0 5px 5px";
    
    //efeitos
    var efeitos = new EfeitosGraficos();

    //classe logica
    var escrever = new EscreverMaoLivre(quadro.canvas, letraAtual, efeitos, jogo);

    //esse é o construtor da interface na engine
    this.renderizar = function () {

        background.renderizar(0, 0, 100, 100);

        btnReiniciar.renderizar(90, 15, 11, 10);

        btnReiniciar.canvas.onclick = function () {
            btnReiniciar.canvas.style.display = "none";
            quadro.canvas.style.display = "none";
            quadro.renderizar(20, 10, 60, 80);
            quadro.canvas.style.display = "block";
            efeitos.Agreccives.FlashBang(quadro.canvas);
            escrever.executar();
            efeitos.Fade.In(btnReiniciar.canvas, 10);
        };

        quadro.renderizar(20, 10, 60, 80);
        linha.renderizar(20, 86, 60, 0.5);

        btnVerificarResposta.renderizar(81, 85, 20, 13);

        btnVerificarResposta.canvas.onclick = function () {
            efeitos.Fade.In(btnVerificarResposta.canvas, 4);
            escrever.verificaSeVenceu();
        };

        botoes.renderizar();

        escrever.executar();
        
        letraAtual.renderizar(escrever.getLetraAtual(), 2, 30, 15, 25);
        
        efeitos.Bounce.EnterRightBounce(btnReiniciar.canvas);
        efeitos.Bounce.EnterRightBounce(btnVerificarResposta.canvas);

    };

    //remove a interface
    function destruir() {
        letraAtual.remover();
        linha.remover();
        efeitos.remover();
        botoes.destruir();
        background.remover();
        quadro.remover();
        btnReiniciar.remover();
        btnVerificarResposta.remover();
    }

    this.destruir = function () {
        destruir();
    };

}

function Fase3_ganhou(jogo) {
    //definição dos elementos da interface
    var background = new ElementosGraficos().imagem;
    background.setImagem(jogo.imagens["fase3_ganhou_background"]);

    //importa os botoes na interface
    var botoes = new Botoes(jogo);
    botoes.isFase3_ganhou();

    var btnProximo = new ElementosGraficos().imagem;
    btnProximo.setImagem(jogo.imagens["fase3_btn_proxima"]);

    //reproduz o audio
    jogo.sons["fase3_final"].setTempoAtual(0);
    jogo.sons["fase3_final"].play();
    
    //efeitos
    var efeitos = new EfeitosGraficos();

    //esse é o construtor da interface na engine
    this.renderizar = function () {

        background.renderizar(0, 0, 100, 100);

        window.setTimeout(function () {
            btnProximo.renderizar(81, 85, 20, 13);
            
            efeitos.Bounce.EnterRightBounce(btnProximo.canvas);

            btnProximo.canvas.onclick = function () {
                destruir();
                var fase = new Creditos(jogo);
                jogo.setInterface(fase);
                jogo.renderizarInterface();
            };
        }, 12 * 1000);

        botoes.renderizar();

    };

    //método padrao de uma interface que remove a interface e seus elementos por completo
    function destruir() {
        efeitos.remover();
        jogo.sons["fase3_final"].pause();
        background.remover();
        btnProximo.remover();
        botoes.destruir();
    }

    this.destruir = function () {
        destruir();
    };
}

function Creditos(jogo) {

    var background = new ElementosGraficos().imagem;
    background.setImagem(jogo.imagens["creditos_background"]);
    
    var fim = new ElementosGraficos().texto;
    fim.setPropriedades("#000000", "2em arial", "center");

    //importa os botoes na interface
    var botoes = new Botoes(jogo);
    botoes.isCreditos();

    this.renderizar = function () {
        background.renderizar(0, 0, 100, 100);
        botoes.renderizar();
        fim.renderizar("Fim ;)", 70, 90, 20, 10);
    };

    function destruir() {
        background.remover();
        botoes.destruir();
        fim.remover();
    }

    this.destruir = function () {
        destruir();
    };

}

/*==============================================================================
 ***************************  TELAS AUXILIARES  ******************************** 
 =============================================================================*/
function RetornarAoMenu(jogo) {

    //definição dos elementos da interface
    var background = new ElementosGraficos().retangulo;
    background.setPropriedades("#000000", "");
    background.canvas.style.opacity = 0.8;

    var btnMenu = new ElementosGraficos().imagem;
    btnMenu.setImagem(jogo.imagens["retornaraomenu_btn_menu"]);

    var btnRetornar = new ElementosGraficos().imagem;
    btnRetornar.setImagem(jogo.imagens["retornaraomenu_btn_retornar"]);
    
    //efeitos
    var efeitos = new EfeitosGraficos();

    //esse é o construtor da interface na engine
    this.renderizar = function () {

        background.renderizar(0, 0, 100, 100);

        background.canvas.onclick = function () {
            destruir();
        };

        btnMenu.renderizar(33, 42, 20, 15);

        btnMenu.canvas.onclick = function () {
            destruir();
            jogo.destruirInterface();
            var menu = new Menu(jogo);
            jogo.setInterface(menu);
            jogo.renderizarInterface();
        };

        btnRetornar.renderizar(52.85, 42, 20, 15);

        btnRetornar.canvas.onclick = function () {
            destruir();
        };
        
        
        efeitos.Bounce.EnterDownBounce(btnMenu.canvas);
        efeitos.Bounce.EnterDownBounce(btnRetornar.canvas);

    };

    function destruir() {
        efeitos.remover();
        background.remover();
        btnMenu.remover();
        btnRetornar.remover();
    }

    this.destruir = function () {
        destruir();
    };
}

function Botoes(jogo) {

    var btnMenu = new ElementosGraficos().imagem;
    btnMenu.setImagem(jogo.imagens["btn_menu"]);

    var trilhaAtual = null;

    var btnSom = new ElementosGraficos().imagem;
    
    //efeitos
    var efeitos = new EfeitosGraficos();

    var renderizarBotaoMenu = true;
    var confirmacaoMenu = true;

    function startAudio(trilhaSonora, volume, replay) {
        console.log("trilha atual = " + trilhaSonora);
        trilhaAtual = trilhaSonora;

        if (jogo.conteudo["statusTrilhaSonora"] === true) {
            jogo.sons[trilhaAtual].setVolume(volume);
            if (replay === true) {
                jogo.sons[trilhaAtual].replay();
            }
            jogo.sons[trilhaAtual].play();
            btnSom.setImagem(jogo.imagens["btn_som_play"]);
        }
        else {
            btnSom.setImagem(jogo.imagens["btn_som_pause"]);
        }

    }
    
    //gera um numero para a trilha da interface
    function escolheTrilha(){
        var num = Math.floor(Math.random() * 11);
        if(num <= 1){
            num = 2;
        }
        if(num > 11){
            num = 11;
        }
        return num;
    }
    
    //identifica as diferentes interfaces

    this.isMenu = function () {
        startAudio("trilha_sonora_1", 0.5, true);
        renderizarBotaoMenu = false;
    };
    this.isSobre = function () {
        startAudio("trilha_sonora_1", 0.5, true);
        confirmacaoMenu = false;
    };
    this.isIntro = function () {
        startAudio("trilha_sonora_"+escolheTrilha(), 0.1, true);
    };
    this.isFase1 = function () {
        startAudio("trilha_sonora_"+escolheTrilha(), 0.3, true);
    };
    this.isFase1_ganhou = function () {
        startAudio("trilha_sonora_"+escolheTrilha(), 0.3, true);
    };
    this.isFase2_apresentacao = function () {
        startAudio("trilha_sonora_"+escolheTrilha(), 0.3, true);
    };
    this.isFase2 = function () {
        startAudio("trilha_sonora_"+escolheTrilha(), 0.3, true);
    };
    this.isFase2_ganhou = function () {
        startAudio("trilha_sonora_"+escolheTrilha(), 0.3, true);
    };
    this.isFase3_apresentacao = function () {
        startAudio("trilha_sonora_"+escolheTrilha(), 0.3, true);
    };
    this.isFase3 = function () {
        startAudio("trilha_sonora_"+escolheTrilha(), 0.3, true);
    };
    this.isFase3_ganhou = function () {
        startAudio("trilha_sonora_"+escolheTrilha(), 0.3, true);
    };
    this.isCreditos = function () {
        confirmacaoMenu = false;
        startAudio("trilha_sonora_"+escolheTrilha(), 0.5, true);
    };


    //esse é o construtor da interface na engine
    this.renderizar = function () {

        btnSom.renderizar(90, 2, 11, 10);

        btnSom.canvas.onclick = function () {
            btnSom.canvas.style.display = "none";
            if (jogo.conteudo["statusTrilhaSonora"] === true) {
                jogo.conteudo["statusTrilhaSonora"] = false;
                btnSom.setImagem(jogo.imagens["btn_som_pause"]);
                jogo.sons[trilhaAtual].pause();
            }
            else {
                jogo.conteudo["statusTrilhaSonora"] = true;
                btnSom.setImagem(jogo.imagens["btn_som_play"]);
                jogo.sons[trilhaAtual].play();
            }

            btnSom.renderizar(90, 2, 11, 10);
            
            efeitos.Fade.In(btnSom.canvas, 10);
        };

        if (renderizarBotaoMenu === true) {
            btnMenu.renderizar(-1, 2, 11, 10);

            btnMenu.canvas.onclick = function () {
                if (confirmacaoMenu === true) {
                    var retornarAoMenu = new RetornarAoMenu(jogo);
                    retornarAoMenu.renderizar();
                }
                else {
                    destruir();
                    var menu = new Menu(jogo);
                    jogo.setInterface(menu);
                    jogo.renderizarInterface();
                }
            };
            
            efeitos.Bounce.EnterLeftBounce(btnMenu.canvas);
        }
        
        efeitos.Bounce.EnterRightBounce(btnSom.canvas);

    };

    //remove a interface
    function destruir() {
        efeitos.remover();
        if (renderizarBotaoMenu === true) {
            btnMenu.remover();
        }
        jogo.sons[trilhaAtual].pause();
        btnSom.remover();
    }

    this.destruir = function () {
        destruir();
    };
}


/*==============================================================================
 ***********************  CONTROLADORES LÓGICOS  ******************************* 
 =============================================================================*/
function EscreverNoPontilhado(canvas, jogo) {
    //obter o contexto
    var ctx = canvas.getContext("2d");
    //margens do canvas
    var marginTop;
    var marginLeft;
    //letras da fase / tolerencia % (20% nao pintado é tolerente)
    var letras = [
        ["A", 20],
        ["E", 20],
        ["I", 30],
        ["O", 20],
        ["U", 25]
    ];
    var letraAtual = null;
    //status da ação de desenhar no canvas
    var mousedown = false;
    //mapeamento de pixeis no canvas
    var pixeisDoQuadro = null;
    var pixeisDaLetra = null;

    /*FUNÇÕES NECESSÁRIAS*/

    function escolheLetra() {
        //escolhe uma nova letra
        if (letraAtual === null) {
            if (letras.length !== 0) {
                //limpa o canvas
                ctx.clearRect(0, 0, canvas.width, canvas.height);

                //gera um indice para a letra
                var indiceAleatorio = Math.floor(Math.random() * (letras.length - 1));

                //armazena a letra atual
                letraAtual = letras[indiceAleatorio];

                //remove a posição do vetor
                letras.splice(indiceAleatorio, 1);

                //estilizar o contexto
                ctx.lineWidth = parseInt((70 * canvas.height) / 513);
                ctx.lineCap = "round";
                ctx.strokeStyle = 'rgb(0, 0, 50)';
                ctx.font = 'bold ' + parseInt((640 * canvas.height) / 513) + 'px Helvetica';
                ctx.fillStyle = 'rgb(255, 0, 0)';
                ctx.textAlign = "center";

                //desenha a letra
                ctx.fillText(letraAtual[0], canvas.width / 2, (canvas.height / 10) * 9.5);

                //mapear os pixeis
                pixeisDoQuadro = ctx.getImageData(0, 0, canvas.width, canvas.height);
                pixeisDaLetra = obterNumeroPixeis(255, 0, 0);
            }
        }
        //caso nao for nula
        else {
            //limpa o canvas
            ctx.clearRect(0, 0, canvas.width, canvas.height);

            //estilizar o contexto
            ctx.lineWidth = parseInt((70 * canvas.height) / 513);
            ctx.lineCap = "round";
            ctx.strokeStyle = 'rgb(0, 0, 50)';
            ctx.font = 'bold ' + parseInt((640 * canvas.height) / 513) + 'px Helvetica';
            ctx.fillStyle = 'rgb(255, 0, 0)';
            ctx.textAlign = "center";

            //desenha a letra
            ctx.fillText(letraAtual[0], canvas.width / 2, (canvas.height / 10) * 9.5);

            //mapear os pixeis
            pixeisDoQuadro = ctx.getImageData(0, 0, canvas.width, canvas.height);
            pixeisDaLetra = obterNumeroPixeis(255, 0, 0);
        }
    }

    function obterACorDoPixel(x, y) {
        //correção para as medidas em dispositivos móveis
        x = Math.floor(x);
        y = Math.floor(y);
        var index = ((y * (pixeisDoQuadro.width * 4)) + (x * 4));
        return {
            r: pixeisDoQuadro.data[index],
            g: pixeisDoQuadro.data[index + 1],
            b: pixeisDoQuadro.data[index + 2],
            a: pixeisDoQuadro.data[index + 3]
        };
    }

    function obterNumeroPixeis(r, g, b) {
        var pixels = ctx.getImageData(0, 0, canvas.width, canvas.height);
        var quantidade = 0;
        for (var i = 0; i < pixels.data.length; i += 4) {
            if (pixels.data[i] === r && pixels.data[i + 1] === g && pixels.data[i + 2] === b) {
                quantidade++;
            }
        }
        return quantidade;
    }

    function verificaSeVenceu() {
        if (((obterNumeroPixeis(255, 0, 0) / pixeisDaLetra) * 100) < letraAtual[1]) {
            letraAtual = null;
            escolheLetra();
            if (letras.length === 0 && letraAtual === null) {
                jogo.destruirInterface();
                var fase2 = new Fase2_ganhou(jogo);
                jogo.setInterface(fase2);
                jogo.renderizarInterface();
            }
            else {
                var acerto = new Fase2_acertou(jogo);
                acerto.renderizar();
            }
        }
    }

    function executar() {
        //canvas.style.opacity = 0.9;
        canvas.style.boxShadow = "#cccccc 0 0 5px 5px";
        canvas.style.borderRadius = "5px";
        canvas.style.backgroundColor = "white";

        /*==========================================================================
         * usado para ajustar as margens de toque do ponteiro do mouse
         *==========================================================================
         * OBS: quando o canvas não ocupa as dimenssões totais do window, as margens
         * precisam obrigatoriamente ser descontadas das distancias x e y dos toques
         * do mouse e touch pois os mesmos se baseiam em um plano cartesiano que
         * corresponde as totalidades do objeto window
         *      X - marginLeft
         *      Y - marginTop
         *========================================================================*/
        marginTop = parseInt(canvas.style.top);
        marginLeft = parseInt(canvas.style.left);

        //escolhe a letra
        escolheLetra();
    }

    function iniciar(x, y) {
        //ajuste no grafico (x,y)
        x = x - marginLeft;
        y = y - marginTop;

        mousedown = true;
        ctx.beginPath();
        ctx.moveTo(x, y);
    }

    function pintar(x, y) {
        //ajuste no grafico (x,y)
        x = x - marginLeft;
        y = y - marginTop;

        if (mousedown) {
            var colour = obterACorDoPixel(x, y);
            console.log(colour.r +" "+ colour.g +" "+ colour.b +" "+ colour.a);
            if (colour.a === 0) {
                mousedown = false;
                var erro = new Fase2_riscandoFora(jogo);
                erro.renderizar();
            }
            else {
                ctx.lineTo(x, y);
                ctx.stroke();
            }
        }
    }

    function parar() {
        mousedown = false;
        ctx.closePath();
        verificaSeVenceu();
    }

    /*AÇÕES DO JOGO*/

    this.executar = function () {
        executar();
    };

    /*==========================================================================
     * EVENTOS MOUSE E TOUCH
     *========================================================================*/

    function onmousedown(ev) {
        iniciar(ev.clientX, ev.clientY);
        ev.preventDefault();
    }
    function onmouseup(ev) {
        parar();
        ev.preventDefault();
    }
    function onmousemove(ev) {
        pintar(ev.clientX, ev.clientY);
    }
    canvas.addEventListener('mousedown', onmousedown, false);
    canvas.addEventListener('mouseup', onmouseup, false);
    canvas.addEventListener('mousemove', onmousemove, false);

    //quando o dedo toca a tela
    function touchStart(evt) {
        iniciar(evt.targetTouches[0].pageX, evt.targetTouches[0].pageY);
        evt.preventDefault();
    }
    //quando o dedo se move na tela
    function touchMove(evt) {
        pintar(evt.targetTouches[0].pageX, evt.targetTouches[0].pageY);
    }
    //quando o dedo desencosta da tela
    function touchEnd(evt) {
        parar();
        evt.preventDefault();
    }
    //adiciona eventos touch
    canvas.addEventListener("touchstart", touchStart, false);
    canvas.addEventListener("touchend", touchEnd, false);
    canvas.addEventListener("touchleave", touchEnd, false);
    canvas.addEventListener("touchmove", touchMove, false);
}

function EscreverMaoLivre(canvas, painelLetraAtual, efeitos, jogo) {

    //obter o contexto
    var ctx = canvas.getContext("2d");
    //margens do canvas
    var marginTop;
    var marginLeft;
    //letras da fase
    var letras = [
        ["a", 0],
        ["e", 1],
        ["i", 2],
        ["o", 3],
        ["u", 4]
    ];
    //letra da jogada
    var letraAtual = null;
    //status da ação de desenhar no canvas
    var mousedown = false;

    //escolhe a letra da jogada
    function escolheLetra() {
        //se ele não estiver jogando passa para uma nova letra
        if (letraAtual === null) {
            if (letras.length !== 0) {
                limparCanvas();

                //gera um indice para a letra
                var indiceAleatorio = Math.floor(Math.random() * (letras.length - 1));

                //armazena a letra atual
                letraAtual = letras[indiceAleatorio];

                //remove a posição do vetor
                letras.splice(indiceAleatorio, 1);
                
                //pinta a letra atual
                painelLetraAtual.renderizar(letraAtual[0].toUpperCase(), 2, 30, 15, 25);

                //reproduz o som correspondente a letra
                jogo.sons["fase3_letra_" + letraAtual[0]].play();

                //printa no console a letra atual
                console.log("LetraSolicitada = " + letraAtual[0].toUpperCase());
            }
        }
        else {
            //limpa o canvas
            limparCanvas();
        }
    }
    
    this.getLetraAtual = function (){
        return letraAtual[0].toUpperCase();
    };

    function limparCanvas() {
        //limpa o canvas
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        ctx.fillStyle = "white";
        ctx.fillRect(0, 0, canvas.width, canvas.height);
    }

    function verificaSeVenceu() {

        var dadosRNA = new DadosRNA();

        
        console.log("===========(Coleta de dados ("+letraAtual[0].toUpperCase()+"))============");
        var pic = new PIC(canvas);
        var baseDeTeste = pic.getMatriz();
        imprimeMatriz(baseDeTeste);
        
        
        console.log("==============(Teste)==============");
        var rnaTeste = new TestePeceptronLetras(dadosRNA, letraAtual[1], baseDeTeste);

        //se acertou a letra
        if (rnaTeste.executaTeste() === true) {
            letraAtual = null;

            if (letras.length === 0) {
                jogo.destruirInterface();
                var fase = new Fase3_ganhou(jogo);
                jogo.setInterface(fase);
                jogo.renderizarInterface();
            }
            else {
                jogo.sons["fase3_letra_correta"].play();
                
                window.setTimeout(function () {
                    canvas.style.display = "none";
                    efeitos.Agreccives.FlashBang(canvas);
                    canvas.style.display = "block";
                    executar();
                }, 4 * 1000);
            }
        }
        //se errou a letra
        else {
            jogo.sons["fase3_letra_incorreta"].play();
            
            window.setTimeout(function () {
                canvas.style.display = "none";
                efeitos.Agreccives.FlashBang(canvas);
                canvas.style.display = "block";
                executar();
            }, 4 * 1000);
        }
    }

    //impressao de matrizes
    function imprimeMatriz(matriz) {
        var texto = "[\n";
        for (var linha = 0; linha < matriz.length; linha++) {
            texto += "[";
            for (var coluna = 0; coluna < matriz[0].length; coluna++) {
                if (coluna !== 0) {
                    texto = texto + ",";
                }
                if (matriz[linha][coluna] > 0) {
                    texto = texto + "  " + matriz[linha][coluna];
                }
                else {
                    texto = texto + " " + matriz[linha][coluna];
                }
            }
            texto += "],\n";
        }
        console.log(texto + "]");
    }

    function imprimeVetor(vetor) {
        var texto = "[";
        for (var linha = 0; linha < vetor.length; linha++) {
            if (linha !== 0) {
                texto = texto + ",";
            }
            if (vetor[linha] > 0) {
                texto = texto + "  <b>" + vetor[linha] + "</b>";
            }
            else {
                texto = texto + " " + vetor[linha];
            }
        }
        console.log(texto + "]");
    }

    function executar() {

        //estilizar o canvas
        canvas.style.boxShadow = "#cccccc 0 0 5px 5px";
        canvas.style.borderRadius = "5px";

        //estilizar o contexto
        ctx.lineWidth = parseInt((40 * canvas.height) / 513);
        ctx.lineCap = "round";
        ctx.strokeStyle = '#000000';
        ctx.font = 'bold ' + parseInt((640 * canvas.height) / 513) + 'px Helvetica';
        ctx.fillStyle = 'rgb(255, 0, 0)';
        //ctx.textBaseline = 'hanging';
        ctx.textAlign = "center";

        /*=========================================================================
         * usado para ajustar as margens de toque do ponteiro do mouse
         *==========================================================================
         * OBS: quando o canvas não ocupa as dimenssões totais do window, as margens
         * precisam obrigatoriamente ser descontadas das distancias x e y dos toques
         * do mouse e touch pois os mesmos se baseiam em um plano cartesiano que
         * corresponde as totalidades do objeto window
         *      X - marginLeft
         *      Y - marginTop
         *========================================================================*/
        marginTop = parseInt(canvas.style.top);
        marginLeft = parseInt(canvas.style.left);

        //escolhe a letra
        escolheLetra();
    }

    //métodos para a escrita na tela

    function iniciar(x, y) {
        //ajuste no grafico (x,y)
        x = x - marginLeft;
        y = y - marginTop;

        mousedown = true;
        ctx.beginPath();
        ctx.moveTo(x, y);
    }

    function pintar(x, y) {
        //ajuste no grafico (x,y)
        x = x - marginLeft;
        y = y - marginTop;

        if (mousedown) {
            ctx.lineTo(x, y);
            ctx.stroke();
        }
    }

    function parar() {
        mousedown = false;
        ctx.closePath();
    }

    /*AÇÕES DO JOGO*/

    this.executar = function () {
        executar();
    };

    this.verificaSeVenceu = function () {
        verificaSeVenceu();
    };

    /*==========================================================================
     * EVENTOS MOUSE E TOUCH
     *========================================================================*/

    function onmousedown(ev) {
        iniciar(ev.clientX, ev.clientY);
        ev.preventDefault();
    }
    function onmouseup(ev) {
        parar();
        ev.preventDefault();
    }
    function onmousemove(ev) {
        pintar(ev.clientX, ev.clientY);
    }
    canvas.addEventListener('mousedown', onmousedown, false);
    canvas.addEventListener('mouseup', onmouseup, false);
    canvas.addEventListener('mousemove', onmousemove, false);

    //quando o dedo toca a tela
    function touchStart(evt) {
        iniciar(evt.targetTouches[0].pageX, evt.targetTouches[0].pageY);
        evt.preventDefault();
    }
    //quando o dedo se move na tela
    function touchMove(evt) {
        pintar(evt.targetTouches[0].pageX, evt.targetTouches[0].pageY);
    }
    //quando o dedo desencosta da tela
    function touchEnd(evt) {
        parar();
        evt.preventDefault();
    }
    //adiciona eventos touch
    canvas.addEventListener("touchstart", touchStart, false);
    canvas.addEventListener("touchend", touchEnd, false);
    canvas.addEventListener("touchleave", touchEnd, false);
    canvas.addEventListener("touchmove", touchMove, false);
}