/*

    @autor Maik Basso
    @email maik@maikbasso.com.br
    @telefone (55) 9952-9459

================================================================================
 * PIC (Processamento de Imagem em Canvas)
 * =============================================================================
 * Este arquivo é responsável por coletar a imageData do canvas para aplica-lo
 * na RNA em uma dimensão escolhida nas configurações do canvasResize
==============================================================================*/
function PIC(canvas){
    
    //cria os canvas auxiliares do processo
    var canvasRecorte = document.createElement("canvas");
    var canvasResize = document.createElement("canvas");
    
    //tamanho final exigido pelo algoritmo da rede neural
    canvasResize.width = 7;
    canvasResize.height = 9;
    
    //digitos que representam a ocorrencia de cor ou nao
    //[branco, não branco] ou [não ocorrencia, ocorrencia]
    var digito = [-1, 1];
    
    //retorna o array do canvas
    this.getMatriz = function (){
        recortaContexto();
        redimensionaContexto();
        return getMatrizBinaria(canvasResize);
    };
    
    //redimensiona a imagem
    function redimensionaContexto(){
        var ctxResize = canvasResize.getContext("2d");
        //printa imagem
        ctxResize.drawImage(canvasRecorte, 0, 0, canvasResize.width, canvasResize.height);
    }
    
    //obtem as dimensoes e faz recorte do espaço necessário no canvas
    function recortaContexto(){
        
        //inicializa as medias
        var x = 100000000;
        var y = 100000000;
        var w = 0;
        var h = 0;

        //calculo das dimensoes do conteúdo
        var matrizBinaria = getMatrizBinaria(canvas);

        for (var linha = 0; linha < matrizBinaria.length; linha++) {
            for (var coluna = 0; coluna < matrizBinaria[0].length; coluna++) {
                if(matrizBinaria[linha][coluna] === digito[1]){
                    //atualiza a disposição no gráfico
                    if(coluna < x){
                        x = coluna;
                    }
                    if(linha < y){
                        y = linha;
                    }
                    //atualiza o tamanho
                    if(coluna > w){
                        w = coluna;
                    }
                    if(linha > y){
                        h = linha;
                    }
                }
            }
        }

        //ajustando a largura e altura 
        w = w - x;
        h = h - y;
        
        //obtem a data da imagem
        var ctx = canvas.getContext("2d");
        var imagedata = ctx.getImageData(0,0,canvas.width,canvas.height);

        //redimensiona o canvas para o tamanho do recorte
        canvasRecorte.height = h;
        canvasRecorte.width = w;
        
        //reconstroe a imagem em um canvas temporario
        var ctxRecorte = canvasRecorte.getContext("2d");
        
        //translação da imagem
        
        putImageData(ctxRecorte, imagedata, -x, -y, x, y, w, h);
    }
    
    //gera matriz binarizada de um canvas
    function getMatrizBinaria(c){

        //inicialização da matriz
        var matrizBinaria = [c.height];
        for (var linha = 0; linha < c.height; linha++) {
            matrizBinaria[linha] = [c.width];
            for (var coluna = 0; coluna < c.width; coluna++) {
                matrizBinaria[linha][coluna] = digito[0];
            }
        }

        //obten-se o conteúdo do canvas
        var ctx = c.getContext("2d");
        var pixels = ctx.getImageData(0, 0, c.width, c.height);

        //analize de cores e binarização da matriz
        var linha = 0;
        var coluna = 0;
        for (var i = 0; i < pixels.data.length; i += 4) {
            if ((pixels.data[i] === 0) &&
                (pixels.data[i + 1] === 0) &&
                (pixels.data[i + 2] === 0) &&
                (pixels.data[i + 3] === 255)) {
                matrizBinaria[linha][coluna] = digito[1];
            }
            coluna++;
            if (coluna === c.width) {
                linha++;
                coluna = 0;
            }
        }

        return matrizBinaria;
    }
    
    //adicionada novos recursos a função putImageData
    function putImageData(ctx, imageData, dx, dy, dirtyX, dirtyY, dirtyWidth, dirtyHeight) {
        var data = imageData.data;
        var height = imageData.height;
        var width = imageData.width;
        dirtyX = dirtyX || 0;
        dirtyY = dirtyY || 0;
        dirtyWidth = dirtyWidth !== undefined ? dirtyWidth : width;
        dirtyHeight = dirtyHeight !== undefined ? dirtyHeight : height;
        var limitBottom = dirtyY + dirtyHeight;
        var limitRight = dirtyX + dirtyWidth;
        for (var y = dirtyY; y < limitBottom; y++) {
            for (var x = dirtyX; x < limitRight; x++) {
                var pos = y * width + x;
                ctx.fillStyle = 'rgba(' + data[pos * 4 + 0]
                        + ',' + data[pos * 4 + 1]
                        + ',' + data[pos * 4 + 2]
                        + ',' + (data[pos * 4 + 3] / 255) + ')';
                ctx.fillRect(x + dx, y + dy, 1, 1);
            }
        }
    }
}