jQuery(function(){
	$('#submit_calculo').click(function(){
		var comprimento = $('#comprimento_calculo'),
			largura = $('#largura_calculo'),
			altura = $('#altura_calculo'),
			er_valor = /[0-9]\.[0-9]/,
			total = 0;
            
        // valida os campos e os prepara para realizar os calculos
        if(er_valor.test(comprimento.val())){
        	comprimento.css('border','1px solid #DFDFDF');
        }else{
        	comprimento.css('border','1px solid red');
        	comprimento.focus();
        	return false;    
        }

        if(er_valor.test(largura.val())){
        	largura.css('border','1px solid #DFDFDF');
        }else{
        	largura.css('border','1px solid red');
        	largura.focus();
        	return false;    
        }

        if(er_valor.test(altura.val())){
        	altura.css('border','1px solid #DFDFDF');
        }else{
        	altura.css('border','1px solid red');
        	altura.focus();
        	return false;    
        }

        // converte os valores para ponto flutuante
		comprimento = parseFloat(comprimento.val());
		largura = parseFloat(largura.val());
		altura = parseFloat(altura.val());

		// realiza o calculo
		total = (comprimento * largura * altura)/1000;

		$('#recebe_calculo').html('<strong>Resultado: </strong> '+total+' litros.');

		return false;
	});

	$('#reset_calculo').click(function(){
		var comprimento = $('#comprimento_calculo'),
			largura = $('#largura_calculo'),
			altura = $('#altura_calculo');

		comprimento.val('').focus();
		largura.val('');
		altura.val('');
	});
});