$("#vw_rep_crt_2").live("pageshow", function() {
    try {
        mapa = new google.maps.Map(document.getElementById("rep_crt_2_mapa"), {
            zoom: 16,
            center: centro,
            mapTypeId: google.maps.MapTypeId.ROADMAP,
            mapTypeControl: false,
            disableDefaultUI: true
        });
        marcador = new google.maps.Marker({
            position: centro,
            map: mapa,
            draggable: true,
            title: 'Ubicación del Reporte'
        });
    } catch (e) {
        fn_log('Error creando mapa: ' + e);
    }

    $('#rep_crt_urgente').val('0').change();

    if (fb_status_check() == true) {
        $('#vw_rep_crt_2_fb_flip').val('on').change();
    } else {
        $('#vw_rep_crt_2_fb_flip').val('off').change();
    }
    if (tw_status_check() == true) {
        $('#vw_rep_crt_2_tw_flip').val('on').change();
    } else {
        $('#vw_rep_crt_2_tw_flip').val('off').change();
    }

    $('#rep_crt_2_mapa_center').click(function() {
        try {
            marcador.setPosition(centro);
            mapa.setCenter(centro);
            control_centrar = true;
        } catch (e) {
            fn_log('Error centrando mapa: ' + e);
        }
    });

    google.maps.event.addListener(marcador, 'drag', function() {
        //navigator.geolocation.clearWatch(geoid);
        //console.log('se movio');
        control_centrar = false;
    });

    if (foto != null) {
        console.log('foto = ' + foto);
        $('#rep_crt_2_foto').css('background-image', 'url(' + foto + ')');
        //$('#rep_crt_2_foto').css('background-size', 'contain');
        $('#rep_crt_2_foto').css('background-size', 'cover');
        //background-image: url(../images/no-photo.png);
    } else {
        $('#rep_crt_2_foto').css('background-image', 'url(images/no-photo.png)');
        $('#rep_crt_2_foto').css('background-size', 'cover');
    }

    if (fn_get_dato('usuario') == null) {
        $('#cnt_rep_crt_2_redessociales').hide();
    } else {
        $('#cnt_rep_crt_2_redessociales').show();
    }
});
$("#rep_crt_urgente").on('slidestop', function(event) {
    if (($('#rep_crt_urgente').val() == '1')) {
        navigator.notification.confirm('Utiliza esta opción si el reporte del niño o niña tiene que ver con:\n\n1. Trata\n2. Explotación sexual\n3. Maltrato\n4. Cualquier circunstancia que ponga en riesgo su vida.\n\nDesea continuar?', function(boton) {
            if (boton == '2') {
                $('#rep_crt_urgente').val('0').change();
            }
        }, 'Pregunta', 'Si, No');
    }
});

$("#rep_crt_local").on('slidestop', function(event) {
    if (($('#rep_crt_local').val() == '1')) {
        navigator.notification.alert('Por favor escriba el nombre del establecimiento', function() {
        }, 'Aviso', 'Aceptar');
        $('#rep_crt_establecimiento').textinput('enable');
    } else {
        $('#rep_crt_establecimiento').textinput('disable');
    }
});

$("#vw_rep_crt_2_fb_flip").on('slidestop', function(event) {
    if (($('#vw_rep_crt_2_fb_flip').val() == 'on') && (!fb_status_check())) {
        fb_conectar();
    }
});
$("#vw_rep_crt_2_tw_flip").on('slidestop', function(event) {
    if (($('#vw_rep_crt_2_tw_flip').val() == 'on') && (!tw_status_check())) {
        tw_conectar();
    }
});

$('#btn_rep_crt_reportar').click(function() {
    console.log("Intentando el envio de foto");
    var coordenada = false;
    var posicion;
    try {
        posicion = (((((marcador.getPosition()).toString()).replace('(', '')).replace(')', '')).replace(' ', '')).split(',');
        coordenada = true;
    } catch (e) {
        $.mobile.hidePageLoadingMsg();
    }
    if (coordenada) {
        $.mobile.showPageLoadingMsg("a", "Procesando...", false);

        var datos = $('#frm_rep_crt').serializeArray();
        fn_crear_clave('latitud', posicion[0], datos);
        fn_crear_clave('longitud', posicion[1], datos);
        fn_crear_clave('prueba', '1', datos);
        if ((fn_get_dato('usuario')) != null) {
            fn_crear_clave('usuario', fn_get_dato('usuario')['id'], datos);
        } else {
            fn_crear_clave('usuario', '1', datos);
        }
        $.ajax({
            url: WS_REP_CRT,
            type: 'GET',
            dataType: 'jsonp',
            async: false,
            data: datos,
            success: function(data) {                
                if ((data.op == true) && (data.cont > 0)) {                   
                    id_reporte = data.res.id;                    
                    fn_compartir_redes_sociales();                    
                    if (localdb.getItem("imgblob").length > 1) {  
                        //console.log("Preparando envio imagen para el reporte " + id_reporte);
                        fn_enviar_cadena_imagen('rep' + id_reporte + '.jpg');                        
                    } else {
                        if ((fn_get_dato('usuario')) != null) {
                            fn_actualizar_datos_reportes(fn_get_dato('usuario')['id']);
                        }
                        fn_check_badget_vigia();
                        document.getElementById('frm_rep_crt').reset();
                        $("#rep_crt_colapsible").trigger("collapse");
                        id_reporte = '';
                        //Cuando el reporte es creado sin foto, luego de enviarse,
                        //se cambia a la vista de agradecimiento.
                        $.mobile.hidePageLoadingMsg();
                        $.mobile.changePage("#vw_rep_crt_3");
                    }
                } else {
                    navigator.notification.alert('Reporte no pudo ser creado\n\nError: ' + data.msg_error, function() {
                    }, 'Error ' + data.num_error, 'Aceptar');
                    $.mobile.hidePageLoadingMsg();
                }
            },
            error: function() {
                $.mobile.hidePageLoadingMsg();
                navigator.notification.alert('La operación no pudo ser completada', '', 'Error', 'Aceptar');
            }
        });
    } else {
        navigator.notification.alert('Aún no se ha obtenido la ubicación', '', 'Error', 'Aceptar');
    }
});