var localdb = window.localStorage;

function fn_tomar_foto_v2() {
    navigator.notification.confirm('Seleccionar origen', function(boton) {
        var foto_opciones = {
            quality: 80,
            targetWidth: 1024,
            targetHeight: 768,
            destinationType: Camera.DestinationType.NATIVE_URI,
            //destinationType: Camera.DestinationType.DATA_URL,
            //destinationType: Camera.DestinationType.FILE_URI,
            //sourceType: Camera.PictureSourceType.SAVEDPHOTOALBUM,
            sourceType: Camera.PictureSourceType.CAMERA,
            //encodingType: Camera.EncodingType.JPEG,
            encodingType: Camera.EncodingType.PNG,
            saveToPhotoAlbum: true
        };
        if (boton == '2') {
            foto_opciones.sourceType = Camera.PictureSourceType.SAVEDPHOTOALBUM;
        }

        if ((boton == '1') || (boton == '2')) {
            try {
                navigator.camera.getPicture(fn_camera_success, fn_foto_error, foto_opciones);
            } catch (error) {
                fn_foto_error();
            }
        }
    }, 'Obtener foto de:', 'Cámara, Galería');
}

function fn_tomar_foto_v3_ffos() {
    var imgblob = null;
    var xblob = null;
    var reader = new FileReader();
    //alert("intentando obtener la foto");
    var pick = new MozActivity({
                name: "pick",
                data: {
                        type: ["image/png", "image/jpg", "image/jpeg"]
                      }
    });

    pick.onsuccess = function () { 
        console.log(JSON.stringify(this.result));
        var imgx = this.result.blob;    
        localdb.setItem("imgtype", this.result.type);
        // Create image and set the returned blob as the src
        jQuery("#rep_crt_2_foto").html("");
        var img = document.createElement("img");
        imgblob = window.URL.createObjectURL(imgx);         
        img.src = imgblob;         
        img.width = 100;       
            
        var reader = new FileReader();
        reader.onload = function(event){
            var strblob = event.target.result;
            localdb.setItem("imgblob", strblob);
            $('#rep_crt_2_foto').css("background-image", "url('" + strblob + "')" );       
            $('#rep_crt_2_foto').css('background-size', 'cover');
            //envia_img(strblob);
        };
        reader.readAsDataURL(imgx);
        
        //var imagePresenter = document.querySelector("#rep_crt_2_foto");
        //imagePresenter.appendChild(img);
        //envia_img();
        $.mobile.changePage("#vw_rep_crt_2");       
    };
 
    pick.onerror = function () { 
        // If an error occurred or the user canceled the activity
        alert("No es posible cargar imagenes!");
    };
    
//    function envia_img(stringblob) {
//        alert("Enviando");
//        $.ajax({
//            url: "http://afvpolar.redsalvavidas.org/pruebablob/index.php",
//            type: 'POST',
//            data: {datoblob: stringblob},
//            success: function(data) {
//                alert(data);
//            },
//            error: function(xhr, ajaxOptions, thrownError) {
//                alert("Error en peticion: " + xhr.statusText + " : " + xhr.responseText + " -> " + thrownError.toString());
//            }
//        });
//    }
}

function fn_camera_success(respuesta) {
    window.resolveLocalFileSystemURI(respuesta, fn_resolve_success, fn_foto_error);
}

function fn_file_upload_success(respuesta) {
    foto = '';
    document.getElementById('frm_rep_crt').reset();
    $("#rep_crt_colapsible").trigger("collapse");
    //Se debe parsear el resultado para poder usarlo como json
    //var resultado = JSON.parse(respuesta.response);
    //console.log(JSON.stringify(respuesta.res));
    resultado = respuesta.res;
    $.ajax({
        url: WS_REP_MOD,
        type: 'get',
        dataType: 'json',
        data: {
            id: id_reporte,
            ruta_imagen: resultado.nombre_completo,
            ruta_miniatura: resultado.nombre_completo
        },
        success: function(data) {
            //Cuando se termina el envío de la foto, se cambia a la vista de agradecimiento.
            if ((fn_get_dato('usuario')) != null) {
                fn_actualizar_datos_reportes(fn_get_dato('usuario')['id']);
            }
            fn_check_badget_vigia();
            id_reporte = '';
            $.mobile.hidePageLoadingMsg();
            $.mobile.changePage("#vw_rep_crt_3");
        },
        error: function() {
            $.mobile.hidePageLoadingMsg();
            $.mobile.changePage("#vw_rep_crt_3");
        }
    });
}

function fn_file_upload_fail(respuesta) {
    $.mobile.changePage("#vw_rep_crt_4");
}

function fn_json_to_string(objeto) {
    return JSON.stringify(objeto);
}

function fn_resolve_success(respuesta) {
    foto = respuesta.fullPath;
    $.mobile.changePage("#vw_rep_crt_2");
}

function fn_enviar_cadena_imagen(nombreimg){
    //console.log("Enviando string con foto");
    $.ajax({
        url: WS_FILE_UPLOAD,
        type: 'POST',
        dataType: 'json',
        data: { nombre: nombreimg, foto: localdb.getItem("imgblob") },
        success: function(resp) {                       
                        fn_file_upload_success(resp);
                        localdb.removeItem("imgblob");  
                        localdb.removeItem("imgtype");
                 },
        error:   function(xhr, ajaxOptions, thrownError) {
                    alert("Error en peticion al enviar foto: " + xhr.statusText + " : " + xhr.responseText + " -> " + thrownError.toString());
                 }
    });
}