var foto = '';
var foto_file_name;
var foto_callback;
var Camera = navigator.camera;
var short_msg_length = 30;

function fn_usr_login() {
    //fn_log('fn_usr_login');
    $.mobile.showPageLoadingMsg("a", "Procesando...", false);
    usuario = fn_get_dato('usuario');

    var datos = {
        login: usuario.username,
        password: usuario.password
    };
    $.ajax({
        url: WS_USR_LOGIN,
        type: 'get',
        dataType: 'jsonp',
        async: false,
        data: datos,
        success: function(data) {
            $.mobile.hidePageLoadingMsg();
            if (data.op == true) {
                if (data.cont > 0) {
                    if (data.password == true) {
                        fn_set_dato('usuario', data.res);
                        $('#cnt_dsh_brd_nombre').text(fn_get_dato('usuario')['nombres']);
                        $.mobile.changePage("#vw_dsh_brd");
                        fn_actualizar_datos_reportes(fn_get_dato('usuario')['id']);
                    } else {
                        navigator.notification.alert('Contraseña incorrecta', function() {
                            localStorage.clear();
                            $.mobile.changePage("#vw_usr_login");
                        }, 'Error', 'Aceptar');
                    }
                } else {
                    navigator.notification.alert('Usuario no existe', function() {
                        localStorage.clear();
                        $.mobile.changePage("#vw_usr_crt");
                    }, 'Error', 'Aceptar');
                }
            } else {
                navigator.notification.alert('Usuario no pudo ser validado\n\nError: ' + data.msg_error, function() {
                    localStorage.clear();
                }, 'Error ' + data.num_error, 'Aceptar');
            }
        },
        complete: function() {
            $.mobile.hidePageLoadingMsg();
        }
    });
}
function fn_compartir_redes_sociales() {
    //fn_log('fn_compartir_redes_sociales');
    if ($('#vw_rep_crt_2_tw_flip').val() == 'on') {
        fn_tw_publicar_reporte();
    }
    if ($('#vw_rep_crt_2_fb_flip').val() == 'on') {
        fn_fb_publicar_reporte();
    }
}
function fn_tomar_foto(callback) {
    if (typeof callback != 'function') {
        callback = foto_success;
    }
    var foto_opciones = {
        quality: 80,
        targetWidth: 1024,
        targetHeight: 768,
        destinationType: Camera.DestinationType.FILE_URI,
        sourceType: Camera.PictureSourceType.CAMERA,
        encodingType: Camera.EncodingType.PNG,
        mediaType: Camera.MediaType.PICTURE,
        saveToPhotoAlbum: true
    };
    navigator.notification.confirm('Seleccionar origen', function(boton) {
        if (boton == '2') {
            foto_opciones.sourceType = Camera.PictureSourceType.SAVEDPHOTOALBUM;
        }

        if ((boton == '1') || (boton == '2')) {
            try {
                navigator.camera.getPicture(
                        function(imageURI) {
                            window.resolveLocalFileSystemURI(imageURI, function(fileEntry) {
                                fileEntry.file(function(fileObj) {
                                    callback(imageURI);
                                });
                            });
                        }
                , fn_foto_error, foto_opciones);
            } catch (error) {
                fn_foto_error();
            }
        }
    }, 'Obtener foto de:', 'Cámara, Galería');
}

function foto_success(imageURI) {
    //    fn_log('funcion onPhotoURISuccess');
    foto = imageURI;
    //fn_log('datos:::' + imageURI + ':::::');
    //fn_log('funcion onPhotoURISuccess');
    $.mobile.changePage("#vw_rep_crt_2");
}
function fn_subir_foto(id, tipo_foto, callback) {
    //fn_log('fn_subir_foto');
    foto_callback = callback;
    foto_file_name = (tipo_foto == 'u') ? 'usr' : 'rep';
    foto_file_name += id + '.png';
    if (foto != null) {
        window.plugins.fileUploader.uploadByUri(WS_FILE_UPLOAD, foto, {}, {}, foto_file_name, 'image/png', fn_file_upload_success, fn_file_upload_fail);
    } else {
        //fn_log('Var foto is null');
        callback(
                {
                    op: false,
                    cont: 0,
                    msg_error: 'No se seleccionó foto.',
                    num_error: 1
                });
    }
}

function fn_file_upload_success(data) {
    //fn_log('fn_file_upload_success');
    fn_log(JSON.stringify(data));
    if (data.status == 'PROGRESS') {
        var porcentaje = parseInt((parseFloat(data.progress) / parseFloat(data.total) * 100) * 100) / 100;
        //fn_log('Porcentaje: %' + porcentaje);
        $.mobile.hidePageLoadingMsg();
        $.mobile.showPageLoadingMsg("a", "Enviando foto... Completado: " + porcentaje + '%', false);
    } else if (data.status == 'COMPLETE') {
        $.mobile.hidePageLoadingMsg();
        //fn_log('data.result');
        //fn_log(JSON.stringify(data.result));
        var result = JSON.parse(data.result);
        if (result.op == true) {
            //fn_log(result.res.ruta_imagen);
            //fn_log(result.res.ruta_miniatura);
            //fn_log('Foto enviada.');
            foto = null;
            foto_file_name = null;
            if (typeof foto_callback === 'function') {
                foto_callback(result);
            }
        } else {
            //fn_log('else data');
            //fn_log(JSON.stringify(data));
            fn_retry_upload('Error al completar envío.');
            if (typeof foto_callback === 'function') {
                foto_callback(
                        {
                            op: false,
                            cont: 0,
                            msg_error: 'Error al completar envío.',
                            num_error: 0
                        });
            }
        }
    }
}
function fn_retry_upload(msg) {
    navigator.notification.confirm(msg, function(boton) {
        //fn_log(JSON.stringify(boton));
        if (boton == '1') {
            window.plugins.fileUploader.uploadByUri(WS_FILE_UPLOAD, foto, {}, 'foto', foto_file_name, 'image/png', fn_file_upload_success, fn_file_upload_fail);
        } else {
            foto = null;
            foto_file_name = null;
        }
    }, 'Reintentar?', 'Sí, Cancelar');
}
function fn_file_upload_fail(msg) {
    fn_log('fn_file_upload_fail');
    $.mobile.hidePageLoadingMsg();
//fn_log('Error no se pudo enviar foto al servidor: '+msg);
//fn_retry_upload('Error al enviar la foto.');
}
function fn_log(texto) {
    console.log(texto);
}
function fn_irA(vista) {
    $.mobile.changePage("#" + vista);
}
jQuery.validator.addMethod("notEqual", function(value, element, param) {
    return this.optional(element) || value != $(param).val();
}, "Debe ser diferente...");
function registrarUsuario(usr) {
    usuario = usr;
    registrarDato('usuario', usr);
}
function getUsuario() {
    return getDato('usuario');
}
function getDato(clave) {
    var valor;
    if (typeof(localStorage) == 'undefined') {
        //fn_log('Your browser does not support HTML5 localStorage. Try upgrading.');
    } else {
        try {
            valor = localStorage.getItem(clave);
            valor = JSON.parse(valor);
        } catch (e) {
            //fn_log('Excepción:\n');
            //fn_log(JSON.stringify(e));
            return null;
        }
    }
    return valor;
}
function registrarDato(clave, valor) {
    if (typeof(localStorage) == 'undefined') {
        //fn_log('Your browser does not support HTML5 localStorage. Try upgrading.');
    } else {
        localStorage.removeItem(clave); //deletes the matching item from the database
        try {
            localStorage.setItem(clave, JSON.stringify(valor));
        } catch (e) {
            if (e == QUOTA_EXCEEDED_ERR) {
                //fn_log('Quota exceeded!'); //data wasn't successfully saved due to quota exceed so throw an error
            }
        }
    }
}

function fn_mensaje_ver(id, mas) {
    fn_log('fn_mensaje_ver');
    var mensajes = fn_get_dato('mensajes');
    var btn_html = '';
    var mensaje = null;
    var cuerpo;
    for (var i = 0; i < mensajes.length; i++) {
        if (mensajes[i].id == id) {
            mensaje = mensajes[i];
        }
    }
    if (mensaje == null) {
        return;
    }
    btn_html = '<a class="btn_ver_msn" data-icon="' + ((!mas == true) ? 'plus' : 'minus') + '" data-iconpos="right" data-mini="true"' +
            'data-role="button" data-theme="e" id="btn_ver_msn_' + mensaje.id + '">Ver ' + ((!mas == true) ? 'más' : 'menos') + '</a>';
    cuerpo = (mas == true) ? mensaje.cuerpo : mensaje.cuerpo.substr(0, short_msg_length) + '...';
    $('#msg_cuerpo' + mensaje.id).text(cuerpo);
    $('#ver_msn_btn_div_' + id).html(btn_html).trigger('create');
    $('#btn_ver_msn_' + id).off('click');
    $('#btn_ver_msn_' + id).click(
            function() {
                fn_mensaje_ver(id, !mas);
            });
}
function fn_listar_mensajes(contenedor) {
    var mensajes = fn_get_dato('mensajes');
    if (mensajes == null) {
        $('#' + contenedor).empty();
        return;
    }
    var mensajes_con_formato = '';
    var cuerpo_preview = '';
    for (var i = 0; i < mensajes.length; i++) {

        cuerpo_preview = mensajes[i].cuerpo;
        mensajes_con_formato +=
                '<div><table class="wid_100 cont_blanco rad_5px pad_5px"><tr><td class="wid_100">' +
                '<div class="tit_cont_msn">' + mensajes[i].titulo + '</div>';
        if (cuerpo_preview.length > short_msg_length) {
            cuerpo_preview = cuerpo_preview.substr(0, short_msg_length) + '...';
            mensajes_con_formato += '<div id="msg_cuerpo' + mensajes[i].id + '" class="desc_cont">' + cuerpo_preview + '</div><div class="">';
            //mensajes_con_formato += '<a class="btn_ver_msn" data-icon="plus" data-iconpos="right" data-mini="true"' +
            //'data-role="button" data-theme="e" id="btn_ver_msn_' + mensajes[i].id + '">Ver más</a>';
            mensajes_con_formato += '<div class="ver_msn_btn_div" id="ver_msn_btn_div_' + mensajes[i].id + '" ><a class="btn_ver_msn" data-icon="plus" data-iconpos="right" data-mini="true"' +
                    'data-role="button" data-theme="e" id="btn_ver_msn_' + mensajes[i].id + '">Ver más</a></div>';
        } else {
            mensajes_con_formato += '<div id="msg_cuerpo' + mensajes[i].id + '" class="desc_cont">' + cuerpo_preview + '</div><div class="">';
        }
        mensajes_con_formato += '</div></td></tr></table></div><br>';
    }
    $('#' + contenedor).empty();
    $('#' + contenedor).html(mensajes_con_formato);
    $('#' + contenedor).trigger("create");
    $.mobile.hidePageLoadingMsg();
    $('.btn_ver_msn').click(
            function() {
                var id = $(this).attr('id');
                id = id.split('_')[3];
                fn_mensaje_ver(id, true);
            }
    );

}

function fn_actualizar_datos_mensajes() {
    $('#usr_msn_contenedor').empty();
    //fn_log('fn_actualizar_datos_mensajes');
    $.mobile.showPageLoadingMsg("a", "Procesando...", false);
    $.ajax({
        url: WS_MSG_CONS,
        type: 'get',
        dataType: 'jsonp',
        async: false,
        data: {},
        success: function(data) {
            //            fn_log(JSON.stringify(data));
            if ((data.op == true) && (data.cont > 0)) {
                //fn_log('mensajes recibidos');
                fn_set_dato('mensajes', data.res);
                fn_listar_mensajes('usr_msn_contenedor');
            } else {
                fn_set_dato('mensajes', '');
                //fn_log('mensajes: no hay datos para escribir');
            }
        },
        error: function() {
            fn_set_dato('mensajes', '');
            fn_log('mensajes error');
        },
        complete: function() {
            $.mobile.hidePageLoadingMsg();
        }
    });
}
function fn_check_connection() {
    var networkState = navigator.connection.type;
    estado_conexion = (networkState != Connection.UNKNOWN) && (networkState != Connection.NONE);
}

