function fn_seleccionar_foto(callback) {
    fn_obtener_foto(false, callback);
}
function fn_tomar_foto(callback) {
    fn_obtener_foto(true, callback);
}
function fn_obtener_foto(camara, callback) {
    var foto_opciones = {
        quality: 50,
        destinationType: Camera.DestinationType.FILE_URI,
        sourceType: Camera.PictureSourceType.SAVEDPHOTOALBUM,
        //sourceType: Camera.PictureSourceType.CAMERA,
        encodingType: Camera.EncodingType.JPEG,
        mediaType: Camera.MediaType.PICTURE,
        correctOrientation: false,
        //saveToPhotoAlbum: true
    };
    if (camara == true) {
        //foto_opciones.sourceType = Camera.PictureSourceType.SAVEDPHOTOALBUM;
        foto_opciones.sourceType = Camera.PictureSourceType.CAMERA;
        foto_opciones.saveToPhotoAlbum = true;
    }
    try {
        navigator.camera.getPicture(
                function(imageURI) {
                    fn_log('Fn_obtener_foto');
                    window.resolveLocalFileSystemURI(imageURI, function(fileEntry) {
                        fileEntry.file(function(fileObj) {
                            fn_log('fileObj');
                            fn_log(JSON.stringify(fileObj));
                            //if (typeof callback == 'function') {
                            //callback(fileObj.fullPath);
                            //}
                        });
                    });

                    if (typeof callback == 'function') {
                        fn_log('imageURI');
                        fn_log(imageURI);
                        callback(imageURI);
                    }
                }
        , fn_foto_error, foto_opciones);
    } catch (error) {
        fn_foto_error(error);
    }
}
function fn_foto_error(e) {
    fn_log(e);
}
function fn_subir_foto(nombre, imageURI, callback, params) {
    fn_log("fn_subir_foto");
    fn_log(imageURI.substr(imageURI.lastIndexOf('/') + 1));
    fn_subir_foto_callback = callback;
    var options = new FileUploadOptions();
    options.fileKey = "foto";
    options.fileName = nombre ? nombre : imageURI.substr(imageURI.lastIndexOf('/') + 1);
    options.mimeType = "image/jpeg";

    if (params)
        options.params = params;

    var ft = new FileTransfer();

    ft.onprogress = function(progressEvent) {
        fn_log("progressEvent");
        fn_log(JSON.stringify(progressEvent));
        if (progressEvent.lengthComputable) {
            var porcentaje = 100 * progressEvent.loaded / progressEvent.total;
            porcentaje = parseInt(porcentaje);
            $.mobile.showPageLoadingMsg("a", "Subiendo foto " + porcentaje + "...", false);
        }
    };
    ft.upload(imageURI, encodeURI(WS_FILE_UPLOAD), fn_subir_foto_success, fn_subir_foto_fail, options, true);
}

function fn_subir_foto_success(r) {
    fn_log("fn_subir_foto_success");
    if ((r.responseCode == 200) && (typeof fn_subir_foto_callback == 'function')) {
        fn_subir_foto_callback(JSON.parse(r.response));
        fn_subir_foto_callback = null;
    }
}

function fn_subir_foto_fail(error) {
    JSON.stringify(error);
    $.mobile.hidePageLoadingMsg();
    alert("Error enviando foto.");
}