/*! Hammer.JS - v1.1.3 - 2014-05-20
 * http://eightmedia.github.io/hammer.js
 *
 * Copyright (c) 2014 Jorik Tangelder <j.tangelder@gmail.com>;
 * Licensed under the MIT license */
(function(T,l){var G=function G(al,ak){return new G.Instance(al,ak||{})};G.VERSION="1.1.3";G.defaults={behavior:{userSelect:"none",touchAction:"pan-y",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}};G.DOCUMENT=document;G.HAS_POINTEREVENTS=navigator.pointerEnabled||navigator.msPointerEnabled;G.HAS_TOUCHEVENTS=("ontouchstart" in T);G.IS_MOBILE=/mobile|tablet|ip(ad|hone|od)|android|silk/i.test(navigator.userAgent);G.NO_MOUSEEVENTS=(G.HAS_TOUCHEVENTS&&G.IS_MOBILE)||G.HAS_POINTEREVENTS;G.CALCULATE_INTERVAL=25;var K={};var C=G.DIRECTION_DOWN="down";var y=G.DIRECTION_LEFT="left";var ac=G.DIRECTION_UP="up";var I=G.DIRECTION_RIGHT="right";var aa=G.POINTER_MOUSE="mouse";var c=G.POINTER_TOUCH="touch";var s=G.POINTER_PEN="pen";var r=G.EVENT_START="start";var F=G.EVENT_MOVE="move";var w=G.EVENT_END="end";var k=G.EVENT_RELEASE="release";var N=G.EVENT_TOUCH="touch";G.READY=false;G.plugins=G.plugins||{};G.gestures=G.gestures||{};function f(){if(G.READY){return}P.determineEventTypes();Q.each(G.gestures,function(ak){n.register(ak)});P.onTouch(G.DOCUMENT,F,n.detect);P.onTouch(G.DOCUMENT,w,n.detect);G.READY=true}var Q=G.utils={extend:function j(ak,am,an){for(var al in am){if(!am.hasOwnProperty(al)||(ak[al]!==l&&an)){continue}ak[al]=am[al]}return ak},on:function J(ak,am,al){ak.addEventListener(am,al,false)},off:function U(ak,am,al){ak.removeEventListener(am,al,false)},each:function Y(ao,an,am){var al,ak;if("forEach" in ao){ao.forEach(an,am)}else{if(ao.length!==l){for(al=0,ak=ao.length;al<ak;al++){if(an.call(am,ao[al],al,ao)===false){return}}}else{for(al in ao){if(ao.hasOwnProperty(al)&&an.call(am,ao[al],al,ao)===false){return}}}}},inStr:function S(al,ak){return al.indexOf(ak)>-1},inArray:function ae(ao,an){if(ao.indexOf){var al=ao.indexOf(an);return(al===-1)?false:al}else{for(var am=0,ak=ao.length;am<ak;am++){if(ao[am]===an){return am}}return false}},toArray:function z(ak){return Array.prototype.slice.call(ak,0)},hasParent:function ad(al,ak){while(al){if(al==ak){return true}al=al.parentNode}return false},getCenter:function H(aq){var ao=[],am=[],ap=[],an=[],al=Math.min,ak=Math.max;if(aq.length===1){return{pageX:aq[0].pageX,pageY:aq[0].pageY,clientX:aq[0].clientX,clientY:aq[0].clientY}}Q.each(aq,function(ar){ao.push(ar.pageX);am.push(ar.pageY);ap.push(ar.clientX);an.push(ar.clientY)});return{pageX:(al.apply(Math,ao)+ak.apply(Math,ao))/2,pageY:(al.apply(Math,am)+ak.apply(Math,am))/2,clientX:(al.apply(Math,ap)+ak.apply(Math,ap))/2,clientY:(al.apply(Math,an)+ak.apply(Math,an))/2}},getVelocity:function a(am,al,ak){return{x:Math.abs(al/am)||0,y:Math.abs(ak/am)||0}},getAngle:function p(am,al){var ak=al.clientX-am.clientX,an=al.clientY-am.clientY;return Math.atan2(an,ak)*180/Math.PI},getDirection:function m(am,al){var ak=Math.abs(am.clientX-al.clientX),an=Math.abs(am.clientY-al.clientY);if(ak>=an){return am.clientX-al.clientX>0?y:I}return am.clientY-al.clientY>0?ac:C},getDistance:function o(am,al){var ak=al.clientX-am.clientX,an=al.clientY-am.clientY;return Math.sqrt((ak*ak)+(an*an))},getScale:function E(al,ak){if(al.length>=2&&ak.length>=2){return this.getDistance(ak[0],ak[1])/this.getDistance(al[0],al[1])}return 1},getRotation:function A(al,ak){if(al.length>=2&&ak.length>=2){return this.getAngle(ak[1],ak[0])-this.getAngle(al[1],al[0])}return 0},isVertical:function O(ak){return ak==ac||ak==C},setPrefixedCss:function af(am,aq,ao,ak){var an=["","Webkit","Moz","O","ms"];aq=Q.toCamelCase(aq);for(var al=0;al<an.length;al++){var ap=aq;if(an[al]){ap=an[al]+ap.slice(0,1).toUpperCase()+ap.slice(1)}if(ap in am.style){am.style[ap]=(ak==null||ak)&&ao||"";break}}},toggleBehavior:function R(am,an,al){if(!an||!am||!am.style){return}Q.each(an,function(ao,ap){Q.setPrefixedCss(am,ap,ao,al)});var ak=al&&function(){return false};if(an.userSelect=="none"){am.onselectstart=ak}if(an.userDrag=="none"){am.ondragstart=ak}},toCamelCase:function u(ak){return ak.replace(/[_-]([a-z])/g,function(al){return al[1].toUpperCase()})}};var P=G.event={preventMouseEvents:false,started:false,shouldDetect:false,on:function J(al,an,am,ao){var ak=an.split(" ");Q.each(ak,function(ap){Q.on(al,ap,am);ao&&ao(ap)})},off:function U(al,an,am,ao){var ak=an.split(" ");Q.each(ak,function(ap){Q.off(al,ap,am);ao&&ao(ap)})},onTouch:function M(am,al,an){var ak=this;var ao=function ao(at){var au=at.type.toLowerCase(),ap=G.HAS_POINTEREVENTS,ar=Q.inStr(au,"mouse"),aq;if(ar&&ak.preventMouseEvents){return}else{if(ar&&al==r&&at.button===0){ak.preventMouseEvents=false;ak.shouldDetect=true}else{if(ap&&al==r){ak.shouldDetect=(at.buttons===1||d.matchType(c,at))}else{if(!ar&&al==r){ak.preventMouseEvents=true;ak.shouldDetect=true}}}}if(ap&&al!=w){d.updatePointer(al,at)}if(ak.shouldDetect){aq=ak.doDetect.call(ak,at,al,am,an)}if(aq==w){ak.preventMouseEvents=false;ak.shouldDetect=false;
d.reset()}if(ap&&al==w){d.updatePointer(al,at)}};this.on(am,K[al],ao);return ao},doDetect:function ah(aq,al,ao,at){var ak=this.getTouchList(aq,al);var au=ak.length;var am=al;var an=ak.trigger;var ar=au;if(al==r){an=N}else{if(al==w){an=k;ar=ak.length-((aq.changedTouches)?aq.changedTouches.length:1)}}if(ar>0&&this.started){am=F}this.started=true;var ap=this.collectEventData(ao,am,ak,aq);if(al!=w){at.call(n,ap)}if(an){ap.changedLength=ar;ap.eventType=an;at.call(n,ap);ap.eventType=am;delete ap.changedLength}if(am==w){at.call(n,ap);this.started=false}return am},determineEventTypes:function Z(){var ak;if(G.HAS_POINTEREVENTS){if(T.PointerEvent){ak=["pointerdown","pointermove","pointerup pointercancel lostpointercapture"]}else{ak=["MSPointerDown","MSPointerMove","MSPointerUp MSPointerCancel MSLostPointerCapture"]}}else{if(G.NO_MOUSEEVENTS){ak=["touchstart","touchmove","touchend touchcancel"]}else{ak=["touchstart mousedown","touchmove mousemove","touchend touchcancel mouseup"]}}K[r]=ak[0];K[F]=ak[1];K[w]=ak[2];return K},getTouchList:function v(an,am){if(G.HAS_POINTEREVENTS){return d.getTouchList()}if(an.touches){if(am==F){return an.touches}var ak=[];var ao=[].concat(Q.toArray(an.touches),Q.toArray(an.changedTouches));var al=[];Q.each(ao,function(ap){if(Q.inArray(ak,ap.identifier)===false){al.push(ap)}ak.push(ap.identifier)});return al}an.identifier=1;return[an]},collectEventData:function ai(am,al,ao,an){var ak=c;if(Q.inStr(an.type,"mouse")||d.matchType(aa,an)){ak=aa}else{if(d.matchType(s,an)){ak=s}}return{center:Q.getCenter(ao),timeStamp:Date.now(),target:an.target,touches:ao,eventType:al,pointerType:ak,srcEvent:an,preventDefault:function(){var ap=this.srcEvent;ap.preventManipulation&&ap.preventManipulation();ap.preventDefault&&ap.preventDefault()},stopPropagation:function(){this.srcEvent.stopPropagation()},stopDetect:function(){return n.stopDetect()}}}};var d=G.PointerEvent={pointers:{},getTouchList:function v(){var ak=[];Q.each(this.pointers,function(al){ak.push(al)});return ak},updatePointer:function X(ak,al){if(ak==w||(ak!=w&&al.buttons!==1)){delete this.pointers[al.pointerId]}else{al.identifier=al.pointerId;this.pointers[al.pointerId]=al}},matchType:function W(ak,am){if(!am.pointerType){return false}var an=am.pointerType,al={};al[aa]=(an===(am.MSPOINTER_TYPE_MOUSE||aa));al[c]=(an===(am.MSPOINTER_TYPE_TOUCH||c));al[s]=(an===(am.MSPOINTER_TYPE_PEN||s));return al[ak]},reset:function x(){this.pointers={}}};var n=G.detection={gestures:[],current:null,previous:null,stopped:false,startDetect:function L(al,ak){if(this.current){return}this.stopped=false;this.current={inst:al,startEvent:Q.extend({},ak),lastEvent:false,lastCalcEvent:false,futureCalcEvent:false,lastCalcData:{},name:""};this.detect(ak)},detect:function t(al){if(!this.current||this.stopped){return}al=this.extendEventData(al);var am=this.current.inst,an=am.options;Q.each(this.gestures,function ak(ao){if(!this.stopped&&am.enabled&&an[ao.name]){ao.handler.call(ao,al,am)}},this);if(this.current){this.current.lastEvent=al}if(al.eventType==w){this.stopDetect()}return al},stopDetect:function b(){this.previous=Q.extend({},this.current);this.current=null;this.stopped=true},getCalculatedData:function i(ar,al,aq,ao,an){var at=this.current,ap=false,am=at.lastCalcEvent,ak=at.lastCalcData;if(am&&ar.timeStamp-am.timeStamp>G.CALCULATE_INTERVAL){al=am.center;aq=ar.timeStamp-am.timeStamp;ao=ar.center.clientX-am.center.clientX;an=ar.center.clientY-am.center.clientY;ap=true}if(ar.eventType==N||ar.eventType==k){at.futureCalcEvent=ar}if(!at.lastCalcEvent||ap){ak.velocity=Q.getVelocity(aq,ao,an);ak.angle=Q.getAngle(al,ar.center);ak.direction=Q.getDirection(al,ar.center);at.lastCalcEvent=at.futureCalcEvent||ar;at.futureCalcEvent=ar}ar.velocityX=ak.velocity.x;ar.velocityY=ak.velocity.y;ar.interimAngle=ak.angle;ar.interimDirection=ak.direction},extendEventData:function D(ao){var aq=this.current,ap=aq.startEvent,an=aq.lastEvent||ap;if(ao.eventType==N||ao.eventType==k){ap.touches=[];Q.each(ao.touches,function(ar){ap.touches.push({clientX:ar.clientX,clientY:ar.clientY})})}var am=ao.timeStamp-ap.timeStamp,al=ao.center.clientX-ap.center.clientX,ak=ao.center.clientY-ap.center.clientY;this.getCalculatedData(ao,an.center,am,al,ak);Q.extend(ao,{startEvent:ap,deltaTime:am,deltaX:al,deltaY:ak,distance:Q.getDistance(ap.center,ao.center),angle:Q.getAngle(ap.center,ao.center),direction:Q.getDirection(ap.center,ao.center),scale:Q.getScale(ap.touches,ao.touches),rotation:Q.getRotation(ap.touches,ao.touches)});return ao},register:function g(al){var ak=al.defaults||{};if(ak[al.name]===l){ak[al.name]=true}Q.extend(G.defaults,ak,true);al.index=al.index||1000;this.gestures.push(al);this.gestures.sort(function(an,am){if(an.index<am.index){return -1}if(an.index>am.index){return 1}return 0});return this.gestures}};G.Instance=function(am,al){var ak=this;f();this.element=am;this.enabled=true;Q.each(al,function(ao,an){delete al[an];al[Q.toCamelCase(an)]=ao});this.options=Q.extend(Q.extend({},G.defaults),al||{});
if(this.options.behavior){Q.toggleBehavior(this.element,this.options.behavior,true)}this.eventStartHandler=P.onTouch(am,r,function(an){if(ak.enabled&&an.eventType==r){n.startDetect(ak,an)}else{if(an.eventType==N){n.detect(an)}}});this.eventHandlers=[]};G.Instance.prototype={on:function V(am,al){var ak=this;P.on(ak.element,am,al,function(an){ak.eventHandlers.push({gesture:an,handler:al})});return ak},off:function q(am,al){var ak=this;P.off(ak.element,am,al,function(ao){var an=Q.inArray({gesture:ao,handler:al});if(an!==false){ak.eventHandlers.splice(an,1)}});return ak},trigger:function ab(al,an){if(!an){an={}}var am=G.DOCUMENT.createEvent("Event");am.initEvent(al,true,true);am.gesture=an;var ak=this.element;if(Q.hasParent(an.target,ak)){ak=an.target}ak.dispatchEvent(am);return this},enable:function e(ak){this.enabled=ak;return this},dispose:function B(){var ak,al;Q.toggleBehavior(this.element,this.options.behavior,false);for(ak=-1;(al=this.eventHandlers[++ak]);){Q.off(this.element,al.gesture,al.handler)}this.eventHandlers=[];P.off(this.element,K[r],this.eventStartHandler);return null}};(function(al){var ak=false;function am(aq,ar){var au=n.current;if(ar.options.dragMaxTouches>0&&aq.touches.length>ar.options.dragMaxTouches){return}switch(aq.eventType){case r:ak=false;break;case F:if(aq.distance<ar.options.dragMinDistance&&au.name!=al){return}var an=au.startEvent.center;if(au.name!=al){au.name=al;if(ar.options.dragDistanceCorrection&&aq.distance>0){var ao=Math.abs(ar.options.dragMinDistance/aq.distance);an.pageX+=aq.deltaX*ao;an.pageY+=aq.deltaY*ao;an.clientX+=aq.deltaX*ao;an.clientY+=aq.deltaY*ao;aq=n.extendEventData(aq)}}if(au.lastEvent.dragLockToAxis||(ar.options.dragLockToAxis&&ar.options.dragLockMinDistance<=aq.distance)){aq.dragLockToAxis=true}var ap=au.lastEvent.direction;if(aq.dragLockToAxis&&ap!==aq.direction){if(Q.isVertical(ap)){aq.direction=(aq.deltaY<0)?ac:C}else{aq.direction=(aq.deltaX<0)?y:I}}if(!ak){ar.trigger(al+"start",aq);ak=true}ar.trigger(al,aq);ar.trigger(al+aq.direction,aq);var at=Q.isVertical(aq.direction);if((ar.options.dragBlockVertical&&at)||(ar.options.dragBlockHorizontal&&!at)){aq.preventDefault()}break;case k:if(ak&&aq.changedLength<=ar.options.dragMaxTouches){ar.trigger(al+"end",aq);ak=false}break;case w:ak=false;break}}G.gestures.Drag={name:al,index:50,handler:am,defaults:{dragMinDistance:10,dragDistanceCorrection:true,dragMaxTouches:1,dragBlockHorizontal:false,dragBlockVertical:false,dragLockToAxis:false,dragLockMinDistance:25}}})("drag");G.gestures.Gesture={name:"gesture",index:1337,handler:function ag(ak,al){al.trigger(this.name,ak)}};(function(ak){var am;function al(ao,ap){var an=ap.options,aq=n.current;switch(ao.eventType){case r:clearTimeout(am);aq.name=ak;am=setTimeout(function(){if(aq&&aq.name==ak){ap.trigger(ak,ao)}},an.holdTimeout);break;case F:if(ao.distance>an.holdThreshold){clearTimeout(am)}break;case k:clearTimeout(am);break}}G.gestures.Hold={name:ak,index:10,defaults:{holdTimeout:500,holdThreshold:2},handler:al}})("hold");G.gestures.Release={name:"release",index:Infinity,handler:function ag(ak,al){if(ak.eventType==k){al.trigger(this.name,ak)}}};G.gestures.Swipe={name:"swipe",index:40,defaults:{swipeMinTouches:1,swipeMaxTouches:1,swipeVelocityX:0.6,swipeVelocityY:0.6},handler:function aj(al,am){if(al.eventType==k){var an=al.touches.length,ak=am.options;if(an<ak.swipeMinTouches||an>ak.swipeMaxTouches){return}if(al.velocityX>ak.swipeVelocityX||al.velocityY>ak.swipeVelocityY){am.trigger(this.name,al);am.trigger(this.name+al.direction,al)}}}};(function(am){var al=false;function ak(ar,at){var ap=at.options,au=n.current,aq=n.previous,ao,an;switch(ar.eventType){case r:al=false;break;case F:al=al||(ar.distance>ap.tapMaxDistance);break;case w:if(!Q.inStr(ar.srcEvent.type,"cancel")&&ar.deltaTime<ap.tapMaxTime&&!al){ao=aq&&aq.lastEvent&&ar.timeStamp-aq.lastEvent.timeStamp;an=false;if(aq&&aq.name==am&&(ao&&ao<ap.doubleTapInterval)&&ar.distance<ap.doubleTapDistance){at.trigger("doubletap",ar);an=true}if(!an||ap.tapAlways){au.name=am;at.trigger(au.name,ar)}}break}}G.gestures.Tap={name:am,index:100,handler:ak,defaults:{tapMaxTime:250,tapMaxDistance:10,tapAlways:true,doubleTapDistance:20,doubleTapInterval:300}}})("tap");G.gestures.Touch={name:"touch",index:-Infinity,defaults:{preventDefault:false,preventMouse:false},handler:function h(ak,al){if(al.options.preventMouse&&ak.pointerType==aa){ak.stopDetect();return}if(al.options.preventDefault){ak.preventDefault()}if(ak.eventType==N){al.trigger("touch",ak)}}};(function(al){var ak=false;function am(ao,ap){switch(ao.eventType){case r:ak=false;break;case F:if(ao.touches.length<2){return}var an=Math.abs(1-ao.scale);var aq=Math.abs(ao.rotation);if(an<ap.options.transformMinScale&&aq<ap.options.transformMinRotation){return}n.current.name=al;if(!ak){ap.trigger(al+"start",ao);ak=true}ap.trigger(al,ao);if(aq>ap.options.transformMinRotation){ap.trigger("rotate",ao)}if(an>ap.options.transformMinScale){ap.trigger("pinch",ao);ap.trigger("pinch"+(ao.scale<1?"in":"out"),ao)
}break;case k:if(ak&&ao.changedLength<2){ap.trigger(al+"end",ao);ak=false}break}}G.gestures.Transform={name:al,index:45,defaults:{transformMinScale:0.01,transformMinRotation:1},handler:am}})("transform");if(typeof define=="function"&&define.amd){define(function(){return G})}else{if(typeof module!=="undefined"&&module.exports){module.exports=G}else{T.Hammer=G}}})(window);