/************************** Initialise ********************************/ 
//Host (without trailing slash)
var host = "http://www.askpeople.net/_ask_people_server";
//Current device
var current_device = "N/A";
//Spinner settings on ajax request

/********************************************************************/
//Event listener for Fast click
if ('addEventListener' in document) {
 window.document.addEventListener('DOMContentLoaded', function() {
 FastClick.attach(document.body);
 }, false);
}
//Event listener for deviceready
if ('addEventListener' in document) {
 window.document.addEventListener("deviceready", onDeviceReady, false);
}
//
function onDeviceReady() {

 //Get device info
 current_device = get_device_info()[0];
 device_model = get_device_info()[1];
 device_version = get_device_info()[2];
}
//Handling modal dialogs
function show_modal(modal_id, div_id, message) {
 jQuery("#"+modal_id).modal();
 document.getElementById(div_id).innerHTML(message);
}
//Handling social sharing
function social_share(question_id){
 var url = host + "/single.question.html?question_id=";
 if (window.plugins && window.plugins.socialsharing) {
 window.plugins.socialsharing.share( url + question_id );
}
//No sharing capability on device
 else if (navigator.notification && window.plugins && window.plugins.socialsharing) { 
 app_alert("It appears, that you do not have any social sharing function on your device.",
 "Sharing problem", 
 "Too bad..."
 );
}
//Not a mobile device - share URL in browser on facebook
 else {
 window.open("http://www.facebook.com/sharer.php?[title]=AskPeople.net%20Question&u="+getParameterByName('question_id'),"_blank","location=yes,menubar=yes,resizable=yes,scrollbars=yes,status=yes,titlebar=yes,toolbar=yes");
 }
}
//Handle page transitions
function goto_url(url) {
 if (window.plugins /*&& window.plugins.nativepagetransitions*/ && window.plugins.spinnerDialog) {
 window.plugins.spinnerDialog.show();
/* window.plugins.nativepagetransitions.slide({
 "href" : url
 });*/
 window.location = (url);
 window.plugins.spinnerDialog.hide();
}
//Not a mobile device, so open URL in browser
 else { window.location = (url); }
}
//Get URL parameter from http://stackoverflow.com/questions/901115/how-can-i-get-query-string-values-in-javascript
function getParameterByName(name) {
 name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
 var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
 results = regex.exec(location.search);
 return results === null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
}
//Handling showing of votes
function show_votes(category_id, question_id) {
 var url = '';
 //Check to show single category question or all questions
 if (category_id) preview_list(null,'',category_id);
 else if (question_id) show_single();
 else url = host + "/show.questions.php";
 //
 var request = $.ajax({
 url: url,
 type: "GET",
 global: false,
 cache: false,
 data: {question_id: question_id},
 dataType: "html",
 async: true,
 beforeSend: function(){ show_spinner() }, 
 success: function(){ hide_spinner() }
});
//All set
request.done(function (msg) {$( "#all_votes" ).html( msg );});
//Errors
request.fail( function(jqXHR, textStatus, errorThrown) { throw_error(jqXHR, textStatus, errorThrown); hide_spinner();} );
}
//Handling adding of vote
function add_vote(question_id, vote_type, button_id) {
 //Get UUID of the device 
 var device_uuid = current_device;
 // 
 var request = $.ajax({
 url: host +"/insert.vote.php",
 type: "GET",
 global: false,
 cache: false,
 data: { question_id: question_id, vote_type: vote_type, uuid: device_uuid},
 dataType: "html",
 async:true,
 beforeSend: function(){ show_spinner() },
 success: function(){ hide_spinner() }
});
//All set
request.done(function( msg ) { $( "#message" ).html( msg );if ($("#preview").html()!="") { preview_list(0,'', getParameterByName('category_id'));}
 if (getParameterByName('category_id')>0) show_votes(getParameterByName('category_id'), null);
 else if (getParameterByName('question_id')>0) show_votes(null, getParameterByName('question_id'));
 else show_votes();
});
//Errors
request.fail( function(jqXHR, textStatus, errorThrown) { throw_error(jqXHR, textStatus, errorThrown); hide_spinner(); } );
}
//Handling preview of questions on home page and on category page
function preview_list(rec, keywords, category_id) {
 // 
 var request = $.ajax({
 url: host + "/view.more.questions.php",
 type: "GET",
 global: false,
 cache: false,
 dataType: "html",
 async:true,
 data: {rec: rec, keywords: keywords, category_id: category_id},
 beforeSend: function(){ show_spinner() },
 success: function(){ hide_spinner() }
});
//All set
request.done(function( msg ) { $( "#preview" ).html( msg ); });
//Errors
request.fail(function(jqXHR, textStatus, errorThrown) { throw_error(jqXHR, textStatus, errorThrown); hide_spinner(); } );
}
//Handling showing of statistics
function show_stats() {
//
 var request = $.ajax({
 url: host + "/show.stats.php",
 type: "GET",
 global: false,
 cache: false,
 data: {},
 dataType: "html",
 async: true,
 beforeSend: function(){ show_spinner() },
 success: function(){ hide_spinner() }
 });
//All set
 request.done(function (msg) { $( "#all_stats" ).html( msg ); } );
//Errors
 request.fail( function(jqXHR, textStatus, errorThrown) { throw_error(jqXHR, textStatus, errorThrown); hide_spinner(); } );
}
//Single question AJAX request
function show_single() {
//
 var request = $.ajax({
 url: host + "/show.single.question.php",
 type: "GET",
 global: false,
 cache: false,
 data: {question_id: getParameterByName('question_id')},
 dataType: "html",
 async: true,
 beforeSend: function(){ show_spinner() },
 success: function(){ hide_spinner() }
});
//All set
 request.done(function (msg) {$( "#all_stats" ).html( msg );}
);
//Errors
request.fail( function(jqXHR, textStatus, errorThrown) { throw_error(jqXHR, textStatus, errorThrown); hide_spinner(); } );
}
//Handling showing of categories
function show_categories() {
 var request = $.ajax({
 url: host + "/show.categories.php",
 type: "GET",
 global: false,
 cache: false,
 dataType: "html",
 async: true,
 beforeSend: function(){ show_spinner() },
 success: function(){ hide_spinner() }
 });
//All set
 request.done(function (msg) {$( "#all_stats" ).html( msg );});
//Errors
 request.fail( function(jqXHR, textStatus, errorThrown) { throw_error(jqXHR, textStatus, errorThrown); hide_spinner();} );
}
//Handling of app settings - SAVE and RETRIEVE via JS localStorage
function handle_settings(type, setting, value) {
if('localStorage' in window && window['localStorage'] !== null) {
var result;
// Store
if (type=="Set") { result = localStorage.setItem(setting, value); $("#myModalSettings").modal(); $("#response-text-settings").html("App settings have been saved.<br>Reload to experience changes." );}
// Retrieve
else if (type=="Get") result = localStorage.getItem(setting);
else {$("#myModalSettings").modal(); $("#response-text-settings").html("Invalid Local Storage input parameters. <br>Probable incorrect call of the function." );}
} else {
// Sorry! No Web Storage support..
$("#myModalSettings").modal(); $("#response-text-settings").html("Settings cannot be saved due to lack of support <br>of Local Storage by your system." );
}
return result;
}
/**/
//Get mobile device information
function get_device_info() {
 var device_prop = [];
 //Get device info
 if (window.device) {current_device = device.uuid;}
 //Add info into array
 device_prop.push(current_device);
 return device_prop;
}
//Error handling function
function throw_error( jqXHR, textStatus, errorThrown ) {
 if (textStatus=="timeout") { $("#myModalConnection").modal(); $("#response-text").html("It appears that you have Internet connection problem. <br>The app cannot communicate with the server." );}
 if (textStatus=="error") { $("#myModalConnection").modal(); $("#response-text").html("It appears that your device/browser cannot communicate with the server.");}
}
//Handling show spinner
function show_spinner() {
try { window.plugins.spinnerDialog.show(); }
catch (e) { /*spinner = new Spinner(opts).spin(document.getElementById('spinner'));*/}
}
//Handling hide spinner
function hide_spinner(){
try { window.plugins.spinnerDialog.hide(); /*spinner.stop(); document.getElementById('spinner').style.display='none';*/ } 
catch (e) { /*spinner.stop(); document.getElementById('spinner').style.display='none'; */}
}
//Google analytics
function google_a(){(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
 (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
 m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
 })(window,document,'script','analytics.js','ga');
 ga('create', 'UA-59052576-1', 'auto'); ga('send', 'pageview');}
//Alerts handling
function app_alert(message, title, button) {
 if (navigator.notification) 
 navigator.notification.alert(
 message,// the message
 function() {},// a callback
 title, // a title
 button// the button text
 );
 else alert(message);
}
//Toggle button view
function toggle_view(element) {
 if($( element).hasClass('glyphicon-plus')) {
 $( element ).removeClass('glyphicon-plus');
 $( element ).addClass('glyphicon-minus');
 //Get AJAX data
 preview_list(4,'',null);
 if ($( '#view-text' ).text() == 'View more') $( '#view-text' ).text('View less');
 }
 else {
 $( element ).removeClass('glyphicon-minus');
 $( element ).addClass('glyphicon-plus');
 $( "#preview" ).html( null );
 if ($( '#view-text' ).text() == 'View less') $( '#view-text' ).text('View more');
 }
}
//Handle exit app
function exit_app() { if (navigator.app) navigator.app.exitApp(); else window.close(); }