//--------------------------------------------------------------------------Support
   function S4() {
      return (((1+Math.random())*0x10000)|0).toString(16).substring(1);
   }
   function guid() {
      return (S4()+S4()+"-"+S4()+"-"+S4()+"-"+S4()+"-"+S4()+S4()+S4());
   }
//-------------------------------------------------------------------Logical element;
   function WiseElement(numberOfInput) {                    
       this.outputValue = 0;               //Result of run
       this.length = numberOfInput;        //Number of inputs
       this.input = [];                    //Inputs values
       this.binput = [];                   //signal
       this.learnCoefficient = numberOfInput;//learn coefficient
       /* Init Values */
       for(var i=0;i<numberOfInput;i++){
           this.input[i] = Math.round(Math.random()*numberOfInput);
           this.binput[i] = 0;
       }
   }
   WiseElement.prototype.output = function(){
       return this.outputValue;
   }
   WiseElement.prototype.run = function(binput){
       this.outputValue = 0;
       for(var i=0;i<this.length;i++){
           this.outputValue+=binput[i]*this.input[i];
           this.binput[i] = binput[i];
       }                    
   }
   WiseElement.prototype.learn = function(result){
       switch (result) {
           case 'TRUE':
               for(var i=0;i<this.length;i++)
                   this.input[i]+=this.learnCoefficient*this.binput[i];
               break;
           case 'FALSE':
               for(var i=0;i<this.length;i++)
                   this.input[i]-=this.learnCoefficient*this.binput[i];
               break;
           case 'NEUTRAL':               
               break;
       }
   }
   WiseElement.prototype.save = function(id,j){
       localStorage.setItem(id+':'+j+':'+'length',this.length);
       for(var i=0;i<this.length;i++){
           localStorage.setItem(id+':'+j+':'+i,this.input[i]);
       }
   }
   WiseElement.prototype.load = function(id,j){
       this.length = localStorage.getItem(id+':'+j+':'+'length');                    
       for(var i=0;i<this.length;i++){
           this.input[i] = parseInt(localStorage.getItem(id+':'+j+':'+i));
       }
   }
   //-------------------------------------------------------------------------------Logical Object;
   function LogicConstructor(_id) {
       this.last = 0;          //last element that dominated
       this.length = 0;        //number of elements
       this.wiseElement = [];  //elements
       this.id = _id;
   }
   LogicConstructor.prototype.add = function(wiseElement){
       this.wiseElement[this.length] = wiseElement;
       this.length++;
   }
   /* Get dominated element */
   LogicConstructor.prototype.output = function(){
       var max, maxn, tmp, ret;
       maxn=0;
       ret = [0];
       max = this.wiseElement[maxn].output();                    
       for(var i=1;i<this.length;i++){
           ret[i]=0;
           tmp = this.wiseElement[i].output();
           if (max<tmp) {
               maxn=i;
               max=tmp;
           }
       }
       this.last = maxn;
       ret[this.last]=1;
       return ret;
   }
   /* execute brain action */
   LogicConstructor.prototype.run = function(binputs){
       for(var i=0;i<this.length;i++){
           this.wiseElement[i].run(binputs);
       }
   }
   /* learn of dominated element */
   LogicConstructor.prototype.learn = function(logic){/*This last should be from player*/
       this.wiseElement[this.last].learn(logic);                    
   }
   LogicConstructor.prototype.print= function(){
       for(var i=0;i<this.length;i++){                        
           console.log(this.wiseElement[i].input);
       }
   }
   LogicConstructor.prototype.save = function(){
       localStorage.setItem(this.id,this.id);
       localStorage.setItem(this.id+':'+'length',this.length)
       for(var i=0;i<this.length;i++){
           this.wiseElement[i].save(this.id,i);
       }
   }
   LogicConstructor.prototype.load = function(){
       if (localStorage.getItem(this.id)==this.id) {
           this.length = localStorage.getItem(this.id+':'+'length');                    
           for(var i=0;i<this.length;i++){
               this.wiseElement[i] = new WiseElement(3);
               this.wiseElement[i].load(this.id,i);
           }
       }
   }
   //----------------------------------------------------------------------------Program Flow;   
   var brainCount=0;
   function brainActShift() {
       brainCount=0;
       lcp = lcl;
       lcl = new LogicConstructor();
       for(var i=0;i<3;i++){
           tmp = new WiseElement(3);
           lcl.add(tmp);
       }
   }
   
   function sum(p,l) {
       for(var i=0;i<p.length;i++){
           for(var j=0;j<p.wiseElement[i].length;j++){
               p.wiseElement[i].input[j]+=l.wiseElement[i].input[j];
               if (p.wiseElement[i].input[j]>=256) {
                   p.wiseElement[i].input[j]=255
               }
               if (p.wiseElement[i].input[j]<=-256) {
                   p.wiseElement[i].input[j]=-255
               }
           }
       }
   }
   
   function brainActSum(lcp,lcl) {
       brainCount=0;
       sum(lcp,lcl);
       lcl = new LogicConstructor();
       for(var i=0;i<3;i++){
           tmp = new WiseElement(3);
           lcl.add(tmp);
       }                    
   }