var renderer, scene, camera, sceneHUD, cameraHUD, light1, light2;
var ahres, avres;
var background;
var background_images = [];
var preload_image_count = 0;

var sound = {};
var sound_on = true;

function highlight(e) { e.style.backgroundColor="#4040FF"; }
function unhighlight(e) { e.style.backgroundColor="#808080"; }

function button_easy()
	{ difflevel = 0; hiscore=hieasy; unhighlight(document.getElementById("button_start1"));
	document.getElementById("panel_title").style.display="none"; setTimeout(init_play,0); }
function button_normal()
	{ difflevel = 1; hiscore=hinormal; unhighlight(document.getElementById("button_start2"));
	document.getElementById("panel_title").style.display="none"; setTimeout(init_play,0); }
function button_hard()
	{ difflevel = 2; hiscore=hihard; unhighlight(document.getElementById("button_start3"));
	document.getElementById("panel_title").style.display="none"; setTimeout(init_play,0); }
function button_help() { window.location = "help.html"; }

function init()
{
	if (window.screen.lockOrientation) { window.screen.lockOrientation("landscape-primary"); }
	else { if (window.screen.mozLockOrientation) { window.screen.mozLockOrientation("landscape-primary"); } }

	ahres = parseInt(document.body.clientWidth); // actual horiz resolution
	avres = parseInt(document.body.clientHeight); // actual vert resolution

	if (avres > ahres) { var t=ahres; ahres=avres; avres=t; }

	document.getElementById("title_image").style.height = ((avres/2)|0) + "px";

	background = document.getElementById("panel_wrap");
	setTimeout(preload_background_images, 100);
}

function preload_background_images()
{
	// backgrounds //
	background_images[0] = new Image();
	background_images[0].src = "metal.jpg";
	for (var i=1; i<=25; i++)
	{
		background_images[i] = new Image();
		background_images[i].onload = on_image_preload;
		background_images[i].src = 'images/bg'+i+'.jpg';
	}
}

function on_image_preload()
{
	preload_image_count++;
	if(preload_image_count==25) { setTimeout(init_audio, 100); }
}

function init_audio()
{
	sound.background = make_audio("background.ogg", true);
	sound.laser = make_audio("laser.ogg", false);
	sound.laser2 = make_audio("laser2.ogg", false);
	sound.explosion = make_audio("explosion.ogg", false);
	sound.beepup = make_audio("beep_up.ogg", false);
	
	sound.explosion.volume = 0.15;
	sound.laser.volume = 0.05;
	sound.beepup.volume = 0.15;
	sound.laser2.volume = 0.25;
	setTimeout(init_webgl, 100);
}
function make_audio(src, loop)
{
	var e = document.createElement("audio");
	e.loop = loop;
	e.autoplay = false;
	e.src = "audio/"+src;
	e.hasplayed = false;
	return e;
}
function play_sound(e)
{
	if (sound_on)
	{
		if (e.hasplayed)
		{
			e.pause();
			e.currentTime = 0;
		}
		e.hasplayed = true;
		e.play(); 
	}
}
function toggle_sound()
{
	sound_on=!sound_on;
	if (!sound_on) { sound.background.pause(); } else { if (running) { sound.background.play(); } }
}

function init_webgl()
{
	scene = new THREE.Scene();
	camera = new THREE.PerspectiveCamera(60, ahres/avres, 1, 400); // fov, aspect ratio, near, far clip
	
	sceneHUD = new THREE.Scene();
	cameraHUD = new THREE.OrthographicCamera(0, ahres, avres, 0, -1, 2);

	renderer = new THREE.WebGLRenderer({ alpha: true });
	renderer.autoClear = false;

	// setup scene //
	camera.position.z = 100; // pull camera back
	scene.add(camera);

	light1 = new THREE.PointLight(0x808040, 0.8); //0x808000
	light1.position.set(150,150, 100);
	scene.add(light1);

	light2 = new THREE.SpotLight(0xFFFFFF, 1); // 0xFFFFFF
	light2.position.set(0,0,100);
	scene.add(light2);

	renderer.setSize(ahres, avres);
	document.getElementById("canvas").appendChild(renderer.domElement); // add webgl canvas to container element//

	setTimeout(init_app, 0);
}

function keydown(e)
{
	var key = e.keyCode? e.keyCode : e.charCode;
	if (key==37) { drift = 2;  } // left
	if (key==39) { drift = -2; } // right
}

function keyup(e)
{
	var key = e.keyCode? e.keyCode : e.charCode;
	if (key==37) { drift = 0;  } // left
	if (key==39) { drift = 0; } // right
	if (key==40) { fire(0); } //down
	if (key==32) { fire(0); } // space

	if (key==80) { pauseplay(); }    // P - pause/play
	if (key==83) { toggle_sound(); } // S - sound on/off
}

function move_left() { drift = 2; }
function move_right() { drift = -2; }
function move_up() { drift = 0; }
function pauseplay() { paused = !paused; if (!paused && running) { timer.start(); sound.background.play(); } else { timer.stop(); sound.background.pause(); } }

function showPanel(panel)
{
	document.getElementById("panel_title").style.display="none";
	document.getElementById("panel_main").style.display="none";
	document.getElementById(panel).style.display="block";

	if (panel=="panel_title") { showScore(difflevel); background.style.backgroundImage = "url("+background_images[0].src+")";  }
}

function showScore()
{
	if (!running)
	{
		var topscore = document.getElementById("topscore");
		var s = topscore.innerHTML.substr(0,1);
		switch (s)
		{
			case "L": topscore.innerHTML = "Easy: "+hieasy; break;
			case "E": topscore.innerHTML = "Normal: "+hinormal; break;
			case "N": topscore.innerHTML = "Hard: "+hihard; break;
			default: topscore.innerHTML = "Last: "+hilast; break;
		}
		setTimeout( showScore, 3000);
	}
}

document.ontouchmove = function(e) { e.preventDefault(); }
document.ontouchstart = function(e) { e.preventDefault(); }

document.body.addEventListener('keyup',keyup,false);
document.body.addEventListener('keydown',keydown,false);

var button1 = document.getElementById("button_start1");
var button2 = document.getElementById("button_start2");
var button3 = document.getElementById("button_start3");
var button4 = document.getElementById("button_help");

button1.addEventListener('touchstart', function() { highlight(this); }, false);
button2.addEventListener('touchstart', function() { highlight(this); }, false);
button3.addEventListener('touchstart', function() { highlight(this); }, false);
button4.addEventListener('touchstart', function() { highlight(this); }, false);

button1.addEventListener('touchexit', function() { unhighlight(this); }, false);
button2.addEventListener('touchexit', function() { unhighlight(this); }, false);
button3.addEventListener('touchexit', function() { unhighlight(this); }, false);
button4.addEventListener('touchexit', function() { unhighlight(this); }, false);

button1.addEventListener('touchend', button_easy, false);
button2.addEventListener('touchend', button_normal, false);
button3.addEventListener('touchend', button_hard, false);
button4.addEventListener('touchend', button_help, false);

button1.addEventListener('click', button_easy, false);
button2.addEventListener('click', button_normal, false);
button3.addEventListener('click', button_hard, false);
button4.addEventListener('click', button_help, false);

document.getElementById("canvas").addEventListener('touchstart', function(e) {
		e.preventDefault();
		var touch, id, x, y;
		for (var i=0; i<e.changedTouches.length; i++)
		{
			touch = e.changedTouches[i];
			id = e.changedTouches[i].identifier;
			x = touch.clientX;
			y = touch.clientY;

			if (x<=(ahres*0.15)) { move_left(); }
			if (x>=(ahres*0.85)) { move_right(); }
			if (x>(ahres*0.15) && x<(ahres*0.85))
			{
				if (y>(avres*0.8))
				{
					if (x<(ahres/2)) { pauseplay(); } else { toggle_sound(); }
				} 
				else { fire(0); }
			}
		}
}, false);

document.getElementById("canvas").addEventListener('touchend', function(e) {
	e.preventDefault();
	var touch, id, x, y;
	for (var i=0;i<e.changedTouches.length;i++)
	{
		touch = e.changedTouches[i];
		id = e.changedTouches[i].identifier;
		x = touch.clientX;
		y = touch.clientY;
		if (x<=(ahres*0.15) || x>=(ahres*0.85)) { move_up(); }
	}
}, false);

init();