/* A. General data about locations:
 * In a public transportation system, there are Stations connected through Routes
 * - An Station has name, address and coordinates 
 * - A Route has directions (Ej: north-south, south-north), operation days, 
 *   type of hourly schedules (Intervals or Frequencies), and connected stations.
 * In other scenaries, there are just Places without relationships.
 */

var applicationData = {
categories: [
{
  name: "Athens Metro",
  stations: [
      /* Γραμμη 3 */
    { /* 0 */ name: "Αγία Μαρίνα", address: "Ιερά Οδός & Αγίας Μαρίνας", coordinatelat: "37.99720", coordinatelng: "23.66747", },
    { /* 1 */ name: "Αιγάλεω", address: "Ιερά Οδός, Πλατεία Ελευθέριου", coordinatelat: "37.99147", coordinatelng: "23.68210", },
    { /* 2 */ name: "Ελαιώνας", address: "Ιερά Οδός, & Αγίας Μαρίνας", coordinatelat: "37.98784", coordinatelng: "23.69341", },
    { /* 3 */ name: "Κεραμεικός", address: "Γραμμές ΟΣΕ προς Πειραιά, ύψος Τεχνόπολις", coordinatelat: "37.97853", coordinatelng: "23.71165", },
    { /* 4 */ name: "Μοναστηράκι", address: "Μοναστηράκι", coordinatelat: "37.97664", coordinatelng: "23.72585", },
    { /* 5 */ name: "Σύνταγμα", address: "Πλατεία Συντάγματος", coordinatelat: "37.97507", coordinatelng: "23.73588", },
    { /* 6 */ name: "Ευαγγελισμός", address: "Λεωφόρος Βασιλίσσης Σοφίας (Ευαγγελισμός)", coordinatelat: "37.97617", coordinatelng: "23.74719", },
    { /* 7 */ name: "Μέγαρο Μουσικής", address: "Λεωφόρος Βασιλίσσης Σοφίας (Ιλίσια)", coordinatelat: "37.97865", coordinatelng: "23.75281", },
    { /* 8 */ name: "Αμπελόκηποι", address: "Λεωφόρος Αλεξάνδρας (Πανόρμου)", coordinatelat: "37.98706", coordinatelng: "23.75694", },
    { /* 9 */ name: "Πανόρμου", address: "Οδός Πανόρμου (Πλατεία Κανελλόπουλου)", coordinatelat: "37.99315", coordinatelng: "23.76339", },
    { /* 10 */ name: "Κατεχάκη", address: "Ιερά Οδός, & Αγίας Μαρίνας", coordinatelat: "37.99317", coordinatelng: "23.77611", },
    { /* 11 */ name: "Εθνική Άμυνα", address: "Λεωφόρος Μεσογείων", coordinatelat: "38.00025", coordinatelng: "23.78574", },
    { /* 12 */ name: "Χολαργός", address: "Λεωφόρος Μεσογείων, Φανερωμένη", coordinatelat: "38.00482", coordinatelng: "23.79488", },
    { /* 13 */ name: "Νομισματοκοπείο", address: "Λεωφόρος Μεσογείων, Νομισματοκοπείο", coordinatelat: "38.00908", coordinatelng: "23.80569", },
    { /* 14 */ name: "Αγία Παρασκευή", address: "Αγίας Παρασκευής, Πολυδούρη", coordinatelat: "38.01726", coordinatelng: "23.81226", },
    { /* 15*/ name: "Χαλάνδρι", address: "Δουκκίσης Πλακεντίας, Γρεβενών", coordinatelat: "38.02156", coordinatelng: "23.82033", },
    { /* 16 */ name: "Δουκίσσης Πλακεντίας", address: "Τέρμα Δουκίσσης Πλακεντίας, Κόμβος", coordinatelat: "38.02389", coordinatelng: "23.83359", },
    { /* 17 */ name: "Παλλήνη", address: "Παλλήνη, Ανατολική Αττική", coordinatelat: "38.00546", coordinatelng: "23.86926", },
    { /* 18 */ name: "Παιανία-Κάντζα", address: "Παλλήνη, Ανατολική Αττική", coordinatelat: "37.98347", coordinatelng: "23.86987", },
    { /* 19 */ name: "Κορωπί", address: "Παλλήνη, Ανατολική Αττική", coordinatelat: "37.91283", coordinatelng: "23.89572", },
    { /* 20*/ name: "Αεροδρόμιο", address: "Διεθνής Αερολιμένας Αθηνών, Ανατολική Αττική", coordinatelat: "37.93680", coordinatelng: "23.94479", },
      /* Γραμμή 2 */
    { /* 21 */ name: "Ανθούπολη", address: "Παναγή Τσαλδάρη, Αναπαύσεως & Θηβών", coordinatelat: "38.01709", coordinatelng: "23.69100", },
    { /* 22 */ name: "Περιστέρι", address: "Δημαρχείο Περιστερίου", coordinatelat: "38.01297", coordinatelng: "23.69570", },
    { /* 23 */ name: "Άγιος Αντώνιος", address: "Εθνάρχου Μακαρίου, Βασ. Αλεξάνδρου & Παναγή Τσαλδάρη", coordinatelat: "38.00640", coordinatelng: "23.69967", },
    { /* 24 */ name: "Σεπόλια", address: "Αντιγόνης & Αμφιαράου", coordinatelat: "38.00278", coordinatelng: "23.71359", },
    { /* 25 */ name: "Αττική", address: "Πλατεία Αττικής, Λιοσίων & Αδμήτου", coordinatelat: "37.99864", coordinatelng: "23.72241", },
    { /* 26 */ name: "Σταθμός Λαρίσης", address: "Θεοδ. Δηλιγιάννη & Δομοκού, Σταθμός Λαρίσης", coordinatelat: "37.99186", coordinatelng: "23.72066", },
    { /* 27 */ name: "Μεταξουργείο", address: "Πλατεία Καραϊσκάκη & Δηλιγιάννη", coordinatelat: "37.98578", coordinatelng: "23.72107", },
    { /* 28 */ name: "Ομόνοια", address: "Πλατεία Oμόνοιας", coordinatelat: "37.98415", coordinatelng: "23.72812", },
    { /* 29 */ name: "Πανεπιστήμιο", address: "Λεωφόρος Ελ. Βενιζέλου & Ρήγα Φεραίου", coordinatelat: "37.98051", coordinatelng: "23.73279", },
    { /* 30 */ name: "Ακρόπολη", address: "Μουσείο Ακρόπολης", coordinatelat: "37.96874", coordinatelng: "23.72960", },
    { /* 31 */ name: "Συγγρού-Φιξ", address: "Λεωφόρος Συγγρού", coordinatelat: "37.96452", coordinatelng: "23.72667", },
    { /* 32 */ name: "Νέος Κόσμος", address: "Ηλίας Ηλιού - Πλατεία Καραϊσκάκη", coordinatelat: "37.95770", coordinatelng: "23.72860", },
    { /* 33 */ name: "Άγιος Ιωάννης", address: "Αγίου Ιωάννη (Κυνηγού)", coordinatelat: "37.95646", coordinatelng: "23.73418", },
    { /* 34 */ name: "Δάφνη", address: "Πλατεία Καλογήρων (Δάφνης)", coordinatelat: "37.94949", coordinatelng: "23.73780", },
    { /* 35 */ name: "Άγιος Δημήτριος", address: "Αρχή Βουλιαγμένης", coordinatelat: "37.94139", coordinatelng: "23.74076", },
    { /* 36 */ name: "Ηλιούπολη", address: "Βουλιαγμένης, ύψος Πύρρωνος", coordinatelat: "37.92980", coordinatelng: "23.74442", },
    { /* 37 */ name: "Άλιμος", address: "Βουλιαγμένης, ύψος Εθνικής Αντιστάσεως", coordinatelat: "37.91823", coordinatelng: "23.74439", },
    { /* 38 */ name: "Αργυρούπολη", address: "Βουλιαγμένης, ύψος Κομνηνών", coordinatelat: "37.90306", coordinatelng: "23.74591", },
    { /* 39 */ name: "Ελληνικό", address: "Βουλιαγμένης, ύψος Ιασωνίδου", coordinatelat: "37.89261", coordinatelng: "23.74747", },
    /* Γραμμη 1 */
    { /* 40 */ name: "Πειραιάς", address: "Πλατεία Οδησσού & Ακτή Ποσειδώνος, Λιμάνι Πειραιά", coordinatelat: "37.94798", coordinatelng: "23.64299", },
    { /* 41 */ name: "Φάληρο", address: "Φάληρο", coordinatelat: "37.94448", coordinatelng: "23.66391", },
    { /* 42 */ name: "Μοσχάτο", address: "", coordinatelat: "37.95533", coordinatelng: "23.68017", },
    { /* 43 */ name: "Καλλιθέα", address: "", coordinatelat: "37.96050", coordinatelng: "23.69720", },
    { /* 44 */ name: "Ταύρος-Ελευθέριος Βενιζέλος", address: "", coordinatelat: "37.96238", coordinatelng: "23.70329", },
    { /* 45 */ name: "Θησείο", address: "", coordinatelat: "37.97668", coordinatelng: "23.72053", },
    { /* 46 */ name: "Βικτώρια", address: "", coordinatelat: "37.99316", coordinatelng: "23.73030", },
    { /* 47 */ name: "Άγιος Νικόλαος", address: "", coordinatelat: "38.00693", coordinatelng: "23.72775", },
    { /* 48 */ name: "Κάτω Πατήσια", address: "", coordinatelat: "38.01210", coordinatelng: "23.72882", },
    { /* 49 */ name: "Άγιος Ελευθέριος", address: "", coordinatelat: "38.02055", coordinatelng: "23.73202", },
    { /* 50 */ name: "Άνω Πατήσια", address: "", coordinatelat: "38.02369", coordinatelng: "23.73597", },
    { /* 51 */ name: "Περισσός", address: "", coordinatelat: "38.03271", coordinatelng: "23.74469", },
    { /* 52 */ name: "Πευκάκια", address: "", coordinatelat: "38.03704", coordinatelng: "23.75001", },
    { /* 53 */ name: "Νέα Ιωνία", address: "", coordinatelat: "38.04155", coordinatelng: "23.75505", },
    { /* 54 */ name: "Ηράκλειο", address: "", coordinatelat: "38.04625", coordinatelng: "23.76614", },
    { /* 55 */ name: "Ειρήνη", address: "", coordinatelat: "38.04373", coordinatelng: "23.78273", },
    { /* 56 */ name: "Νεραντζιώτισσα", address: "Αττική Οδός & Νεραντζιωτίσσης, Αμαρούσιο, Αθήνα", coordinatelat: "38.04516", coordinatelng: "23.79301", },
    { /* 57 */ name: "Μαρούσι", address: "", coordinatelat: "38.05632", coordinatelng: "23.80510", },
    { /* 58 */ name: "ΚΑΤ", address: "", coordinatelat: "38.06568", coordinatelng: "23.80415", },
    { /* 59 */ name: "Κηφισιά", address: "", coordinatelat: "38.07360", coordinatelng: "23.80819", },
 ],
  routes: [
  { name: "Γραμμή 3",
    directions: [
    { name: "Αγία Μαρίνα » Δουκίσσης Πλακεντίας", days: [1,2,3,4,0], hours: ["05:30","00:38"], typeOfSchedule: "Intervals", stations: [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17], },
    { name: "Δουκίσσης Πλακεντίας » Αγία Μαρίνα", days: [1,2,3,4,0], hours: ["05:30","00:29"], typeOfSchedule: "Intervals", stations: [17,16,15,14,13,12,11,10,9,8,7,6,5,4,3,2,1], },
    { name: "Αγία Μαρίνα » Δουκίσσης Πλακεντίας", days: [5,6], hours: ["05:30","02:38"], typeOfSchedule: "Intervals", stations: [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17], },
    { name: "Δουκίσσης Πλακεντίας » Αγία Μαρίνα", days: [5,6], hours: ["05:30","02:29"], typeOfSchedule: "Intervals", stations: [17,16,15,14,13,12,11,10,9,8,7,6,5,4,3,2,1], },
    ]
  },
  { name: "Γραμμή 3 - Έως Αεροδρόμιο",
    directions: [
    { name: "Αγία Μαρίνα » Αεροδρόμιο", days: [1,2,3,4,0], hours: ["05:30","22:56"], typeOfSchedule: "Intervals", stations: [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20], },
    { name: "Αεροδρόμιο » Αγία Μαρίνα", days: [1,2,3,4,0], hours: ["05:30","22:56"], typeOfSchedule: "Intervals", stations: [20,19,18,17,16,15,14,13,12,11,10,9,8,7,6,5,4,3,2,1], },
    { name: "Αγία Μαρίνα » Αεροδρόμιο", days: [5,6], hours: ["05:30","22:56"], typeOfSchedule: "Intervals", stations: [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20], },
    { name: "Αεροδρόμιο » Αγία Μαρίνα", days: [5,6], hours: ["05:30","22:56"], typeOfSchedule: "Intervals", stations: [20,19,18,17,16,15,14,13,12,11,10,9,8,7,6,5,4,3,2,1], },
    ]
  },
  { name: "Γραμμή 2",
    directions: [
    { name: "Ανθούπολη » Ελληνικό", days: [1,2,3,4,0], hours: ["05:30","00:36"], typeOfSchedule: "Intervals", stations: [21,22,23,24,25,26,27,28,29,5,30,31,32,33,34,35,36,37,38,39], },
    { name: "Ελληνικό » Ανθούπολη", days: [1,2,3,4,0], hours: ["05:30","00:33"], typeOfSchedule: "Intervals", stations: [39,38,37,36,35,34,33,32,31,30,5,29,28,27,26,25,24,23,22,21], },
    { name: "Ανθούπολη » Ελληνικό", days: [5,6], hours: ["05:30","02:36"], typeOfSchedule: "Intervals", stations: [21,22,23,24,25,26,27,28,29,5,30,31,32,33,34,35,36,37,38,39], },
    { name: "Ελληνικό » Ανθούπολη", days: [5,6], hours: ["05:30","02:33"], typeOfSchedule: "Intervals", stations: [39,38,37,36,35,34,33,32,31,30,5,29,28,27,26,25,24,23,22,21], },
    ]
  },
  { name: "Γραμμή 1",
    directions: [
    { name: "Πειραιάς » Κηφισιά", days: [1,2,3,4,5,6,0], hours: ["05:00","01:06"], typeOfSchedule: "Intervals", stations: [40,41,42,43,44,45,4,28,46,25,47,48,49,50,51,52,53,54,55,56,57,58,59], },
    { name: "Κηφισιά » Πειραιάς", days: [1,2,3,4,5,6,0], hours: ["05:00","01:06"], typeOfSchedule: "Intervals", stations: [59,58,57,56,55,54,53,52,51,50,49,48,47,25,46,28,4,45,44,43,42,41,40], },
    ]
  },
  { name: "Γραμμή 1 - Έως Ομόνοια",
    directions: [
    { name: "Πειραιάς » Ομόνοια", days: [1,2,3,4,5,6,0], hours: ["05:00","01:06"], typeOfSchedule: "Intervals", stations: [40,41,42,43,44,45,4,28,46,25], },
    { name: "Ομόνοια » Πειραιάς", days: [1,2,3,4,5,6,0], hours: ["05:00","01:06"], typeOfSchedule: "Intervals", stations: [25,46,28,4,45,44,43,42,41,40], },
    ]
  },
  ]
},
{
  name: "Alimentadora Norte",
  stations:
  [
    { /* 0 */ name: "Naranjal", address: "Av. Túpac Amaru cdra 45 con Av. Chinchaysuyo cdra 1 - Independencia", coordinatelat: "-11.982013", coordinatelng: "-77.058663", },
    { /* 1 */ name: "Ca. Huáscar", address: "Av. Chinchaysuyo cdra 1 con Ca. Huáscar - Independencia", coordinatelat: "-11.979987", coordinatelng: "-77.057894", },
    { /* 2 */ name: "Ca. Paracas", address: "Av. Indoamérica con Ca. Paracas - Independencia", coordinatelat: "-11.981121", coordinatelng: "-77.054159", },
    { /* 3 */ name: "Ca. Huanacaure", address: "Av. Indoamérica con Ca. Huanacaure - Independencia", coordinatelat: "-11.982674", coordinatelng: "-77.053537", },
    { /* 4 */ name: "Ca. Pisac", address: "Ca. Huanacaure con Ca. Pisac - Independencia", coordinatelat: "-11.981593", coordinatelng: "-77.049106", },
    { /* 5 */ name: "Ca. Huatanay", address: "Ca. Huatanay con Ca. Quipaypampa - Independencia", coordinatelat: "-11.981651", coordinatelng: "-77.048045", },
    { /* 6 */ name: "Ca. Yauri", address: "Av. Coricancha con Ca. Yauri - Independencia", coordinatelat: "-11.9811", coordinatelng: "-77.043495", },
    { /* 7 */ name: "Ca. Río Coricancha", address: "Av. Coricancha con Ca. Río Vilcanota - Independencia", coordinatelat: "-11.980754", coordinatelng: "-77.040618", },
    { /* 8 */ name: "Ca. Vilcashuaman", address: "Ca. Vilcashuaman", coordinatelat: "-11.979704", coordinatelng: "-77.037819", },
    { /* 9 */ name: "Ca. Quillabamba", address: "Ca. Quillabamba con Ca. Hermanos Ayar", coordinatelat: "-11.979305", coordinatelng: "-77.039579", },
    { /* 10 */ name: "Ca. Cushihuallar", address: "Av. Coricancha con Ca. Cushihuallar", coordinatelat: "-11.980517", coordinatelng: "-77.040372", },
    { /* 11 */ name: "Ca. Muquiyauyos", address: "Av. Huanacaure con Ca. Muquiyauyos", coordinatelat: "-11.981625", coordinatelng: "-77.050093", },
    { /* 12 */ name: "Ca. 15 de Julio", address: "Av. Chinchaysuyo cdra 1 con Ca. 15 de Julio", coordinatelat: "-11.97983", coordinatelng: "-77.058397", },
  ],
  routes: [
  { name: "Alimentador AN-01 Tahuantinsuyo",
    directions: [
    { name: "AN-01", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [0,1,2,3,4,5,6,7,8,9,10,6,5,11,3,2,12,0], },
    ]
  },
  { name: "Alimentador AN-02 Tungasuca",
    directions: [
    { name: "AN-02", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [], },
    ]
  },
  { name: "Alimentador AN-03 Trapiche",
    directions: [
    { name: "AN-03", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [], },
    ]
  },
  { name: "Alimentador AN-04 Collique",
    directions: [
    { name: "AN-04 Regular", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [], },
    { name: "AN-04 Directo Mañana", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [], },
    { name: "AN-04 Directo Tarde", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [], },
    ]
  },
  { name: "Alimentador AN-05 Payet",
    directions: [
    { name: "AN-05", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [], },
    ]
  },
  { name: "Alimentador AN-06 Puno",
    directions: [
    { name: "AN-06", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [], },
    ]
  },
  { name: "Alimentador AN-07 Belaunde",
    directions: [
    { name: "AN-07 Regular", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [], },
    { name: "AN-07 Directo Mañana", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [], },
    { name: "AN-07 Directo Tarde", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [], },
    ]
  },
  { name: "Alimentador AN-08 Milagro de Jesús",
    directions: [
    { name: "AN-08 Regular", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [], },
    { name: "AN-08 Directo Mañana", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [], },
    { name: "AN-08 Directo Tarde", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [], },
    ]
  },
  { name: "Alimentador AN-09 Carabayllo",
    directions: [
    { name: "AN-09 Regular", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [], },
    { name: "AN-09 Directo Mañana", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [], },
    { name: "AN-09 Directo Tarde", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [], },
    ]
  },
  { name: "Alimentador AN-10 Santo Domingo",
    directions: [
    { name: "AN-10", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [], },
    ]
  },
  { name: "Alimentador AN-12 Puente Piedra",
    directions: [
    { name: "AN-12", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [], },
    ]
  },
  { name: "Alimentador AN-13 La Ensenada",
    directions: [
    { name: "AN-13", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [], },
    ]
  },
  { name: "Alimentador AN-14 Bertello",
    directions: [
    { name: "AN-14", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [], },
    ]
  },
  { name: "Alimentador AN-15 Los Alisos",
    directions: [
    { name: "AN-15", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [], },
    ]
  },
  { name: "Alimentador AN-16 Los Olivos",
    directions: [
    { name: "AN-16", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [], },
    ]
  },
  { name: "Alimentador AN-17 Antúnez de Mayolo",
    directions: [
    { name: "AN-17", days: [0,1,2,3,4,5,6], hours: ["06:00","23:00"], typeOfSchedule: "Intervals", stations: [], },
    ]
  },
  ]
},
]
};
