define(['underscore', 'backbone', 'models/Home'],
    function(_, Backbone , Home) {
        var List = Backbone.Collection.extend({
            //carouselLinks : [],
            model : Home,
            addImages: function() {
                this.reset();
                var pics = navigator.getDeviceStorage("pictures");
				
                var that = this;
                // Let's browse all the images available
                var cursor = pics.enumerate();
               
                cursor.onsuccess = function() {
                    var file = this.result;
                    var isFile = file != null;
                    if (isFile) {
                        datetime = $.format.date(file.lastModifiedDate, DEFAULTDATE);

						var imgTitle = file.name;
                        var imgName = imgTitle.slice(imgTitle.lastIndexOf("/") + 1);
						
                        var obj = {
                            href: window.URL.createObjectURL(file),
                            title: file.name,
                            size : file.size,
                            datetime: datetime,
                            name: imgName
                        };
                        
                        /*var duplicate = that.findWhere({name: imgName});
                        if(duplicate && obj.size <= 1048576){
                            console.log("inside duplicate n size check");
                            if(duplicate.size < obj.size){
                                that.unshift(obj);
                                that.remove(duplicate);
                                console.log("Inside duplicate");
                            }
                        }else */
                        if(obj.title.indexOf("previews/Download/Bluetooth") === -1 && obj.size <= 1048576){
                            that.unshift(obj); 

                        }

                    }

                    if(!isFile){
                        
                        that.trigger("onImageLoad");
                        return;
                    }
						
                    if (!this.done) {
                        this.continue();
                    }
                }

                cursor.onerror = function() {
                    console.warn("No file found: " + this.error);
                }


            },
			
            addSlide: function(name,outputFolder) {
                var sdcard = navigator.getDeviceStorage(outputFolder);
                var request = sdcard.get(name);
                var that = this;
			
                request.onsuccess = function () {
                    var file = this.result;
                    datetime = $.format.date(file.lastModifiedDate, DEFAULTDATE);
                    var isFile = file != null;
                    if (isFile) {
                        var galleryLength = that.models.length;
                        var obj = {
                            href: window.URL.createObjectURL(file),
                            title: file.name,
                            size : file.size,
                            datetime: datetime
                        };

                        that.unshift(obj);
                        that.trigger("onImageLoad");
                    }
                }

                request.onerror = function () {
                    console.warn("Unable to get the file: " + this.error);
                }
              
            },
            deleteImg: function(pos) {
                var index = pos;
                var currentActive = $('div.slide[data-index="'+index+'"]');
                console.log("currentActive", currentActive);
                var imgName =  currentActive.find("img").attr('title');
                console.log("imgName", imgName);
                var albumFolder = "pictures";
            
                var sdcard = navigator.getDeviceStorage(albumFolder);
            
                var request = sdcard.delete(imgName);
                var that = this;
                request.onsuccess = function () {
                    that.remove(that.at(index));
                    that.trigger("onImageLoad");
					that.trigger("onAdjustGallery");
                    //APP.viewSplash.gallery.slide(index);
                    $('#view-imageDetails').hide();
                }

                request.onerror = function () {
                    console.log("Unable to delete the file: " + this.error);
                } 
            }
        });
  
  return List;
});

